/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.ui.fieldeditors.BBadgePickerFE;
import com.tridiumx.entsec.access.ui.orion.BEnrollBadgeView;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="wiegandFormatModified")
public class BBatchEnrollBadgeView
extends BEnrollBadgeView {
    @Generated
    public static final Action wiegandFormatModified = BBatchEnrollBadgeView.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBatchEnrollBadgeView.class);

    @Generated
    public void wiegandFormatModified() {
        this.invoke(wiegandFormatModified, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject o, Context cx) throws Exception {
        super.doLoadValue(o, cx);
        BWbFieldEditor editor = this.accessEditor.getFieldSheet().getEditor(BBadge.wiegandFormat);
        this.linkTo((BComponent)editor, (Slot)BWbPlugin.setModified, (Slot)wiegandFormatModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BObject doSaveValue(BObject o, Context cx) throws Exception {
        BBadge badge = (BBadge)this.getCurrentValue();
        if (cx == null) {
            cx = this.getCurrentContext();
        }
        BBadge template = (BBadge)this.accessEditor.saveValue(o, cx);
        OrionSession session = null;
        try {
            session = this.getOrionDatabase().createSession(cx);
            BBadgePickerFE newBadgesEditor = (BBadgePickerFE)this.accessEditor.getFieldSheet().getEditor(badge.getProperty("newBadges"));
            BVector v = (BVector)newBadgesEditor.saveValue();
            BBadge[] newBadges = (BBadge[])v.getChildren(BBadge.class);
            for (int i = 0; i < newBadges.length; ++i) {
                newBadges[i].setBDescription(template.getBDescription());
                newBadges[i].setStatus(template.getStatus());
                newBadges[i].setIssueDate(template.getIssueDate());
                newBadges[i].setExpirationDate(template.getExpirationDate());
                newBadges[i].setOwner(template.getOwner());
                newBadges[i].setTenant(template.getTenant());
                session.insert((BIOrionObject)newBadges[i]);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        return o;
    }

    public void doWiegandFormatModified(Context cx) throws Exception {
        BBadge badge = (BBadge)this.getCurrentValue();
        BBadgePickerFE newBadgesEditor = (BBadgePickerFE)this.accessEditor.getFieldSheet().getEditor(badge.getProperty("newBadges"));
        newBadgesEditor.loadValue((BObject)new BVector());
        String lastBadgeRead = this.accessEditor.getFieldSheet().getEditor(badge.getProperty("scannedBadge")).saveValue(cx).toString();
        this.lastBadgeReadChanged(lastBadgeRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lastBadgeReadChanged(String lastBadgeRead) throws Exception {
        BBadge badge = (BBadge)this.getCurrentValue();
        BOrionDatabase db = badge.getOrionDatabase();
        OrionSession session = null;
        try {
            session = db.createSession(null);
            BBadge newBadge = new BBadge();
            newBadge.setBadgeId(lastBadgeRead);
            BBadge dbBadge = (BBadge)session.read((BIOrionObject)newBadge);
            BBadgePickerFE newBadgesEditor = (BBadgePickerFE)this.accessEditor.getFieldSheet().getEditor(badge.getProperty("newBadges"));
            this.accessEditor.getFieldSheet().getEditor(badge.getProperty("scannedBadge")).loadValue((BObject)BString.make((String)lastBadgeRead));
            if (lastBadgeRead.length() == 0) {
                return;
            }
            if (dbBadge != null) {
                this.accessEditor.getFieldSheet().getEditor(badge.getProperty("enrollmentStatus")).loadValue((BObject)BString.make((String)("Badge Already Exists:  " + dbBadge.toDisplayString(null))));
                return;
            }
            this.accessEditor.getFieldSheet().getEditor(badge.getProperty("enrollmentStatus")).loadValue((BObject)BString.DEFAULT);
            BRef wiegandFormatRef = (BRef)this.accessEditor.getFieldSheet().getEditor(BBadge.wiegandFormat).saveValue();
            BWiegandFormat wiegandFormat = (BWiegandFormat)wiegandFormatRef.getTarget(session);
            if (wiegandFormat == null) {
                this.accessEditor.getFieldSheet().getEditor(badge.getProperty("enrollmentStatus")).loadValue((BObject)BString.make((String)"Please Select a Wiegand Format"));
            }
            if ((newBadge = wiegandFormat.getBadge(lastBadgeRead)) == null) {
                return;
            }
            BVector vector = (BVector)newBadgesEditor.saveValue();
            BBadge[] newBadges = (BBadge[])vector.getChildren(BBadge.class);
            boolean found = false;
            for (int i = 0; i < newBadges.length; ++i) {
                if (!newBadges[i].getBadgeId().equals(newBadge.getBadgeId())) continue;
                return;
            }
            vector.add(null, (BValue)newBadge);
            newBadgesEditor.loadValue((BObject)vector);
            newBadgesEditor.setModified();
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    @Override
    public void addEnrollInfo(BBadge badge, Context cx) {
        Property[] props = new Property[]{BBadge.credential, BBadge.facilityCode};
        BAppView.setReadonly(badge, props);
        props = new Property[]{BBadge.wiegandFormat};
        BAppView.setWritable(badge, props);
        props = new Property[]{BBadge.credential, BBadge.facilityCode};
        BAppView.setHidden(badge, props, true);
        badge.setCredential("");
        badge.setFacilityCode("");
        if (badge.getProperty("newBadges") == null) {
            badge.add("newBadges", (BValue)new BVector(), 0, BFacets.make((String)"fieldEditor", (String)"entsec:BadgePickerFE"), null);
        }
        if (badge.getProperty("enrollmentStatus") == null) {
            badge.add("enrollmentStatus", (BValue)BString.make((String)""), 1, BFacets.DEFAULT, null);
        }
        if (badge.getProperty("scannedBadge") == null) {
            badge.add("scannedBadge", (BValue)BString.make((String)""), 1, BFacets.DEFAULT, null);
        }
        if (badge.getProperty("enrollmentReader") == null) {
            badge.add("enrollmentReader", (BValue)BRef.make((BOrionTypeId)BAccReaderRec.ORION_TYPE.getOrionTypeId()), 0, BFacets.make((String)"allowNull", (BIDataValue)BBoolean.TRUE), null);
        }
    }
}

