/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.ui.orion.BBadgeView;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import java.math.BigInteger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BRangeBadgeView
extends BBadgeView {
    @Generated
    public static final Type TYPE = Sys.loadType(BRangeBadgeView.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject o, Context cx) throws Exception {
        this.addEnrollInfo((BBadge)o, cx);
        super.doLoadValue(o, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BObject doSaveValue(BObject o, Context cx) throws Exception {
        BBadge badge = (BBadge)this.getCurrentValue();
        if (cx == null) {
            cx = this.getCurrentContext();
        }
        BBadge template = (BBadge)this.accessEditor.saveValue(o, cx);
        OrionSession session = null;
        try {
            session = this.getOrionDatabase().createSession(cx);
            String credentialStart = this.accessEditor.getFieldSheet().getEditor(badge.getProperty("credentialStart")).saveValue().toString();
            String credentialFinish = this.accessEditor.getFieldSheet().getEditor(badge.getProperty("credentialFinish")).saveValue().toString();
            BRangeBadgeView.duplicate(template, credentialStart, credentialFinish, session, cx);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        return o;
    }

    public static void duplicate(BBadge template, String idStart, String idFinish, OrionSession session, Context cx) throws Exception {
        BigInteger start = new BigInteger(idStart);
        start = start.add(BigInteger.ONE);
        BigInteger finish = new BigInteger(idFinish);
        while (start.compareTo(finish) != 1) {
            String startString = start.toString();
            BBadge badge = new BBadge();
            badge.setIssueDate(template.getIssueDate());
            badge.setExpirationDate(template.getExpirationDate());
            badge.setFacilityCode(template.getFacilityCode());
            badge.setCredential(startString);
            badge.setWiegandFormat(template.getWiegandFormat());
            badge.setOwner(template.getOwner());
            badge.setBadgeId(badge.calculateId(session));
            badge.setTenant(template.getTenant());
            badge.setStatus(template.getStatus());
            badge.setBDescription(template.getBDescription());
            if (session.exists((BIOrionObject)badge)) {
                if (idStart.equals(startString)) {
                    throw new IllegalStateException(BAccessControlService.lex.getText("badgeRangeCreateFailFor", new Object[]{idStart, idFinish}));
                }
                String end = start.subtract(BigInteger.ONE).toString();
                throw new IllegalStateException(BAccessControlService.lex.getText("badgeAlreadyExistsRangeWorkedFor", new Object[]{startString, idStart, end, idFinish}));
            }
            session.insert((BIOrionObject)badge);
            start = start.add(BigInteger.ONE);
        }
    }

    public void addEnrollInfo(BBadge badge, Context cx) {
        Property[] props = new Property[]{BBadge.credential};
        BAppView.setHidden(badge, props, true);
        if (badge.getProperty("credentialStart") == null) {
            badge.add("credentialStart", (BValue)BString.make((String)"0"));
        }
        if (badge.getProperty("credentialFinish") == null) {
            badge.add("credentialFinish", (BValue)BString.make((String)"0"));
        }
    }
}

