/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.schedule;

import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridiumx.entsec.access.ui.schedule.BDistributedScheduleManager;
import com.tridiumx.entsec.access.ui.schedule.DistributedScheduleModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType
public class BDistributedScheduleMgrTable
extends BMgrTable {
    @Generated
    public static final Type TYPE = Sys.loadType(BDistributedScheduleMgrTable.class);
    DistributedScheduleModel model;
    HashMap<BOrd, BObject> hashScheduleContainer = new HashMap();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDistributedScheduleMgrTable() {
    }

    public BDistributedScheduleMgrTable(DistributedScheduleModel model) {
        super((MgrModel)model);
        this.model = model;
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.hashScheduleContainer != null) {
            this.hashScheduleContainer.clear();
            this.hashScheduleContainer = null;
        }
    }

    public void reload() {
        BDistributedScheduleManager manager = (BDistributedScheduleManager)this.getManager();
        BNiagaraScheduleDeviceExt target = manager.getDeviceExt();
        this.setContainer((BComponent)target);
        this.clearScheduleContainerMap();
        this.hashScheduleContainer.put(((BComponent)this.getManager().getCurrentValue()).getSlotPathOrd(), this.getManager().getCurrentValue());
        BAbstractSchedule[] rows = this.getLocalSchedules();
        this.getSelection().deselectAll();
        this.getComponentModel().setRows((BComponent[])rows);
        BComponent[] containerComps = this.getContainerComponents(this.hashScheduleContainer);
        if (containerComps.length > 0) {
            this.getManager().registerForComponentEvents(containerComps, this.model.getSubscribeDepth());
        }
    }

    private BComponent[] getContainerComponents(HashMap<BOrd, BObject> hashScheduleContainer) {
        Collection<BObject> values = hashScheduleContainer.values();
        if (values.size() > 0) {
            BComponent[] containerComps = new BComponent[values.size()];
            int index = 0;
            Iterator<BObject> iterator = values.iterator();
            while (iterator.hasNext()) {
                containerComps[index++] = (BComponent)iterator.next();
            }
            return containerComps;
        }
        return new BComponent[0];
    }

    private BatchResolve getResolvedOrds(BOrd[] ords, BObject base) {
        BatchResolve batchResolveOrds = new BatchResolve(ords);
        if (batchResolveOrds != null) {
            batchResolveOrds.resolve(base);
        }
        return batchResolveOrds;
    }

    public HashMap<BOrd, BObject> getScheduleContainerMap() {
        return this.hashScheduleContainer;
    }

    public void clearScheduleContainerMap() {
        if (this.hashScheduleContainer != null) {
            this.getManager().unregisterForAllComponentEvents();
            this.hashScheduleContainer.clear();
        }
    }

    public BAbstractSchedule[] getLocalSchedules() {
        BITable result = null;
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("where ((parent.type != schedule:AbstractSchedule) and (");
        Type[] validTypes = this.model.getIncludeTypes();
        for (int i = 0; i < validTypes.length; ++i) {
            if (i > 0) {
                whereClause.append(" or ");
            }
            whereClause.append("type = " + validTypes[i].getTypeInfo().getModuleName() + ":" + validTypes[i].getTypeInfo().getTypeName());
        }
        whereClause.append("))");
        String query = "station:|slot:/|bql: select slotPathOrd from schedule:AbstractSchedule " + whereClause.toString();
        BOrd queryOrd = BOrd.make((BOrd)((BScheduleDeviceExt)this.model.getManager().getCurrentValue()).getAbsoluteOrd(), (String)query);
        result = (BITable)queryOrd.resolve(this.model.getManager().getCurrentValue()).get();
        TableCursor cur = result.cursor();
        Array accepted = new Array(BAbstractSchedule.class);
        BOrd[] ords = null;
        ArrayList<BOrd> bOrds = new ArrayList<BOrd>();
        while (cur.next()) {
            String path = cur.cell(result.getColumns().get(0)).toString();
            bOrds.add(BOrd.make((String)("station:|" + path)).normalize());
        }
        ords = bOrds.toArray(new BOrd[bOrds.size()]);
        BatchResolve resolvedOrds = this.getResolvedOrds(ords, this.model.getManager().getCurrentValue());
        if (resolvedOrds == null) {
            return new BAbstractSchedule[0];
        }
        BComponent[] schedComponents = resolvedOrds.getTargetComponents();
        for (int j = 0; j < schedComponents.length; ++j) {
            if (!resolvedOrds.isResolved(j)) continue;
            if (this.model.accept(schedComponents[j])) {
                accepted.add((Object)((BAbstractSchedule)schedComponents[j]));
            }
            BComponent parent = (BComponent)schedComponents[j].getParent();
            this.hashScheduleContainer.put(parent.getSlotPathOrd(), (BObject)parent);
        }
        return (BAbstractSchedule[])accepted.trim();
    }

    public void handleComponentEvent(BComponentEvent event) {
        switch (event.getId()) {
            case 1: 
            case 2: {
                if (!(event.getValue() instanceof BAbstractSchedule)) break;
                this.reload();
            }
        }
    }
}

