/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.accessDriver.enums.BEnforcementEnum;
import com.tridiumx.accessDriver.enums.BOccupancyEnum;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessValidationInfo;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.PersonCache;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.net.ConnectException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.util.BUuid;

public abstract class AccessZonesValidationUtil {
    public static boolean validate(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        int i;
        String stationName = Sys.getStation().getStationName();
        BAccessZoneRec[] entryZoneRecs = AccessZonesValidationUtil.getEntryZoneRecs(info, session, dbCache);
        info.addEntryZoneRecs(entryZoneRecs);
        for (int i2 = 0; i2 < entryZoneRecs.length; ++i2) {
            BAccessZoneRec zoneRec = entryZoneRecs[i2];
            info.setAccessZoneRec((BAccessZoneRec)zoneRec.newCopy());
            if (zoneRec.getStationName().equals(stationName)) {
                BAccessZone zone = (BAccessZone)zoneRec.getMappedOrd().get();
                info.addEntryZone(zone, zoneRec);
                if (AccessZonesValidationUtil.validateAccessZoneEntry(zone, zoneRec, info, session, dbCache)) continue;
                for (int j = 0; j <= i2; ++j) {
                    AccessZonesValidationUtil.clearMaybePending(entryZoneRecs[j], info, true);
                }
                return false;
            }
            boolean validated = false;
            try {
                BAccessValidationInfo remoteInfo = (BAccessValidationInfo)RemoteUtil.invokeRemote(zoneRec.getStationName(), zoneRec.getMappedOrd(), BAccessZone.remoteValidationEntry, (BValue)info);
                info.copyFrom((BComplex)remoteInfo);
                validated = info.getRecord().getGranted();
            }
            catch (ConnectException e) {
                info.getRecord().setDetails(BAccessControlService.lex.getText("error.connectFailure", new Object[]{zoneRec.getStationName(), zoneRec.getZoneName()}));
                if (zoneRec.getFallbackEnforcement() != BEnforcementEnum.off) {
                    validated = false;
                    if (zoneRec.getFallbackEnforcement() == BEnforcementEnum.hard) {
                        info.getRecord().setActivity(BBadgeActivity.connectionProblem);
                    } else if (zoneRec.getFallbackEnforcement() == BEnforcementEnum.soft) {
                        info.getRecord().setActivity(BBadgeActivity.grantedButConnectionProblem);
                    }
                } else {
                    validated = true;
                }
            }
            catch (Exception e) {
                info.getRecord().setDetails("Error " + e.getMessage());
                e.printStackTrace();
                validated = false;
                info.getRecord().setActivity(BBadgeActivity.unknown);
            }
            if (validated) continue;
            for (int j = 0; j <= i2; ++j) {
                AccessZonesValidationUtil.clearMaybePending(entryZoneRecs[j], info, true);
            }
            return false;
        }
        BAccessZoneRec[] exitZoneRecs = AccessZonesValidationUtil.getExitZoneRecs(info, session, dbCache);
        info.addExitZoneRecs(exitZoneRecs);
        for (i = 0; i < exitZoneRecs.length; ++i) {
            BAccessZoneRec zoneRec = exitZoneRecs[i];
            info.setAccessZoneRec((BAccessZoneRec)zoneRec.newCopy());
            if (zoneRec.getStationName().equals(stationName)) {
                BAccessZone zone = (BAccessZone)zoneRec.getMappedOrd().get();
                info.addExitZone(zone, zoneRec);
                boolean exitValidation = AccessZonesValidationUtil.validateAccessZoneExit(zone, zoneRec, info, session, dbCache);
                if (exitValidation) continue;
                throw new IllegalStateException("Exit Readers must allow exit");
            }
            boolean exitValidation = true;
            try {
                BAccessValidationInfo remoteInfo = (BAccessValidationInfo)RemoteUtil.invokeRemote(zoneRec.getStationName(), zoneRec.getMappedOrd(), BAccessZone.remoteValidationExit, (BValue)info);
                info.copyFrom((BComplex)remoteInfo);
                exitValidation = info.getRecord().getGranted();
            }
            catch (ConnectException e) {
                info.getRecord().setDetails(BAccessControlService.lex.getText("error.connectFailure", new Object[]{zoneRec.getStationName(), zoneRec.getZoneName()}));
                if (zoneRec.getFallbackEnforcement() != BEnforcementEnum.off) {
                    info.getRecord().setActivity(BBadgeActivity.grantedButConnectionProblem);
                }
            }
            catch (Exception ee) {
                info.getRecord().setDetails("Error " + ee.getMessage());
                info.getRecord().setActivity(BBadgeActivity.grantedButConnectionProblem);
                ee.printStackTrace();
            }
            if (exitValidation) continue;
            throw new IllegalStateException("Exit Readers must allow exit");
        }
        for (i = 0; i < entryZoneRecs.length; ++i) {
            AccessZonesValidationUtil.confirmMaybePending(entryZoneRecs[i], info, true);
        }
        for (i = 0; i < exitZoneRecs.length; ++i) {
            AccessZonesValidationUtil.confirmMaybePending(exitZoneRecs[i], info, false);
        }
        return true;
    }

    public static boolean validateAccessZoneEntry(BAccessZone accessZone, BAccessZoneRec accessZoneRec, BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        boolean personIsSupervisor = false;
        if (accessZone.getLockDown()) {
            info.getRecord().setActivity(BBadgeActivity.accessZoneDisabled);
            return false;
        }
        if (info.validatedRemotely && !AccessZonesValidationUtil.personExists(info, session, dbCache)) {
            info.getRecord().setActivity(BBadgeActivity.connectionProblem);
            info.getRecord().setDetails(BAccessControlService.lex.getText("error.personDoesNotExistLocally"));
            return true;
        }
        BPersonZoneJoin inside = AccessZonesValidationUtil.getPersonZoneJoin(info, session, dbCache, accessZoneRec);
        if (inside != null) {
            BEnforcementEnum passbackEnum = accessZone.getPassbackMode();
            BRelTime timeout = accessZone.getPassbackTimeout();
            BAbsTime lastActivity = inside.getLastModified();
            if (timeout.equals((Object)BRelTime.DEFAULT) || lastActivity.delta(BAbsTime.now()).compareTo((Object)timeout) < 0) {
                if (passbackEnum.equals((Object)BEnforcementEnum.hard)) {
                    info.getRecord().setActivity(BBadgeActivity.antiPassbackViolation);
                    return false;
                }
                if (passbackEnum.equals((Object)BEnforcementEnum.soft)) {
                    info.getRecord().setActivity(BBadgeActivity.grantedButAntiPassbackViolation);
                    info.getRecord().setDetails(BAccessControlService.lex.getText("personAlreadyInside"));
                }
            }
        }
        BEnforcementEnum supervisorEnum = accessZone.getSupervisorRequiredEnforcement();
        boolean isSupervisor = false;
        if (supervisorEnum.equals((Object)BEnforcementEnum.off)) {
            personIsSupervisor = true;
        }
        if (!supervisorEnum.equals((Object)BEnforcementEnum.off) || accessZone.getOccupancyCriteria() == BOccupancyEnum.supervisors) {
            BSupervisorZoneJoin supervisor = new BSupervisorZoneJoin();
            supervisor.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)info.getPersonData().getPersonUuid()));
            supervisor.setAccessZone(BRef.make((BIOrionObject)accessZoneRec));
            isSupervisor = AccessZonesValidationUtil.supervisorExists(info, session, dbCache, supervisor);
        }
        if (!supervisorEnum.equals((Object)BEnforcementEnum.off)) {
            if (!isSupervisor) {
                int total = AccessZonesValidationUtil.getOccupiedSupervisorCount(info, session, dbCache, accessZoneRec);
                if (total == 0 && !accessZone.hasSupervisorPending(info.getDoorHandle(), true)) {
                    if (supervisorEnum.equals((Object)BEnforcementEnum.hard)) {
                        info.getRecord().setActivity(BBadgeActivity.supervisorRequired);
                        return false;
                    }
                    if (supervisorEnum.equals((Object)BEnforcementEnum.soft)) {
                        info.getRecord().setActivity(BBadgeActivity.grantedButSupervisorRequired);
                    }
                }
            } else {
                personIsSupervisor = true;
            }
        }
        if (accessZone.getOccupancyCriteria() == BOccupancyEnum.supervisors && !isSupervisor) {
            return true;
        }
        BEnforcementEnum aboveHighEnforcement = accessZone.getAboveHighThresholdEnforcement();
        BDynamicEnum atHighEnforcement = accessZone.getAtHighThresholdEnforcement();
        BDynamicEnum belowLowEnforcement = accessZone.getBelowLowThresholdEnforcement();
        BDynamicEnum atLowEnforcement = accessZone.getAtLowThresholdEnforcement();
        if (inside == null && (aboveHighEnforcement.getOrdinal() != 0 || atHighEnforcement.getOrdinal() != 0 || atLowEnforcement.getOrdinal() != 0 || belowLowEnforcement.getOrdinal() != 0)) {
            int totalPeople = AccessZonesValidationUtil.getOccupiedPersonsCount(info, session, dbCache, accessZoneRec);
            BAccessZone.PendingOccupancy newPending = new BAccessZone.PendingOccupancy(info.getPersonData().getPersonUuid(), info.getDoorHandle(), true, personIsSupervisor);
            BAccessZone.Pending pending = accessZone.tryToAddToPending(newPending);
            if ((totalPeople += pending.count) > accessZone.getHighThreshold()) {
                if (aboveHighEnforcement.equals((Object)BEnforcementEnum.hard)) {
                    info.getRecord().setActivity(BBadgeActivity.occupancyViolation);
                    info.getRecord().setDetails(BAccessControlService.lex.getText("aboveHighThreshold", new Object[]{"" + totalPeople}));
                    return false;
                }
                if (aboveHighEnforcement.getOrdinal() == 1) {
                    info.getRecord().setActivity(BBadgeActivity.grantedButOccupancyViolation);
                    info.getRecord().setDetails(BAccessControlService.lex.getText("aboveHighThreshold", new Object[]{"" + totalPeople}));
                }
            } else if (atHighEnforcement.getOrdinal() == 1 && totalPeople == accessZone.getHighThreshold()) {
                info.getRecord().setActivity(BBadgeActivity.grantedButOccupancyViolation);
                info.getRecord().setDetails(BAccessControlService.lex.getText("atHighThreshold", new Object[]{"" + totalPeople}));
            }
            if (totalPeople <= accessZone.getLowThreshold()) {
                if (belowLowEnforcement.getOrdinal() == 2) {
                    if (pending.alreadyPending) {
                        info.getRecord().setActivity(BBadgeActivity.occupancyViolation);
                        info.getRecord().setDetails(BAccessControlService.lex.getText("personAlreadyPendingEntry"));
                        return false;
                    }
                    if (totalPeople < accessZone.getLowThreshold()) {
                        info.getRecord().setActivity(BBadgeActivity.grantedIfOccupancyCorrected);
                    }
                }
                if (atLowEnforcement.getOrdinal() == 1 && totalPeople == accessZone.getLowThreshold()) {
                    info.getRecord().setActivity(BBadgeActivity.grantedButOccupancyViolation);
                    info.getRecord().setDetails(BAccessControlService.lex.getText("atLowThreshold", new Object[]{"" + totalPeople}));
                }
            }
        }
        return true;
    }

    public static boolean validateAccessZoneExit(BAccessZone accessZone, BAccessZoneRec accessZoneRec, BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        int supervisorCount;
        info.hasExitAccessZone = true;
        boolean personIsSupervisor = false;
        if (accessZone.getLockDown()) {
            info.getRecord().setActivity(BBadgeActivity.grantedButAccessZoneDisabled);
            return true;
        }
        if (info.validatedRemotely && !AccessZonesValidationUtil.personExists(info, session, dbCache)) {
            info.getRecord().setActivity(BBadgeActivity.grantedButConnectionProblem);
            info.getRecord().setDetails(BAccessControlService.lex.getText("error.personDoesNotExistLocally"));
            return true;
        }
        BEnforcementEnum passbackEnum = accessZone.getPassbackMode();
        BPersonZoneJoin inside = AccessZonesValidationUtil.getPersonZoneJoin(info, session, dbCache, accessZoneRec);
        if (inside == null && !passbackEnum.equals((Object)BEnforcementEnum.off)) {
            info.getRecord().setActivity(BBadgeActivity.grantedButAntiPassbackViolation);
            info.getRecord().setDetails(BAccessControlService.lex.getText("personExitingIsNotInside"));
            return true;
        }
        if (inside == null) {
            return true;
        }
        BEnforcementEnum supervisorEnum = accessZone.getSupervisorRequiredEnforcement();
        boolean isSupervisor = false;
        if (supervisorEnum.equals((Object)BEnforcementEnum.off)) {
            personIsSupervisor = true;
        }
        if (!supervisorEnum.equals((Object)BEnforcementEnum.off) || accessZone.getOccupancyCriteria() == BOccupancyEnum.supervisors) {
            BSupervisorZoneJoin supervisor = new BSupervisorZoneJoin();
            supervisor.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)info.getPersonData().getPersonUuid()));
            supervisor.setAccessZone(BRef.make((BIOrionObject)accessZoneRec));
            isSupervisor = AccessZonesValidationUtil.supervisorExists(info, session, dbCache, supervisor);
        }
        if (!supervisorEnum.equals((Object)BEnforcementEnum.off) && isSupervisor && (supervisorCount = AccessZonesValidationUtil.getOccupiedSupervisorCount(info, session, dbCache, accessZoneRec)) <= 1) {
            info.getRecord().setActivity(BBadgeActivity.grantedButSupervisorRequired);
        }
        if (accessZone.getOccupancyCriteria() == BOccupancyEnum.supervisors && !isSupervisor) {
            return true;
        }
        BDynamicEnum belowLowEnforcement = accessZone.getBelowLowThresholdEnforcement();
        BDynamicEnum atLowEnforcement = accessZone.getAtLowThresholdEnforcement();
        if (atLowEnforcement.getOrdinal() != 0 || belowLowEnforcement.getOrdinal() != 0) {
            int totalPeople = AccessZonesValidationUtil.getOccupiedPersonsCount(info, session, dbCache, accessZoneRec);
            BAccessZone.PendingOccupancy newPending = new BAccessZone.PendingOccupancy(info.getPersonData().getPersonUuid(), info.getDoorHandle(), false, personIsSupervisor);
            BAccessZone.Pending pending = accessZone.tryToAddToPending(newPending);
            if ((totalPeople -= pending.count) < accessZone.getLowThreshold()) {
                if (belowLowEnforcement.getOrdinal() == 2) {
                    if (pending.alreadyPending) {
                        info.getRecord().setActivity(BBadgeActivity.grantedButOccupancyViolation);
                        info.getRecord().setDetails(BAccessControlService.lex.getText("personAlreadyPendingExit"));
                    } else if (totalPeople > 0) {
                        info.setAccessZoneRec(new BAccessZoneRec());
                        info.getRecord().setActivity(BBadgeActivity.grantedButWaitingOnMoreOccupancy);
                        accessZone.generateAlarmOnCleanUpFor2ManRule = info.getDoorHandle();
                    } else if (totalPeople == 0) {
                        if (info.getRecord().getActivity() == BBadgeActivity.grantedButSupervisorRequired) {
                            info.getRecord().setActivity(BBadgeActivity.granted);
                            info.setAccessZoneRec(new BAccessZoneRec());
                        }
                        accessZone.generateAlarmOnCleanUpFor2ManRule = null;
                    }
                }
            } else if (atLowEnforcement.getOrdinal() == 1 && totalPeople == accessZone.getLowThreshold()) {
                info.getRecord().setActivity(BBadgeActivity.grantedButOccupancyViolation);
                info.getRecord().setDetails(BAccessControlService.lex.getText("atLowThreshold", new Object[]{"" + totalPeople}));
            }
        }
        return true;
    }

    public static void clearMaybePending(BAccessZoneRec rec, BAccessValidationInfo info, boolean entry) {
        if (rec.getStationName().equals(Sys.getStation().getStationName())) {
            BAccessZone z = null;
            z = entry ? info.entryZones.get(rec.getUuid()) : info.exitZones.get(rec.getUuid());
            z.clearMaybePending();
        } else {
            try {
                RemoteUtil.invokeRemote(rec.getStationName(), rec.getMappedOrd(), BAccessZone.remoteClearMaybePending, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void confirmMaybePending(BAccessZoneRec rec, BAccessValidationInfo info, boolean entry) {
        if (rec.getStationName().equals(Sys.getStation().getStationName())) {
            BAccessZone z = null;
            z = entry ? info.entryZones.get(rec.getUuid()) : info.exitZones.get(rec.getUuid());
            z.confirmMaybePending();
        } else {
            try {
                RemoteUtil.invokeRemote(rec.getStationName(), rec.getMappedOrd(), BAccessZone.remoteConfirmMaybePending, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static BAccessZoneRec[] getEntryZoneRecs(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getEntryZones(info.readerRec.getUuid());
        }
        return (BAccessZoneRec[])info.readerRec.getEntryAccessZones(session).toArray();
    }

    private static BAccessZoneRec[] getExitZoneRecs(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getExitZones(info.readerRec.getUuid());
        }
        return (BAccessZoneRec[])info.readerRec.getExitAccessZones(session).toArray();
    }

    public static BPersonZoneJoin getPersonZoneJoin(BAccessValidationInfo info, OrionSession session, DbCache dbCache, BAccessZoneRec accessZoneRec) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getPersonZoneJoin(dbCache, info.getPersonData().getPersonUuid(), accessZoneRec.getUuid());
        }
        BPersonZoneJoin inside = new BPersonZoneJoin();
        inside.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)info.getPersonData().getPersonUuid()));
        inside.setAccessZone(BRef.make((BIOrionObject)accessZoneRec));
        return (BPersonZoneJoin)session.read((BIOrionObject)inside);
    }

    public static boolean supervisorExists(BAccessValidationInfo info, OrionSession session, DbCache dbCache, BSupervisorZoneJoin supervisorZoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            BSupervisorZoneJoin zoneJoin = dbCache.getSupervisorZoneJoin(dbCache, (BUuid)supervisorZoneJoin.getPerson().getId(), (BUuid)supervisorZoneJoin.getAccessZone().getId());
            return zoneJoin != null;
        }
        return session.exists((BIOrionObject)supervisorZoneJoin);
    }

    private static int getOccupiedSupervisorCount(BAccessValidationInfo info, OrionSession session, DbCache dbCache, BAccessZoneRec accessZoneRec) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getAccessZoneSupervisorCount(accessZoneRec.getUuid());
        }
        return accessZoneRec.getOccupiedSupervisorCount(session);
    }

    private static int getOccupiedPersonsCount(BAccessValidationInfo info, OrionSession session, DbCache dbCache, BAccessZoneRec accessZoneRec) {
        if (!dbCache.isRunningOnSupervisor()) {
            return dbCache.getAccessZonePersonCount(accessZoneRec.getUuid());
        }
        return accessZoneRec.getOccupiedCount(session);
    }

    private static boolean personExists(BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        if (!dbCache.isRunningOnSupervisor()) {
            return PersonCache.exists(dbCache, info.getPersonData().getPersonUuid());
        }
        return session.exists(BPerson.ORION_TYPE, new PropertyValue[]{new PropertyValue(BPerson.personId, (BValue)info.getPersonData().getPersonUuid())});
    }
}

