/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.EnumScheduleRecCacheData;
import com.tridiumx.entsec.orionTools.BEnumScheduleRec;
import com.tridiumx.entsec.orionTools.MappingSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.util.BUuid;

public abstract class EnumScheduleRecCache
extends AbstractCache {
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map<BUuid, EnumScheduleRecCacheData> enumScheduleRecsMap = new HashMap<BUuid, EnumScheduleRecCacheData>();

    public static void initEnumScheduleRecs(DbCache dbCache, OrionSession session) {
        EnumScheduleRecCache.getWriteLock(rwLock);
        try {
            enumScheduleRecsMap.clear();
        }
        finally {
            EnumScheduleRecCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BEnumScheduleRec.ORION_TYPE);
            while (cursor.next()) {
                BEnumScheduleRec rec = (BEnumScheduleRec)cursor.get();
                EnumScheduleRecCache.insertEnumScheduleRec(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void insertEnumScheduleRec(DbCache dbCache, BEnumScheduleRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            EnumScheduleRecCache.insertEnumScheduleRec(rec.getUuid(), rec.getScheduleDisplayPath());
        }
    }

    private static void insertEnumScheduleRec(BUuid enumScheduleRecUuid, String scheduleDisplayPath) {
        EnumScheduleRecCache.getWriteLock(rwLock);
        try {
            EnumScheduleRecCacheData data = EnumScheduleRecCache.getCacheData(enumScheduleRecUuid);
            if (data == null) {
                data = new EnumScheduleRecCacheData(scheduleDisplayPath);
            } else {
                data.setEnumScheduleDisplayPath(scheduleDisplayPath);
            }
            EnumScheduleRecCache.addMapEntry(enumScheduleRecUuid, data);
        }
        finally {
            EnumScheduleRecCache.releaseWriteLock(rwLock);
        }
    }

    public static void updateEnumScheduleRec(DbCache dbCache, BEnumScheduleRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            EnumScheduleRecCache.insertEnumScheduleRec(dbCache, rec);
        }
    }

    public static void deleteEnumScheduleRec(DbCache dbCache, BEnumScheduleRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            EnumScheduleRecCache.removeEnumScheduleRec(rec.getUuid());
        }
    }

    private static void removeEnumScheduleRec(BUuid key) {
        EnumScheduleRecCache.getWriteLock(rwLock);
        try {
            enumScheduleRecsMap.remove(key);
        }
        finally {
            EnumScheduleRecCache.releaseWriteLock(rwLock);
        }
    }

    public static BEnumSchedule getEnumSchedule(DbCache dbCache, BUuid enumScheduleRecUuid) {
        if (enumScheduleRecUuid == null) {
            return null;
        }
        EnumScheduleRecCacheData data = EnumScheduleRecCache.getCacheData(enumScheduleRecUuid);
        if (data == null) {
            return null;
        }
        String scheduleDisplayPath = data.getEnumScheduleDisplayPath();
        if (scheduleDisplayPath != null && scheduleDisplayPath.length() > 0) {
            BOrd scheduleOrd = BOrd.make((BOrd)MappingSupport.STATION_ORD, (BOrd)BOrd.make((String)MappingSupport.displayPathToSlotOrd(scheduleDisplayPath)));
            return (BEnumSchedule)scheduleOrd.get();
        }
        return null;
    }

    private static EnumScheduleRecCacheData getCacheData(BUuid enumScheduleRecUuid) {
        if (enumScheduleRecUuid == null) {
            return null;
        }
        EnumScheduleRecCache.getReadLock(rwLock);
        try {
            EnumScheduleRecCacheData enumScheduleRecCacheData = enumScheduleRecsMap.get(enumScheduleRecUuid);
            return enumScheduleRecCacheData;
        }
        finally {
            EnumScheduleRecCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, EnumScheduleRecCacheData data) {
        EnumScheduleRecCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                enumScheduleRecsMap.put(key, data);
            } else {
                EnumScheduleRecCache.removeEnumScheduleRec(key);
            }
        }
        finally {
            EnumScheduleRecCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        EnumScheduleRecCache.getReadLock(rwLock);
        try {
            int n = enumScheduleRecsMap.size();
            return n;
        }
        finally {
            EnumScheduleRecCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        EnumScheduleRecCache.getReadLock(rwLock);
        try {
            System.out.println("Enum Schedule Record Cache: " + enumScheduleRecsMap.size() + " Record(s)");
            Set<Map.Entry<BUuid, EnumScheduleRecCacheData>> set = enumScheduleRecsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry<BUuid, EnumScheduleRecCacheData> me : set) {
                BUuid key = me.getKey();
                System.out.println("  Schedule: " + key.toString());
                EnumScheduleRecCacheData data = me.getValue();
                String value = data.getEnumScheduleDisplayPath();
                System.out.println("    Display Path: " + value);
            }
            System.out.println("");
        }
        finally {
            EnumScheduleRecCache.releaseReadLock(rwLock);
        }
    }
}

