/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.SqlColumns;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.BAccessRightData;
import com.tridiumx.entsec.access.util.dbCache.data.BPersonData;
import com.tridiumx.entsec.access.util.dbCache.data.PersonAccessRightCacheData;
import com.tridiumx.entsec.access.util.dbCache.data.PersonCacheData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.query.BProjection;
import javax.baja.query.util.Predicates;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public abstract class PersonCache
extends AbstractCache {
    private static final BAccessRightData[] EMPTY_ACCESS_RIGHT_DATA_ARRAY = new BAccessRightData[0];
    private static final BAccessZoneRec[] EMPTY_ACCESS_ZONE_ARRAY = new BAccessZoneRec[0];
    private static final BPersonZoneJoin[] EMPTY_PERSON_ACCESS_ZONE_ARRAY = new BPersonZoneJoin[0];
    private static final BUuid[] EMPTY_BUUID_ARRAY = new BUuid[0];
    private static final int MAP_INITIAL_CAPACITY = 16;
    private static final float MAP_LOAD_FACTOR = 0.75f;
    private static final boolean MAP_ACCESS_ORDER = true;
    private static int max_cache_size = -1;
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map<BUuid, PersonCacheData> personsMap = new LinkedPersonMap<BUuid, PersonCacheData>(16, 0.75f, true);

    public static void initPersons(DbCache dbCache, OrionSession session) {
        PersonCache.getWriteLock(rwLock);
        try {
            personsMap.clear();
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            BSqlQuery personQuery = BSqlQuery.make((OrionType)BPerson.ORION_TYPE);
            BProjection projection = new BProjection();
            projection.add(SqlColumns.make((OrionType)BPerson.ORION_TYPE, (Property)BPerson.personId));
            projection.add(SqlColumns.make((OrionType)BPerson.ORION_TYPE, (Property)BPerson.firstName));
            projection.add(SqlColumns.make((OrionType)BPerson.ORION_TYPE, (Property)BPerson.lastName));
            projection.add(SqlColumns.make((OrionType)BPerson.ORION_TYPE, (Property)BPerson.supervisor));
            projection.add(SqlColumns.make((OrionType)BPerson.ORION_TYPE, (Property)BPerson.traceCard));
            OrionCursor cursor = session.select(personQuery.select(projection));
            BPerson person = null;
            BDynamicOrionObject result = null;
            while (cursor.next()) {
                result = (BDynamicOrionObject)cursor.get();
                person = new BPerson();
                BOrionDatabase orionDatabase = session.getOrionDatabase();
                person.setPersonId(BUuid.make((String)result.get(orionDatabase.getColumnName(BPerson.ORION_TYPE, BPerson.personId)).toString()));
                person.setFirstName(result.get(orionDatabase.getColumnName(BPerson.ORION_TYPE, BPerson.firstName)).toString());
                person.setLastName(result.get(orionDatabase.getColumnName(BPerson.ORION_TYPE, BPerson.lastName)).toString());
                person.setSupervisor(((BBoolean)result.get(orionDatabase.getColumnName(BPerson.ORION_TYPE, BPerson.supervisor))).getBoolean());
                person.setTraceCard(((BBoolean)result.get(orionDatabase.getColumnName(BPerson.ORION_TYPE, BPerson.traceCard))).getBoolean());
                PersonCache.insertPerson(dbCache, person);
            }
            cursor.close();
        }
        PersonCache.initAccessRights(dbCache, session);
        PersonCache.initPersonZones(dbCache, session);
        PersonCache.initSupervisorZones(dbCache, session);
    }

    public static BPerson initPerson(DbCache dbCache, BUuid personUuid, OrionSession session) {
        BPerson person = (BPerson)session.read(BPerson.ORION_TYPE, new PropertyValue(BPerson.personId, (BValue)personUuid));
        if (person == null) {
            return null;
        }
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.insertPerson(dbCache, person);
        }
        PersonCache.initAccessRights(dbCache, person, session);
        PersonCache.initPersonZones(dbCache, person, session);
        PersonCache.initSupervisorZones(dbCache, person, session);
        return person;
    }

    private static void initAccessRights(DbCache dbCache, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BPersonAccJoin.ORION_TYPE);
            while (cursor.next()) {
                BPersonAccJoin pa = (BPersonAccJoin)((Object)cursor.get());
                PersonCache.insertAccessRight(dbCache, pa);
            }
            cursor.close();
        }
    }

    private static void initAccessRights(DbCache dbCache, BPerson person, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BPersonAccJoin.ORION_TYPE, new PropertyValue(BPersonAccJoin.person, (BValue)BRef.make((BIOrionObject)person)));
            while (cursor.next()) {
                BPersonAccJoin pa = (BPersonAccJoin)((Object)cursor.get());
                PersonCache.insertAccessRight(dbCache, pa);
            }
            cursor.close();
        }
    }

    public static void initPersonZones(DbCache dbCache, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BPersonZoneJoin.ORION_TYPE);
            while (cursor.next()) {
                BPersonZoneJoin zoneJoin = (BPersonZoneJoin)cursor.get();
                PersonCache.insertPersonZone(dbCache, zoneJoin);
            }
            cursor.close();
        }
    }

    public static void initPersonZones(DbCache dbCache, BPerson person, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BPersonZoneJoin.ORION_TYPE, new PropertyValue(BPersonZoneJoin.person, (BValue)BRef.make((BIOrionObject)person)));
            while (cursor.next()) {
                BPersonZoneJoin zoneJoin = (BPersonZoneJoin)cursor.get();
                PersonCache.insertPersonZone(dbCache, zoneJoin);
            }
            cursor.close();
        }
    }

    public static void initSupervisorZones(DbCache dbCache, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BSupervisorZoneJoin.ORION_TYPE);
            while (cursor.next()) {
                BSupervisorZoneJoin zoneJoin = (BSupervisorZoneJoin)cursor.get();
                PersonCache.insertSupervisorZone(dbCache, zoneJoin);
            }
            cursor.close();
        }
    }

    public static void initSupervisorZones(DbCache dbCache, BPerson person, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BSupervisorZoneJoin.ORION_TYPE, new PropertyValue(BSupervisorZoneJoin.person, (BValue)BRef.make((BIOrionObject)person)));
            while (cursor.next()) {
                BSupervisorZoneJoin zoneJoin = (BSupervisorZoneJoin)cursor.get();
                PersonCache.insertSupervisorZone(dbCache, zoneJoin);
            }
            cursor.close();
        }
    }

    public static void insertPerson(DbCache dbCache, BPerson person) {
        PersonCache.insertPerson(dbCache, person, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertPerson(DbCache dbCache, BPerson person, boolean pinKnown) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.getWriteLock(rwLock);
            try {
                PersonCacheData data = PersonCache.getCacheData(person.getPersonId());
                if (data == null) {
                    data = new PersonCacheData(person);
                } else {
                    data.setPersonData(person);
                }
                data.setPinKnown(pinKnown);
                PersonCache.addMapEntry(person.getPersonId(), data);
            }
            finally {
                PersonCache.releaseWriteLock(rwLock);
            }
        }
    }

    public static void updatePerson(DbCache dbCache, BPerson person) {
        PersonCache.updatePerson(dbCache, person, false);
    }

    public static void updatePerson(DbCache dbCache, BPerson person, boolean pinKnown) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.insertPerson(dbCache, person, pinKnown);
        }
    }

    public static boolean exists(DbCache dbCache, BUuid personUuid) {
        return PersonCache.getCacheData(personUuid) != null;
    }

    public static void deletePerson(DbCache dbCache, BPerson person) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.removePerson(person.getPersonId());
        }
    }

    private static void removePerson(BUuid key) {
        PersonCache.getWriteLock(rwLock);
        try {
            personsMap.remove(key);
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
    }

    public static void insertAccessRight(DbCache dbCache, BPersonAccJoin personAccJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.insertAccessRight((BUuid)personAccJoin.getPerson().getId(), personAccJoin);
        }
    }

    private static void insertAccessRight(BUuid personUuid, BPersonAccJoin personAccJoin) {
        PersonCache.getWriteLock(rwLock);
        try {
            PersonCacheData data = PersonCache.getCacheData(personUuid);
            if (data == null) {
                data = new PersonCacheData(personAccJoin);
            } else {
                data.insertAccessRight(personAccJoin);
            }
            PersonCache.addMapEntry(personUuid, data);
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
    }

    public static void updateAccessRight(DbCache dbCache, BPersonAccJoin personAccJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.insertAccessRight(dbCache, personAccJoin);
        }
    }

    public static void deleteAccessRight(DbCache dbCache, BPersonAccJoin personAccJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.removeAccessRight((BUuid)personAccJoin.getPerson().getId(), (BUuid)personAccJoin.getAccessRight().getId());
        }
    }

    public static void removePersonsAccessRight(DbCache dbCache, OrionSession session, BAccessRight accessRight) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BPersonAccJoin.ORION_TYPE, new PropertyValue(BPersonAccJoin.accessRight, (BValue)BRef.make((BIOrionObject)accessRight)));
            while (cursor.next()) {
                BPersonAccJoin rec = (BPersonAccJoin)((Object)cursor.get());
                PersonCache.removeAccessRight((BUuid)rec.getPerson().getId(), accessRight.getAccessRightId());
            }
            cursor.close();
        }
    }

    private static void removeAccessRight(BUuid personUuid, BUuid accessRightUuid) {
        PersonCache.getWriteLock(rwLock);
        try {
            PersonCacheData data = PersonCache.getCacheData(personUuid);
            if (data != null) {
                data.deleteAccessRight(accessRightUuid);
                PersonCache.addMapEntry(personUuid, data);
            }
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
    }

    public static void removePersonsAccessZone(DbCache dbCache, OrionSession session, BAccessZoneRec accessZone) {
        PersonCache.removePersonsPersonZone(dbCache, session, accessZone);
        PersonCache.removePersonsSupervisorZone(dbCache, session, accessZone);
    }

    public static void insertPersonZone(DbCache dbCache, BPersonZoneJoin zoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.insertPersonZone((BUuid)zoneJoin.getPerson().getId(), zoneJoin);
        }
    }

    private static void insertPersonZone(BUuid personUuid, BPersonZoneJoin zoneJoin) {
        PersonCache.getWriteLock(rwLock);
        try {
            PersonCacheData data = PersonCache.getCacheData(personUuid);
            if (data == null) {
                data = new PersonCacheData(zoneJoin);
            } else {
                data.insertPersonZone(zoneJoin);
            }
            PersonCache.addMapEntry(personUuid, data);
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
    }

    public static void updatePersonZone(DbCache dbCache, BPersonZoneJoin zoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.insertPersonZone(dbCache, zoneJoin);
        }
    }

    public static void deletePersonZone(DbCache dbCache, BPersonZoneJoin zoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.removePersonZone((BUuid)zoneJoin.getPerson().getId(), (BUuid)zoneJoin.getAccessZone().getId());
        }
    }

    private static void removePersonsPersonZone(DbCache dbCache, OrionSession session, BAccessZoneRec accessZone) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BPersonZoneJoin.ORION_TYPE, new PropertyValue(BPersonZoneJoin.accessZone, (BValue)BRef.make((BIOrionObject)accessZone)));
            while (cursor.next()) {
                BPersonZoneJoin rec = (BPersonZoneJoin)cursor.get();
                PersonCache.removePersonZone((BUuid)rec.getPerson().getId(), accessZone.getUuid());
            }
            cursor.close();
        }
    }

    private static void removePersonZone(BUuid personUuid, BUuid accessZoneUuid) {
        PersonCache.getWriteLock(rwLock);
        try {
            PersonCacheData data = PersonCache.getCacheData(personUuid);
            if (data != null) {
                data.deletePersonZone(accessZoneUuid);
                PersonCache.addMapEntry(personUuid, data);
            }
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
    }

    public static void insertSupervisorZone(DbCache dbCache, BSupervisorZoneJoin zoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.insertSupervisorZone((BUuid)zoneJoin.getPerson().getId(), zoneJoin);
        }
    }

    private static void insertSupervisorZone(BUuid personUuid, BSupervisorZoneJoin zoneJoin) {
        PersonCache.getWriteLock(rwLock);
        try {
            PersonCacheData data = PersonCache.getCacheData(personUuid);
            if (data == null) {
                data = new PersonCacheData(zoneJoin);
            } else {
                data.insertSupervisorZone(zoneJoin);
            }
            PersonCache.addMapEntry(personUuid, data);
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
    }

    public static void updateSupervisorZone(DbCache dbCache, BSupervisorZoneJoin zoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.insertSupervisorZone(dbCache, zoneJoin);
        }
    }

    public static void deleteSupervisorZone(DbCache dbCache, BSupervisorZoneJoin zoneJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            PersonCache.removeSupervisorZone((BUuid)zoneJoin.getPerson().getId(), (BUuid)zoneJoin.getAccessZone().getId());
        }
    }

    private static void removePersonsSupervisorZone(DbCache dbCache, OrionSession session, BAccessZoneRec accessZone) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BSupervisorZoneJoin.ORION_TYPE, new PropertyValue(BSupervisorZoneJoin.accessZone, (BValue)BRef.make((BIOrionObject)accessZone)));
            while (cursor.next()) {
                BSupervisorZoneJoin rec = (BSupervisorZoneJoin)cursor.get();
                PersonCache.removeSupervisorZone((BUuid)rec.getPerson().getId(), accessZone.getUuid());
            }
            cursor.close();
        }
    }

    private static void removeSupervisorZone(BUuid personUuid, BUuid accessZoneUuid) {
        PersonCache.getWriteLock(rwLock);
        try {
            PersonCacheData data = PersonCache.getCacheData(personUuid);
            if (data != null) {
                data.deleteSupervisorZone(accessZoneUuid);
                PersonCache.addMapEntry(personUuid, data);
            }
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
    }

    public static BPersonData getPerson(DbCache dbCache, BUuid personUuid) {
        return PersonCache.getPerson(dbCache, personUuid, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BPersonData getPerson(DbCache dbCache, BUuid personUuid, OrionSession session, boolean refreshPersonForPin) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (refreshPersonForPin) {
            OrionCursor orionCursor = null;
            boolean isNewOrionSession = false;
            try {
                if (session == null) {
                    BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                    session = service.createSession(null);
                    isNewOrionSession = true;
                }
                BSqlQuery personQuery = BSqlQuery.make((OrionType)BPerson.ORION_TYPE);
                BProjection projection = new BProjection();
                projection.add(SqlColumns.make((OrionType)BPerson.ORION_TYPE, (Property)BPerson.pinNumber));
                personQuery.where(Predicates.eq((Property)BPerson.personId, (BSimple)personUuid));
                BDynamicOrionObject result = null;
                orionCursor = session.select(personQuery.select(projection));
                if (orionCursor.next()) {
                    result = (BDynamicOrionObject)orionCursor.get();
                    data.setPinNumber((BPassword)result.get(BPerson.pinNumber));
                }
                data.setPinKnown(true);
                PersonCache.addMapEntry(personUuid, data);
            }
            finally {
                if (orionCursor != null) {
                    orionCursor.close();
                }
                if (session != null && isNewOrionSession) {
                    session.close();
                }
            }
        }
        return data.getPerson(personUuid);
    }

    public static HashMap<BUuid, PersonAccessRightCacheData> getAccessRightEntries(DbCache dbCache, BUuid personUuid, BAbsTime time, boolean filterValidDate) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (data == null) {
            return new HashMap<BUuid, PersonAccessRightCacheData>();
        }
        return data.getAccessRightJoins(time, filterValidDate);
    }

    public static BAccessRightData[] getAccessRights(DbCache dbCache, BUuid personUuid, BAbsTime time, boolean filterValidDate) {
        HashMap<BUuid, PersonAccessRightCacheData> accessRightEntries = PersonCache.getAccessRightEntries(dbCache, personUuid, time, filterValidDate);
        if (accessRightEntries.isEmpty()) {
            return EMPTY_ACCESS_RIGHT_DATA_ARRAY;
        }
        Array arr = new Array(BAccessRightData.class);
        accessRightEntries.forEach((uuid, join) -> {
            BAccessRightData accessRightData = dbCache.getAccessRightData((BUuid)uuid);
            if (accessRightData != null) {
                if (join.getAssignedThreatLevel() == -1) {
                    arr.add((Object)accessRightData);
                } else {
                    BAccessRightData tempData = new BAccessRightData(accessRightData.getAccessRightUuid(), accessRightData.getAccessRightCacheData().newCopy());
                    if (join.getAssignedThreatLevel() != -1) {
                        tempData.getAccessRightCacheData().setAssignedThreatLevel(join.getAssignedThreatLevel());
                    }
                    arr.add((Object)tempData);
                }
            }
        });
        return (BAccessRightData[])arr.trim();
    }

    public static boolean containsAccessRight(BUuid personUuid, BUuid accessRightUuid) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (data == null) {
            return false;
        }
        return data.containsAccessRight(accessRightUuid);
    }

    public static BUuid[] getPersonZoneUuids(DbCache dbCache, BUuid personUuid) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (data == null) {
            return EMPTY_BUUID_ARRAY;
        }
        return data.getPersonZoneUuids();
    }

    public static BAccessZoneRec[] getPersonZones(DbCache dbCache, BUuid personUuid) {
        BUuid[] zoneUuids = PersonCache.getPersonZoneUuids(dbCache, personUuid);
        if (zoneUuids.length == 0) {
            return EMPTY_ACCESS_ZONE_ARRAY;
        }
        Array arr = new Array(BAccessZoneRec.class);
        for (int i = 0; i < zoneUuids.length; ++i) {
            BAccessZoneRec accessZone = dbCache.getAccessZone(zoneUuids[i]);
            if (accessZone == null) continue;
            arr.add((Object)accessZone);
        }
        return (BAccessZoneRec[])arr.trim();
    }

    public static BPersonZoneJoin getPersonZoneJoin(DbCache dbCache, BUuid personUuid, BUuid accessZoneUuid) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (data == null) {
            return null;
        }
        BAbsTime lastModified = data.getPersonZoneLastModified(accessZoneUuid);
        if (lastModified == null) {
            return null;
        }
        BPersonZoneJoin personZoneJoin = new BPersonZoneJoin();
        personZoneJoin.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)personUuid));
        personZoneJoin.setAccessZone(BRef.make((BOrionTypeId)BAccessZoneRec.ORION_TYPE.getOrionTypeId(), (BSimple)accessZoneUuid));
        personZoneJoin.setLastModified(lastModified);
        personZoneJoin.clearAllModified();
        return personZoneJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BPersonZoneJoin[] getOccupiedPersons(BUuid accessZoneUuid) {
        PersonCache.getReadLock(rwLock);
        try {
            BPersonZoneJoin[] bPersonZoneJoinArray;
            Set<Map.Entry<BUuid, PersonCacheData>> set = personsMap.entrySet();
            if (set.isEmpty()) {
                BPersonZoneJoin[] bPersonZoneJoinArray2 = EMPTY_PERSON_ACCESS_ZONE_ARRAY;
                return bPersonZoneJoinArray2;
            }
            Array arr = new Array(BPersonZoneJoin.class);
            for (Map.Entry<BUuid, PersonCacheData> me : set) {
                BUuid personUuid = me.getKey();
                PersonCacheData data = me.getValue();
                if (!data.containsPersonZone(accessZoneUuid)) continue;
                BPersonZoneJoin personZoneJoin = new BPersonZoneJoin();
                personZoneJoin.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)personUuid));
                personZoneJoin.setAccessZone(BRef.make((BOrionTypeId)BAccessZoneRec.ORION_TYPE.getOrionTypeId(), (BSimple)accessZoneUuid));
                personZoneJoin.clearAllModified();
                arr.add((Object)personZoneJoin);
            }
            if (arr.size() == 0) {
                bPersonZoneJoinArray = EMPTY_PERSON_ACCESS_ZONE_ARRAY;
                return bPersonZoneJoinArray;
            }
            bPersonZoneJoinArray = (BPersonZoneJoin[])arr.trim();
            return bPersonZoneJoinArray;
        }
        finally {
            PersonCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAccessZoneOccupancy(BUuid accessZoneUuid) {
        PersonCache.getReadLock(rwLock);
        try {
            Set<Map.Entry<BUuid, PersonCacheData>> set = personsMap.entrySet();
            if (set.isEmpty()) {
                return;
            }
            for (Map.Entry<BUuid, PersonCacheData> me : set) {
                PersonCacheData data = me.getValue();
                if (!data.containsPersonZone(accessZoneUuid)) continue;
                data.deletePersonZone(accessZoneUuid);
            }
        }
        finally {
            PersonCache.releaseReadLock(rwLock);
        }
    }

    public static boolean containsPersonZone(BUuid personUuid, BUuid accessZoneUuid) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (data == null) {
            return false;
        }
        return data.containsPersonZone(accessZoneUuid);
    }

    public static BUuid[] getSupervisorZoneUuids(DbCache dbCache, BUuid personUuid) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (data == null) {
            return EMPTY_BUUID_ARRAY;
        }
        return data.getSupervisorZoneUuids();
    }

    public static BAccessZoneRec[] getSupervisorZones(DbCache dbCache, BUuid personUuid) {
        BUuid[] zoneUuids = PersonCache.getSupervisorZoneUuids(dbCache, personUuid);
        if (zoneUuids.length == 0) {
            return EMPTY_ACCESS_ZONE_ARRAY;
        }
        Array arr = new Array(BAccessZoneRec.class);
        for (int i = 0; i < zoneUuids.length; ++i) {
            BAccessZoneRec accessZone = dbCache.getAccessZone(zoneUuids[i]);
            if (accessZone == null) continue;
            arr.add((Object)accessZone);
        }
        return (BAccessZoneRec[])arr.trim();
    }

    public static BSupervisorZoneJoin getSupervisorZoneJoin(DbCache dbCache, BUuid personUuid, BUuid accessZoneUuid) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (data == null) {
            return null;
        }
        BAbsTime lastModified = data.getSupervisorZoneLastModified(accessZoneUuid);
        if (lastModified == null) {
            return null;
        }
        BSupervisorZoneJoin supervisorZoneJoin = new BSupervisorZoneJoin();
        supervisorZoneJoin.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)personUuid));
        supervisorZoneJoin.setAccessZone(BRef.make((BOrionTypeId)BAccessZoneRec.ORION_TYPE.getOrionTypeId(), (BSimple)accessZoneUuid));
        supervisorZoneJoin.setLastModified(lastModified);
        supervisorZoneJoin.clearAllModified();
        return supervisorZoneJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BPersonZoneJoin[] getOccupiedSupervisors(BUuid accessZoneUuid) {
        PersonCache.getReadLock(rwLock);
        try {
            BPersonZoneJoin[] bPersonZoneJoinArray;
            Set<Map.Entry<BUuid, PersonCacheData>> set = personsMap.entrySet();
            if (set.isEmpty()) {
                BPersonZoneJoin[] bPersonZoneJoinArray2 = EMPTY_PERSON_ACCESS_ZONE_ARRAY;
                return bPersonZoneJoinArray2;
            }
            Array arr = new Array(BPersonZoneJoin.class);
            for (Map.Entry<BUuid, PersonCacheData> me : set) {
                BUuid personUuid = me.getKey();
                PersonCacheData data = me.getValue();
                if (!data.containsPersonZone(accessZoneUuid) || !data.containsSupervisorZone(accessZoneUuid)) continue;
                BPersonZoneJoin personZoneJoin = new BPersonZoneJoin();
                personZoneJoin.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)personUuid));
                personZoneJoin.setAccessZone(BRef.make((BOrionTypeId)BAccessZoneRec.ORION_TYPE.getOrionTypeId(), (BSimple)accessZoneUuid));
                personZoneJoin.clearAllModified();
                arr.add((Object)personZoneJoin);
            }
            if (arr.size() == 0) {
                bPersonZoneJoinArray = EMPTY_PERSON_ACCESS_ZONE_ARRAY;
                return bPersonZoneJoinArray;
            }
            bPersonZoneJoinArray = (BPersonZoneJoin[])arr.trim();
            return bPersonZoneJoinArray;
        }
        finally {
            PersonCache.releaseReadLock(rwLock);
        }
    }

    public static boolean containsSupervisorZone(BUuid personUuid, BUuid accessZoneUuid) {
        PersonCacheData data = PersonCache.getCacheData(personUuid);
        if (data == null) {
            return false;
        }
        return data.containsSupervisorZone(accessZoneUuid);
    }

    public static PersonCacheData getCacheData(BUuid personUuid) {
        if (personUuid == null) {
            return null;
        }
        PersonCache.getReadLock(rwLock);
        try {
            PersonCacheData personCacheData = personsMap.get(personUuid);
            return personCacheData;
        }
        finally {
            PersonCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, PersonCacheData data) {
        PersonCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                personsMap.put(key, data);
            } else {
                PersonCache.removePerson(key);
            }
        }
        finally {
            PersonCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        PersonCache.getReadLock(rwLock);
        try {
            int n = personsMap.size();
            return n;
        }
        finally {
            PersonCache.releaseReadLock(rwLock);
        }
    }

    public static Map<BUuid, PersonCacheData> getPersonsMap() {
        return personsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        PersonCache.getReadLock(rwLock);
        try {
            System.out.println("Person Cache: " + personsMap.size() + " Record(s). Max cache size: " + max_cache_size);
            Set<Map.Entry<BUuid, PersonCacheData>> set = personsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry<BUuid, PersonCacheData> me : set) {
                BUuid personUuid = me.getKey();
                System.out.println("  Person: " + personUuid.toString());
                PersonCacheData data = me.getValue();
                System.out.println("    Name: " + data.getDisplayString());
                System.out.println("    Supervisor: " + data.getSupervisor());
                System.out.println("    Trace Card: " + data.getTraceCard());
                data.printMap();
            }
            System.out.println("");
        }
        finally {
            PersonCache.releaseReadLock(rwLock);
        }
    }

    public static int getMaxCacheSize() {
        return max_cache_size;
    }

    public static void setMaxCacheSize(int size) {
        max_cache_size = size;
    }

    private static class LinkedPersonMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        protected LinkedPersonMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (max_cache_size == -1) {
                return false;
            }
            AbstractCache.getReadLock(rwLock);
            try {
                boolean bl = this.size() > max_cache_size;
                return bl;
            }
            finally {
                AbstractCache.releaseReadLock(rwLock);
            }
        }
    }
}

