/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BThreatLevelBadgeJoin;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.BThreatLevelBadgeJoinData;
import com.tridiumx.entsec.access.util.dbCache.data.ThreatLevelBadgeJoinCacheData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;

public abstract class ThreatLevelBadgeJoinCache
extends AbstractCache {
    private static final BThreatLevelBadgeJoinData[] EMPTY_THREAT_LEVEL_DATA_ARRAY = new BThreatLevelBadgeJoinData[0];
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map<BString, ThreatLevelBadgeJoinCacheData> threatLevelGroupsMap = new HashMap<BString, ThreatLevelBadgeJoinCacheData>();

    public static void initThreatLevelBadgeJoins(DbCache dbCache, OrionSession session) {
        ThreatLevelBadgeJoinCache.getWriteLock(rwLock);
        try {
            threatLevelGroupsMap.clear();
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BThreatLevelBadgeJoin.ORION_TYPE);
            while (cursor.next()) {
                BThreatLevelBadgeJoin rec = (BThreatLevelBadgeJoin)((Object)cursor.get());
                ThreatLevelBadgeJoinCache.insertThreatLevelBadgeJoin(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void initThreatLevelBadgeJoins(DbCache dbCache, BThreatLevelBadgeJoin[] threatLevelGroups) {
        ThreatLevelBadgeJoinCache.getWriteLock(rwLock);
        try {
            threatLevelGroupsMap.clear();
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            for (int i = 0; i < threatLevelGroups.length; ++i) {
                ThreatLevelBadgeJoinCache.insertThreatLevelBadgeJoin(dbCache, threatLevelGroups[i]);
            }
        }
    }

    public static void insertThreatLevelBadgeJoin(DbCache dbCache, BThreatLevelBadgeJoin rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            ThreatLevelBadgeJoinCache.getWriteLock(rwLock);
            try {
                ThreatLevelBadgeJoinCacheData data = ThreatLevelBadgeJoinCache.getCacheData(rec.getBadge().getId());
                if (data == null) {
                    data = new ThreatLevelBadgeJoinCacheData(rec);
                } else {
                    data.setData(rec);
                }
                ThreatLevelBadgeJoinCache.addMapEntry((BString)rec.getBadge().getId(), data);
            }
            finally {
                ThreatLevelBadgeJoinCache.releaseWriteLock(rwLock);
            }
        }
    }

    public static void updateThreatLevelBadgeJoin(DbCache dbCache, BThreatLevelBadgeJoin rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            ThreatLevelBadgeJoinCache.insertThreatLevelBadgeJoin(dbCache, rec);
        }
    }

    public static void deleteThreatLevelBadgeJoin(DbCache dbCache, BString badgeId) {
        if (!dbCache.isRunningOnSupervisor()) {
            BThreatLevelBadgeJoin join = new BThreatLevelBadgeJoin();
            join.setBadge(BRef.make((BOrionTypeId)BBadge.ORION_TYPE.getOrionTypeId(), (BSimple)badgeId));
            ThreatLevelBadgeJoinCache.removeThreatLevelBadgeJoin(dbCache, join);
        }
    }

    public static void deleteThreatLevelBadgeJoin(DbCache dbCache, BThreatLevelBadgeJoin threatLevelGroup) {
        if (!dbCache.isRunningOnSupervisor()) {
            ThreatLevelBadgeJoinCache.removeThreatLevelBadgeJoin(dbCache, threatLevelGroup);
        }
    }

    private static void removeThreatLevelBadgeJoin(DbCache dbCache, BThreatLevelBadgeJoin threatLevelGroup) {
        boolean objectExists = false;
        ThreatLevelBadgeJoinCache.getWriteLock(rwLock);
        try {
            objectExists = threatLevelGroupsMap.remove(threatLevelGroup.getBadge().getId()) != null;
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseWriteLock(rwLock);
        }
        if (objectExists) {
            dbCache.removeThreatLevelBadgeJoins(threatLevelGroup);
        }
    }

    public static BThreatLevelBadgeJoinData getThreatLevelBadgeJoinData(BString badgeId) {
        ThreatLevelBadgeJoinCache.getReadLock(rwLock);
        try {
            ThreatLevelBadgeJoinCacheData cacheData = ThreatLevelBadgeJoinCache.getCacheData((BSimple)badgeId);
            if (cacheData == null) {
                BThreatLevelBadgeJoinData bThreatLevelBadgeJoinData = null;
                return bThreatLevelBadgeJoinData;
            }
            BThreatLevelBadgeJoinData bThreatLevelBadgeJoinData = new BThreatLevelBadgeJoinData(badgeId, cacheData);
            return bThreatLevelBadgeJoinData;
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BThreatLevelBadgeJoinData[] getThreatLevelBadgeJoinDataArr() {
        ThreatLevelBadgeJoinCache.getReadLock(rwLock);
        try {
            Set<Map.Entry<BString, ThreatLevelBadgeJoinCacheData>> set = threatLevelGroupsMap.entrySet();
            if (set.isEmpty()) {
                BThreatLevelBadgeJoinData[] bThreatLevelBadgeJoinDataArray = EMPTY_THREAT_LEVEL_DATA_ARRAY;
                return bThreatLevelBadgeJoinDataArray;
            }
            Array arr = new Array(BThreatLevelBadgeJoinData.class);
            for (Map.Entry<BString, ThreatLevelBadgeJoinCacheData> me : set) {
                ThreatLevelBadgeJoinCacheData data;
                BString key = me.getKey();
                BThreatLevelBadgeJoinData threatLevelGroupData = new BThreatLevelBadgeJoinData(key, data = me.getValue());
                if (threatLevelGroupData == null) continue;
                arr.add((Object)threatLevelGroupData);
            }
            BThreatLevelBadgeJoinData[] bThreatLevelBadgeJoinDataArray = (BThreatLevelBadgeJoinData[])arr.trim();
            return bThreatLevelBadgeJoinDataArray;
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseReadLock(rwLock);
        }
    }

    private static ThreatLevelBadgeJoinCacheData getCacheData(BSimple key) {
        if (key == null) {
            return null;
        }
        ThreatLevelBadgeJoinCache.getReadLock(rwLock);
        try {
            ThreatLevelBadgeJoinCacheData threatLevelBadgeJoinCacheData = threatLevelGroupsMap.get(key);
            return threatLevelBadgeJoinCacheData;
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BString key, ThreatLevelBadgeJoinCacheData data) {
        ThreatLevelBadgeJoinCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                threatLevelGroupsMap.put(key, data);
            } else {
                threatLevelGroupsMap.remove(key);
            }
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        ThreatLevelBadgeJoinCache.getReadLock(rwLock);
        try {
            int n = threatLevelGroupsMap.size();
            return n;
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        ThreatLevelBadgeJoinCache.getReadLock(rwLock);
        try {
            System.out.println("Threat Level Cache: " + ThreatLevelBadgeJoinCache.getSize() + " Record(s)");
            Set<Map.Entry<BString, ThreatLevelBadgeJoinCacheData>> set = threatLevelGroupsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry<BString, ThreatLevelBadgeJoinCacheData> me : set) {
                BString key = me.getKey();
                System.out.println("  Threat Level: " + key.toString());
                ThreatLevelBadgeJoinCacheData data = me.getValue();
                int activeLevel = data.getActiveThreatLevel();
                System.out.println("    Badge: " + key);
                System.out.println("    ThreatLevelGroup: " + data.getThreatLevelGroupUuid());
                System.out.println("    ActiveThreatLevel: " + activeLevel);
            }
            System.out.println("");
        }
        finally {
            ThreatLevelBadgeJoinCache.releaseReadLock(rwLock);
        }
    }
}

