/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.backup;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.file.FoxFileException;
import com.tridium.sys.station.Station;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.backup.BBackupService;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BRemoteBackupChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BRemoteBackupChannel.class);
    public static final Lexicon lex = Lexicon.make(BRemoteBackupChannel.class);
    public static final String BACK_UP = "remoteBackup";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRemoteBackupChannel() {
        super(BACK_UP);
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == BACK_UP) {
            this.backup(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public InputStream backup(boolean save) throws Exception {
        if (this.isTraceOn()) {
            this.trace("entsec:remotebackup save=" + save);
        }
        FoxMessage req = new FoxMessage();
        req.add("save", save);
        FoxCircuit circuit = this.openCircuit(BACK_UP);
        circuit.writeMessage(req);
        FoxMessage resp = circuit.readMessage();
        if (resp.getBoolean("failure", false)) {
            if (resp.getString("exception", null) != null) {
                throw Fox.exceptionTranslator.messageToException(resp);
            }
            throw new FoxFileException(lex.getText("backup.error.badFile"));
        }
        circuit.flush();
        return circuit.getInputStream();
    }

    public void backup(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        boolean save = req.getBoolean("save", false);
        FoxMessage resp = new FoxMessage();
        circuit.writeMessage(resp);
        BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        if (!service.getPermissions(this.getSessionContext()).has(48)) {
            throw new PermissionException();
        }
        if (this.isTraceOn()) {
            this.trace("entsec :remotebackup  save=" + save);
        }
        if (save) {
            Station.saveSync();
        }
        OutputStream out = circuit.getOutputStream();
        service.zip(null, out, true, this.getSessionContext());
    }
}

