/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.backup;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.nd.BNiagaraStation;
import com.tridium.util.TimeFormat;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.backup.BSystemBackups;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.security.AccessController;
import javax.baja.backup.BBackupService;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSystemRestoreJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemRestoreJob.class);
    private boolean fromArchive;
    private BIFile file;
    private String[] stationNames;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSystemRestoreJob() {
    }

    public BSystemRestoreJob(BIFile file, String[] stationNames, boolean fromArchive) {
        this.file = file;
        this.stationNames = stationNames;
        this.fromArchive = fromArchive;
    }

    public void run(Context cx) throws Exception {
        BAbsTime now = Clock.time();
        String timestamp = TimeFormat.format((BAbsTime)now, (String)"YYMMDD_HHmm");
        if (this.file instanceof BZipFile) {
            boolean allDown;
            int i;
            int i2;
            BZipFile zipFile = (BZipFile)this.file;
            this.log().message("Opening zip file:" + zipFile + " for " + this.stationNames.length + " stations.");
            this.progress(2);
            zipFile.open();
            BIFile supervisorFile = null;
            BIFile[] files = zipFile.getZipSpace().listFiles();
            Array subordinateStations = new Array(BNiagaraStation.class);
            Array subDistributionFiles = new Array(BDistributionFile.class);
            this.log().message("Ensuring open connections for all subordinates...");
            for (i2 = 0; i2 < files.length; ++i2) {
                BDistributionFile backupFile = (BDistributionFile)files[i2];
                BDistribution dist = backupFile.makeDistribution();
                String[] split = TextUtil.split((String)dist.getDescription(), (char)'\"');
                String stationName = split[1];
                String hostName = split[3];
                BNiagaraStation station = this.getSubordinateStationToBackup(stationName);
                if (station != null) {
                    if (!station.getEnabled()) {
                        throw new Exception("Stations must be enabled: " + station.getStationName());
                    }
                    this.log().message("Ensuring open connections for station: " + station.getStationName());
                    BFoxSession foxSession = RemoteUtil.getFoxSession(station);
                    foxSession.engageNoRetry(timestamp);
                    foxSession.disengage(timestamp);
                    subordinateStations.add((Object)station);
                    subDistributionFiles.add((Object)backupFile);
                    continue;
                }
                if (!Sys.getStation().getStationName().equals(stationName) || !this.restoreStation(stationName)) continue;
                supervisorFile = files[i2];
            }
            this.progress(10);
            for (i2 = 0; i2 < subordinateStations.size(); ++i2) {
                this.progress((int)(10.0f + 20.0f * (float)i2 / (float)subordinateStations.size()));
                BNiagaraStation station = (BNiagaraStation)subordinateStations.get(i2);
                BDistributionFile backupFile = (BDistributionFile)subDistributionFiles.get(i2);
                BDistribution dist = backupFile.makeDistribution();
                this.restoreRemoteStation(station, backupFile, dist, cx);
            }
            this.log().message("Waiting for all remote stations to initiate shutdown sequence");
            boolean[] down = new boolean[subordinateStations.size()];
            for (i = 0; i < down.length; ++i) {
                down[i] = false;
            }
            do {
                Thread.sleep(2000L);
                for (i = 0; i < subordinateStations.size(); ++i) {
                    BNiagaraStation station = (BNiagaraStation)subordinateStations.get(i);
                    try {
                        this.checkProgress(station, cx);
                        continue;
                    }
                    catch (ConnectException e) {
                        down[i] = true;
                        continue;
                    }
                    catch (ServiceNotFoundException ee) {
                        down[i] = true;
                    }
                }
                allDown = true;
                for (int i3 = 0; i3 < down.length; ++i3) {
                    if (down[i3]) continue;
                    allDown = false;
                }
            } while (!allDown);
            this.log().message("All remote stations have restarted...");
            this.progress(35);
            if (supervisorFile != null) {
                this.log().message("Copying Recovery file for supervisor: " + Sys.getStation().getStationName());
                this.progress(40);
                BDistributionFile backupFile = (BDistributionFile)supervisorFile;
                BDistribution dist = backupFile.makeDistribution();
                FilePath copyPath = new FilePath("^" + dist.getInstallableFileName());
                BIFile copyFile = BFileSystem.INSTANCE.makeFile(copyPath);
                OutputStream outputStream = copyFile.getOutputStream();
                FileUtil.pipe((InputStream)supervisorFile.getInputStream(), (OutputStream)outputStream);
                supervisorFile.getInputStream().close();
                outputStream.close();
                this.progress(50);
                this.log().message("Restoring Supervisor");
                AccessController.doPrivileged(() -> {
                    BBackupService svc = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
                    svc.restoreFiles(copyFile, false, false, cx);
                    return null;
                });
            }
            zipFile.close();
        } else if (this.file instanceof BDistributionFile) {
            BDistributionFile backupFile = (BDistributionFile)this.file;
            BDistribution dist = backupFile.makeDistribution();
            boolean deleteWhenDone = true;
            if (BEnterpriseSecurityService.isWorkstation() && this.fromArchive) {
                deleteWhenDone = false;
            }
            boolean deleteWhenDoneFlag = deleteWhenDone;
            AccessController.doPrivileged(() -> {
                BBackupService svc = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
                svc.restoreFiles(this.file, false, deleteWhenDoneFlag, cx);
                return null;
            });
            this.log().message("Restoring dist file for local station...");
        } else {
            throw new IllegalStateException("not allowed");
        }
    }

    public void restoreRemoteStation(BNiagaraStation station, BDistributionFile backupFile, BDistribution dist, Context cx) throws Exception {
        this.log().message("Sending recovery files to station: " + station.getStationName());
        BAbsTime now = Clock.time();
        String timestamp = TimeFormat.format((BAbsTime)now, (String)"YYMMDD_HHmm");
        BFoxSession foxSession = RemoteUtil.getFoxSession(station);
        foxSession.engageNoRetry(timestamp);
        BFileChannel chan = (BFileChannel)foxSession.getConnection().getChannels().get("file", BFileChannel.TYPE);
        FilePath path = new FilePath("^" + dist.getInstallableFileName());
        BFoxFileSpace fileSpace = new BFoxFileSpace(chan);
        BFoxFileStore remoteFileStore = chan.makeFile(fileSpace, path);
        try (OutputStream out = remoteFileStore.getOutputStream();
             InputStream in = backupFile.getInputStream();){
            FileUtil.pipe((InputStream)in, (OutputStream)out);
        }
        BEnterpriseSecurityService remoteService = (BEnterpriseSecurityService)foxSession.getService(BEnterpriseSecurityService.TYPE);
        remoteService.lease(4);
        BSystemBackups systemBackups = remoteService.getSystemBackups();
        this.log().message("starting recovery for station: " + station.getStationName());
        systemBackups.restore(BOrd.make((String)("file:^" + dist.getInstallableFileName())));
        foxSession.disengage(timestamp);
    }

    public void checkProgress(BNiagaraStation station, Context cx) throws Exception {
        BAbsTime now = Clock.time();
        String timestamp = TimeFormat.format((BAbsTime)now, (String)"YYMMDD_HHmm");
        BFoxSession foxSession = RemoteUtil.getFoxSession(station);
        foxSession.engageNoRetry(timestamp);
        BEnterpriseSecurityService remoteService = (BEnterpriseSecurityService)foxSession.getService(BEnterpriseSecurityService.TYPE);
        remoteService.lease();
        BSystemBackups systemBackups = remoteService.getSystemBackups();
        systemBackups.lease();
        String restoreInfo = systemBackups.getRestoreInfo();
        if (restoreInfo.startsWith("Failed:")) {
            throw new IllegalStateException(restoreInfo);
        }
        foxSession.disengage(timestamp);
    }

    public boolean restoreStation(String stationName) {
        for (int i = 0; i < this.stationNames.length; ++i) {
            if (!this.stationNames[i].equals(stationName)) continue;
            return true;
        }
        return false;
    }

    public BNiagaraStation getSubordinateStationToBackup(String stationName) {
        for (int i = 0; i < this.stationNames.length; ++i) {
            if (!this.stationNames[i].equals(stationName)) continue;
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BNiagaraStation[] stations = service.getMonitorSysDefSecurity().getSecuritySubordinateStations();
            for (int j = 0; j < stations.length; ++j) {
                if (!stations[j].getStationName().equals(stationName)) continue;
                return stations[j];
            }
        }
        return null;
    }
}

