/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion;

import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BRef;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionAppSchemaManager;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.util.ObjectUtil;
import com.tridiumx.accessDriver.BIIntrusionValidationService;
import com.tridiumx.accessDriver.BValidationInfo;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.LicenseChecker;
import com.tridiumx.entsec.intrusion.BIntrusionOrionRec;
import com.tridiumx.entsec.intrusion.BIntrusionRecord;
import com.tridiumx.entsec.intrusion.BIntrusionWorker;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.ValidationUtil;
import com.tridiumx.entsec.intrusion.dyntable.BIntrusionPins;
import com.tridiumx.entsec.intrusion.fox.BIntrusionChannel;
import com.tridiumx.entsec.intrusion.fox.BNiagaraIntrusionDeviceExt;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPin;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPinJoin;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneGroup;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.intrusion.orion.BMappedIntrusionZoneExt;
import com.tridiumx.entsec.intrusion.query.BIntrusionZones;
import com.tridiumx.entsec.intrusion.replicate.IntrusionReplicator;
import com.tridiumx.entsec.intrusion.schema.Upgrade_1_0_to_1_1;
import com.tridiumx.entsec.intrusion.schema.Upgrade_1_1_to_1_2;
import com.tridiumx.entsec.intrusion.schema.Upgrade_1_2_to_1_3;
import com.tridiumx.entsec.intrusion.schema.Upgrade_1_3_to_1_4;
import com.tridiumx.entsec.intrusion.schema.Upgrade_1_4_to_1_5;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BIMappingService;
import com.tridiumx.entsec.orionTools.BMappedScheduleExt;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.MergeSupport;
import com.tridiumx.entsec.orionTools.OrionTypeRegistrator;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.history.BOrionNiagaraHistoryTypeExport;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BIActivityService;
import com.tridiumx.entsec.securityUtil.HistoryManager;
import com.tridiumx.entsec.securityUtil.alarm.BNiagaraAlarmClassDeviceExt;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDef;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefEvent;
import com.tridiumx.entsec.securityUtil.orion.BSecurityHistoryConsolidator;
import java.security.AccessController;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.util.BDescriptor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistorySource;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BTypeSpec;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="intrusionZones", type="BIntrusionZones", defaultValue="new BIntrusionZones()", flags=8), @NiagaraProperty(name="intrusionWorker", type="BIntrusionWorker", defaultValue="new BIntrusionWorker()"), @NiagaraProperty(name="intrusionHistory", type="BSecurityHistoryConsolidator", defaultValue="new BSecurityHistoryConsolidator(BHistoryId.make(\"^\", \"IntrusionRecord\"), BIntrusionRecord.TYPE.getTypeSpec(), true)", flags=8), @NiagaraProperty(name="intrusionPins", type="BAppTable", defaultValue="new BIntrusionPins()", flags=8), @NiagaraProperty(name="monitorSysDef", type="BMonitorSysDef", defaultValue="new BMonitorSysDef()", flags=4), @NiagaraProperty(name="namingCollision", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="moduleDependenciesFacets", type="BFacets", defaultValue="BFacets.DEFAULT", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="handleSysDefEvent", parameterType="BMonitorSysDefEvent", defaultValue="new BMonitorSysDefEvent()", flags=5), @NiagaraAction(name="schemaUpgradeFix", flags=16), @NiagaraAction(name="cleanupAfterReplication", flags=20)})
@NiagaraTopic(name="newActivity", eventType="BActivityRecord")
public class BIntrusionService
extends BAbstractOrionApp
implements BIService,
BIMappingService,
BIActivityService,
BIIntrusionValidationService,
BIHistorySource {
    @Generated
    public static final Property intrusionZones = BIntrusionService.newProperty((int)8, (BValue)new BIntrusionZones(), null);
    @Generated
    public static final Property intrusionWorker = BIntrusionService.newProperty((int)0, (BValue)new BIntrusionWorker(), null);
    @Generated
    public static final Property intrusionHistory = BIntrusionService.newProperty((int)8, (BValue)new BSecurityHistoryConsolidator(BHistoryId.make((String)"^", (String)"IntrusionRecord"), BIntrusionRecord.TYPE.getTypeSpec(), true), null);
    @Generated
    public static final Property intrusionPins = BIntrusionService.newProperty((int)8, (BValue)new BIntrusionPins(), null);
    @Generated
    public static final Property monitorSysDef = BIntrusionService.newProperty((int)4, (BValue)new BMonitorSysDef(), null);
    @Generated
    public static final Property namingCollision = BIntrusionService.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property moduleDependenciesFacets = BIntrusionService.newProperty((int)5, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Action handleSysDefEvent = BIntrusionService.newAction((int)5, (BValue)new BMonitorSysDefEvent(), null);
    @Generated
    public static final Action schemaUpgradeFix = BIntrusionService.newAction((int)16, null);
    @Generated
    public static final Action cleanupAfterReplication = BIntrusionService.newAction((int)20, null);
    @Generated
    public static final Topic newActivity = BIntrusionService.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIntrusionService.class);
    private static Type[] serviceTypes = new Type[]{TYPE, BIMappingService.TYPE, BIIntrusionValidationService.TYPE};
    public OrionType[] registeredOrionTypes;
    public static final OrionType[] orionTypes = new OrionType[]{BIntrusionZoneRec.ORION_TYPE, BIntrusionZoneGroup.ORION_TYPE, BIntrusionPin.ORION_TYPE, BIntrusionPinJoin.ORION_TYPE, BIntrusionOrionRec.ORION_TYPE};
    private static final BIcon ICON = BIcon.make((String)"module://entsec/rc/intrusion/intrusion.png");
    public static final BIcon ERROR_ICON = BIcon.make((BIcon)ICON, (BIcon)BIcon.std((String)"badges/error.png"));
    static BTypeSpec[] historyTypesToExport = new BTypeSpec[]{BIntrusionRecord.TYPE.getTypeSpec()};
    public static final Logger LOG = Logger.getLogger(TYPE.getModule().getModuleName());
    public static final Lexicon lex = Lexicon.make(BIntrusionService.class);
    private OrionSession session;
    private HistoryManager historyManager;
    private boolean orionReady;
    private MappingSupport mappingSupport = new MappingSupport(this);
    private IntrusionReplicator<?> replicator = new IntrusionReplicator();
    public boolean fix_VERSION_1_0_to_VERSION_1_1 = false;
    public static final BSchemaVersion VERSION_1_5 = BSchemaVersion.make((String)"1.5");
    public static final BSchemaVersion VERSION_1_4 = BSchemaVersion.make((String)"1.4");
    public static final BSchemaVersion VERSION_1_3 = BSchemaVersion.make((String)"1.3");
    public static final BSchemaVersion VERSION_1_2 = BSchemaVersion.make((String)"1.2");
    public static final BSchemaVersion VERSION_1_1 = BSchemaVersion.make((String)"1.1");
    public static final BSchemaVersion VERSION_1_0 = BSchemaVersion.make((String)"1.0");
    public static final BSchemaVersion CURRENT_VERSION = VERSION_1_5;
    protected OrionAppSchemaManager schemaManager = new OrionAppSchemaManager((BIOrionApp)this, new ISchemaUpgrader[]{new Upgrade_1_0_to_1_1(), new Upgrade_1_1_to_1_2(), new Upgrade_1_2_to_1_3(), new Upgrade_1_3_to_1_4(), new Upgrade_1_4_to_1_5()});
    private static final String VENDOR = "tridium";
    private static final String INTRUSION_FEATURE = "intrusion";
    public boolean encryptPinNumbers = false;

    @Generated
    public BIntrusionZones getIntrusionZones() {
        return (BIntrusionZones)this.get(intrusionZones);
    }

    @Generated
    public void setIntrusionZones(BIntrusionZones v) {
        this.set(intrusionZones, (BValue)v, null);
    }

    @Generated
    public BIntrusionWorker getIntrusionWorker() {
        return (BIntrusionWorker)this.get(intrusionWorker);
    }

    @Generated
    public void setIntrusionWorker(BIntrusionWorker v) {
        this.set(intrusionWorker, (BValue)v, null);
    }

    @Generated
    public BSecurityHistoryConsolidator getIntrusionHistory() {
        return (BSecurityHistoryConsolidator)this.get(intrusionHistory);
    }

    @Generated
    public void setIntrusionHistory(BSecurityHistoryConsolidator v) {
        this.set(intrusionHistory, (BValue)v, null);
    }

    @Generated
    public BAppTable getIntrusionPins() {
        return (BAppTable)this.get(intrusionPins);
    }

    @Generated
    public void setIntrusionPins(BAppTable v) {
        this.set(intrusionPins, (BValue)v, null);
    }

    @Generated
    public BMonitorSysDef getMonitorSysDef() {
        return (BMonitorSysDef)this.get(monitorSysDef);
    }

    @Generated
    public void setMonitorSysDef(BMonitorSysDef v) {
        this.set(monitorSysDef, (BValue)v, null);
    }

    @Generated
    public boolean getNamingCollision() {
        return this.getBoolean(namingCollision);
    }

    @Generated
    public void setNamingCollision(boolean v) {
        this.setBoolean(namingCollision, v, null);
    }

    @Generated
    public BFacets getModuleDependenciesFacets() {
        return (BFacets)this.get(moduleDependenciesFacets);
    }

    @Generated
    public void setModuleDependenciesFacets(BFacets v) {
        this.set(moduleDependenciesFacets, (BValue)v, null);
    }

    @Generated
    public void handleSysDefEvent(BMonitorSysDefEvent parameter) {
        this.invoke(handleSysDefEvent, (BValue)parameter, null);
    }

    @Generated
    public void schemaUpgradeFix() {
        this.invoke(schemaUpgradeFix, null, null);
    }

    @Generated
    public void cleanupAfterReplication() {
        this.invoke(cleanupAfterReplication, null, null);
    }

    @Override
    @Generated
    public void fireNewActivity(BActivityRecord event) {
        this.fire(newActivity, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        super.serviceStarted();
        this.updateModuleDependencies();
        try {
            BOrionService orion = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            if (orion == null || orion.getStatus().isFault()) {
                this.configFail("non-fault OrionService required.");
                return;
            }
        }
        catch (Exception e) {
            this.configFail("non-fault OrionService required.");
        }
        try {
            BReplicationService repl = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
            repl.addListener(this.replicator);
        }
        catch (Exception e) {
            this.configFail("ReplicationService required.");
        }
        this.linkToMonitorSysDef();
    }

    public void started() throws Exception {
        super.started();
        this.mappingSupport.orionReadyAndStarted();
        this.getHistoryManager();
        BValue channel = BFoxChannelRegistry.getPrototype().get(INTRUSION_FEATURE);
        if (channel == null) {
            BFoxChannelRegistry.getPrototype().add(INTRUSION_FEATURE, (BValue)new BIntrusionChannel());
        } else if (!channel.getType().is(BIntrusionChannel.TYPE)) {
            throw new Exception("Intrusion channel already registered as " + channel.getType());
        }
        this.getComponentSpace().enableMixIn(BNiagaraIntrusionDeviceExt.TYPE);
        if (!(this.getIntrusionPins() instanceof BIntrusionPins)) {
            this.setIntrusionPins(new BIntrusionPins());
        }
        LicenseChecker licenseChecker = LicenseChecker.getChecker();
        licenseChecker.register(this.getParent(), this.getParent().getSlot(this.getName()), VENDOR, INTRUSION_FEATURE, true);
    }

    public void stopped() throws Exception {
        this.closeOrionSession();
        LicenseChecker licenseChecker = LicenseChecker.getChecker();
        licenseChecker.deregister(this.getParent());
    }

    protected void finalize() {
        this.closeOrionSession();
    }

    public void closeOrionSession() {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
            this.session = null;
        }
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature(VENDOR, INTRUSION_FEATURE);
    }

    public void serviceStopped() {
        this.unlinkFromMonitorSysDef();
        this.getComponentSpace().disableMixIn(BMappedIntrusionZoneExt.TYPE);
        this.getComponentSpace().disableMixIn(BNiagaraIntrusionDeviceExt.TYPE);
    }

    public BSchemaVersion getSchemaVersion() {
        return CURRENT_VERSION;
    }

    public void performSchemaUpgrade(BLocalOrionDatabase orionDatabase, BSchemaVersion oldVersion) throws Exception {
        this.schemaManager.performSchemaUpgrade(orionDatabase, oldVersion);
    }

    public void orionReady(BOrionDatabase db) {
        this.session = db.createSession(null);
        this.orionReady = true;
        this.getComponentSpace().enableMixIn(BMappedIntrusionZoneExt.TYPE);
        this.getComponentSpace().enableMixIn(BMappedScheduleExt.TYPE);
        this.mappingSupport.orionReadyAndStarted();
        this.getIntrusionHistory().validateOrionApp(this);
    }

    public OrionType[] getOrionTypes() {
        if (!this.orionReady || this.registeredOrionTypes == null) {
            this.registeredOrionTypes = OrionTypeRegistrator.getDistictOrionTypes(this, orionTypes, this.registeredOrionTypes);
        }
        return this.registeredOrionTypes;
    }

    public void stationStarted() throws Exception {
        BReplicationService replicationService;
        LinkCheck check;
        super.stationStarted();
        if (this.fix_VERSION_1_0_to_VERSION_1_1) {
            LOG.warning("invoking SchemaUpgradeFix");
            this.schemaUpgradeFix();
        }
        LOG.fine("Intrusion:encryptPinNumbers: " + this.encryptPinNumbers);
        if (this.encryptPinNumbers) {
            LOG.warning("Encrypting intrusion pin numbers");
            try (OrionSession orionSession = null;){
                orionSession = this.createSession(null);
                ((BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE)).getAndUpdatePinNumbers(BIntrusionPin.class, (Context)orionSession);
            }
        }
        if ((check = this.checkLink((BComponent)(replicationService = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE)), (Slot)BReplicationService.lastReplication, (Slot)cleanupAfterReplication, null)).isValid()) {
            BLink link = this.makeLink((BComponent)replicationService, (Slot)BReplicationService.lastReplication, (Slot)cleanupAfterReplication, null);
            this.add(null, (BValue)link);
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        this.getIntrusionWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSchemaUpgradeFix() {
        OrionSession orionSession = null;
        try {
            orionSession = this.createSession(null);
            OrionCursor c = orionSession.scan(BIntrusionZoneRec.ORION_TYPE);
            while (c.next()) {
                BIntrusionZoneRec rec = (BIntrusionZoneRec)c.get();
                BIntrusionZoneGroup group = new BIntrusionZoneGroup();
                group.setIntrusionZone(BRef.make((BIOrionObject)rec));
                group.setStationName(Sys.getStation().getStationName());
                this.session.persist((BIOrionObject)group);
            }
        }
        finally {
            if (orionSession != null) {
                orionSession.close();
                orionSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupAfterReplication() {
        if (this.getNamingCollision()) {
            this.setNamingCollision(false);
            LOG.fine("runnning naming collision algorithm");
            HashMap<String, BIntrusionZoneRec> map = new HashMap<String, BIntrusionZoneRec>();
            OrionSession session = null;
            try {
                session = this.createSession(null);
                OrionCursor c = session.scan(BIntrusionZoneRec.ORION_TYPE);
                while (c.next()) {
                    BIntrusionZoneRec rec = (BIntrusionZoneRec)c.get();
                    if (map.get(rec.getIntrusionZoneName()) == null) {
                        map.put(rec.getIntrusionZoneName(), rec);
                        continue;
                    }
                    BIntrusionZoneRec oldRec = rec;
                    LOG.fine("collision found:" + rec.getIntrusionZoneName());
                    try {
                        rec = (BIntrusionZoneRec)map.get(rec.getIntrusionZoneName());
                        BIntrusionZone intrusionZone = (BIntrusionZone)rec.getMappedOrd().get();
                        intrusionZone.doChangeUuid(rec.getUuid());
                    }
                    catch (Exception intrusionZone) {
                        // empty catch block
                    }
                    MergeSupport.mergeRecords((BIOrionObject)rec, (BIOrionObject)oldRec, session);
                    BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                    BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                    BIntrusionZoneRec.GroupsCursor groupsCursor = rec.getGroups(session);
                    while (groupsCursor.next()) {
                        BNiagaraAlarmClassDeviceExt alarmClassExt;
                        BIntrusionZoneGroup group = (BIntrusionZoneGroup)groupsCursor.get();
                        String stationName = group.getStationName();
                        BNiagaraStation station = (BNiagaraStation)network.get(stationName);
                        if (station == null || (alarmClassExt = (BNiagaraAlarmClassDeviceExt)station.getMixIn(BNiagaraAlarmClassDeviceExt.TYPE)) == null || !alarmClassExt.getSyncInEnabled()) continue;
                        LOG.fine("Orion collision being fixed on :" + stationName);
                        try {
                            RemoteUtil.invokeRemote(stationName, oldRec.getMappedOrd(), BIntrusionZone.changeUuid, (BValue)rec.getUuid());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    public boolean validatePin(BValidationInfo info) {
        return ValidationUtil.validatePin(info.getAccessReader(), info.getPin(), this.session);
    }

    @Override
    public boolean isOrionReady() {
        return this.orionReady;
    }

    @Override
    public void mappedRemoved(BComponent c) {
        this.mappingSupport.mappedRemoved(c);
    }

    @Override
    public void mappedAdded(BComponent c) {
        this.mappingSupport.mappedAdded(c);
    }

    @Override
    public void mappedUpdate(BComponent c) {
        this.mappingSupport.mappedUpdate(c);
    }

    @Override
    public void mappedPersist(BComponent c) {
        this.mappingSupport.mappedPersist(c);
    }

    public HistoryManager getHistoryManager() {
        if (this.historyManager == null) {
            this.historyManager = new HistoryManager(this, new Type[]{BIntrusionRecord.TYPE}, new HistoryManager.HistoryConverter[]{new IntrusionToActivity()});
        }
        return this.historyManager;
    }

    public void appendIntrusionHistory(BIntrusionRecord record) {
        this.getHistoryManager().append(record);
    }

    public BIcon getIcon() {
        return !this.getStatus().isFault() ? ICON : ERROR_ICON;
    }

    public void historyConfigChanged(BHistoryConfig config, Property p) {
        if (!this.isRunning()) {
            return;
        }
        this.getHistoryManager().historyConfigChanged(config, p);
    }

    private void linkToMonitorSysDef() {
        if (this.get("sysDefLink") != null) {
            return;
        }
        this.linkTo("sysDefLink", this.getMonitorSysDef(), (Slot)BMonitorSysDef.monitorSysDefEvent, (Slot)handleSysDefEvent);
    }

    private void unlinkFromMonitorSysDef() {
        Property p = this.getProperty("sysDefLink");
        if (p != null) {
            this.remove(p);
        }
    }

    public void doHandleSysDefEvent(BMonitorSysDefEvent event) throws Exception {
        String stationName = event.getStationName();
        int role = event.getRole();
        int eventType = event.getId();
        if (BMonitorSysDefEvent.isInsert(eventType)) {
            BNiagaraNetwork ntwk = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation niagaraSupervisorStation = (BNiagaraStation)ntwk.getNiagaraStation(stationName);
            if (BMonitorSysDefEvent.isSupervisor(role)) {
                try {
                    this.configureHistoryExports(niagaraSupervisorStation, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (BMonitorSysDefEvent.isDelete(eventType) && BMonitorSysDefEvent.isSupervisor(role)) {
            try {
                BNiagaraNetwork ntwk = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                BNiagaraStation niagaraSupervisorStation = (BNiagaraStation)ntwk.getNiagaraStation(stationName);
                if (niagaraSupervisorStation == null) {
                    LOG.warning("Cannot find supervisor station " + stationName + " for SysDefEvent: " + (Object)((Object)event));
                } else {
                    this.configureHistoryExports(niagaraSupervisorStation, false);
                }
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.SEVERE, "Unhandled SysDefEvent: " + (Object)((Object)event), e);
                }
                LOG.severe("Unhandled SysDefEvent: " + (Object)((Object)event) + ": " + e.getMessage());
            }
        }
    }

    private void configureHistoryExports(BNiagaraStation station, boolean enable) {
        BDescriptor[] descriptors = station.getHistories().getDescriptors();
        for (int j = 0; j < historyTypesToExport.length; ++j) {
            BTypeSpec recType = historyTypesToExport[j];
            boolean foundExisting = false;
            for (int i = 0; i < descriptors.length; ++i) {
                BDescriptor descriptor = descriptors[i];
                if (!(descriptor instanceof BOrionNiagaraHistoryTypeExport) || !((BOrionNiagaraHistoryTypeExport)descriptor).getRecordType().equals((Object)recType)) continue;
                foundExisting = true;
                if (enable) {
                    descriptor.setEnabled(true);
                    Clock.schedule((BComponent)descriptor, (BRelTime)BRelTime.makeSeconds((int)10), (Action)BDescriptor.execute, null);
                    break;
                }
                BComponent parent = (BComponent)descriptor.getParent();
                parent.remove((BComplex)descriptor);
                break;
            }
            if (foundExisting || !enable) continue;
            BOrionNiagaraHistoryTypeExport descriptor = new BOrionNiagaraHistoryTypeExport();
            descriptor.setRecordType(recType);
            descriptor.setExecuteOnAppend(true);
            descriptor.setExecutionTime(new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make((BTime)BTime.make((int)2, (int)0, (int)0), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT, (BRelTime)BRelTime.makeMinutes((int)15))));
            descriptor.setEnabled(true);
            StringBuffer sb = new StringBuffer();
            sb.append(recType.toString());
            sb.append(" Type Export");
            station.getHistories().add(sb.toString() + "?", (BValue)descriptor);
            Clock.schedule((BComponent)descriptor, (BRelTime)BRelTime.makeSeconds((int)10), (Action)BDescriptor.execute, null);
        }
    }

    public boolean isIntrusionPinExists(OrionSession session, BIntrusionPin intrusionPin) {
        BSqlQuery query = BSqlQuery.make((OrionType)BIntrusionPin.ORION_TYPE);
        ExpressionBuilder builder = new ExpressionBuilder();
        BSqlField pinId = new BSqlField(BIntrusionPin.ORION_TYPE, BIntrusionPin.intrusionPinId);
        builder.and(Predicates.ne((BExpression)pinId.newExprCopy(), (BSimple)intrusionPin.getIntrusionPinId()));
        query.where(builder.getExpression());
        OrionCursor cursor = session.select((BQuery)query);
        String targetPin = AccessController.doPrivileged(() -> ((BPassword)intrusionPin.getPinNumber()).getValue());
        while (cursor.next()) {
            if (!((BIntrusionPin)cursor.get()).getPinNumber().validate(targetPin)) continue;
            return true;
        }
        cursor.close();
        return false;
    }

    private void updateModuleDependencies() {
        BFacets facets = BFacets.NULL;
        facets = ObjectUtil.appendModuleDependencyFacets((BFacets)facets, Stream.of("intrusionSmartKeyHx"));
        this.setModuleDependenciesFacets(facets);
    }

    public static class IntrusionToActivity
    extends HistoryManager.HistoryConverter {
        @Override
        public BActivityRecord convert(BHistoryRecord record) {
            BIntrusionRecord rec = (BIntrusionRecord)record;
            return rec.convertToActivity(null);
        }
    }
}

