/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.fox;

import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.BRemoteIntrusionResult;
import com.tridiumx.entsec.intrusion.BRemoteIntrusionSync;
import com.tridiumx.entsec.intrusion.fox.BIntrusionGroupExt;
import com.tridiumx.entsec.intrusion.fox.BNiagaraIntrusionDeviceExt;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.intrusion.orion.BMappedIntrusionZoneExt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataTable;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUnrestrictedFolder;

@NiagaraType
public class BIntrusionChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BIntrusionChannel.class);
    public static final String CHANNEL_NAME = "intrusion";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIntrusionChannel() {
        super(CHANNEL_NAME);
    }

    public final BNiagaraIntrusionDeviceExt getDeviceExt() {
        try {
            return (BNiagaraIntrusionDeviceExt)((BNiagaraStation)this.getConnection().getParent()).getMixIn(BNiagaraIntrusionDeviceExt.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public FoxResponse process(FoxRequest req) throws Exception {
        String command = req.command;
        if (command == "allowingTimeForDisarm") {
            return this.allowingTimeForDisarm(req);
        }
        if (command == "armingSequence") {
            return this.armingSequence(req);
        }
        if (command == "armingTest") {
            return this.armingTest(req);
        }
        if (command == "disarm") {
            return this.disarm(req);
        }
        if (command == "forceArm") {
            return this.forceArm(req);
        }
        if (command == "ping") {
            return this.ping(req);
        }
        if (command == "learn") {
            return this.learn(req);
        }
        if (command == "sync") {
            return this.sync(req);
        }
        if (command == "push") {
            return this.push(req);
        }
        throw new InvalidCommandException(command);
    }

    public void ping() throws Exception {
        FoxRequest req = this.makeRequest("ping");
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("enabled")) {
            throw new Exception("Target disabled.");
        }
    }

    public FoxResponse ping(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        boolean enabled = false;
        try {
            BIntrusionService service = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
            enabled = !service.getStatus().isDisabled();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        resp.add("enabled", enabled);
        return resp;
    }

    public BITable<?> learn() throws Exception {
        FoxRequest req = this.makeRequest("learn");
        FoxResponse resp = this.sendSync(req);
        BITable<?> table = BIntrusionChannel.decodeTable((FoxMessage)resp);
        return table;
    }

    public FoxResponse learn(FoxRequest req) throws Exception {
        String query = "station:|slot:/|bql: select name,slotPathOrd,type,timeDelay,warningTime,zoneStatus.ordinal,entsec_MappedIntrusionZoneExt.uuid from entsec:IntrusionZone";
        BOrd queryOrd = BOrd.make((BOrd)this.getComponentSpace().getAbsoluteOrd(), (String)query);
        BITable table = (BITable)queryOrd.resolve().get();
        FoxResponse resp = new FoxResponse(req);
        BIntrusionChannel.encode((FoxMessage)resp, table);
        return resp;
    }

    public BRemoteIntrusionResult allowingTimeForDisarm(BRemoteIntrusionResult result) throws Exception {
        FoxRequest req = this.makeRequest("allowingTimeForDisarm");
        req.add("result", ValueDocEncoder.marshal((BValue)result));
        FoxResponse response = this.sendSync(req);
        result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)response.getString("result"));
        return result;
    }

    public FoxResponse allowingTimeForDisarm(FoxRequest req) throws Exception {
        BRemoteIntrusionResult result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)req.getString("result"));
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BIntrusionZone iz = (BIntrusionZone)service.lookupAlarmClass(result.getRecord().getIntrusionZone());
        result = iz.doRemoteAllowingTimeForDisarm(result);
        FoxResponse resp = new FoxResponse(req);
        resp.add("result", ValueDocEncoder.marshal((BValue)result));
        return resp;
    }

    public BRemoteIntrusionResult armingTest(BRemoteIntrusionResult result) throws Exception {
        FoxRequest req = this.makeRequest("armingTest");
        req.add("result", ValueDocEncoder.marshal((BValue)result));
        FoxResponse response = this.sendSync(req);
        result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)response.getString("result"));
        return result;
    }

    public FoxResponse armingTest(FoxRequest req) throws Exception {
        BRemoteIntrusionResult result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)req.getString("result"));
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BIntrusionZone iz = (BIntrusionZone)service.lookupAlarmClass(result.getRecord().getIntrusionZone());
        result = iz.doRemoteArmingTest(result);
        FoxResponse resp = new FoxResponse(req);
        resp.add("result", ValueDocEncoder.marshal((BValue)result));
        return resp;
    }

    public BRemoteIntrusionResult armingSequence(BRemoteIntrusionResult result) throws Exception {
        FoxRequest req = this.makeRequest("armingSequence");
        req.add("result", ValueDocEncoder.marshal((BValue)result));
        FoxResponse response = this.sendSync(req);
        result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)response.getString("result"));
        return result;
    }

    public FoxResponse armingSequence(FoxRequest req) throws Exception {
        BRemoteIntrusionResult result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)req.getString("result"));
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BIntrusionZone iz = (BIntrusionZone)service.lookupAlarmClass(result.getRecord().getIntrusionZone());
        result = iz.doRemoteArmingSequence(result);
        FoxResponse resp = new FoxResponse(req);
        resp.add("result", ValueDocEncoder.marshal((BValue)result));
        return resp;
    }

    public BRemoteIntrusionResult disarm(BRemoteIntrusionResult result) throws Exception {
        FoxRequest req = this.makeRequest("disarm");
        req.add("result", ValueDocEncoder.marshal((BValue)result));
        FoxResponse response = this.sendSync(req);
        result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)response.getString("result"));
        return result;
    }

    public FoxResponse disarm(FoxRequest req) throws Exception {
        BRemoteIntrusionResult result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)req.getString("result"));
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BIntrusionZone iz = (BIntrusionZone)service.lookupAlarmClass(result.getRecord().getIntrusionZone());
        result = iz.doRemoteDisarm(result);
        FoxResponse resp = new FoxResponse(req);
        resp.add("result", ValueDocEncoder.marshal((BValue)result));
        return resp;
    }

    public BRemoteIntrusionResult forceArm(BRemoteIntrusionResult result) throws Exception {
        FoxRequest req = this.makeRequest("forceArm");
        req.add("result", ValueDocEncoder.marshal((BValue)result));
        FoxResponse response = this.sendSync(req);
        result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)response.getString("result"));
        return result;
    }

    public FoxResponse forceArm(FoxRequest req) throws Exception {
        BRemoteIntrusionResult result = (BRemoteIntrusionResult)ValueDocDecoder.unmarshal((String)req.getString("result"));
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BIntrusionZone iz = (BIntrusionZone)service.lookupAlarmClass(result.getRecord().getIntrusionZone());
        result = iz.doRemoteForceArm(result);
        FoxResponse resp = new FoxResponse(req);
        resp.add("result", ValueDocEncoder.marshal((BValue)result));
        return resp;
    }

    public BRemoteIntrusionSync sync(BRemoteIntrusionSync result) throws Exception {
        FoxRequest req = this.makeRequest("sync");
        req.add("result", ValueDocEncoder.marshal((BValue)result));
        FoxResponse response = this.sendSync(req);
        result = (BRemoteIntrusionSync)ValueDocDecoder.unmarshal((String)response.getString("result"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FoxResponse sync(FoxRequest req) throws Exception {
        BRemoteIntrusionSync result = (BRemoteIntrusionSync)ValueDocDecoder.unmarshal((String)req.getString("result"));
        BIntrusionZone iz = null;
        BIntrusionService service = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
        OrionSession session = null;
        BIntrusionZoneRec rec = new BIntrusionZoneRec();
        try {
            session = service.createSession(null);
            rec.setUuid(result.getUuid());
            rec = (BIntrusionZoneRec)session.read((BIOrionObject)rec);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        if (rec != null) {
            try {
                iz = (BIntrusionZone)rec.getMappedOrd().get();
                String stationName = ((NiagaraStation)this.getServerConnection().getConnectionTarget(NiagaraStation.class).orElse(null)).getStationName();
                if (BIntrusionGroupExt.getExt(iz, stationName) == null) {
                    BIntrusionGroupExt.addExt(iz, stationName);
                }
                result = iz.doRemoteSync(result);
            }
            catch (UnresolvedException e) {
                result.getRecord().setDetails(result.getRecord().getDetails() + "; skipped sync on " + Sys.getStation().getStationName() + ";");
                result.setTestedStations(result.getTestedStations() + ";" + Sys.getStation().getStationName() + ";");
            }
        } else {
            result.getRecord().setDetails(result.getRecord().getDetails() + "; skipped sync on " + Sys.getStation().getStationName() + ";");
            result.setTestedStations(result.getTestedStations() + ";" + Sys.getStation().getStationName() + ";");
        }
        FoxResponse resp = new FoxResponse(req);
        resp.add("result", ValueDocEncoder.marshal((BValue)result));
        return resp;
    }

    public BRemoteIntrusionSync push(BUnrestrictedFolder zones) throws Exception {
        FoxRequest req = this.makeRequest("push");
        req.add("zones", ValueDocEncoder.marshal((BValue)zones));
        FoxResponse response = this.sendSync(req);
        BRemoteIntrusionSync result = (BRemoteIntrusionSync)ValueDocDecoder.unmarshal((String)response.getString("result"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FoxResponse push(FoxRequest req) throws Exception {
        BUnrestrictedFolder vector = (BUnrestrictedFolder)ValueDocDecoder.unmarshal((String)req.getString("zones"));
        BIntrusionService service = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        OrionSession session = null;
        try {
            session = service.createSession(null);
            BIntrusionZone[] zones = (BIntrusionZone[])vector.getChildren(BIntrusionZone.class);
            Object iz = null;
            String remoteStationName = ((NiagaraStation)this.getServerConnection().getConnectionTarget(NiagaraStation.class).orElse(null)).getStationName();
            for (int i = 0; i < zones.length; ++i) {
                BIntrusionZone remoteZone = zones[i];
                BMappedIntrusionZoneExt remoteExt = (BMappedIntrusionZoneExt)remoteZone.getMixIn(BMappedIntrusionZoneExt.TYPE);
                BMappedIntrusionZoneExt.handlePush(remoteZone, remoteExt.getUuid(), remoteZone.getName(), null, remoteStationName, alarmService, session);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        FoxResponse resp = new FoxResponse(req);
        return resp;
    }

    protected static BITable<?> decodeTable(FoxMessage msg) throws Exception {
        byte[] b = msg.getBlob("table", null);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
        BIDataTable ret = DataTableDecoder.decode((DataInput)in);
        return ret;
    }

    protected static void encode(FoxMessage msg, BITable<?> table) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        DataTableEncoder.encode((BIDataTable)BToDataTable.toDataTable(table), (DataOutput)dout, null);
        msg.add("table", bout.toByteArray());
    }
}

