/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importconfig;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.accessDriver.enums.activity.BLDAPActivityEnum;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BLdapServerPersonEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportPrepareStep;
import com.tridiumx.entsec.ldap.importsteps.LdapImportStep;
import com.tridiumx.entsec.ldap.importutil.LdapImportUtils;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.users.BCleanupUserDataJob;
import com.tridiumx.ldapDriver.users.BLdapUser;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"ldapDriver:LdapServer"}, app="entsec", requiredPermissions="r")})
public class BLdapTempImportForPersonCleanupJob
extends BCleanupUserDataJob
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapTempImportForPersonCleanupJob.class);
    public static final String PERSONNEL_CLEANUP_PROCESS = "Personnel cleanup process";
    public static final String CLEANUP_MESSAGE_FOR_AUDIT_LOG = " users got deleted by cleanup process.";
    private Logger log = Logger.getLogger("entsec:LdapTempImportForPersonCleanupJob");

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (!BEnterpriseSecurityService.isWorkstation()) {
            this.log.severe("This process is not valid for JACE.");
            throw new BajaException("This process is not valid for JACE.");
        }
        OrionSession session = null;
        int noOfUsersDeleted = 0;
        String processLogMessage = null;
        String processLogStatus = null;
        BLdapServer server = this.getServer();
        try {
            session = LdapImportUtils.getOrionSession();
            session.delete(BLdapServerPersonEntry.ORION_TYPE, Predicates.eq((Property)BLdapServerPersonEntry.ldapServerOrd, (BSimple)server.getSlotPathOrd()));
            LdapImportPrepareStep prepareStep = new LdapImportPrepareStep(server);
            boolean isImportReady = ((LdapImportStep)prepareStep).execute();
            if (isImportReady) {
                LdapImportPrepareStep.ImportData importData = (LdapImportPrepareStep.ImportData)((LdapImportStep)prepareStep).getStepData();
                do {
                    if (isImportReady) {
                        this.setProgress(10);
                    }
                    BLdapUser[] users = importData.getUserList();
                    BatchStatement batchStatement = session.batchInsert(BLdapServerPersonEntry.ORION_TYPE);
                    for (int index = 0; index < users.length; ++index) {
                        BLdapUser user = users[index];
                        batchStatement.add((BIOrionObject)new BLdapServerPersonEntry(user.getDistinguishedName(), server.getSlotPathOrd().toString()));
                    }
                    batchStatement.execute();
                    session.commit();
                    isImportReady = ((LdapImportStep)prepareStep).execute();
                } while ((importData = (LdapImportPrepareStep.ImportData)((LdapImportStep)prepareStep).getStepData()).hasMore());
            }
            noOfUsersDeleted = this.callCleanUpStoredProcedure(session, server.getSlotPathOrd().toString());
            processLogStatus = LdapImportUtils.ImportProcessStatus.SUCCESS.name();
            session.delete(BLdapServerPersonEntry.ORION_TYPE, Predicates.eq((Property)BLdapServerPersonEntry.ldapServerOrd, (BSimple)server.getSlotPathOrd()));
            session.commit();
        }
        catch (Exception e) {
            processLogStatus = LdapImportUtils.ImportProcessStatus.ERROR.name();
            this.log.log(Level.SEVERE, "Exception occurred during synchronizing deleted records.", e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        processLogMessage = new StringBuffer(String.valueOf(noOfUsersDeleted)).append(CLEANUP_MESSAGE_FOR_AUDIT_LOG).toString();
        LdapImportUtils.addAuditLogEntry(server.getSlotPathOrd(), processLogStatus, processLogMessage, PERSONNEL_CLEANUP_PROCESS, BLDAPActivityEnum.cleanupPersonnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int callCleanUpStoredProcedure(OrionSession session, String serverSlotPath) throws SQLException {
        int noOfUsersDeleted = 0;
        Connection connection = null;
        Statement callableStatement = null;
        try {
            connection = this.getConnection(session);
            callableStatement = connection.prepareCall("CALL removePersonsDeletedFromLdapServer(?, ?)");
            int paramIndex = 0;
            callableStatement.setString(++paramIndex, serverSlotPath);
            callableStatement.registerOutParameter(++paramIndex, 4);
            callableStatement.execute();
            noOfUsersDeleted = callableStatement.getInt(paramIndex);
        }
        finally {
            if (callableStatement != null) {
                callableStatement.close();
            }
            this.closeConnection(connection);
        }
        return noOfUsersDeleted;
    }

    private Connection getConnection(OrionSession session) throws SQLException {
        return session.getOrionDatabase().getRdbms().getConnection();
    }

    private void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }
}

