/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.FilteredLdapMappingDetailsCache;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class LdapImportDeletePersonEntries
extends LdapImportMakeDatabaseEntry {
    public LdapImportDeletePersonEntries(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BPerson.ORION_TYPE;
    }

    @Override
    public boolean execute() {
        this.log.fine("Deleting all the person entries asscoiated with LDAP server : " + this.server.getDisplayName(null));
        BSqlJoin join = new BSqlJoin(new BSqlField(BPerson.ORION_TYPE, BPerson.personId), new BSqlField(BPersonLdapServerJoin.ORION_TYPE, BPersonLdapServerJoin.person));
        BUuid serverId = FilteredLdapMappingDetailsCache.getInstance(this.server.getName()).getLdapServerReference();
        BExpression serverFilter = Predicates.eq((String)"ldapServer", (BSimple)BRef.make((BTypeSpec)com.tridiumx.entsec.access.orion.BLdapServer.TYPE.getTypeSpec(), (BSimple)serverId));
        BSqlQuery q = BSqlQuery.make((OrionType)BPerson.ORION_TYPE);
        q = q.join(join);
        q = (BSqlQuery)q.where(serverFilter);
        OrionCursor c = this.session.select((BQuery)q);
        BatchStatement deleteStmt = this.session.batchDelete(this.getDataBaseEntryType());
        while (c.next()) {
            BPerson person = (BPerson)c.get();
            deleteStmt.add((BIOrionObject)person);
        }
        try {
            deleteStmt.execute();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Error while deleting the entries in Person table", ex);
            return false;
        }
        this.log.fine("Personnel deletion successful");
        return true;
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[0];
    }
}

