/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importsteps.LdapImportStep;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.RecordStatus;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class LdapImportMakeBadgeEntry
extends LdapImportMakeDatabaseEntry {
    public LdapImportMakeBadgeEntry(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BBadge.ORION_TYPE;
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[]{BBadge.credential, BBadge.facilityCode};
    }

    @Override
    public boolean execute() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step LdapImportMakeBadgeEntry");
        }
        boolean success = true;
        BPerson person = null;
        LdapImportStep tenantStep = null;
        LdapImportStep personStep = null;
        if (this.steps != null && this.steps.length == 2) {
            tenantStep = this.steps[0];
            personStep = this.steps[1];
        }
        if (this.steps != null && this.steps.length == 1) {
            personStep = this.steps[0];
        }
        BBadge badge = (BBadge)this.getStepData();
        if (tenantStep != null) {
            BTenant tenant = (BTenant)((Object)tenantStep.getStepData());
            if (tenant == null) {
                success = false;
            }
            badge.setTenant(BRef.make((BTypeSpec)BTenant.ORION_TYPE.getTypeSpec(), (BSimple)tenant.getTenantId()));
        }
        if (personStep != null) {
            person = (BPerson)personStep.getStepData();
            if (person == null) {
                success = false;
            }
            badge.setOwner(BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)person.getPersonId()));
        }
        if (success && this.unassignLdapImportedBadgeFromPerson(person, this.session)) {
            success = super.execute();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Completed the step LdapImportMakeBadgeEntry");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordStatus recordExists(BOrionObject obj) {
        boolean recordExists = false;
        OrionCursor c = null;
        BBadge badge = null;
        BBadge ref = (BBadge)obj;
        try {
            BBadge temp = new BBadge();
            temp.setCredential(ref.getCredential());
            temp.setFacilityCode(ref.getFacilityCode());
            temp.setWiegandFormat(ref.getWiegandFormat());
            String badgeId = null;
            try {
                badgeId = temp.calculateId(this.session);
            }
            catch (Exception e) {
                this.log.severe("Error calculating badge id : " + e.getLocalizedMessage());
                badgeId = null;
            }
            if (badgeId != null) {
                OrionType orionType = BBadge.ORION_TYPE;
                BSqlQuery query = BSqlQuery.make((OrionType)orionType);
                BExpression exp = Predicates.eq((String)"badgeId", (BSimple)BString.make((String)badgeId));
                query = (BSqlQuery)query.where(exp);
                c = this.session.select((BQuery)query);
                while (c.next()) {
                    badge = (BBadge)c.get();
                    badge.setBDescription(ref.getBDescription());
                    badge.setStatus(ref.getStatus());
                    badge.setIssueDate(ref.getIssueDate());
                    badge.setExpirationDate(ref.getExpirationDate());
                    badge.setOwner(ref.getOwner());
                    badge.setTenant(ref.getTenant());
                    badge.setLastModified(BAbsTime.now());
                    recordExists = true;
                }
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        badge = recordExists && badge != null ? badge : ref;
        return new RecordStatus(badge, recordExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unassignLdapImportedBadgeFromPerson(BPerson person, OrionSession session) {
        boolean success = false;
        BBadge badge = null;
        try (OrionCursor c = null;){
            OrionType orionType = BBadge.ORION_TYPE;
            BSqlQuery query = BSqlQuery.make((OrionType)orionType);
            BExpression exp = Predicates.eq((String)"owner", (BSimple)BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)person.getPersonId()));
            query = (BSqlQuery)query.where(exp);
            c = session.select((BQuery)query);
            while (c.next()) {
                badge = (BBadge)c.get();
                BBadgeLdapServerJoin badgeLdapServerJoin = badge.getBadgeLdapServerJoins(session).getBadgeLdapServerJoin();
                if (badgeLdapServerJoin == null) continue;
                badge.setLastModified(BAbsTime.now());
                badge.setOwner(BRef.NULL);
                session.delete((BIOrionObject)badgeLdapServerJoin);
                session.update((BIOrionObject)badge);
            }
            success = true;
        }
        return success;
    }

    @Override
    public BRef getRefFieldValue(String value, ColumnDetails colDetails) {
        if (colDetails.getRefColumnName() != null) {
            if (colDetails.getRefColumnName().equals("wiegandFormat")) {
                BExpression expression = Predicates.eq((String)"wiegandFormatName", (BSimple)BString.make((String)value));
                BSqlQuery query = (BSqlQuery)BSqlQuery.make((OrionType)BWiegandFormat.ORION_TYPE).where(expression);
                OrionCursor c = this.session.select((BQuery)query);
                BUuid uuid = null;
                if (c.next()) {
                    BWiegandFormat format = (BWiegandFormat)c.get();
                    uuid = format.getWiegandFormatId();
                }
                if (uuid != null) {
                    return BRef.make((BTypeSpec)BWiegandFormat.TYPE.getTypeSpec(), uuid);
                }
            } else if (colDetails.getRefColumnName().equals("tenant")) {
                BExpression expression = Predicates.eq((String)"tenantName", (BSimple)BString.make((String)value));
                BSqlQuery query = (BSqlQuery)BSqlQuery.make((OrionType)BTenant.ORION_TYPE).where(expression);
                OrionCursor c = this.session.select((BQuery)query);
                BUuid uuid = null;
                if (c.next()) {
                    BTenant format = (BTenant)((Object)c.get());
                    uuid = format.getTenantId();
                }
                if (uuid != null) {
                    return BRef.make((BTypeSpec)BTenant.TYPE.getTypeSpec(), uuid);
                }
            }
        }
        return super.getRefFieldValue(value, colDetails);
    }
}

