/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.FilteredLdapMappingDetailsCache;
import com.tridiumx.entsec.ldap.importutil.RecordStatus;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class LdapImportMakeBadgeLdapServerJoinEntry
extends LdapImportMakeDatabaseEntry {
    public LdapImportMakeBadgeLdapServerJoinEntry(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public boolean execute() {
        BBadge badge;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step LdapImportMakeBadgeLdapServerJoinEntry");
        }
        boolean success = false;
        if (this.steps != null && this.steps.length == 1 && (badge = (BBadge)this.steps[0].getStepData()) != null) {
            BBadgeLdapServerJoin joinEntry = (BBadgeLdapServerJoin)((Object)this.getStepData());
            BRef ldapServerRef = BRef.make((BTypeSpec)com.tridiumx.entsec.access.orion.BLdapServer.ORION_TYPE.getTypeSpec(), (BSimple)this.getLDAPServerReference(this.server.getName()));
            joinEntry.setLdapServer(ldapServerRef);
            String badgeId = badge.getBadgeId();
            BRef badgeRef = BRef.make((BTypeSpec)BBadge.ORION_TYPE.getTypeSpec(), (BSimple)BString.make((String)badgeId));
            joinEntry.setBadge(badgeRef);
            joinEntry.setJobId((int)Thread.currentThread().getId());
            success = super.execute();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Completed the step LdapImportMakeBadgeLdapServerJoinEntry");
        }
        return success;
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BBadgeLdapServerJoin.ORION_TYPE;
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordStatus recordExists(BOrionObject obj) {
        boolean recordExists = false;
        BBadgeLdapServerJoin badgeLdapJoin = null;
        BBadgeLdapServerJoin ref = (BBadgeLdapServerJoin)obj;
        try (OrionCursor c = null;){
            BSqlQuery query = BSqlQuery.make((OrionType)BBadgeLdapServerJoin.ORION_TYPE);
            BExpression exp1 = Predicates.eq((String)"badge", (BSimple)ref.getBadge());
            BExpression exp2 = Predicates.eq((String)"ldapServer", (BSimple)ref.getLdapServer());
            query = query.where(Predicates.and((BExpression)exp1, (BExpression)exp2));
            c = this.session.select((BQuery)query);
            if (c.next()) {
                recordExists = true;
                badgeLdapJoin = (BBadgeLdapServerJoin)((Object)c.get());
                badgeLdapJoin.setLastModified(BAbsTime.now());
            }
        }
        return new RecordStatus(recordExists && badgeLdapJoin != null ? badgeLdapJoin : obj, recordExists);
    }

    protected BUuid getLDAPServerReference(String ldapServerName) {
        BUuid uuid = FilteredLdapMappingDetailsCache.getInstance(ldapServerName).getLdapServerReference();
        return uuid;
    }
}

