/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridiumx.entsec.ldap.importsteps.LdapImportStep;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.LdapImportUtils;
import com.tridiumx.entsec.ldap.importutil.RecordStatus;
import com.tridiumx.entsec.ldap.importvalidate.ILdapImportEntryValidator;
import com.tridiumx.entsec.ldap.importvalidate.LdapEntryMandatoryFieldsValidator;
import com.tridiumx.ldapDriver.BLdapAttributeValuePair;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.users.BLdapUser;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.license.LicenseException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public abstract class LdapImportMakeDatabaseEntry
extends LdapImportStep {
    private static final String FACTORY_METHOD = "make";
    private Map<String, ColumnDetails> mappingDetails;
    protected OrionSession session;
    protected BLdapUser user;
    private BOrionObject orionObject;
    private boolean gotLicenseExceptionDuringInsert;
    private String licenseExceptionMessage;

    public LdapImportMakeDatabaseEntry(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server);
        this.mappingDetails = mappingDetails;
        this.session = session;
        this.orionObject = (BOrionObject)this.getDataBaseEntryType().getInstance();
    }

    public RecordStatus recordExists(BOrionObject obj) {
        return new RecordStatus(obj, this.session.exists((BIOrionObject)obj));
    }

    public final void setLdapUser(BLdapUser user) {
        this.user = user;
    }

    protected Map<String, ColumnDetails> getLdapEntSecMappingDetails() {
        return this.mappingDetails;
    }

    public abstract OrionType getDataBaseEntryType();

    public abstract Property[] getMandatoryProperties();

    @Override
    public boolean validate() {
        boolean isValid = true;
        ILdapImportEntryValidator[] validators = this.getApplicableValidators();
        if (validators != null) {
            for (int index = 0; index < validators.length && isValid; ++index) {
                isValid = validators[index].validate(this.mappingDetails, this) && isValid;
            }
        }
        return isValid;
    }

    @Override
    public boolean execute() {
        boolean isTraceON = this.log.isLoggable(Level.FINE);
        if (isTraceON) {
            this.log.fine("Entering the step LdapImportMakeDatabaseEntry");
        }
        Map<String, ColumnDetails> mappingDetails = this.getLdapEntSecMappingDetails();
        boolean populated = false;
        if (mappingDetails != null && this.user != null) {
            populated = this.populateOrionObject(mappingDetails);
            if (populated) {
                String type = "";
                try {
                    type = this.orionObject.getType().getTypeSpec().encodeToString();
                    RecordStatus recStatus = this.recordExists(this.orionObject);
                    this.orionObject = recStatus.get();
                    if (recStatus.isExists()) {
                        if (isTraceON) {
                            this.log.fine("Updating record " + type);
                        }
                        this.session.update((BIOrionObject)recStatus.get());
                    }
                    if (isTraceON) {
                        this.log.fine("Inserting record " + type);
                    }
                    try {
                        this.session.insert((BIOrionObject)this.orionObject);
                    }
                    catch (LicenseException ex) {
                        this.log.fine("Failed to make entsec entry for type : " + type + " " + ex.getMessage());
                        this.gotLicenseExceptionDuringInsert = true;
                        this.licenseExceptionMessage = ex.getMessage();
                        return false;
                    }
                }
                catch (Exception ex) {
                    this.log.severe("Failed to make entsec entry for type : " + type + " " + ex.getMessage());
                    ex.printStackTrace();
                    return false;
                }
            } else {
                return false;
            }
        }
        if (isTraceON) {
            this.log.fine("Completed the step LdapImportMakeDatabaseEntry");
        }
        return true;
    }

    public boolean isGotLicenseExceptionDuringInsert() {
        return this.gotLicenseExceptionDuringInsert;
    }

    public String getLicenseExceptionMessage() {
        return this.licenseExceptionMessage;
    }

    protected boolean populateOrionObject(Map<String, ColumnDetails> mappingDetails) {
        Set<String> attrs = mappingDetails.keySet();
        for (String attr : attrs) {
            ColumnDetails colDtls;
            BLdapAttributeValuePair attrValue = (BLdapAttributeValuePair)this.user.getAttributeList().get(attr);
            if (attrValue != null) {
                BValue value;
                colDtls = mappingDetails.get(attr);
                if (colDtls == null) continue;
                Property property = this.orionObject.getProperty(colDtls.getColumnName());
                if (property == null && colDtls.getRefColumnName() != null && !"".equals(colDtls.getRefColumnName())) {
                    property = this.orionObject.getProperty(colDtls.getRefColumnName());
                }
                if (property == null) continue;
                try {
                    value = this.getPropertyValue(attrValue, colDtls, property);
                }
                catch (Exception e) {
                    return false;
                }
                if (value == null) continue;
                if (property.getName().equals("lastName") && value.equals((Object)"")) {
                    return false;
                }
                this.orionObject.set(property, value);
                continue;
            }
            colDtls = mappingDetails.get(attr);
            if (colDtls == null || !colDtls.getColumnName().equals("lastName")) continue;
            return false;
        }
        return true;
    }

    private BValue getPropertyValue(BLdapAttributeValuePair attrValue, ColumnDetails colDtls, Property property) throws Exception {
        Object value = null;
        try {
            Type type = property.getType();
            Method method = this.getMethodInstance(type);
            if (method != null) {
                value = type.equals(BRef.TYPE) ? this.getRefFieldValue(attrValue.getAttrValue(), colDtls) : (type.equals(BAbsTime.TYPE) ? LdapImportUtils.parseLdapDate(attrValue.getAttrValue()) : (BValue)method.invoke(null, attrValue.getAttrValue()));
            }
        }
        catch (Exception e) {
            String errorMessage = "Error creating an LDAP entry of type " + this.orionObject.getType().toString();
            this.log.severe(errorMessage + e.getLocalizedMessage());
            throw e;
        }
        return value;
    }

    @Override
    public Object getStepData() {
        return this.orionObject;
    }

    @Override
    public ILdapImportEntryValidator[] getApplicableValidators() {
        return new ILdapImportEntryValidator[]{new LdapEntryMandatoryFieldsValidator()};
    }

    public BRef getRefFieldValue(String value, ColumnDetails colDetails) {
        return BRef.DEFAULT;
    }

    public BLdapServer getLdapServer() {
        return this.server;
    }

    private Method getMethodInstance(Type type) throws NoSuchMethodException, SecurityException {
        Class typeClass = type.getTypeClass();
        Method method = type.equals(BRef.TYPE) ? typeClass.getMethod(FACTORY_METHOD, BTypeSpec.class, BSimple.class) : typeClass.getMethod(FACTORY_METHOD, String.class);
        return method;
    }
}

