/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importutil.AuditLogEntryStatus;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.LdapImportLogEntry;
import com.tridiumx.entsec.ldap.importutil.LdapImportUtils;
import com.tridiumx.entsec.ldap.importutil.RecordStatus;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.ldapDriver.BLdapServer;
import java.security.AccessController;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class LdapImportMakePersonEntry
extends LdapImportMakeDatabaseEntry {
    public static int PERSON_PIN_MAX_LEGNTH = 8;
    private RecordStatus recordStatus = null;

    public LdapImportMakePersonEntry(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public boolean execute() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step LdapImportMakePersonEntry");
        }
        if (super.execute()) {
            return this.validateUserPin((BPerson)this.recordStatus.get());
        }
        return false;
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BPerson.ORION_TYPE;
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[]{BPerson.lastName};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordStatus recordExists(BOrionObject obj) {
        if (this.recordStatus != null) {
            return this.recordStatus;
        }
        BRef tenantRef = BRef.NULL;
        if (this.steps != null && this.steps.length == 1) {
            BTenant tenant = (BTenant)((Object)this.steps[0].getStepData());
            tenantRef = BRef.make((BTypeSpec)BTenant.ORION_TYPE.getTypeSpec(), (BSimple)tenant.getTenantId());
        }
        BPerson person = (BPerson)obj;
        boolean recordExists = false;
        String dn = this.user.getDistinguishedName();
        OrionCursor c1 = null;
        OrionCursor c2 = null;
        OrionCursor c3 = null;
        try {
            BSqlQuery query = BSqlQuery.make((OrionType)BPersonLdapServerJoin.ORION_TYPE);
            BExpression exp = Predicates.eq((String)"distinguishedName", (BSimple)BString.make((String)dn));
            query = query.where(exp);
            c1 = this.session.select((BQuery)query);
            if (c1.next()) {
                recordExists = true;
                BPersonLdapServerJoin join = (BPersonLdapServerJoin)((Object)c1.get());
                BUuid personId = (BUuid)join.getPerson().getId();
                BSqlQuery pQuery = BSqlQuery.make((OrionType)BPerson.ORION_TYPE);
                BExpression pexp = Predicates.eq((String)"personId", (BSimple)personId);
                c2 = this.session.select((BQuery)(pQuery = pQuery.where(pexp)));
                if (c2.next()) {
                    person = (BPerson)c2.get();
                    BPerson ref = (BPerson)obj;
                    person.setFirstName(ref.getFirstName());
                    person.setLastName(ref.getLastName());
                    person.setMiddleInitial(ref.getMiddleInitial());
                    person.setEmployeeId(ref.getEmployeeId());
                    person.setDepartment(ref.getDepartment());
                    person.setPersonType(ref.getPersonType());
                    person.setTenant(ref.getTenant());
                    person.setSupervisor(ref.getSupervisor());
                    person.setPinNumber(ref.getPinNumber());
                    person.setTraceCard(ref.getTraceCard());
                    person.setLastModified(BAbsTime.now());
                }
            } else {
                BSqlQuery duplicatePersonQuery = BSqlQuery.make((OrionType)BPerson.ORION_TYPE);
                ExpressionBuilder b = new ExpressionBuilder();
                b.and(Predicates.eq((BExpression)Funcs.lower((BExpression)new BSqlField(BPerson.ORION_TYPE, BPerson.lastName)), (BSimple)BString.make((String)TextUtil.toLowerCase((String)person.getLastName()))));
                b.and(Predicates.eq((BExpression)Funcs.lower((BExpression)new BSqlField(BPerson.ORION_TYPE, BPerson.firstName)), (BSimple)BString.make((String)TextUtil.toLowerCase((String)person.getFirstName()))));
                b.and(Predicates.eq((BExpression)Funcs.lower((BExpression)new BSqlField(BPerson.ORION_TYPE, BPerson.middleInitial)), (BSimple)BString.make((String)TextUtil.toLowerCase((String)person.getMiddleInitial()))));
                duplicatePersonQuery.where(b.getExpression());
                c3 = this.session.select((BQuery)duplicatePersonQuery);
                if (c3.next()) {
                    this.getLogList().add(new LdapImportLogEntry("The Person " + this.user.getDistinguishedName() + " with same Last Name, First Name and Middle Initial already present. ", AuditLogEntryStatus.WARNING, true));
                }
            }
        }
        finally {
            if (c1 != null) {
                c1.close();
            }
            if (c2 != null) {
                c2.close();
            }
            if (c3 != null) {
                c3.close();
            }
        }
        person.setTenant(tenantRef);
        this.recordStatus = new RecordStatus(person, recordExists);
        return this.recordStatus;
    }

    @Override
    public boolean validate() {
        boolean valid = super.validate();
        BLdapImportConfig importConfig = (BLdapImportConfig)this.server.getMixIn(BLdapImportConfig.TYPE);
        if (importConfig.getAllowNewInactiveUsers()) {
            return valid;
        }
        if (!this.isUserStatusActive(importConfig)) {
            this.getLogList().add(new LdapImportLogEntry("The status is not valid for the user with distinguished name : " + this.user.getDistinguishedName(), AuditLogEntryStatus.ERROR, true));
            return false;
        }
        return valid;
    }

    public boolean isUserStatusActive(BLdapImportConfig importConfig) {
        return LdapImportUtils.isLDAPUserStatusActive(this.user, importConfig);
    }

    private boolean validateUserPin(BPerson person) {
        boolean valid = true;
        BPassword password = person.getPinNumber();
        if (password.isDefault()) {
            password = BPassword.make((String)"");
        }
        String value = AccessController.doPrivileged(() -> ((BPassword)password).getValue());
        try {
            if (value != null) {
                long l;
                if (value.length() > PERSON_PIN_MAX_LEGNTH) {
                    throw new NumberFormatException("PIN length cannnot be greater than " + PERSON_PIN_MAX_LEGNTH);
                }
                if (value.length() > 0 && value.length() <= PERSON_PIN_MAX_LEGNTH && (l = Long.parseLong(value)) < 0L) {
                    throw new NumberFormatException("PIN must be positive");
                }
            }
        }
        catch (NumberFormatException e) {
            valid = false;
            this.getLogList().clear();
            this.getLogList().add(new LdapImportLogEntry("Invalid PIN value for the user.", AuditLogEntryStatus.ERROR, false));
        }
        return valid;
    }
}

