/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.util;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BInfoTemplate;
import com.tridiumx.entsec.access.orion.BLdapGroup;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.ldap.BExportLastJobProperties;
import com.tridiumx.ldapDriver.BLdapNetwork;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BDiscoverableClassDef;
import com.tridiumx.ldapDriver.attributes.BDiscoverableClassDefContainer;
import com.tridiumx.ldapDriver.users.BLdapUser;
import com.tridiumx.ldapDriver.users.BLdapUserOperationResponse;
import com.tridiumx.ldapDriver.users.BLdapUsersDeviceExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.naming.NamingException;

public class ExportPersonsDataUtility {
    public static final String ORD = "ord";
    public static final String STATION = "station:|";

    public static BLdapUserOperationResponse[] addUsersToLdapServer(ArrayList<BLdapUser> ldapUsers, BLdapServer selectedLdapServer) {
        Object[] usersList = ldapUsers.toArray();
        BLdapUser[] usersArray = (BLdapUser[])Arrays.copyOf(usersList, usersList.length, BLdapUser[].class);
        BLdapUsersDeviceExt userExt = selectedLdapServer.getLdapUsersExt();
        BLdapUserOperationResponse[] result = userExt.add(usersArray);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSynchedLdapPersonsDetails(HashMap<String, BPersonLdapServerJoin> personLdapJoinMap) {
        OrionSession orionSession = ExportPersonsDataUtility.getOrionSession();
        BatchStatement orionObjectStatement = null;
        try {
            orionObjectStatement = orionSession.batchInsert(BPersonLdapServerJoin.ORION_TYPE);
            Set<String> keySet = personLdapJoinMap.keySet();
            Iterator<String> itr = keySet.iterator();
            while (itr.hasNext()) {
                BPersonLdapServerJoin personLdap = personLdapJoinMap.get(itr.next());
                orionObjectStatement.add((BIOrionObject)personLdap);
            }
            orionObjectStatement.execute();
            orionSession.commit();
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSynchedLdapBadgeDetails(HashMap<String, BBadgeLdapServerJoin> badgeLdapJoinMap) {
        OrionSession orionSession = ExportPersonsDataUtility.getOrionSession();
        BatchStatement orionObjectStatement = null;
        try {
            orionObjectStatement = orionSession.batchInsert(BBadgeLdapServerJoin.ORION_TYPE);
            Set<String> keySet = badgeLdapJoinMap.keySet();
            Iterator<String> itr = keySet.iterator();
            while (itr.hasNext()) {
                BBadgeLdapServerJoin badgeLdap = badgeLdapJoinMap.get(itr.next());
                orionObjectStatement.add((BIOrionObject)badgeLdap);
            }
            orionObjectStatement.execute();
            orionSession.commit();
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPersonInfoAttributeValue(BPerson person, String personInfoAttribute) {
        OrionSession orionSession = null;
        try {
            orionSession = ExportPersonsDataUtility.getOrionSession();
            BPersonInfo personInfo = person.getPersonInfo(orionSession);
            BInfoTemplate[] infoTemplates = BInfoTemplate.getOrderedInfoTemplates(orionSession);
            for (int ii = 0; ii < infoTemplates.length; ++ii) {
                BInfoTemplate infoTemplate = infoTemplates[ii];
                String personInfoValue = infoTemplate.getDefaultValue();
                String templateId = "" + infoTemplate.getInfoTemplateId();
                if (personInfoAttribute.indexOf(templateId) <= -1) continue;
                if (personInfo != null) {
                    personInfoValue = personInfo.getValue(infoTemplate);
                }
                String string = personInfoValue;
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBadgeAttributeValue(BPerson person, String[] badgeAttribute) {
        OrionSession orionSession = null;
        try {
            orionSession = ExportPersonsDataUtility.getOrionSession();
            BIOrionObject[] badges = person.getBadges(orionSession).toArray();
            if (badges.length > 0) {
                BBadge badge = (BBadge)badges[0];
                if (badgeAttribute.length <= 2) {
                    String string = badge.get(badgeAttribute[1]).toString();
                    return string;
                }
                BWiegandFormat format = badge.resolveWiegandFormat(orionSession);
                String string = format.get(badgeAttribute[2]).toString();
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
        }
    }

    private static BUuid getPersonReference(BPerson person) {
        return person.getPersonId();
    }

    private static String getBadgeReference(BBadge badge) {
        return badge.getBadgeId();
    }

    public static BPersonLdapServerJoin makePersonLdapServerJoinEntry(BPerson person, BLdapServer selectedLdapServer, String distinguishName, int jobId) {
        BPersonLdapServerJoin personLdapJoin = new BPersonLdapServerJoin();
        personLdapJoin.setDistinguishedName(distinguishName);
        personLdapJoin.setJobId(jobId);
        BRef personRef = BRef.make((BTypeSpec)BPerson.TYPE.getTypeSpec(), (BSimple)ExportPersonsDataUtility.getPersonReference(person));
        personLdapJoin.setPerson(personRef);
        BRef ldapServerRef = BRef.make((BTypeSpec)com.tridiumx.entsec.access.orion.BLdapServer.TYPE.getTypeSpec(), (BSimple)ExportPersonsDataUtility.getLDAPServerReference(selectedLdapServer));
        personLdapJoin.setLdapServer(ldapServerRef);
        return personLdapJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBadgeLdapServerJoin makeBadgeLdapServerJoinEntry(BPerson person, BLdapServer selectedLdapServer, String distinguishName, int jobId) {
        BBadgeLdapServerJoin badgeLdapJoin = null;
        OrionSession orionSession = null;
        try {
            badgeLdapJoin = new BBadgeLdapServerJoin();
            orionSession = ExportPersonsDataUtility.getOrionSession();
            BIOrionObject[] badges = person.getBadges(orionSession).toArray();
            if (badges.length > 0) {
                BBadge badge = (BBadge)badges[0];
                BRef badgeRef = BRef.make((BTypeSpec)BPerson.TYPE.getTypeSpec(), (BSimple)BString.make((String)ExportPersonsDataUtility.getBadgeReference(badge)));
                BRef ldapServerRef = BRef.make((BTypeSpec)com.tridiumx.entsec.access.orion.BLdapServer.TYPE.getTypeSpec(), (BSimple)ExportPersonsDataUtility.getLDAPServerReference(selectedLdapServer));
                badgeLdapJoin.setBadge(badgeRef);
                badgeLdapJoin.setJobId(jobId);
                badgeLdapJoin.setLdapServer(ldapServerRef);
            }
        }
        catch (Throwable throwable) {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
            throw throwable;
        }
        ExportPersonsDataUtility.closeOrionSession(orionSession);
        return badgeLdapJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BUuid getLDAPServerReference(BLdapServer selectedLdapServer) {
        BUuid uuid = BUuid.DEFAULT;
        if (selectedLdapServer != null) {
            selectedLdapServer.lease();
            BOrd ord = selectedLdapServer.getSlotPathOrd();
            OrionSession session = null;
            try {
                session = ExportPersonsDataUtility.getOrionSession();
                BSqlQuery query = BSqlQuery.make((OrionType)com.tridiumx.entsec.access.orion.BLdapServer.ORION_TYPE);
                BQuery q = query.where(Predicates.eq((String)ORD, (BSimple)BOrd.make((String)(STATION + ord.encodeToString()))));
                OrionCursor cursor = session.select(q);
                if (cursor.next()) {
                    com.tridiumx.entsec.access.orion.BLdapServer ldapServer = (com.tridiumx.entsec.access.orion.BLdapServer)((Object)cursor.get());
                    uuid = ldapServer.getLdapServerId();
                }
            }
            finally {
                ExportPersonsDataUtility.closeOrionSession(session);
            }
        }
        return uuid;
    }

    public static String getDistinguishName(ArrayList<String> distinguishNamesList, String distinguishName, String attrName, String propValue) {
        if (distinguishNamesList.contains(attrName)) {
            distinguishName = distinguishName.length() < 1 ? attrName + "=" + propValue : distinguishName + "," + attrName + "=" + propValue;
        }
        return distinguishName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getDistinguishNamesListForDeletion(int jobId) {
        OrionSession orionSession = null;
        ArrayList<String> distinguishNamesList = new ArrayList<String>();
        OrionCursor cursor = null;
        try {
            orionSession = ExportPersonsDataUtility.getOrionSession();
            cursor = orionSession.select(BSqlQuery.make((OrionType)BPersonLdapServerJoin.ORION_TYPE).where(Predicates.eq((Property)BPersonLdapServerJoin.jobId, (BSimple)BInteger.make((int)jobId))));
            while (cursor.next()) {
                BPersonLdapServerJoin personLdap = (BPersonLdapServerJoin)((Object)cursor.get());
                distinguishNamesList.add(personLdap.getDistinguishedName().toString());
            }
            ArrayList<String> arrayList = distinguishNamesList;
            return arrayList;
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
        }
    }

    public static ArrayList<BLdapUser> getLdapUsersForDeletion(ArrayList<String> distinguishNamesList) {
        ArrayList<BLdapUser> ldapUsersList = new ArrayList<BLdapUser>();
        BLdapUser user = null;
        for (int i = 0; i < distinguishNamesList.size(); ++i) {
            user = new BLdapUser();
            user.setDistinguishedName(distinguishNamesList.get(i));
            ldapUsersList.add(user);
        }
        return ldapUsersList;
    }

    public static BLdapUserOperationResponse[] deleteUsersFromLdapServer(ArrayList<BLdapUser> ldapUsers, BLdapServer selectedLdapServer) throws NamingException {
        Object[] usersList = ldapUsers.toArray();
        BLdapUser[] usersArray = (BLdapUser[])Arrays.copyOf(usersList, usersList.length, BLdapUser[].class);
        BLdapUsersDeviceExt ldapUsersDeviceExt = selectedLdapServer.getLdapUsersExt();
        ldapUsersDeviceExt.setUserBase(selectedLdapServer.getUserSearchBase());
        BLdapUserOperationResponse[] result = ldapUsersDeviceExt.delete(usersArray);
        return result;
    }

    public static void deleteLdapPersonsDetails(Array<BSimple> deletedUsersList) throws Exception {
        OrionSession orionSession = null;
        BatchStatement orionObjectStatement = null;
        Array deletedNames = new Array(BSimple.class);
        try {
            orionSession = ExportPersonsDataUtility.getOrionSession();
            orionObjectStatement = orionSession.batchDelete(BPersonLdapServerJoin.ORION_TYPE);
            for (int i = 0; i < deletedUsersList.size(); ++i) {
                deletedNames.add(deletedUsersList.get(i));
            }
            OrionCursor cursor = null;
            if (deletedNames.size() > 0) {
                cursor = orionSession.select(BSqlQuery.make((OrionType)BPersonLdapServerJoin.ORION_TYPE).where(Predicates.in((Property)BPersonLdapServerJoin.distinguishedName, (BSimple[])((BSimple[])deletedNames.trim()))));
                while (cursor.next()) {
                    BPersonLdapServerJoin personLdap = (BPersonLdapServerJoin)((Object)cursor.get());
                    orionObjectStatement.add((BIOrionObject)personLdap);
                }
                orionObjectStatement.execute();
                orionSession.commit();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            orionSession.rollback();
            throw new Exception("Persons not deleted successfully from Orion Database.... ");
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
        }
    }

    public static void deleteLdapGroupDetails(Array<BSimple> deletedGroupsList) throws Exception {
        OrionSession orionSession = null;
        BatchStatement orionObjectStatement = null;
        Array deletedGroups = new Array(BSimple.class);
        try {
            orionSession = ExportPersonsDataUtility.getOrionSession();
            orionObjectStatement = orionSession.batchDelete(BLdapGroup.ORION_TYPE);
            for (int i = 0; i < deletedGroupsList.size(); ++i) {
                deletedGroups.add(deletedGroupsList.get(i));
            }
            OrionCursor cursor = null;
            if (deletedGroups.size() > 0) {
                cursor = orionSession.select(BSqlQuery.make((OrionType)BLdapGroup.ORION_TYPE).where(Predicates.in((Property)BLdapGroup.ldapGroupId, (BSimple[])((BSimple[])deletedGroups.trim()))));
                while (cursor.next()) {
                    BLdapGroup groupLdap = (BLdapGroup)((Object)cursor.get());
                    orionObjectStatement.add((BIOrionObject)groupLdap);
                }
                orionObjectStatement.execute();
                orionSession.commit();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            orionSession.rollback();
            throw new Exception("Persons not deleted successfully from Orion Database.... ");
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
        }
    }

    public static void deleteLdapGroup(String groupName) throws Exception {
        OrionSession orionSession = null;
        OrionCursor cursor = null;
        try {
            orionSession = ExportPersonsDataUtility.getOrionSession();
            cursor = orionSession.select(BSqlQuery.make((OrionType)BLdapGroup.ORION_TYPE).where(Predicates.eq((Property)BLdapGroup.ldapGroupId, (BSimple)BUuid.make((String)groupName))));
            while (cursor.next()) {
                BLdapGroup groupLdap = (BLdapGroup)((Object)cursor.get());
                orionSession.delete((BIOrionObject)groupLdap);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            orionSession.rollback();
            throw new Exception("Persons not deleted successfully from Orion Database.... ");
        }
        finally {
            ExportPersonsDataUtility.closeOrionSession(orionSession);
        }
    }

    public static int getLdapServerJobId(BLdapServer selectedLdapServer) {
        BExportLastJobProperties exportStatus = (BExportLastJobProperties)selectedLdapServer.getMixIn(BExportLastJobProperties.TYPE);
        int jobId = Integer.parseInt(exportStatus.getLastExportJobId());
        return jobId;
    }

    public static OrionSession getOrionSession() {
        BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
        if (orionDatabases.length > 0) {
            OrionSession orionSession = orionDatabases[0].createSession(null);
            orionSession.setAutoCommit(false);
            return orionSession;
        }
        return null;
    }

    public static void closeOrionSession(OrionSession orionSession) {
        if (orionSession != null) {
            orionSession.close();
            orionSession = null;
        }
    }

    public static BLdapServer getSelectedLdapServer(String ldapServerName) {
        BLdapNetwork ldapNetwork = (BLdapNetwork)Sys.getService((Type)BLdapNetwork.TYPE);
        ldapNetwork.lease();
        BLdapServer selectedLdapServer = (BLdapServer)ldapNetwork.get(ldapServerName);
        return selectedLdapServer;
    }

    public static int cleanDatabaseEntriesForLDAPServerDelete(BOrd ord, OrionSession session) {
        return session.delete(com.tridiumx.entsec.access.orion.BLdapServer.ORION_TYPE, Predicates.eq((String)ORD, (BSimple)BOrd.make((String)(STATION + ord.encodeToString()))));
    }

    public static BDiscoverableClassDef[] getObjectClassList(BLdapServer selectedLdapServer) {
        BDiscoverableClassDefContainer container = selectedLdapServer.getAttributes().getObjectClassList();
        container.lease();
        BDiscoverableClassDef[] ocList = (BDiscoverableClassDef[])container.getChildren(BDiscoverableClassDef.class);
        return ocList;
    }
}

