/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.nav;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BMappedExt;
import com.tridiumx.entsec.orionTools.BMappedScheduleExt;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.MergeSupport;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BControlSchedule;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="uuid", type="BUuid", defaultValue="BUuid.NULL", flags=1, facets={@Facet(name="KEY", value="true")}), @NiagaraProperty(name="stationName", type="String", defaultValue="", flags=1, facets={@Facet(name="WIDTH", value="64"), @Facet(name="INDEXED", value="true")}), @NiagaraProperty(name="scheduleName", type="String", defaultValue="", flags=9, facets={@Facet(name="WIDTH", value="128"), @Facet(name="DISPLAY_ID", value="true")}), @NiagaraProperty(name="scheduleDisplayPath", type="String", defaultValue="", flags=1, facets={@Facet(name="WIDTH", value="256")}), @NiagaraProperty(name="scheduleTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=1, facets={@Facet(name="WIDTH", value="64")})})
public abstract class BAbstractScheduleRec
extends BReplicableObject
implements BIOrdMappable {
    @Generated
    public static final Property uuid = BAbstractScheduleRec.newProperty((int)1, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    @Generated
    public static final Property stationName = BAbstractScheduleRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    @Generated
    public static final Property scheduleName = BAbstractScheduleRec.newProperty((int)9, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    @Generated
    public static final Property scheduleDisplayPath = BAbstractScheduleRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"width", (int)256));
    @Generated
    public static final Property scheduleTypeSpec = BAbstractScheduleRec.newProperty((int)1, (BValue)BTypeSpec.DEFAULT, (BFacets)BFacets.make((String)"width", (int)64));
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractScheduleRec.class);
    private static final BIcon ICON = BIcon.std((String)"schedule.png");

    @Generated
    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    @Generated
    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    @Override
    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Generated
    public String getScheduleName() {
        return this.getString(scheduleName);
    }

    @Generated
    public void setScheduleName(String v) {
        this.setString(scheduleName, v, null);
    }

    @Generated
    public String getScheduleDisplayPath() {
        return this.getString(scheduleDisplayPath);
    }

    @Generated
    public void setScheduleDisplayPath(String v) {
        this.setString(scheduleDisplayPath, v, null);
    }

    @Generated
    public BTypeSpec getScheduleTypeSpec() {
        return (BTypeSpec)this.get(scheduleTypeSpec);
    }

    @Generated
    public void setScheduleTypeSpec(BTypeSpec v) {
        this.set(scheduleTypeSpec, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        if (this.getScheduleName().length() == 0) {
            return false;
        }
        try {
            BControlSchedule schedule = (BControlSchedule)this.getMappedOrd().get();
            if (Flags.isReadonly((BComplex)schedule.getParent(), (Slot)schedule.getPropertyInParent())) {
                return super.beforeUpdate(session);
            }
            BAbstractScheduleRec rec = (BAbstractScheduleRec)session.read((BIOrionObject)this.newCopy());
            String displayOrd = rec.getScheduleDisplayPath();
            if (!this.getScheduleDisplayPath().equals(displayOrd)) {
                Logger.getLogger(TYPE.getModule().getModuleName()).log(Level.INFO, "update schedule path from " + displayOrd + " to " + this.getScheduleDisplayPath());
                BMappedScheduleExt.updateSchedulePath(rec, this);
            }
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(TYPE.getModule().getModuleName());
            BAbstractScheduleRec.logException(logger, e, Level.SEVERE, e.getMessage());
        }
        return super.beforeUpdate(session);
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        BAbstractScheduleRec rec = (BAbstractScheduleRec)session.read((BIOrionObject)this.newCopy());
        if (rec == null) {
            return false;
        }
        MergeSupport.setReferencesToNull((BIOrionObject)this, session);
        Logger.getLogger(TYPE.getModule().getModuleName()).log(Level.INFO, "deleting a schedule: " + rec.getMappedDisplayPath());
        try {
            BMappedScheduleExt.deleteSchedule(rec);
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(TYPE.getModule().getModuleName());
            BAbstractScheduleRec.logException(logger, e, Level.SEVERE, e.getMessage());
        }
        return super.beforeDelete(session);
    }

    @Override
    public void afterInsert(OrionSession session) {
        this.insertInCache();
        if (!Sys.getStation().getStationName().equals(this.getStationName())) {
            BMappedScheduleExt.importSchedule(this, this.newMappedExt());
        }
        super.afterInsert(session);
    }

    protected abstract BMappedExt newMappedExt();

    protected abstract void insertInCache();

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        this.updateCache();
    }

    protected abstract void updateCache();

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        this.deleteFromCache();
    }

    protected abstract void deleteFromCache();

    public void mapFrom(BObject source) {
        BControlSchedule schedule = (BControlSchedule)source;
        BMappedExt ext = this.getMixIn(schedule);
        this.setUuid(ext.getUuid());
        this.setScheduleTypeSpec(schedule.getType().getTypeSpec());
        if (schedule.isRunning()) {
            this.setStationName(Sys.getStation().getStationName());
        } else {
            BStation station = this.getConfigStation((BComponent)schedule);
            if (station == null) {
                return;
            }
            this.setStationName(station.getStationName());
        }
        String displayName = schedule.getDisplayName(null);
        if (displayName != null) {
            this.setScheduleName(displayName);
        } else if (schedule.getName() != null) {
            this.setScheduleName(schedule.getName());
        } else {
            throw new IllegalStateException("need a name when running");
        }
        this.setSlotPathOrd((BObject)schedule);
    }

    protected abstract BMappedExt getMixIn(BControlSchedule var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BStation getConfigStation(BComponent pObject) {
        BStation object = null;
        BComplex parent = null;
        try {
            if (pObject == null) {
                BStation bStation = null;
                return bStation;
            }
            if (pObject instanceof BStation) {
                BStation bStation = object = (BStation)pObject;
                return bStation;
            }
            for (parent = pObject.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BStation)) continue;
                object = (BStation)parent;
                break;
            }
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(TYPE.getModule().getModuleName());
            BAbstractScheduleRec.logException(logger, e, Level.SEVERE, e.getMessage());
        }
        finally {
            parent = null;
        }
        return object;
    }

    public static void logException(Logger logger, Exception e, Level level, String message) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(level, message, e);
        } else {
            logger.log(level, message);
        }
    }

    @Override
    public BOrd getMappedOrd() {
        return MappingSupport.getMappedOrd(this);
    }

    @Override
    public void setSlotPathOrd(BObject source) {
        this.setScheduleDisplayPath(MappingSupport.getDisplayPath(source));
    }

    @Override
    public String getMappedDisplayPath() {
        return this.getScheduleDisplayPath();
    }

    public String getMappedSupervisorId() {
        return MappingSupport.displayPathToSlotOrd(this.getScheduleDisplayPath());
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    public BIcon getIcon() {
        return ICON;
    }
}

