/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.nav;

import com.tridiumx.entsec.nav.BEntsecNav;
import com.tridiumx.entsec.nav.BEntsecNavGroup;
import com.tridiumx.entsec.nav.BEntsecNavLink;
import com.tridiumx.entsec.nav.BEntsecNavNode;
import com.tridiumx.entsec.nav.EntsecNavTree;
import java.io.InputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BXmlFile;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraType(ext={@FileExt(name="enav")})
public class BEntsecNavFile
extends BXmlFile {
    @Generated
    public static final Type TYPE = Sys.loadType(BEntsecNavFile.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BEntsecNavFile(BIFileStore store) {
        super(store);
    }

    public BEntsecNavFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BEntsecNavFile create(FilePath path, EntsecNavTree tree) throws Exception {
        Array links = new Array(BEntsecNavLink.class, 16);
        Array groups = new Array(BEntsecNavGroup.class, 16);
        BEntsecNavFile.loadTree((Array<BEntsecNavLink>)links, (Array<BEntsecNavGroup>)groups, tree);
        BEntsecNavFile navFile = (BEntsecNavFile)BFileSystem.INSTANCE.makeFile(path);
        try (XWriter out = new XWriter(navFile.getOutputStream());){
            out.prolog();
            out.w((Object)"<enav>").nl();
            BEntsecNavFile.writeGroups(out, (BEntsecNavGroup[])groups.trim(), 2);
            BEntsecNavFile.writeLinks(out, (BEntsecNavLink[])links.trim(), 2);
            out.w((Object)"</enav>").nl();
            out.flush();
        }
        return navFile;
    }

    public XElem parse() throws Exception {
        XParser parser = XParser.make((InputStream)this.getInputStream());
        return parser.parse();
    }

    public static BEntsecNavGroup[] parseGroups(XElem root) throws Exception {
        XElem groupsElem = root.elem("groups");
        if (groupsElem == null) {
            return new BEntsecNavGroup[0];
        }
        XElem[] groupElems = groupsElem.elems("group");
        Array groups = new Array(BEntsecNavGroup.class, groupElems.length);
        for (int i = 0; i < groupElems.length; ++i) {
            BEntsecNavGroup group = (BEntsecNavGroup)BEntsecNavFile.parseObject((BComplex)new BEntsecNavGroup(), groupElems[i]);
            if (group == null) continue;
            groups.add((Object)group);
        }
        return (BEntsecNavGroup[])groups.trim();
    }

    public static BEntsecNavLink[] parseLinks(XElem root) throws Exception {
        XElem linksElem = root.elem("links");
        if (linksElem == null) {
            return new BEntsecNavLink[0];
        }
        XElem[] linkElems = linksElem.elems("link");
        Array links = new Array(BEntsecNavLink.class, linkElems.length);
        for (int i = 0; i < linkElems.length; ++i) {
            BEntsecNavLink link = (BEntsecNavLink)BEntsecNavFile.parseObject((BComplex)new BEntsecNavLink(), linkElems[i]);
            if (link == null) continue;
            links.add((Object)link);
        }
        return (BEntsecNavLink[])links.trim();
    }

    public static BComplex parseObject(BComplex obj, XElem elem) throws Exception {
        String navName;
        if (obj instanceof BEntsecNavGroup) {
            navName = elem.get("navName", null);
            if (navName != null) {
                ((BEntsecNavGroup)obj).setNavName(navName);
            }
        } else if (obj instanceof BEntsecNavLink && (navName = elem.get("navName", null)) != null) {
            ((BEntsecNavLink)obj).setNavName(navName);
        }
        XElem[] propElems = elem.elems("p");
        for (int i = 0; i < propElems.length; ++i) {
            String propName = propElems[i].get("name");
            Property prop = obj.getProperty(propName);
            if (prop == null) continue;
            BValue value = (BValue)((BSimple)prop.getType().getInstance()).decodeFromString(propElems[i].get("value"));
            obj.set(prop, value);
        }
        return obj;
    }

    public static void writeGroups(XWriter out, BEntsecNavGroup[] groups, int indent) throws Exception {
        out.indent(indent).w((Object)"<groups>").nl();
        for (int i = 0; i < groups.length; ++i) {
            BEntsecNavFile.writeGroup(out, groups[i], indent + 2);
        }
        out.indent(indent).w((Object)"</groups>").nl();
    }

    public static void writeGroup(XWriter out, BEntsecNavGroup group, int indent) throws Exception {
        out.indent(indent).w((Object)"<group ").attr("navName", group.getNavName()).w((Object)">").nl();
        SlotCursor c = group.getProperties();
        while (c.next()) {
            BEntsecNavFile.writeProperty(out, (BComplex)group, c.property(), indent + 2);
        }
        out.indent(indent).w((Object)"</group>").nl();
    }

    public static void writeLinks(XWriter out, BEntsecNavLink[] links, int indent) throws Exception {
        out.indent(indent).w((Object)"<links>").nl();
        for (int i = 0; i < links.length; ++i) {
            BEntsecNavFile.writeLink(out, links[i], indent + 2);
        }
        out.indent(indent).w((Object)"</links>").nl();
    }

    public static void writeLink(XWriter out, BEntsecNavLink link, int indent) throws Exception {
        out.indent(indent).w((Object)"<link");
        String navName = link.getNavName();
        if (navName == null) {
            BINavNode linkTarget = null;
            try {
                linkTarget = link.resolveTarget(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (linkTarget != null) {
                navName = linkTarget.getNavName();
            }
        }
        if (navName != null) {
            out.w((Object)" ").attr("navName", navName);
        }
        out.w((Object)">").nl();
        SlotCursor c = link.getProperties();
        while (c.next()) {
            BEntsecNavFile.writeProperty(out, (BComplex)link, c.property(), indent + 2);
        }
        out.indent(indent).w((Object)"</link>").nl();
    }

    public static void writeProperty(XWriter out, BComplex obj, Property prop, int indent) throws Exception {
        BValue v = obj.get(prop);
        if (!v.isSimple()) {
            return;
        }
        out.indent(indent).w((Object)"<p ");
        out.attr("name", prop.getName());
        out.w((Object)" ").attr("value", ((BSimple)v).encodeToString());
        out.w((Object)"/>").nl();
    }

    protected static void loadTree(Array<BEntsecNavLink> links, Array<BEntsecNavGroup> groups, EntsecNavTree tree) {
        BEntsecNavFile.loadTree(links, groups, tree.getRoot());
    }

    protected static void loadTree(Array<BEntsecNavLink> links, Array<BEntsecNavGroup> groups, BINavNode root) {
        BEntsecNavNode nav;
        if (root instanceof BEntsecNavNode && !(nav = (BEntsecNavNode)root).isDynamicGroup()) {
            BINavNode inner = nav.getWrappedTarget();
            if (inner instanceof BEntsecNavGroup) {
                groups.add((Object)((BEntsecNavGroup)inner));
            } else {
                BEntsecNavLink link = BEntsecNavFile.makeLink(root);
                if (link != null) {
                    links.add((Object)link);
                }
            }
        }
        BINavNode[] children = root.getNavChildren();
        for (int i = 0; i < children.length; ++i) {
            BEntsecNavFile.loadTree(links, groups, children[i]);
        }
    }

    protected static BEntsecNavLink makeLink(BINavNode node) {
        BEntsecNav navHint;
        if (!(node instanceof BEntsecNavNode)) {
            return null;
        }
        BEntsecNavNode nav = (BEntsecNavNode)node;
        if (nav.isDynamic()) {
            return null;
        }
        BEntsecNavLink newLink = new BEntsecNavLink();
        newLink.setTargetOrd(nav.getNavOrd());
        newLink.setNavDisplayFormat(nav.getDisplayFormat());
        newLink.setNavView(nav.getNavView());
        newLink.setParentPath(nav.getParentPath());
        newLink.setChildTypes(nav.getChildTypes());
        newLink.setIconOverride(nav.getIconOverride());
        newLink.setIndex(nav.getIndex());
        BEntsecNavLink navLink = nav.getLink();
        if (navLink != null && navLink.isMounted()) {
            newLink.setNavName(navLink.getNavName());
        }
        if ((navHint = nav.getNavHint()) != null && navHint.isMounted()) {
            newLink.setNavName(nav.getNavName());
        }
        return newLink;
    }
}

