/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.nav;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.nav.BEntsecNav;
import com.tridiumx.entsec.nav.BEntsecNavFile;
import com.tridiumx.entsec.nav.BEntsecNavGroup;
import com.tridiumx.entsec.nav.BEntsecNavLink;
import com.tridiumx.entsec.nav.BEntsecNavNode;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.nav.BNavFileNode;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;

public class EntsecNavTree {
    private BINavNode root;
    private HashMap<BOrd, BINavNode> ordMap;
    private HashMap<BTypeSpec, BINavNode> childTypeMap;
    private Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(EntsecNavTree.class).getModuleName());
    private static Logger log = Logger.getLogger("entsec.nav");

    public EntsecNavTree() {
        this.root = new BNavFileNode(this.lex.get("nav.home"), BOrd.make((String)"station:|entsecnav:/"), BIcon.make((String)this.lex.get("nav.home.icon")));
        ((BNavFileNode)this.root).setLexiconText(LexiconText.make((BModule)this.lex.module, (String)"nav.home"));
    }

    public EntsecNavTree(BINavNode root) {
        this.root = root;
    }

    public BINavNode getRoot() {
        return this.root;
    }

    public BINavNode findNavNode(BOrd ord) {
        if (this.ordMap == null) {
            throw new IllegalStateException("Tree not committed.");
        }
        return this.ordMap.get(ord);
    }

    public BINavNode findNavNode(BObject obj) {
        if (this.ordMap == null) {
            throw new IllegalStateException("Tree not committed.");
        }
        if (obj instanceof BINavNode && ((BINavNode)obj).getNavOrd() != null) {
            return this.findNavNode(((BINavNode)obj).getNavOrd().relativizeToHost());
        }
        return null;
    }

    public BINavNode[] getNavPath(BINavNode node) throws Exception {
        if (node == null) {
            return null;
        }
        Array path = new Array(BINavNode.class);
        while (node != null && node != this.root) {
            path.add((Object)node);
            node = node.getNavParent();
        }
        if (node == null) {
            return null;
        }
        return (BINavNode[])path.reverse().trim();
    }

    public BINavNode getTypeOwner(BTypeSpec typeSpec) {
        return this.childTypeMap.get(typeSpec);
    }

    public void commit() {
        this.ordMap = new HashMap();
        this.childTypeMap = new HashMap();
        this.map(this.ordMap, this.childTypeMap, this.root);
        log.info("Default nav committed.");
    }

    private void map(HashMap<BOrd, BINavNode> ordMap, HashMap<BTypeSpec, BINavNode> childTypeMap, BINavNode root) {
        BOrd targetNavOrd;
        BINavNode target;
        BOrd ord = root.getNavOrd();
        if (root instanceof BEntsecNavNode && (target = ((BEntsecNavNode)root).getTarget(null)) != null && !(target instanceof BEntsecNavGroup) && (targetNavOrd = target.getNavOrd()) != null) {
            ord = targetNavOrd;
        }
        if (ord != null) {
            ord = ord.relativizeToHost();
        }
        if (ord != null) {
            OrdQuery[] queries = ord.parse();
            int n = queries.length - 1;
            if (n >= 0 && queries[n] instanceof ViewQuery) {
                ord = BOrd.make((OrdQuery[])queries, (int)0, (int)(queries.length - 1));
            }
            ordMap.put(ord, root);
            if (root instanceof BEntsecNavNode) {
                BTypeSpec[] childTypes = ((BEntsecNavNode)root).getChildTypeSpecs();
                for (int i = 0; i < childTypes.length; ++i) {
                    BINavNode typeOwner = childTypeMap.get(childTypes[i]);
                    if (typeOwner != null) {
                        log.severe("Duplicate type owner: " + typeOwner.getNavOrd() + " and " + root.getNavOrd());
                        continue;
                    }
                    childTypeMap.put(childTypes[i], root);
                }
            }
        }
        BINavNode[] children = root.getNavChildren();
        for (int i = 0; i < children.length; ++i) {
            this.map(ordMap, childTypeMap, children[i]);
        }
    }

    public void buildDefaultNav() {
        log.info("Rebuilding default navigation.");
        this.ordMap = null;
        this.childTypeMap = null;
        this.root = new BNavFileNode("Home", BOrd.make((String)"station:|entsecnav:/"), BIcon.make((String)this.lex.get("nav.home.icon")));
        ((BNavFileNode)this.root).setLexiconText(LexiconText.make((BModule)this.lex.module, (String)"nav.home"));
        this.loadNodes();
        BEntsecNavFile[] navFiles = this.loadNavFiles();
        for (int i = 0; i < navFiles.length; ++i) {
            BEntsecNavFile navFile = navFiles[i];
            BEntsecNavLink[] linksFromFile = null;
            BEntsecNavGroup[] groupsFromFile = null;
            XElem navFileRoot = null;
            try {
                if (navFile != null) {
                    navFileRoot = navFile.parse();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (navFileRoot != null) {
                try {
                    linksFromFile = BEntsecNavFile.parseLinks(navFileRoot);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    groupsFromFile = BEntsecNavFile.parseGroups(navFileRoot);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.loadLinks(linksFromFile);
            this.loadGroups(groupsFromFile);
        }
        this.sort(this.root, (Context)null);
        log.info("Default navigation build complete.");
    }

    public BEntsecNavFile[] loadNavFiles() {
        try {
            BEntsecNavFile navFile = (BEntsecNavFile)BOrd.make((String)"file:^nav/defaultNav.enav").resolve().get();
            log.fine("Loading default nav from ^nav/defaultNav.enav");
            return new BEntsecNavFile[]{navFile};
        }
        catch (UnresolvedException navFile) {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BOrdList ordList = service.getBrandingManager().getEntsecNavOrdList();
            log.fine("Loading default nav from " + ordList.toString());
            Array a = new Array(BEntsecNavFile.class);
            for (int i = 0; i < ordList.size(); ++i) {
                try {
                    BEntsecNavFile navFile2 = (BEntsecNavFile)ordList.get(i).resolve().get();
                    a.add((Object)navFile2);
                    continue;
                }
                catch (UnresolvedException ex) {
                    log.log(Level.SEVERE, "Error loading nav: " + ordList.get(i), ex);
                }
            }
            return (BEntsecNavFile[])a.trim();
        }
    }

    private void loadNodes() {
        BOrd query = BOrd.make((String)"bql:select from entsec:EntsecNav");
        TableCursor c = ((BITable)query.get((BObject)Sys.getStation())).cursor();
        while (c.next()) {
            String[] pathElems;
            BEntsecNav nav = (BEntsecNav)((Object)c.get());
            String parentPath = nav.getParentPath();
            if (nav.getIsGroup()) {
                parentPath = "/";
            }
            if ((pathElems = TextUtil.split((String)parentPath, (char)'/')).length == 0 || pathElems[0].length() != 0) {
                throw new IllegalArgumentException("Relative paths not supported: " + parentPath);
            }
            BEntsecNavNode newNode = BEntsecNavNode.makeFor(nav, (BINavNode)nav.getParent());
            BINavNode parent = this.root;
            if (pathElems[1].length() != 0) {
                for (int i = 1; i < pathElems.length; ++i) {
                    Object elem = parent.getNavChild(pathElems[i]);
                    if (elem == null) {
                        elem = BEntsecNavNode.makeTemporary(pathElems[i], BOrd.make((String)("station:|entsecnav:" + this.makePath(pathElems, i))), BIcon.std((String)"object.png"));
                        ((BNavContainer)parent).addNavChild(elem);
                    }
                    parent = elem;
                }
            }
            ((BNavContainer)parent).addNavChild((BINavNode)newNode);
            if (!nav.getIsGroup()) continue;
            this.addChildren(nav.getParent(), newNode);
        }
    }

    private void addChildren(BComplex parent, BNavContainer navParent) {
        SlotCursor c = parent.getProperties();
        while (c.nextComponent()) {
            BComponent child = (BComponent)c.get();
            if (child instanceof BEntsecNav) continue;
            navParent.addNavChild((BINavNode)BEntsecNavNode.makeDynamic((BINavNode)child));
        }
    }

    private void loadLinks(BEntsecNavLink[] linksFromFile) {
        if (linksFromFile != null) {
            for (int i = 0; i < linksFromFile.length; ++i) {
                this.loadLink(linksFromFile[i]);
            }
        }
        BOrd query = BOrd.make((String)"bql:select from entsec:EntsecNavLink");
        TableCursor c = ((BITable)query.get((BObject)Sys.getStation())).cursor();
        while (c.next()) {
            BEntsecNavLink link = (BEntsecNavLink)c.get();
            this.loadLink(link);
        }
    }

    private void loadLink(BEntsecNavLink link) {
        BINavNode existing;
        String parentPath = link.getParentPath();
        String[] pathElems = TextUtil.split((String)parentPath, (char)'/');
        if (pathElems.length == 0 || pathElems[0].length() != 0) {
            throw new IllegalArgumentException("Relative paths not supported.");
        }
        BEntsecNavNode newNode = BEntsecNavNode.makeForLink(link);
        BINavNode parent = this.root;
        if (pathElems[1].length() != 0) {
            for (int i = 1; i < pathElems.length; ++i) {
                Object elem = parent.getNavChild(pathElems[i]);
                if (elem == null) {
                    elem = BEntsecNavNode.makeTemporary(pathElems[i], BOrd.make((String)("station:|entsecnav:" + this.makePath(pathElems, i))), BIcon.std((String)"object.png"));
                    ((BNavContainer)parent).addNavChild(elem);
                }
                parent = elem;
            }
        }
        if ((existing = parent.getNavChild(newNode.getNavName())) != null) {
            if (link.isMounted()) {
                log.warning("Duplicate nav node: " + newNode.getNavName() + " from " + link.getSlotPath());
            } else {
                log.warning("Duplicate nav node: " + newNode.getNavName());
            }
        } else {
            ((BNavContainer)parent).addNavChild((BINavNode)newNode);
        }
    }

    private void loadGroups(BEntsecNavGroup[] groupsFromFile) {
        if (groupsFromFile != null) {
            for (int i = 0; i < groupsFromFile.length; ++i) {
                this.loadGroup(groupsFromFile[i]);
            }
        }
        BOrd query = BOrd.make((String)"bql:select from entsec:EntsecNavGroup");
        TableCursor c = ((BITable)query.get((BObject)Sys.getStation())).cursor();
        while (c.next()) {
            BEntsecNavGroup group = (BEntsecNavGroup)c.get();
            this.loadGroup(group);
        }
    }

    private void loadGroup(BEntsecNavGroup group) {
        BINavNode existing;
        String parentPath = group.getParentPath();
        String[] pathElems = TextUtil.split((String)parentPath, (char)'/');
        if (pathElems.length == 0 || pathElems[0].length() != 0) {
            throw new IllegalArgumentException("Relative paths not supported.");
        }
        BEntsecNavNode newNode = BEntsecNavNode.makeFor((BINavNode)group);
        BINavNode parent = this.root;
        if (pathElems[1].length() != 0) {
            for (int i = 1; i < pathElems.length; ++i) {
                Object elem = parent.getNavChild(pathElems[i]);
                if (elem == null) {
                    elem = BEntsecNavNode.makeTemporary(pathElems[i], BOrd.make((String)("station:|entsecnav:" + this.makePath(pathElems, i))), BIcon.std((String)"object.png"));
                    ((BNavContainer)parent).addNavChild(elem);
                }
                parent = elem;
            }
        }
        if ((existing = parent.getNavChild(newNode.getNavName())) != null) {
            if (existing instanceof BEntsecNavNode && ((BEntsecNavNode)existing).isTemporary()) {
                ((BNavContainer)parent).removeNavChild(existing);
                BINavNode[] children = existing.getNavChildren();
                for (int i = 0; i < children.length; ++i) {
                    newNode.addNavChild(children[i]);
                }
                ((BNavContainer)parent).addNavChild((BINavNode)newNode);
            } else if (group.isMounted()) {
                log.warning("Duplicate nav node: " + newNode.getNavName() + " from " + group.getSlotPath());
            } else {
                log.warning("Duplicate nav node: " + newNode.getNavName());
            }
        } else {
            ((BNavContainer)parent).addNavChild((BINavNode)newNode);
        }
    }

    private String makePath(String[] elems, int depth) {
        StringBuffer s = new StringBuffer(64);
        for (int i = 0; i < depth; ++i) {
            s.append("/").append(elems[i]);
        }
        if (s.length() == 0) {
            return "/";
        }
        return s.toString();
    }

    private void sort(BINavNode root, Context cx) {
        this.sort(root, new NavNodeComparator(cx));
    }

    private void sort(BINavNode root, Comparator<BINavNode> comparator) {
        if (!root.hasNavChildren()) {
            return;
        }
        Object[] children = root.getNavChildren();
        if (root instanceof BNavContainer) {
            SortUtil.sort((Object[])children, (Object[])children, comparator);
            ((BNavContainer)root).reorderNavChildren((BINavNode[])children);
        }
        for (int i = 0; i < children.length; ++i) {
            this.sort((BINavNode)children[i], comparator);
        }
    }

    private static class NavNodeComparator
    implements Comparator<BINavNode>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Context cx;

        public NavNodeComparator(Context cx) {
            this.cx = cx;
        }

        @Override
        public int compare(BINavNode o1, BINavNode o2) {
            BEntsecNavNode n1 = (BEntsecNavNode)o1;
            BEntsecNavNode n2 = (BEntsecNavNode)o2;
            if (n1.getIndex() != n2.getIndex()) {
                return n1.getIndex() - n2.getIndex();
            }
            String dname1 = n1.getNavDisplayName(this.cx);
            String dname2 = n2.getNavDisplayName(this.cx);
            return dname1.compareTo(dname2);
        }
    }
}

