/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridiumx.entsec.orionTools.BIMappingService;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BMappedExt;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;

public class MappingSupport {
    public static final BOrd STATION_ORD = BOrd.make((String)"station:");
    private Queue purgeQueue;
    private Queue persistQueue;
    private BIMappingService service;

    public MappingSupport(BIMappingService service) {
        this.service = service;
        this.purgeQueue = new Queue();
        this.persistQueue = new Queue();
    }

    public void mappedRemoved(BComponent c) {
        if (this.service.isOrionReady()) {
            OrionSession session = null;
            try {
                session = this.service.getOrionDatabase().createSession(null);
                session.mappedDelete((BObject)c);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        } else if (this.purgeQueue.find((Object)c) == null) {
            this.purgeQueue.enqueue((Object)c);
        }
    }

    public void mappedAdded(BComponent c) {
        if (this.service.isOrionReady()) {
            OrionSession session = null;
            try {
                session = this.service.getOrionDatabase().createSession(null);
                session.mappedInsert((BObject)c);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        } else if (this.persistQueue.find((Object)c) == null) {
            this.persistQueue.enqueue((Object)c);
        }
    }

    public void mappedUpdate(BComponent c) {
        if (this.service.isOrionReady()) {
            OrionSession session = null;
            try {
                session = this.service.getOrionDatabase().createSession(null);
                session.mappedUpdate((BObject)c);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        } else if (this.persistQueue.find((Object)c) == null) {
            this.persistQueue.enqueue((Object)c);
        }
    }

    public void mappedPersist(BComponent c) {
        if (this.service.isOrionReady()) {
            OrionSession session = null;
            try {
                session = this.service.getOrionDatabase().createSession(null);
                if (session.mappedRead((BObject)c) == null) {
                    session.mappedInsert((BObject)c);
                }
                session.mappedUpdate((BObject)c);
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        } else if (this.persistQueue.find((Object)c) == null) {
            this.persistQueue.enqueue((Object)c);
        }
    }

    public void orionReadyAndStarted() {
        if (!this.service.isOrionReady() || !((BComponent)this.service).isRunning()) {
            return;
        }
        OrionSession session = null;
        try {
            BComponent c;
            session = this.service.getOrionDatabase().createSession(null);
            while (!this.purgeQueue.isEmpty()) {
                c = (BComponent)this.purgeQueue.dequeue();
                session.mappedDelete((BObject)c);
            }
            while (!this.persistQueue.isEmpty()) {
                c = (BComponent)this.persistQueue.dequeue();
                if (session.mappedRead((BObject)c) == null) {
                    session.mappedInsert((BObject)c);
                    continue;
                }
                session.mappedUpdate((BObject)c);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public static String getMixInName(Type getMixInType) {
        return TextUtil.replace((String)getMixInType.toString(), (String)":", (String)"_");
    }

    public static BOrd getMappedOrd(BIOrdMappable mappable) {
        if (mappable.getMappedDisplayPath().length() > 0) {
            return BOrd.make((BOrd)STATION_ORD, (BOrd)BOrd.make((String)MappingSupport.displayPathToSlotOrd(mappable.getMappedDisplayPath())));
        }
        return BOrd.DEFAULT;
    }

    public static String displayPathToSlotOrd(String displayPath) {
        String slotPath = displayPath;
        String[] split = TextUtil.split((String)slotPath, (char)'/');
        for (int i = 0; i < split.length; ++i) {
            split[i] = SlotPath.escape((String)split[i]);
        }
        slotPath = TextUtil.join((String[])split, (char)'/');
        slotPath = TextUtil.replace((String)slotPath, (String)SlotPath.escape((String)"$2f"), (String)"$2f");
        return "slot:" + slotPath;
    }

    public static String getDisplayPath(BObject source) {
        String slotPath = source.asComponent().getSlotPath().toString();
        return MappingSupport.slotOrdToDisplayPath(slotPath);
    }

    public static String slotOrdToDisplayPath(String slotPath) {
        slotPath = slotPath.substring(5);
        slotPath = TextUtil.replace((String)slotPath, (String)"$2f", (String)SlotPath.escape((String)"$2f"));
        return SlotPath.unescape((String)slotPath);
    }

    public static Type getMappedType(OrionType type) {
        try {
            TypeInfo[] infos = type.getTypeInfo().getAgentInfo().getAgentOn();
            for (int i = 0; i < infos.length; ++i) {
                if (!infos[i].is(BComponent.TYPE)) continue;
                return infos[i].getTypeSpec().getResolvedType();
            }
        }
        catch (NoSuchAgentException noSuchAgentException) {
            // empty catch block
        }
        return null;
    }

    public static Type getMappedExtType(Type type) {
        try {
            AgentInfo info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BMappedExt.TYPE)).getDefault();
            Type mappedExtType = info.getAgentType().getTypeSpec().getResolvedType();
            return mappedExtType;
        }
        catch (NoSuchAgentException e) {
            return null;
        }
    }

    public static Type[] getMixIns(Type type) {
        AgentList info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BIMixIn.TYPE));
        AgentInfo[] list = info.list();
        Type[] types = new Type[list.length];
        for (int i = 0; i < list.length; ++i) {
            types[i] = list[i].getAgentType().getTypeSpec().getResolvedType();
        }
        return types;
    }

    public static void addMappedExt(BComponent component, BUuid uuid) {
        Type type = component.getType();
        AgentInfo info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BMappedExt.TYPE)).getDefault();
        Type mappedExtType = info.getAgentType().getTypeSpec().getResolvedType();
        BMappedExt ext = (BMappedExt)mappedExtType.getInstance();
        ext.setUuid(uuid);
        component.add(MappingSupport.getMixInName(mappedExtType), (BValue)ext);
    }

    public static BUuid getMappedUuid(BComponent component) {
        Type type = component.getType();
        AgentInfo info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BMappedExt.TYPE)).getDefault();
        Type mappedExtType = info.getAgentType().getTypeSpec().getResolvedType();
        BMappedExt mappedExt = (BMappedExt)component.get(MappingSupport.getMixInName(mappedExtType));
        return mappedExt.getUuid();
    }

    public static BUuid getMappedUuidRemotely(BComponent component) {
        component.lease();
        Type type = component.getType();
        AgentInfo info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BMappedExt.TYPE)).getDefault();
        Type mappedExtType = info.getAgentType().getTypeSpec().getResolvedType();
        BMappedExt mappedExt = (BMappedExt)component.get(MappingSupport.getMixInName(mappedExtType));
        mappedExt.lease();
        return mappedExt.getUuid();
    }

    public static void setMappedUuid(BComponent component, BUuid uuid) {
        Type type = component.getType();
        AgentInfo info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BMappedExt.TYPE)).getDefault();
        Type mappedExtType = info.getAgentType().getTypeSpec().getResolvedType();
        BMappedExt mappedExt = (BMappedExt)component.get(MappingSupport.getMixInName(mappedExtType));
        mappedExt.setUuid(uuid);
    }

    public static BRef getMappedRef(BComponent component) {
        Type type = component.getType();
        AgentInfo info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BIOrdMappable.TYPE)).getDefault();
        BTypeSpec typeSpec = info.getAgentType().getTypeSpec();
        return BRef.make((BTypeSpec)typeSpec, (BSimple)MappingSupport.getMappedUuid(component));
    }
}

