/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.ui;

import com.tridiumx.entsec.orionTools.ui.BAppFieldSheet;
import com.tridiumx.entsec.orionTools.ui.BAppView;
import java.util.HashMap;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="handleSetModified"), @NiagaraAction(name="handlePluginModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BAppEditor
extends BWbEditor {
    @Generated
    public static final Action handleSetModified = BAppEditor.newAction((int)0, null);
    @Generated
    public static final Action handlePluginModified = BAppEditor.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAppEditor.class);
    public static final int MODE_NEW = 0;
    public static final int MODE_EDIT = 1;
    protected BAppView view;
    protected HashMap<BWbPlugin, BImage> modified = new HashMap();
    protected int mode;
    protected Array<Field> extraFields = new Array(Field.class);
    protected BAppFieldSheet fieldSheet;

    @Generated
    public void handleSetModified() {
        this.invoke(handleSetModified, null, null);
    }

    @Generated
    public void handlePluginModified(BWidgetEvent parameter) {
        this.invoke(handlePluginModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAppEditor(int mode, BAppView view) {
        this.mode = mode;
        this.view = view;
    }

    public void doLoadValue(BObject o, Context cx) {
        BComponent obj = (BComponent)o;
        BTabbedPane tabbedPane = new BTabbedPane();
        tabbedPane.addPane(Lexicon.make(BAppEditor.class).getText("command.summary.label"), null, this.view.getSummaryWidget(obj));
        if (this.view.getWbShell() != null && this.view.getWbShell().getActiveView() == this.view) {
            tabbedPane.setTabPlacement(BAlign.bottom);
        }
        this.fieldSheet = new BAppFieldSheet(this.mode);
        this.fieldSheet.loadValue((BObject)obj, cx);
        this.linkTo((BComponent)this.fieldSheet, (Slot)BWbPlugin.setModified, (Slot)setModified);
        this.linkTo((BComponent)this.fieldSheet, (Slot)BWbPlugin.setModified, (Slot)handleSetModified);
        this.linkTo((BComponent)this.fieldSheet, (Slot)BAppFieldSheet.handlePluginModified, (Slot)handlePluginModified);
        tabbedPane.addPane(obj.getType().getDisplayName(cx), BImage.make((BIcon)obj.getIcon()), (BWidget)this.fieldSheet);
        if (this.mode == 0) {
            tabbedPane.selectPane((BWidget)this.fieldSheet);
        }
        for (int i = 0; i < this.extraFields.size(); ++i) {
            Field f = (Field)this.extraFields.get(i);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.setModified, (Slot)setModified);
            this.linkTo((BComponent)f.editor, (Slot)BWbPlugin.setModified, (Slot)handleSetModified);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.pluginModified, (Slot)handlePluginModified);
            tabbedPane.addPane(f.label.getText(), f.icon, (BWidget)f.editor);
        }
        this.setContent((BWidget)tabbedPane);
    }

    public void addField(BWbFieldEditor ed, String text, BImage icon) {
        BLabel label = new BLabel(icon, text);
        label.setValign(BValign.top);
        Field f = new Field(null, label, ed, true);
        f.icon = icon;
        this.extraFields.add((Object)f);
    }

    public BObject doSaveValue(BObject o, Context cx) throws CannotSaveException, Exception {
        BComponent obj = (BComponent)o;
        int fc = this.extraFields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = (Field)this.extraFields.get(i);
            if (!f.editor.isModified()) continue;
            if (!f.extra) {
                obj.set(f.prop, (BValue)f.editor.saveValue((BObject)obj.get(f.prop), cx));
                continue;
            }
            if (this.mode == 0) continue;
            f.editor.saveValue((BObject)obj, cx);
        }
        obj = (BComponent)this.fieldSheet.saveValue((BObject)obj, cx);
        return obj;
    }

    public BWbFieldEditor getEditor(Property p) {
        for (int i = 0; i < this.extraFields.size(); ++i) {
            Field field = (Field)this.extraFields.get(i);
            if (field.prop != p) continue;
            return field.editor;
        }
        return null;
    }

    public void clearModified() {
        super.clearModified();
        BLabelPane[] labelPanes = (BLabelPane[])this.getContent().getChildren(BLabelPane.class);
        for (int i = 0; i < labelPanes.length; ++i) {
            if (!(labelPanes[i].getContent() instanceof BWbPlugin)) continue;
            BWbPlugin plugin = (BWbPlugin)labelPanes[i].getContent();
            if (plugin.isModified()) {
                plugin.clearModified();
            }
            if (this.modified.get(plugin) == null) continue;
            labelPanes[i].getLabel().setImage(this.modified.get(plugin));
        }
        this.modified.clear();
        this.repaint();
    }

    public void doHandleSetModified() {
        BLabelPane[] labelPanes = (BLabelPane[])this.getContent().getChildren(BLabelPane.class);
        for (int i = 0; i < labelPanes.length; ++i) {
            BWbPlugin plugin;
            if (!(labelPanes[i].getContent() instanceof BWbPlugin) || !(plugin = (BWbPlugin)labelPanes[i].getContent()).isModified() || this.modified.get(plugin) != null) continue;
            this.modified.put(plugin, labelPanes[i].getLabel().getImage());
            labelPanes[i].getLabel().setImage(labelPanes[i].getLabel().getImage().getHighlightedImage());
        }
        this.repaint();
    }

    public void doHandlePluginModified(BWidgetEvent event) {
    }

    public BAppFieldSheet getFieldSheet() {
        return this.fieldSheet;
    }

    protected class Field {
        public Property prop;
        public BLabel label;
        public BWbFieldEditor editor;
        public BImage icon;
        public boolean extra;

        public Field(Property prop, BLabel label, BWbFieldEditor editor, boolean extra) {
            this.prop = prop;
            this.label = label;
            this.editor = editor;
            this.extra = extra;
        }
    }
}

