/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.ui;

import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="labelMargin", type="double", defaultValue="10d"), @NiagaraProperty(name="rowGap", type="double", defaultValue="8d"), @NiagaraProperty(name="indent", type="double", defaultValue="0d"), @NiagaraProperty(name="extraRight", type="double", defaultValue="60d")})
@NiagaraAction(name="handleSetModified")
@NiagaraTopic(name="handlePluginModified", eventType="BWidgetEvent")
public class BAppFieldSheet
extends BWbEditor {
    @Generated
    public static final Property labelMargin = BAppFieldSheet.newProperty((int)0, (double)10.0, null);
    @Generated
    public static final Property rowGap = BAppFieldSheet.newProperty((int)0, (double)8.0, null);
    @Generated
    public static final Property indent = BAppFieldSheet.newProperty((int)0, (double)0.0, null);
    @Generated
    public static final Property extraRight = BAppFieldSheet.newProperty((int)0, (double)60.0, null);
    @Generated
    public static final Action handleSetModified = BAppFieldSheet.newAction((int)0, null);
    @Generated
    public static final Topic handlePluginModified = BAppFieldSheet.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAppFieldSheet.class);
    static final BColor dividerColor = BColor.make((int)0xBBBBBB);
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    public static final int MODE_NEW = 0;
    public static final int MODE_EDIT = 1;
    protected int mode;
    protected Array<Field> fields;
    protected Array<Field> extraFields = new Array(Field.class);
    protected Array<Field> versionFields;
    protected double[] divs;

    @Generated
    public double getLabelMargin() {
        return this.getDouble(labelMargin);
    }

    @Generated
    public void setLabelMargin(double v) {
        this.setDouble(labelMargin, v, null);
    }

    @Generated
    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    @Generated
    public void setRowGap(double v) {
        this.setDouble(rowGap, v, null);
    }

    @Generated
    public double getIndent() {
        return this.getDouble(indent);
    }

    @Generated
    public void setIndent(double v) {
        this.setDouble(indent, v, null);
    }

    @Generated
    public double getExtraRight() {
        return this.getDouble(extraRight);
    }

    @Generated
    public void setExtraRight(double v) {
        this.setDouble(extraRight, v, null);
    }

    @Generated
    public void handleSetModified() {
        this.invoke(handleSetModified, null, null);
    }

    @Generated
    public void fireHandlePluginModified(BWidgetEvent event) {
        this.fire(handlePluginModified, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAppFieldSheet(int mode) {
        this.mode = mode;
    }

    public void doLoadValue(BObject o, Context cx) {
        int i;
        BComponent obj = (BComponent)o;
        Lexicon lex = Lexicon.make(obj.getClass());
        Property[] props = obj.getPropertiesArray();
        this.fields = new Array(Field.class, props.length);
        this.versionFields = new Array(Field.class);
        for (i = 0; i < props.length; ++i) {
            Property prop = props[i];
            if (Flags.isHidden((BComplex)obj, (Slot)prop)) continue;
            BValue propValue = obj.get(prop);
            BWbFieldEditor ed = BWbFieldEditor.makeFor((BObject)propValue, (Context)prop.getFacets());
            ed.setReadonly(Flags.isReadonly((BComplex)obj, (Slot)prop));
            ed.loadValue((BObject)propValue, (Context)new BasicContext(cx, prop.getFacets()));
            String ordList = null;
            BImage icon = null;
            ordList = prop.getFacets().gets("iconOverride", null);
            icon = ordList != null ? BImage.make((BIcon)BIcon.make((String)ordList)) : BImage.make((BIcon)propValue.getIcon());
            if (icon == null) {
                icon = defaultIcon;
            }
            Field f = new Field(prop, new BLabel(icon, prop.getDefaultDisplayName(cx)), ed, false);
            f.icon = icon;
            if (prop.getDefaultValue().getType().equals(BUuid.TYPE)) {
                this.versionFields.add((Object)f);
                continue;
            }
            this.add("label" + i, (BValue)f.label);
            this.add("editor" + i, (BValue)f.editor);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.setModified, (Slot)setModified);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.setModified, (Slot)handleSetModified);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.pluginModified, (Slot)handlePluginModified);
            this.fields.add((Object)f);
        }
        for (i = 0; i < this.extraFields.size(); ++i) {
            Field f = (Field)this.extraFields.get(i);
            this.add(null, (BValue)f.label);
            this.add(null, (BValue)f.editor);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.setModified, (Slot)setModified);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.pluginModified, (Slot)handlePluginModified);
            this.fields.add((Object)f);
        }
        this.divs = new double[this.fields.size()];
    }

    public void addField(BWbFieldEditor ed, String text, BImage icon, Property prop) {
        BLabel label = new BLabel(icon, text);
        label.setValign(BValign.top);
        Field f = new Field(prop, label, ed, true);
        f.icon = icon;
        this.extraFields.add((Object)f);
    }

    public Array<Field> getFields() {
        return this.fields;
    }

    public BObject doSaveValue(BObject o, Context cx) throws CannotSaveException, Exception {
        BComponent obj = (BComponent)o;
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = (Field)this.fields.get(i);
            if (!f.editor.isModified()) continue;
            if (!f.extra) {
                obj.set(f.prop, (BValue)f.editor.saveValue((BObject)obj.get(f.prop), cx));
                continue;
            }
            if (this.mode == 0) continue;
            f.editor.saveValue((BObject)obj, cx);
        }
        int vc = this.versionFields.size();
        for (int i = 0; i < vc; ++i) {
            Field f = (Field)this.versionFields.get(i);
            if (!f.editor.isModified()) continue;
            obj.set(f.prop, (BValue)f.editor.saveValue((BObject)obj.get(f.prop), cx));
        }
        this.clearModified();
        return obj;
    }

    public void computePreferredSize() {
        if (this.fields == null) {
            this.setPreferredSize(0.0, 0.0);
            return;
        }
        double maxLabel = 0.0;
        double maxEditor = 0.0;
        double ph = 0.0;
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = (Field)this.fields.get(i);
            f.label.computePreferredSize();
            f.editor.computePreferredSize();
            if (i == 0) {
                maxLabel = f.label.getPreferredWidth();
                maxEditor = f.editor.getPreferredWidth();
            } else {
                maxLabel = Math.max(maxLabel, f.label.getPreferredWidth());
                maxEditor = Math.max(maxEditor, f.editor.getPreferredWidth());
            }
            if (i != 0) {
                ph += this.getRowGap();
            }
            ph += Math.max(f.label.getPreferredHeight(), f.editor.getPreferredHeight());
        }
        this.setPreferredSize(this.getIndent() + maxLabel + maxEditor + this.getLabelMargin() + this.getExtraRight(), ph);
    }

    public void doLayout(BWidget[] kids) {
        if (this.fields == null) {
            return;
        }
        double labelWidth = 0.0;
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = (Field)this.fields.get(i);
            f.label.computePreferredSize();
            f.editor.computePreferredSize();
            labelWidth = i == 0 ? f.label.getPreferredWidth() : Math.max(labelWidth, f.label.getPreferredWidth());
        }
        double y = 0.0;
        double indent = this.getIndent();
        for (int i = 0; i < fc; ++i) {
            Field field = (Field)this.fields.get(i);
            double rowHeight = Math.max(field.label.getPreferredHeight(), field.editor.getPreferredHeight());
            field.label.setBounds(indent, y + (rowHeight - field.label.getPreferredHeight()) / 2.0, field.label.getPreferredWidth(), rowHeight);
            field.editor.setBounds(indent + labelWidth + this.getLabelMargin(), y + (rowHeight - field.editor.getPreferredHeight()) / 2.0, field.editor.getPreferredWidth(), rowHeight);
            this.divs[i] = y += rowHeight + this.getRowGap();
        }
    }

    public void paint(Graphics g) {
        this.paintChildren(g);
        for (int i = 0; i < this.divs.length; ++i) {
            double y = this.divs[i] - this.getRowGap() / 2.0;
            g.setBrush(dividerColor);
            g.strokeLine(0.0, y, this.getWidth(), y);
        }
    }

    public BWbFieldEditor getEditor(Property p) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = (Field)this.fields.get(i);
            if (field.prop != p) continue;
            return field.editor;
        }
        return null;
    }

    public void clearModified() {
        super.clearModified();
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = (Field)this.fields.get(i);
            f.label.setImage(f.icon);
        }
    }

    public void doHandleSetModified() {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field f = (Field)this.fields.get(i);
            if (!f.editor.isModified()) continue;
            f.label.setImage(f.icon.getHighlightedImage());
        }
        this.repaint();
    }

    public class Field {
        public Property prop;
        public BLabel label;
        public BWbFieldEditor editor;
        public BImage icon;
        public boolean extra;

        public Field(Property prop, BLabel label, BWbFieldEditor editor, boolean extra) {
            this.prop = prop;
            this.label = label;
            this.editor = editor;
            this.extra = extra;
        }
    }
}

