/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.ui;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.orionTools.ui.BDynamicTableJoinView;
import com.tridiumx.entsec.orionTools.ui.BOrionSummary;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="assign", parameterType="BComponent", defaultValue="new BComponent()"), @NiagaraAction(name="summary", parameterType="BComponent", defaultValue="new BComponent()")})
public class BJoinFE
extends BWbFieldEditor {
    @Generated
    public static final Action assign = BJoinFE.newAction((int)0, (BValue)new BComponent(), null);
    @Generated
    public static final Action summary = BJoinFE.newAction((int)0, (BValue)new BComponent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJoinFE.class);
    private static BModule module = Sys.getModuleForClass(BJoinFE.class);
    protected Command unassignCommand;
    protected Command summaryCommand;
    private BOrionTypeId joinType;
    private BDynamicTable dynamicTable;
    private AssignResults results = new AssignResults();
    private String navDisplayName;
    private BIcon navIcon;
    private BDynamicTableJoinView dynamicTableJoinView;
    private BBorderPane potentialBorderPane;
    private BBorderPane assignedBorderPane;

    @Generated
    public void assign(BComponent parameter) {
        this.invoke(assign, (BValue)parameter, null);
    }

    @Generated
    public void summary(BComponent parameter) {
        this.invoke(summary, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BJoinFE(BOrionTypeId rowType) {
        this.results.rowType = rowType;
        this.dynamicTable = new BDynamicTable();
        this.dynamicTableJoinView = new BDynamicTableJoinView();
        this.results.assigned = new BList();
        this.results.assigned.setController((ListController)new Controller());
        this.results.unassigned = new BList();
        BGridPane grid = new BGridPane(2);
        grid.setRowAlign(BValign.top);
        this.potentialBorderPane = new BBorderPane((BWidget)this.dynamicTableJoinView);
        BConstrainedPane cPane = new BConstrainedPane((BWidget)this.potentialBorderPane);
        cPane.setMinHeight(410.0);
        cPane.setMinWidth(500.0);
        cPane.setMaxHeight(410.0);
        cPane.setMaxWidth(500.0);
        grid.add(null, (BValue)cPane);
        double width = 200.0;
        double height = this.results.assigned.getRenderer().getItemHeight() * 19.0 + 1.0;
        BConstrainedPane listCons = new BConstrainedPane((BWidget)this.results.assigned);
        listCons.setMinHeight(height);
        listCons.setMaxHeight(height);
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)listCons);
        Command[] commands = this.getButtonCommands();
        if (commands != null) {
            BGridPane buttons = new BGridPane(commands.length);
            buttons.setUniformColumnWidth(true);
            buttons.setColumnGap(5.0);
            buttons.setColumnAlign(BHalign.fill);
            for (int i = 0; i < commands.length; ++i) {
                buttons.add(null, (BValue)new BButton(commands[i]));
            }
            edge.setBottom((BWidget)new BBorderPane((BWidget)buttons, BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0)));
        }
        this.assignedBorderPane = new BBorderPane((BWidget)edge);
        grid.add(null, (BValue)this.assignedBorderPane);
        listCons.setMinWidth(width);
        this.setContent((BWidget)grid);
        this.linkTo((BComponent)this.results.assigned, (Slot)BList.listModified, (Slot)setModified);
        this.linkTo((BComponent)this.dynamicTableJoinView, (Slot)BDynamicTableJoinView.assign, (Slot)assign);
        this.linkTo((BComponent)this.dynamicTableJoinView, (Slot)BDynamicTableJoinView.summary, (Slot)summary);
    }

    public String getNavDisplayName(Context cx) {
        return this.navDisplayName;
    }

    public BIcon getNavIcon() {
        return this.navIcon;
    }

    public void doLoadValue(BObject o, Context cx) throws Exception {
        this.results.assigned.removeAllItems();
        this.results.unassigned.removeAllItems();
        BOrionObject target = (BOrionObject)o;
        BOrionDatabase orionDatabase = target.getOrionDatabase();
        BOrd ord = orionDatabase.getOrdInSpace();
        this.dynamicTable.setDbOrd(ord);
        this.results = BJoinFE.getAssigned(target, this.results.rowType, this.results, cx);
        OrionType orionRowType = orionDatabase.getType(this.results.rowType);
        this.dynamicTable.setRowType(this.results.rowType);
        this.dynamicTable.setResolveBase(o);
        this.dynamicTableJoinView.loadValue((BObject)this.dynamicTable, cx);
        BComponent rowInstance = (BComponent)orionRowType.getInstance();
        this.navIcon = rowInstance.getIcon();
        Lexicon lex = Lexicon.make(rowInstance.getClass());
        this.navDisplayName = this.results.oneToOne ? target.getSlot(this.results.refProperty).getDefaultDisplayName(cx) : (this.results.joinType != null ? lex.get(target.getOrionType().getTypeName() + ".to." + this.results.joinType.getTypeName() + ".to." + orionRowType.getTypeName(), lex.get(orionRowType.getTypeName() + ".displayName.plural", orionRowType.getDisplayName(cx) + "s")) : lex.get(target.getOrionType().getTypeName() + ".to." + orionRowType.getTypeName(), lex.get(orionRowType.getTypeName() + ".displayName.plural", orionRowType.getDisplayName(cx) + "s")));
        Lexicon oLex = Lexicon.make(((Object)((Object)this)).getClass());
        String potentialText = oLex.getText("potential", new Object[]{this.navDisplayName});
        this.potentialBorderPane.setLabel((BWidget)new BLabel(potentialText));
        String assignedText = oLex.getText("assigned", new Object[]{this.navDisplayName});
        this.assignedBorderPane.setLabel((BWidget)new BLabel(assignedText));
    }

    public Command[] getButtonCommands() {
        this.unassignCommand = new UnassignCommand();
        this.summaryCommand = new SummaryCommand();
        return new Command[]{this.unassignCommand, this.summaryCommand};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssignResults getAssigned(BOrionObject target, BOrionTypeId rowType, AssignResults results, Context cx) throws Exception {
        BOrionDatabase db = target.getOrionDatabase();
        OrionSession session = null;
        try {
            int i;
            session = db.createSession(cx);
            OrionType orionType1 = db.getType(rowType);
            OrionType orionType2 = db.getType(target.getOrionType().getOrionTypeId());
            if (orionType1.isAssociation()) {
                Property[] props = orionType1.getProperties();
                for (int i2 = 0; i2 < props.length; ++i2) {
                    BRef ref;
                    BOrionTypeId typeId;
                    if (!(props[i2].getDefaultValue() instanceof BRef) || (typeId = (ref = (BRef)props[i2].getDefaultValue()).getTargetOrionTypeId()).equals((Object)target.getOrionType().getOrionTypeId())) continue;
                    results.joinType = rowType;
                    rowType = typeId;
                    orionType1 = db.getType(rowType);
                    break;
                }
            }
            results.target = target;
            results.rowType = rowType;
            BTypeDependency[] ref1 = db.getDependentTypes(orionType1);
            BTypeDependency[] ref2 = db.getDependentTypes(orionType2);
            Object match = null;
            for (i = 0; i < ref1.length; ++i) {
                for (int j = 0; j < ref2.length; ++j) {
                    OrionType joinOrionType;
                    if (!ref1[i].getFromTypeId().equals((Object)ref2[j].getFromTypeId()) || results.joinType != null && !results.joinType.equals((Object)ref1[i].getFromTypeId()) || !(joinOrionType = db.getType(ref1[i].getFromTypeId())).isAssociation()) continue;
                    BOrionObject join = (BOrionObject)joinOrionType.getTypeSpec().getInstance();
                    join.setOrionDatabase(db);
                    join.set(ref2[j].getFromProperty(), (BValue)BRef.make((BIOrionObject)target));
                    BIOrionObject[] assigned = session.select(joinOrionType, PropertyValue.make((BComplex)join)).toArray();
                    results.manyToManyTemplate = join;
                    results.refProperty = ref1[i].getFromProperty();
                    for (int k = 0; k < assigned.length; ++k) {
                        BRef ref = (BRef)assigned[k].get(ref1[i].getFromProperty());
                        BIOrionObject item = ref.getTarget(session);
                        JoinDisplay joinDisplay = new JoinDisplay(assigned[k], item, results.refProperty);
                        results.assigned.addItem((Object)joinDisplay);
                    }
                    AssignResults assignResults = results;
                    return assignResults;
                }
            }
            if (match == null) {
                for (int j = 0; j < ref2.length; ++j) {
                    if (!orionType1.getOrionTypeId().equals((Object)ref2[j].getFromTypeId())) continue;
                    results.oneToMany = true;
                    OrionType joinOrionType = db.getType(ref2[j].getFromTypeId());
                    BOrionObject join = (BOrionObject)joinOrionType.getTypeSpec().getInstance();
                    results.refProperty = ref2[j].getFromProperty();
                    join.setOrionDatabase(db);
                    join.set(results.refProperty, (BValue)BRef.make((BIOrionObject)target));
                    BIOrionObject[] assigned = session.select(joinOrionType, PropertyValue.make((BComplex)join)).toArray();
                    for (int i3 = 0; i3 < assigned.length; ++i3) {
                        results.assigned.addItem((Object)new JoinDisplay(assigned[i3], assigned[i3], results.refProperty));
                    }
                    AssignResults assignResults = results;
                    return assignResults;
                }
                for (i = 0; i < ref1.length; ++i) {
                    if (!orionType2.getOrionTypeId().equals((Object)ref1[i].getFromTypeId())) continue;
                    results.oneToOne = true;
                    results.refProperty = ref1[i].getFromProperty();
                    BRef ref = (BRef)target.get(results.refProperty);
                    BIOrionObject item = ref.getTarget(session);
                    if (item != null) {
                        results.assigned.addItem((Object)new JoinDisplay((BIOrionObject)target, item, results.refProperty));
                        AssignResults assignResults = results;
                        return assignResults;
                    }
                    AssignResults assignResults = results;
                    return assignResults;
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        return results;
    }

    public BObject doSaveValue(BObject o, Context cx) {
        return BJoinFE.doSaveValue(this.results, this.getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BObject doSaveValue(AssignResults results, Context cx) {
        BOrionObject target = results.target;
        BOrionDatabase db = target.getOrionDatabase();
        OrionSession session = null;
        try {
            session = db.createSession(cx);
            if (results.oneToOne) {
                if (results.assigned.getItemCount() > 0) {
                    JoinDisplay joinDisplay = (JoinDisplay)results.assigned.getItem(0);
                    BIOrionObject aboutToSave = joinDisplay.joinToSave;
                    Property[] keys = target.getOrionType().getKey();
                    for (int i = 0; i < keys.length; ++i) {
                        aboutToSave.init(keys[i], target.get(keys[i]));
                        aboutToSave.setModified(keys[i], false);
                    }
                    session.update(aboutToSave);
                } else {
                    Property p = target.getProperty(results.refProperty);
                    target.set(p, p.getDefaultValue());
                    session.update((BIOrionObject)target);
                }
            } else if (results.oneToMany) {
                JoinDisplay joinDisplay;
                int i;
                for (i = 0; i < results.assigned.getItemCount(); ++i) {
                    joinDisplay = (JoinDisplay)results.assigned.getItem(i);
                    session.update(joinDisplay.joinToSave);
                }
                for (i = 0; i < results.unassigned.getItemCount(); ++i) {
                    joinDisplay = (JoinDisplay)results.unassigned.getItem(i);
                    BOrionObject save = (BOrionObject)joinDisplay.joinToSave;
                    Property p = save.getProperty(results.refProperty);
                    save.set(p, p.getDefaultValue());
                    session.update((BIOrionObject)save);
                }
            } else {
                JoinDisplay joinDisplay;
                int i;
                for (i = 0; i < results.assigned.getItemCount(); ++i) {
                    joinDisplay = (JoinDisplay)results.assigned.getItem(i);
                    boolean exists = session.exists(joinDisplay.joinToSave);
                    if (exists) continue;
                    session.insert(joinDisplay.joinToSave);
                }
                for (i = 0; i < results.unassigned.getItemCount(); ++i) {
                    joinDisplay = (JoinDisplay)results.unassigned.getItem(i);
                    session.delete(joinDisplay.joinToSave);
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        return target;
    }

    public void doAssign(BComponent c) {
        BJoinFE.doAssign(this.results, (BOrionObject)c, this.getCurrentContext());
    }

    public static void doAssign(AssignResults results, BOrionObject assign, Context cx) {
        BOrionObject target = results.target;
        if (results.oneToOne) {
            results.clearAssigned(cx);
            target.set(target.getProperty(results.refProperty), (BValue)BRef.make((BIOrionObject)assign));
            JoinDisplay joinDisplay = new JoinDisplay((BIOrionObject)target, (BIOrionObject)assign, results.refProperty);
            if (results.assigned.indexOfItem((Object)joinDisplay) == -1) {
                results.addAssigned(joinDisplay, cx);
            }
        } else if (results.oneToMany) {
            assign.set(assign.getProperty(results.refProperty), (BValue)BRef.make((BIOrionObject)target));
            JoinDisplay joinDisplay = new JoinDisplay((BIOrionObject)assign, (BIOrionObject)assign, results.refProperty);
            if (results.assigned.indexOfItem((Object)joinDisplay) == -1) {
                results.addAssigned(joinDisplay, cx);
            }
            if (results.unassigned.indexOfItem((Object)joinDisplay) != -1) {
                results.removeUnassigned(joinDisplay, cx);
            }
        } else {
            BOrionObject join = (BOrionObject)results.manyToManyTemplate.newCopy();
            join.setOrionDatabase(results.manyToManyTemplate.getOrionDatabase());
            join.set(results.refProperty, (BValue)BRef.make((BIOrionObject)assign));
            JoinDisplay joinDisplay = new JoinDisplay((BIOrionObject)join, (BIOrionObject)assign, results.refProperty);
            if (results.assigned.indexOfItem((Object)joinDisplay) == -1) {
                results.addAssigned(joinDisplay, cx);
            }
            if (results.unassigned.indexOfItem((Object)joinDisplay) != -1) {
                results.removeUnassigned(joinDisplay, cx);
            }
        }
    }

    public static void doUnassign(AssignResults results, BOrionObject unassign, Context cx) {
        BOrionObject target = results.target;
        if (results.oneToOne) {
            results.clearAssigned(cx);
        } else if (results.oneToMany) {
            unassign.set(unassign.getProperty(results.refProperty), (BValue)BRef.make((BIOrionObject)target));
            JoinDisplay joinDisplay = new JoinDisplay((BIOrionObject)unassign, (BIOrionObject)unassign, results.refProperty);
            if (results.assigned.indexOfItem((Object)joinDisplay) != -1) {
                results.removeAssigned(joinDisplay, cx);
            }
            if (results.unassigned.indexOfItem((Object)joinDisplay) == -1) {
                results.addUnassigned(joinDisplay, cx);
            }
        } else {
            BOrionObject join = (BOrionObject)results.manyToManyTemplate.newCopy();
            join.setOrionDatabase(results.manyToManyTemplate.getOrionDatabase());
            join.set(results.refProperty, (BValue)BRef.make((BIOrionObject)unassign));
            JoinDisplay joinDisplay = new JoinDisplay((BIOrionObject)join, (BIOrionObject)unassign, results.refProperty);
            if (results.assigned.indexOfItem((Object)joinDisplay) != -1) {
                results.removeAssigned(joinDisplay, cx);
            }
            if (results.unassigned.indexOfItem((Object)joinDisplay) == -1) {
                results.addUnassigned(joinDisplay, cx);
            }
        }
    }

    public void doSummary(BComponent c) {
        BOrionObject o = (BOrionObject)c;
        BOrionSummary orionSummary = new BOrionSummary();
        orionSummary.setReadonly(true);
        orionSummary.loadValue((BObject)o, this.getCurrentContext());
        BDialog.open((BWidget)this, (String)Lexicon.make(BJoinFE.class).getText("command.summary.label"), (Object)((Object)orionSummary), (int)1);
    }

    protected class UnassignCommand
    extends Command {
        public UnassignCommand() {
            super((BWidget)BJoinFE.this, TYPE.getModule(), "command.unassign");
        }

        public CommandArtifact doInvoke() {
            try {
                Object[] selection = ((BJoinFE)BJoinFE.this).results.assigned.getSelectedItems();
                for (int i = 0; i < selection.length; ++i) {
                    JoinDisplay joinDisplay = (JoinDisplay)selection[i];
                    BJoinFE.this.results.removeAssigned(joinDisplay, BJoinFE.this.getCurrentContext());
                    BJoinFE.this.results.addUnassigned(joinDisplay, BJoinFE.this.getCurrentContext());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected class SummaryCommand
    extends Command {
        public SummaryCommand() {
            super((BWidget)BJoinFE.this, TYPE.getModule(), "command.summary");
        }

        public CommandArtifact doInvoke() {
            try {
                Object[] selection = ((BJoinFE)BJoinFE.this).results.assigned.getSelectedItems();
                for (int i = 0; i < selection.length; ++i) {
                    JoinDisplay joinDisplay = (JoinDisplay)selection[i];
                    BJoinFE.this.doSummary((BComponent)joinDisplay.rowToDisplay);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    class Controller
    extends ListController {
        Controller() {
        }

        protected void itemDoubleClicked(BMouseEvent event, int index) {
            BJoinFE.this.unassignCommand.invoke();
        }
    }

    public static class AssignResults {
        public BOrionObject manyToManyTemplate;
        public boolean oneToOne = false;
        public boolean oneToMany = false;
        public String refProperty;
        public BOrionObject target;
        public BOrionTypeId rowType;
        public BOrionTypeId joinType;
        public BList assigned;
        public BList unassigned;

        public void addAssigned(JoinDisplay joinDisplay, Context cx) {
            this.assigned.addItem((Object)joinDisplay);
        }

        public void removeAssigned(JoinDisplay joinDisplay, Context cx) {
            this.assigned.removeItem((Object)joinDisplay);
        }

        public void clearAssigned(Context cx) {
            this.assigned.removeAllItems();
        }

        public void addUnassigned(JoinDisplay joinDisplay, Context cx) {
            this.unassigned.addItem((Object)joinDisplay);
        }

        public void removeUnassigned(JoinDisplay joinDisplay, Context cx) {
            this.unassigned.removeItem((Object)joinDisplay);
        }

        public void clearUnassigned(Context cx) {
            this.unassigned.removeAllItems();
        }
    }

    public static class JoinDisplay {
        public BIOrionObject joinToSave;
        public BIOrionObject rowToDisplay;
        public String refProperty;

        public JoinDisplay(BIOrionObject joinToSave, BIOrionObject rowToDisplay, String refProperty) {
            this.joinToSave = joinToSave;
            this.rowToDisplay = rowToDisplay;
            this.refProperty = refProperty;
        }

        public boolean equals(Object obj) {
            if (obj instanceof JoinDisplay) {
                return this.joinToSave.get(this.refProperty).equals((Object)((JoinDisplay)obj).joinToSave.get(this.refProperty)) && BOrionObject.equivalent((BIOrionObject)this.joinToSave, (BIOrionObject)((JoinDisplay)obj).joinToSave);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.joinToSave.hashCode();
        }

        public String encodeToString() {
            String encoded = this.joinToSave.getHandle() + "~" + this.rowToDisplay.getHandle() + "~" + this.refProperty;
            return encoded;
        }

        public static JoinDisplay decodeFromString(String s, BObject resolveBase) {
            String[] split = TextUtil.split((String)s, (char)'~');
            BOrionObject joinToSave = null;
            try {
                joinToSave = (BOrionObject)BOrd.make((String)split[0]).get(resolveBase);
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
            BOrionObject rowToDisplay = (BOrionObject)BOrd.make((String)split[1]).get(resolveBase);
            String refProperty = split[2];
            return new JoinDisplay((BIOrionObject)joinToSave, (BIOrionObject)rowToDisplay, refProperty);
        }

        public String toString() {
            return this.rowToDisplay.toDisplayString(null);
        }
    }
}

