/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.crop;

import com.tridiumx.entsec.photoID.crop.BPaperRatioEnum;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BPaperRatio
extends BSimple
implements BIEncodable {
    public static final BPaperRatio RATIO_3_4 = BPaperRatio.make(BPaperRatioEnum.ratio, 3, 4);
    public static final BPaperRatio RATIO_4_3 = BPaperRatio.make(BPaperRatioEnum.ratio, 4, 3);
    public static final BPaperRatio RATIO_16_9 = BPaperRatio.make(BPaperRatioEnum.ratio, 16, 9);
    public static final BPaperRatio RATIO_9_16 = BPaperRatio.make(BPaperRatioEnum.ratio, 9, 16);
    public static final BPaperRatio FREEHAND = BPaperRatio.make(BPaperRatioEnum.freehand, 0, 0);
    public static final BPaperRatio DEFAULT = RATIO_3_4;
    public static final Type TYPE = Sys.loadType(BPaperRatio.class);
    private BPaperRatioEnum units;
    private int width;
    private int height;
    public static final BPaperRatio[] defaults = new BPaperRatio[]{RATIO_3_4, RATIO_4_3, RATIO_16_9, RATIO_9_16, FREEHAND};

    public Type getType() {
        return TYPE;
    }

    private BPaperRatio() {
        this(BPaperRatioEnum.ratio, 3, 4);
    }

    private BPaperRatio(BPaperRatioEnum units, int width, int height) {
        this.units = units;
        this.width = width;
        this.height = height;
    }

    public static BPaperRatio make(BPaperRatioEnum units, int width, int height) {
        return new BPaperRatio(units, width, height);
    }

    public boolean equals(Object o) {
        if (o instanceof BPaperRatio) {
            return this.encodeToString().equals(((BPaperRatio)((Object)o)).encodeToString());
        }
        return false;
    }

    public String toString(Context cx) {
        if (this.getUnits() == BPaperRatioEnum.ratio) {
            return "" + this.getWidth() + ":" + this.getHeight();
        }
        if (this.getUnits() == BPaperRatioEnum.freehand) {
            return BPaperRatioEnum.freehand.getDisplayTag(cx);
        }
        return this.encodeToString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        String s = in.readUTF();
        return this.decodeFromString(s);
    }

    public String encodeToString() {
        StringBuffer b = new StringBuffer();
        if (this.getUnits() == BPaperRatioEnum.freehand) {
            b.append(this.getUnits().getTag());
        } else if (this.getUnits() == BPaperRatioEnum.ratio) {
            b.append(this.getWidth()).append(":").append(this.getHeight());
            b.append(" ").append(this.getUnits().getTag());
        }
        return b.toString();
    }

    public BObject decodeFromString(String s) {
        if (s.equals(BPaperRatioEnum.freehand.getTag())) {
            return FREEHAND;
        }
        BPaperRatio paperRatio = new BPaperRatio();
        s = TextUtil.replace((String)s, (String)" ", (String)":");
        String[] split = TextUtil.split((String)s, (char)':');
        paperRatio.setWidth(Integer.parseInt(split[0]));
        paperRatio.setHeight(Integer.parseInt(split[1]));
        paperRatio.setUnits(BPaperRatioEnum.ratio);
        return paperRatio;
    }

    public BPaperRatioEnum getUnits() {
        return this.units;
    }

    public void setUnits(BPaperRatioEnum units) {
        this.units = units;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getRatio() {
        return (double)this.getWidth() / (double)this.getHeight();
    }
}

