/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.obix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.naming.OrdTarget;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.xml.XElem;
import javax.baja.xml.XWriter;
import obix.Obj;
import obix.io.ObixBinEncoder;
import obix.io.ObixXmlDecoder;
import obix.io.ObixXmlEncoder;

public abstract class EntsecObixUtil {
    public static final BRelTime STALE_TIME = BRelTime.makeMinutes((int)6);

    public static Obj getObj(XElem elem) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XWriter out = new XWriter((OutputStream)stream);
        elem.write(out, 0);
        out.flush();
        byte[] buf = stream.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(buf);
        obix.io.ObixDecoder decoder = obix.io.ObixDecoder.make((InputStream)bin);
        return decoder.decodeDocument();
    }

    public static String encodeObj(Obj obj) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObixBinEncoder encoder = new ObixBinEncoder((OutputStream)stream);
        encoder.encodeDocument(obj);
        return new String(stream.toByteArray());
    }

    public static BValue getValue(Obj obj, BValue prototype) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObixXmlEncoder encoder = new ObixXmlEncoder((OutputStream)stream);
        encoder.encode(obj);
        encoder.flush();
        ByteArrayInputStream is = new ByteArrayInputStream(stream.toByteArray());
        ObixDecoder decoder = new ObixDecoder((InputStream)is, null);
        return decoder.decode(prototype);
    }

    public static Obj getObj(BValue value) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObixEncoder encoder = new ObixEncoder("/", "/", (OutputStream)stream);
        encoder.encodeFully(OrdTarget.unmounted((BObject)value));
        encoder.commit();
        ByteArrayInputStream is = new ByteArrayInputStream(stream.toByteArray());
        ObixXmlDecoder decoder = new ObixXmlDecoder((InputStream)is);
        return decoder.decodeDocument();
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] data = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            data[i / 2] = Integer.decode("0x" + s.charAt(i) + s.charAt(i + 1)).byteValue();
        }
        return data;
    }

    static class Encoder
    extends ObixEncoder {
        Encoder(ObixEncoder base) throws Exception {
            super(base);
        }

        protected void configChild(String parentHref, OrdTarget tgt) {
            super.configChild(parentHref, tgt);
            this.setRef(false);
        }
    }
}

