/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.orion;

import com.tridium.gx.awt.ImageManager;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridium.orion.annotations.OrionProperties;
import com.tridium.orion.annotations.OrionProperty;
import com.tridium.orion.sql.BIsNull;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.BIBackgroundAssociation;
import com.tridiumx.entsec.orionTools.BITenantObject;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.orion.BOrionImageFormat;
import java.io.File;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraOrionType
@NiagaraProperties(value={@NiagaraProperty(name="lastModified", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=2053, facets={@Facet(name="INDEXED", value="true")}), @NiagaraProperty(name="imageId", type="BUuid", defaultValue="BUuid.NULL", flags=1, facets={@Facet(name="KEY", value="true")}), @NiagaraProperty(name="image", type="BBlob", defaultValue="BBlob.DEFAULT"), @NiagaraProperty(name="imageFormat", type="BOrionImageFormat", defaultValue="BOrionImageFormat.jpg", flags=1)})
@OrionProperties(value={@OrionProperty(name="person", refType="entsec:Person", facets={@Facet(name="INDEXED", value="true"), @Facet(name="ON_DELETE", value="BOnDelete.CASCADE")}), @OrionProperty(name="tenant", refType="entsec:Tenant", flags=8, facets={@Facet(name="ON_DELETE", value="BOnDelete.NO_ACTION"), @Facet(name="ALLOW_NULL", value="true")})})
public class BPersonPortrait
extends BOrionObject
implements BIBackgroundAssociation,
BITenantObject {
    @Generated
    public static final Property lastModified = BPersonPortrait.newProperty((int)2053, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    @Generated
    public static final Property imageId = BPersonPortrait.newProperty((int)1, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    @Generated
    public static final Property person = BPersonPortrait.newProperty((int)0, (BValue)BRef.make((String)"entsec:Person"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"onDelete", (int)1)));
    @Generated
    public static final Property tenant = BPersonPortrait.newProperty((int)8, (BValue)BRef.make((String)"entsec:Tenant"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    @Generated
    public static final Property image = BPersonPortrait.newProperty((int)0, (BValue)BBlob.DEFAULT, null);
    @Generated
    public static final Property imageFormat = BPersonPortrait.newProperty((int)1, (BValue)BOrionImageFormat.jpg, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPersonPortrait.class);
    @Generated
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final String COLUMN_KEY = "portrait";
    public static boolean ensureNextDelete = false;
    public static boolean leaveFiles = false;
    private static TempCleaner tempCleaner;
    static long SIX_MINUTES;
    static long FIVE_MINUTES;
    static long bytesCached;
    static int cacheLimit;
    static boolean leaveFilesPerm;
    static Object imageOrdLock;
    public static final BIcon ICON;

    @Generated
    public BAbsTime getLastModified() {
        return (BAbsTime)this.get(lastModified);
    }

    @Generated
    public void setLastModified(BAbsTime v) {
        this.set(lastModified, (BValue)v, null);
    }

    @Generated
    public BUuid getImageId() {
        return (BUuid)this.get(imageId);
    }

    @Generated
    public void setImageId(BUuid v) {
        this.set(imageId, (BValue)v, null);
    }

    @Generated
    public BRef getPerson() {
        return (BRef)this.get(person);
    }

    @Generated
    public void setPerson(BRef v) {
        this.set(person, (BValue)v, null);
    }

    @Generated
    public BPerson resolvePerson(OrionSession session) {
        return (BPerson)this.getPerson().getTarget(session);
    }

    @Override
    @Generated
    public BRef getTenant() {
        return (BRef)this.get(tenant);
    }

    @Generated
    public void setTenant(BRef v) {
        this.set(tenant, (BValue)v, null);
    }

    @Generated
    public BTenant resolveTenant(OrionSession session) {
        return (BTenant)this.getTenant().getTarget(session);
    }

    @Generated
    public BBlob getImage() {
        return (BBlob)this.get(image);
    }

    @Generated
    public void setImage(BBlob v) {
        this.set(image, (BValue)v, null);
    }

    @Generated
    public BOrionImageFormat getImageFormat() {
        return (BOrionImageFormat)this.get(imageFormat);
    }

    @Generated
    public void setImageFormat(BOrionImageFormat v) {
        this.set(imageFormat, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    @Override
    public Property getTenantProperty() {
        return tenant;
    }

    public BOrd getInMemoryImageOrd() {
        return BOrd.make((String)("orion://" + this.getOrionDatabase().getName() + "|orionimage:" + this.getImageId() + "." + this.getImageFormat().getTag()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrd getImageOrd() {
        Object object = imageOrdLock;
        synchronized (object) {
            String fileName = null;
            try {
                BIFile file;
                BDirectory dir;
                fileName = this.getFileName();
                if (Sys.getStation() == null) {
                    return BOrd.make((String)(this.getOrionDatabase().getAbsoluteOrd() + "|orionimage:" + this.getImageId() + "." + this.getImageFormat().getTag()));
                }
                BDirectory tempDir = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("^temp"));
                if (tempDir == null) {
                    tempDir = BFileSystem.INSTANCE.makeDir(new FilePath("^temp"));
                }
                if ((dir = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("^temp/orionImage"))) == null) {
                    dir = BFileSystem.INSTANCE.makeDir(new FilePath("^temp/orionImage"));
                }
                if ((file = BFileSystem.INSTANCE.findFile(new FilePath("^temp/orionImage/" + fileName))) == null || ensureNextDelete) {
                    if (bytesCached > (long)cacheLimit || ensureNextDelete) {
                        bytesCached = 0L;
                        ImageManager.trimAll();
                        if (!leaveFiles || ensureNextDelete) {
                            if (!leaveFilesPerm) {
                                BIFile[] toDelete = dir.listFiles();
                                for (int i = 0; i < toDelete.length; ++i) {
                                    try {
                                        toDelete[i].delete();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            ensureNextDelete = false;
                        }
                    }
                    if (file == null) {
                        file = BFileSystem.INSTANCE.makeFile(new FilePath("^temp/orionImage/" + fileName));
                        bytesCached += (long)this.getImage().length();
                        file.write(this.getImage().copyBytes());
                        File f = BFileSystem.INSTANCE.pathToLocalFile(new FilePath("^temp/orionImage/" + fileName));
                        if (!leaveFilesPerm) {
                            f.deleteOnExit();
                        }
                    }
                }
            }
            catch (Exception e) {
                BEnterpriseSecurityService.LOG.log(Level.FINE, "Cannot provide Orion Image: " + fileName, e);
            }
            return BOrd.make((String)("file:^temp/orionImage/" + fileName));
        }
    }

    public String getFileName() throws Exception {
        return this.getImageId().encodeToString() + "." + this.getImageFormat().getTag();
    }

    public static String getPortraitDisplayName(Context cx) {
        return "Portrait";
    }

    public static BPersonPortrait readFromImageOrd(BOrd ord, OrionSession session) {
        if (ord.equals((Object)BOrd.DEFAULT)) {
            return null;
        }
        try {
            String[] splitOrd = TextUtil.split((String)ord.toString(), (char)'/');
            String body = splitOrd[splitOrd.length - 1];
            String[] split = TextUtil.split((String)body, (char)'.');
            BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(split[0]);
            return (BPersonPortrait)session.read(ORION_TYPE, (BSimple)uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean beforeInsert(OrionSession session) {
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
        int kb = this.getImage().length() / 1000;
        if (kb > network.getMaxImageFileSize()) {
            throw new BajaRuntimeException("Image is greater than Max Image File Size: " + kb + " KB > " + network.getMaxImageFileSize() + " KB");
        }
        this.setLastModified(BAbsTime.now());
        this.ensureUniquePerson(session);
        return super.beforeInsert(session);
    }

    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
    }

    public boolean beforeUpdate(OrionSession session) {
        this.setLastModified(BAbsTime.now());
        this.ensureUniquePerson(session);
        return super.beforeUpdate(session);
    }

    public boolean isAuditable() {
        return true;
    }

    public void ensureUniquePerson(OrionSession session) {
        if (this.getPerson().isBound()) {
            OrionCursor c = session.select(ORION_TYPE, new PropertyValue(person, (BValue)this.getPerson()));
            while (c.next()) {
                BPersonPortrait other = (BPersonPortrait)c.get();
                if (other.getImageId().equals((Object)this.getImageId())) continue;
                session.delete((BIOrionObject)other);
            }
        } else {
            BPersonPortrait.startTempCleaner();
        }
    }

    public static void startTempCleaner() {
        if (tempCleaner == null) {
            tempCleaner = new TempCleaner("Entsec:TempCleanerThread", true);
            tempCleaner.start();
        }
    }

    static void removeTempCleaner() {
        tempCleaner = null;
    }

    public BIcon getIcon() {
        return ICON;
    }

    static {
        SIX_MINUTES = 360000L;
        FIVE_MINUTES = 300000L;
        bytesCached = 0L;
        cacheLimit = Integer.getInteger("orionImage.cacheSize", 10) * 1000000;
        leaveFilesPerm = Boolean.getBoolean("orionImage.leaveFiles");
        imageOrdLock = new Object();
        ICON = BIcon.std((String)"image.png");
    }

    static class TempCleaner
    extends Thread {
        public TempCleaner(String name, boolean daemon) {
            super(name);
            this.setDaemon(daemon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(SIX_MINUTES);
                        boolean keepAlive = false;
                        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
                        OrionSession session = null;
                        try {
                            session = service.createSession(null);
                            BSqlQuery q = BSqlQuery.make((OrionType)ORION_TYPE);
                            BSqlField personField = new BSqlField(ORION_TYPE, person);
                            q.where((BExpression)new BIsNull((BExpression)personField));
                            OrionCursor c = session.select((BQuery)q);
                            while (c.next()) {
                                BPersonPortrait personPortrait = (BPersonPortrait)c.get();
                                if (personPortrait.getLastModified().getMillis() < BAbsTime.now().getMillis() - FIVE_MINUTES) {
                                    session.delete((BIOrionObject)personPortrait);
                                    continue;
                                }
                                keepAlive = true;
                            }
                            if (keepAlive) continue;
                            BPersonPortrait.removeTempCleaner();
                            return;
                        }
                        finally {
                            if (session == null) continue;
                            session.close();
                            session = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (ServiceNotFoundException snfe) {
                    BEnterpriseSecurityService.LOG.log(Level.SEVERE, snfe.getMessage(), snfe);
                    BPersonPortrait.removeTempCleaner();
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

