/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.video;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.videoDriver.ui.videoStream.decoder.VideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.video.BPhotoIDCamera;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.naming.BOrd;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BBlob;
import javax.baja.util.BUuid;

public class PhotoIDVideoDecoder
extends VideoDecoder {
    private BOrd lastOrd = null;
    private BImage lastImage = null;
    private static Object lock = new Object();
    private BUuid personId = BUuid.DEFAULT;
    public BPhotoIDCamera camera;
    public static final BImage DEFAULT_IMAGE = BImage.make((String)"module://entsec/rc/silhoutteImage.PNG");
    public boolean isCameraOk = false;

    public PhotoIDVideoDecoder(BPhotoIDCamera camera) {
        this.camera = camera;
        this.initMonitor();
    }

    public void initMonitor() {
        try {
            FoxRpcUtil.doSilentRpc((BISpaceNode)this.camera, (String)"monitorDoorRPC", (Object[])new Object[0]);
            this.personId = this.camera.getPersonId();
            this.isCameraOk = true;
        }
        catch (Exception e) {
            this.isCameraOk = false;
            e.printStackTrace();
        }
    }

    public void readFrameData(VidFrame vidFrame) throws Exception {
    }

    public void decodeFrame(VidFrame vidFrame) throws Exception {
        if (this.decodePhotoFrame(vidFrame)) {
            Thread.sleep(200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decodePhotoFrame(VidFrame vidFrame) throws Exception {
        Object object = lock;
        synchronized (object) {
            BOrd ord = null;
            BImage image = null;
            this.camera.lease();
            if (this.requestToStop) {
                return false;
            }
            FoxRpcUtil.doSilentRpc((BISpaceNode)this.camera, (String)"keepAliveMonitorRPC", (Object[])new Object[0]);
            if (this.requestToStop) {
                return false;
            }
            BPhotoIDNetwork network = null;
            if (this.camera.getParent() instanceof BPhotoIDNetwork) {
                network = (BPhotoIDNetwork)this.camera.getParent();
                network.lease();
            }
            if (this.isCameraOk) {
                if (this.camera.getPortraitOrd() != BOrd.DEFAULT) {
                    BOrd sessionOrd = this.camera.getSession().getAbsoluteOrd();
                    ord = BOrd.make((String)(sessionOrd + "|" + this.camera.getPortraitOrd()));
                    if (ord.equals((Object)this.lastOrd)) {
                        return true;
                    }
                    BBlob blob = null;
                    try {
                        blob = (BBlob)ord.get();
                    }
                    catch (Exception e) {
                        this.lastImage = DEFAULT_IMAGE;
                        this.lastOrd = BOrd.DEFAULT;
                        this.lastImage.sync();
                        vidFrame.image = DEFAULT_IMAGE;
                        return false;
                    }
                    image = BImage.make((byte[])blob.copyBytes());
                } else {
                    image = DEFAULT_IMAGE;
                }
                if (this.requestToStop) {
                    return false;
                }
                this.camera.lease(2);
            } else {
                image = DEFAULT_IMAGE;
            }
            if (this.lastImage != null && image.equals((Object)this.lastImage)) {
                return true;
            }
            if (this.requestToStop) {
                return false;
            }
            image.sync();
            if (image.getHeight() > 400.0) {
                double scale = 400.0 / image.getHeight();
                image = image.transform(BTransform.makeScale((double)scale, (double)scale));
                image.sync();
            }
            this.lastImage = image;
            this.lastOrd = ord;
            vidFrame.image = this.lastImage;
            return false;
        }
    }
}

