/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.query.BProjCol;
import com.tridiumx.entsec.filter.BDynamicRecentTimeRangeType;
import com.tridiumx.entsec.filter.BSecRecentAbsTimeFilter;
import com.tridiumx.entsec.filter.BStationStringFilter;
import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import javax.baja.history.BHistoryRecord;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"entsec:ActivityRecord"}, requiredPermissions="r")})
public class BActivityColumnsProvider
extends BColumnsProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BActivityColumnsProvider.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public TypeSpecPath[] getDefaultColumns(BQuery query) {
        BTypeSpec typeSpec = QueryUtil.getRowType(query);
        Array a = new Array(TypeSpecPath.class);
        BHistoryRecord rec = (BHistoryRecord)typeSpec.getInstance();
        Property[] props = rec.getFrozenPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            if (Flags.isHidden((BComplex)rec, (Slot)props[i])) continue;
            a.add((Object)new TypeSpecPath(props[i]));
        }
        return (TypeSpecPath[])a.trim();
    }

    @Override
    public BProjCol makeColumn(TypeSpecPath typeSpecPath, BQuery query) {
        BProjCol col = super.makeColumn(typeSpecPath, query);
        if (typeSpecPath.typeSpec.equals((Object)BAbsTime.TYPE.getTypeSpec())) {
            BSecRecentAbsTimeFilter filter = new BSecRecentAbsTimeFilter();
            filter.setLocked(true);
            filter.setRecentTimeRangeType(BDynamicRecentTimeRangeType.last12Hours);
            col.add("defaultFilter", (BValue)filter);
        } else if (typeSpecPath.path.equals("station")) {
            BStationStringFilter filter = new BStationStringFilter();
            col.add("defaultFilter", (BValue)filter, 0x10000000);
        }
        return col;
    }

    @Override
    public int getDefaultSortColumnIndex(BQuery query) {
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].get("typeSpec").equals((Object)BAbsTime.TYPE.getTypeSpec())) continue;
            return i;
        }
        return -1;
    }
}

