/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.rdb.hsqldb.BHsqlDatabase;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLog;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDefragAndStationSaveJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BDefragAndStationSaveJob.class);
    public static final int DEFRAG_PROGRESS_STARTED = 10;
    public static final int DEFRAG_PROGRESS_COMPLETED = 100;
    private static final BIcon icon = BIcon.std((String)"save.png");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void run(Context cx) throws Exception {
        JobLog jobLog = this.log();
        jobLog.start("Start database defrag and station save..");
        this.progress(10);
        BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
        BHsqlDatabase hsqlDatabase = null;
        for (BOrionDatabase orionDatabase : orionDatabases) {
            BLocalOrionDatabase db = (BLocalOrionDatabase)orionDatabase;
            BRdbms rdbms = db.getRdbms();
            try {
                if (!rdbms.getType().is(BHsqlDatabase.TYPE)) continue;
                hsqlDatabase = (BHsqlDatabase)orionDatabase.getRdbms();
                if (!hsqlDatabase.getDefragOnSave()) {
                    hsqlDatabase.doDefragAndSave();
                } else {
                    jobLog.failed("Defrag on save is enabled");
                }
                this.progress(100);
                jobLog.endSuccess("Database defrag and station save done successfully");
            }
            catch (Exception e) {
                jobLog.endFailed((Throwable)e);
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

