/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.ping.BIPingable;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BPingJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BPingJob.class);
    private BIPingable pingable;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPingJob() {
    }

    public BPingJob(BIPingable pingable) {
        this.pingable = pingable;
    }

    public void run(Context cx) throws Exception {
        this.progress(10);
        Exception e = null;
        if (this.pingable instanceof BDeviceNetwork) {
            BDeviceNetwork network = (BDeviceNetwork)this.pingable;
            network.doPing();
            this.log().success(network.getDisplayName(cx) + " has been successfully pinged.");
            BDevice[] devices = network.getDevices();
            for (int i = 0; i < devices.length; ++i) {
                Exception pingException = this.pingDevice(devices[i]);
                if (pingException == null) continue;
                e = pingException;
            }
        } else if (this.pingable instanceof BDevice) {
            Exception pingException = this.pingDevice((BDevice)this.pingable);
            if (pingException != null) {
                e = pingException;
            }
        } else if (this.pingable != null) {
            this.pingable.doPing();
        }
        if (e != null) {
            throw new Exception("Not all devices could be pinged");
        }
    }

    public Exception pingDevice(BDevice device) throws Exception {
        Exception e = null;
        if (device.getEnabled()) {
            if (device instanceof BObixClient) {
                ((BObixClient)device).doAttach();
                device.doPing();
            } else {
                device.doPing();
            }
            if (device.getHealth().getDown()) {
                e = new Exception(device.getHealth().getLastFailCause());
                this.log().failed(device.getDisplayName(null) + " cannot be reached:", (Throwable)e);
            } else {
                this.log().success(device.getDisplayName(null) + " has been successfully pinged.");
            }
        }
        return e;
    }
}

