/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.rdb.aes.BRdbSecuritySettings;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BValidatePinNumbersJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BValidatePinNumbersJob.class);
    private String currentPasskey = null;
    private String newPasskey = null;
    private String confirmNewPasskey = null;
    private boolean isValidationPassed = false;
    private String message = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BValidatePinNumbersJob(String currentPasskey, String newPasskey, String confirmNewPasskey) {
        this.currentPasskey = currentPasskey;
        this.newPasskey = newPasskey;
        this.confirmNewPasskey = confirmNewPasskey;
    }

    public BValidatePinNumbersJob() {
    }

    public void run(Context cx) {
        BRdbSecuritySettings rdbmsSettings = ((BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE)).getOrionDatabase().getRdbms().getRdbSecuritySettings();
        BPassword savedKey = rdbmsSettings.getPasskey();
        if (!savedKey.validate(this.currentPasskey)) {
            this.message = "The current passkey was incorrect.";
        } else if (savedKey.validate(this.newPasskey)) {
            this.message = "The new passkey and the current passkey cannot be same.";
        } else if (this.newPasskey.trim().equals("")) {
            this.message = "The new passkey cannot be blank.";
        } else if (!this.newPasskey.equals(this.confirmNewPasskey)) {
            this.message = "The new passkeys do not match.";
        } else {
            this.message = "This process will take up to 10 minutes to complete, during which the system will be unusable";
            this.isValidationPassed = true;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isValidationPassed() {
        return this.isValidationPassed;
    }
}

