/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query;

import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.query.BProjCol;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.filter.BSecAbsTimeFilter;
import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmRecord"})})
public class BAlarmDbColumnsProvider
extends BColumnsProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmDbColumnsProvider.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public TypeSpecPath[] getDefaultColumns(BQuery query) {
        Array a = new Array(TypeSpecPath.class);
        a.add((Object)new TypeSpecPath(BAbsTime.TYPE.getTypeSpec(), "timestamp", lex.getText("alarmTime")));
        a.add((Object)new TypeSpecPath(BAlarmRecord.normalTime));
        a.add((Object)new TypeSpecPath(BString.TYPE.getTypeSpec(), "alarmData.sourceName", lex.getText("sourceName")));
        BFunctionExpression alarmClassExp = Funcs.make((String)(TYPE + ".getAlarmClassDisplayName"), (Type)BString.TYPE, (BExpression)Exprs.simple((BSimple)BString.DEFAULT));
        TypeSpecPath alarmClassDisplayName = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), "alarmClassDisplayName", null, (BExpression)alarmClassExp);
        a.add((Object)alarmClassDisplayName);
        a.add((Object)new TypeSpecPath(BAlarmRecord.sourceState));
        a.add((Object)new TypeSpecPath(BAlarmRecord.ackState));
        a.add((Object)new TypeSpecPath(BAlarmRecord.priority));
        BFunctionExpression exp = Funcs.make((String)(BEnterpriseSecurityService.TYPE + ".format"), (Type)BString.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)"alarmData.msgText")));
        TypeSpecPath formatCol = new TypeSpecPath(BTypeSpec.make((String)"baja:String"), "alarmData.msgText", null, (BExpression)exp);
        a.add((Object)formatCol);
        a.add((Object)new TypeSpecPath(BString.TYPE.getTypeSpec(), "alarmData.badge", BBadge.TYPE.getDisplayName(null)));
        a.add((Object)new TypeSpecPath(BAlarmRecord.user));
        return (TypeSpecPath[])a.trim();
    }

    @Override
    public TypeSpecPath[] getHiddenColumns(BQuery query) {
        Array a = new Array(TypeSpecPath.class);
        a.add((Object)new TypeSpecPath(BAlarmRecord.uuid));
        a.add((Object)new TypeSpecPath(BAlarmRecord.sourceState));
        a.add((Object)new TypeSpecPath(BAlarmRecord.ackState));
        return (TypeSpecPath[])a.trim();
    }

    @Override
    public BProjCol makeColumn(TypeSpecPath typeSpecPath, BQuery query) {
        BProjCol col = super.makeColumn(typeSpecPath, query);
        if (typeSpecPath.typeSpec.equals((Object)BAbsTime.TYPE.getTypeSpec()) && typeSpecPath.path.equals("timestamp")) {
            BSecAbsTimeFilter filter = new BSecAbsTimeFilter();
            filter.setTimeRangeType(BDynamicTimeRangeType.today);
            col.add("defaultFilter", (BValue)filter);
        }
        return col;
    }

    @Override
    public int getDefaultSortColumnIndex(BQuery query) {
        BProjectionColumn[] columns = query.getProjection().getProjectionColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].get("typeSpec").equals((Object)BAbsTime.TYPE.getTypeSpec())) continue;
            return i;
        }
        return -1;
    }

    public static BObject getAlarmClassDisplayName(BObject row, BString useless) {
        BAlarmRecord rec = (BAlarmRecord)row;
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmClass alarmClass = alarmService.lookupAlarmClass(rec.getAlarmClass());
        return BString.make((String)alarmClass.getDisplayName(null));
    }
}

