/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query.consolidated;

import com.tridium.bql.filter.BStringFilter;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedQuery;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedRow;
import com.tridiumx.entsec.securityUtil.query.consolidated.ConsolidatedTableCursor;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.query.BQuery;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BConsolidatedQueryResult
extends BObject
implements BITable<BObject> {
    @Generated
    public static final Type TYPE = Sys.loadType(BConsolidatedQueryResult.class);
    private BConsolidatedQuery monitor;
    private BStringFilter stationFilter;
    private BOrd baseOrd;
    private BQuery query;
    private int sortCol;
    private boolean sortAsc;
    private ArrayList<BConsolidatedRow> list;
    private ColumnList columns;
    private IFilter filter;
    private BFacets tableFacets = BFacets.NULL;
    Context cx;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BConsolidatedQueryResult(BConsolidatedQuery monitor, BStringFilter stationFilter, BOrd baseOrd, BQuery query, int sortCol, boolean sortAsc, Context cx) {
        this(monitor, stationFilter, baseOrd, query, sortCol, sortAsc, cx, null);
    }

    private BConsolidatedQueryResult(BConsolidatedQuery monitor, BStringFilter stationFilter, BOrd baseOrd, BQuery query, int sortCol, boolean sortAsc, Context cx, IFilter filter) {
        this.monitor = monitor;
        this.stationFilter = stationFilter;
        this.baseOrd = baseOrd;
        this.query = query;
        this.sortCol = sortCol;
        this.sortAsc = sortAsc;
        this.cx = cx;
        this.filter = filter;
    }

    public TableCursor<BObject> cursor() {
        return new ConsolidatedTableCursor(this);
    }

    public BITable<BObject> filter(IFilter filter) {
        return new BConsolidatedQueryResult(this.monitor, this.stationFilter, this.baseOrd, this.query, this.sortCol, this.sortAsc, this.cx, filter);
    }

    public int size() {
        this.load();
        return this.list.size();
    }

    public BObject get(int index) {
        this.load();
        return this.list.get(index);
    }

    public BObject[] list() {
        this.load();
        int size = this.list.size();
        BObject[] result = new BObject[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.list.get(i);
        }
        return result;
    }

    public BObject[] list(BObject[] in) {
        this.load();
        int size = this.list.size();
        if (in.length < size) {
            in = new BObject[size];
        }
        for (int i = 0; i < size; ++i) {
            in[i] = this.list.get(i).getValue();
        }
        if (in.length > size) {
            in[size] = null;
        }
        return in;
    }

    public BITable<BObject> toTable() {
        return this;
    }

    public ColumnList getColumns() {
        this.load();
        return this.columns;
    }

    public BObject get(int row, Column col) {
        this.load();
        return this.list.get(row).get(col);
    }

    public String getString(int row, Column col) {
        this.load();
        return this.list.get(row).getString(col);
    }

    public double getDouble(int row, Column col) {
        this.load();
        return this.list.get(row).getDouble(col);
    }

    public float getFloat(int row, Column col) {
        this.load();
        return this.list.get(row).getFloat(col);
    }

    public int getInt(int row, Column col) {
        this.load();
        return this.list.get(row).getInt(col);
    }

    public long getLong(int row, Column col) {
        this.load();
        return this.list.get(row).getLong(col);
    }

    public boolean getBoolean(int row, Column col) {
        this.load();
        return this.list.get(row).getBoolean(col);
    }

    public int getFlags(int row, Column col) {
        this.load();
        return this.list.get(row).getFlags(col);
    }

    public BFacets getFacets(int row, Column col) {
        this.load();
        return this.list.get(row).getFacets(col);
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    private synchronized void load() {
        if (this.list != null) {
            return;
        }
        Cursor<BConsolidatedRow> c = this.monitor.doConsolidatedQuery(this.stationFilter, this.baseOrd, this.query, this.sortCol, this.sortAsc, this.filter, this.cx);
        this.list = new ArrayList(128);
        while (c.next()) {
            BConsolidatedRow row = (BConsolidatedRow)((Object)c.get());
            this.list.add(row);
            if (this.columns == null) {
                this.columns = row.getTable().getColumns();
            }
            if (this.tableFacets != BFacets.NULL) continue;
            this.tableFacets = row.getTable().getTableFacets();
        }
    }
}

