/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet.trend;

import com.tridiumemea.addons.bacnet.trend.BRoundRobinCollector;
import com.tridiumemea.addons.bacnet.util.ParentLegal;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enableBatching", type="BBoolean", defaultValue="BBoolean.FALSE"), @NiagaraProperty(name="sleepFor", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(0)"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}), @NiagaraProperty(name="afterHistories", type="BInteger", defaultValue="BInteger.make(5)", facets={@Facet(name="BFacets.MIN", value="BInteger.make(1)")}), @NiagaraProperty(name="lastBatchDuration", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=65603, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}), @NiagaraProperty(name="averageBatchDuration", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=65603, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")})})
public class BCollectorBatching
extends BComponent {
    public static final Property enableBatching = BCollectorBatching.newProperty((int)0, (boolean)((BBoolean)BBoolean.FALSE.as(BBoolean.class)).getBoolean(), null);
    public static final Property sleepFor = BCollectorBatching.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    public static final Property afterHistories = BCollectorBatching.newProperty((int)0, (int)((BInteger)BInteger.make((int)5).as(BInteger.class)).getInt(), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property lastBatchDuration = BCollectorBatching.newProperty((int)65603, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    public static final Property averageBatchDuration = BCollectorBatching.newProperty((int)65603, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    public static final Type TYPE = Sys.loadType(BCollectorBatching.class);
    private int batchHistoryCounter;
    private int batchCounter;
    private BAbsTime lastBatchStart;

    public boolean getEnableBatching() {
        return this.getBoolean(enableBatching);
    }

    public void setEnableBatching(boolean v) {
        this.setBoolean(enableBatching, v, null);
    }

    public BRelTime getSleepFor() {
        return (BRelTime)this.get(sleepFor);
    }

    public void setSleepFor(BRelTime v) {
        this.set(sleepFor, (BValue)v, null);
    }

    public int getAfterHistories() {
        return this.getInt(afterHistories);
    }

    public void setAfterHistories(int v) {
        this.setInt(afterHistories, v, null);
    }

    public BRelTime getLastBatchDuration() {
        return (BRelTime)this.get(lastBatchDuration);
    }

    public void setLastBatchDuration(BRelTime v) {
        this.set(lastBatchDuration, (BValue)v, null);
    }

    public BRelTime getAverageBatchDuration() {
        return (BRelTime)this.get(averageBatchDuration);
    }

    public void setAverageBatchDuration(BRelTime v) {
        this.set(averageBatchDuration, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    void executeBatchSleepLogic() throws InterruptedException {
        if (this.isBatchingEnabled()) {
            ++this.batchHistoryCounter;
            if (this.batchHistoryCounter == this.getAfterHistories()) {
                this.setLastBatchDuration(this.lastBatchStart.delta(BAbsTime.now()));
                ++this.batchCounter;
                long avg = this.getAverageBatchDuration().getMillis();
                long new_sample = this.getLastBatchDuration().getMillis();
                avg -= avg / (long)this.batchCounter;
                this.setAverageBatchDuration(BRelTime.make((long)(avg += new_sample / (long)this.batchCounter)));
                if (BRoundRobinCollector.log.isLoggable(Level.FINE)) {
                    BRoundRobinCollector.log.fine("Reached end of batch " + this.batchCounter + " in " + this.getLastBatchDuration() + " sleeping for " + this.getSleepFor());
                }
                try {
                    Thread.sleep(this.getSleepFor().getMillis());
                    if (BRoundRobinCollector.log.isLoggable(Level.FINE)) {
                        BRoundRobinCollector.log.fine("Starting next batch");
                    }
                    this.lastBatchStart = BAbsTime.now();
                }
                catch (InterruptedException ie) {
                    this.lastBatchStart = BAbsTime.DEFAULT;
                    this.batchCounter = 0;
                    throw ie;
                }
                finally {
                    this.batchHistoryCounter = 0;
                }
            }
        }
    }

    boolean isBatchingEnabled() {
        return this.getEnableBatching() && this.getAfterHistories() > 0 && this.getSleepFor().getMillis() > 0L;
    }

    void resetBatchCounterAndTimes(BAbsTime initLastBatchStart) {
        this.lastBatchStart = initLastBatchStart;
        this.batchCounter = 0;
        this.setAverageBatchDuration((BRelTime)averageBatchDuration.getDefaultValue());
        this.setLastBatchDuration((BRelTime)lastBatchDuration.getDefaultValue());
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BRoundRobinCollector.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"provisioning.png");
    }

    public boolean isNavChild() {
        return false;
    }
}

