/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.addons.bacnet.trend;

import com.tridiumemea.addons.bacnet.trend.BRoundRobinCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.util.BBacnetWorker;
import javax.baja.bacnet.util.worker.BBacnetWorkerPool;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.util.BAbstractDescriptor;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableException;
import javax.baja.util.Invocation;

final class CollectorUtil {
    private CollectorUtil() {
    }

    static void sanityCheckNetwork(BBacnetNetwork bacnetNetwork) throws LocalizableException {
        if (bacnetNetwork == null) {
            throw new BajaRuntimeException("BACnet network not found");
        }
        if (bacnetNetwork.isFatalFault() || bacnetNetwork.isDisabled() || bacnetNetwork.isDown()) {
            throw new BajaRuntimeException("Aborting: Network is in " + bacnetNetwork.getStatus());
        }
        if (!bacnetNetwork.getWorker().hasWorkerPool()) {
            throw new LocalizableException(CollectorUtil.getModuleName(), "noWorker");
        }
        BBacnetWorkerPool[] poolOfOne = (BBacnetWorkerPool[])bacnetNetwork.getWorker().getChildren(BBacnetWorkerPool.class);
        BBacnetWorkerPool pool = poolOfOne[0];
        if (pool.getMaxThreads() < 2) {
            throw new LocalizableException(CollectorUtil.getModuleName(), "noWorkerThreads");
        }
        if (BRoundRobinCollector.log.isLoggable(Level.FINE)) {
            BRoundRobinCollector.log.fine("Using Worker Pool with max " + pool.getMaxThreads() + " threads.");
        }
    }

    private static String getModuleName() {
        return BRoundRobinCollector.TYPE.getModule().getModuleName();
    }

    static void importHistory(BBacnetWorker bacnetWorker, BHistoryImport hist) {
        if (hist.isUnoperational()) {
            throw new BajaRuntimeException("Not collecting from " + hist.getStatus() + " descriptor: " + hist.getSlotPathOrd().toString());
        }
        if (BRoundRobinCollector.log.isLoggable(Level.FINE)) {
            BRoundRobinCollector.log.fine("Requesting History: " + hist.getSlotPathOrd().toString());
        }
        Invocation i = new Invocation((BComponent)hist, BAbstractDescriptor.execute, null, null);
        bacnetWorker.post((Runnable)i);
    }

    static ArrayList<ArrayList<BDescriptor>> buildDescriptorArray(BDeviceNetwork net) {
        BDevice[] devices = net.getDevices();
        int deviceCount = devices.length;
        BRoundRobinCollector.log.info("TrendLog collection initiated for " + deviceCount + (deviceCount == 1 ? " device" : " devices"));
        ArrayList<ArrayList<BDescriptor>> devQ = new ArrayList<ArrayList<BDescriptor>>(deviceCount);
        for (int i = 0; i < devices.length; ++i) {
            BHistoryDeviceExt[] historyDeviceExts = (BHistoryDeviceExt[])devices[i].getChildren(BHistoryDeviceExt.class);
            BHistoryDeviceExt devExt = null;
            if (historyDeviceExts.length != 1) {
                BRoundRobinCollector.log.warning(devices[i].getName() + " has " + historyDeviceExts.length + " HistoryDeviceExt's");
            } else if (historyDeviceExts.length > 0) {
                devExt = historyDeviceExts[0];
            }
            if (devExt == null) continue;
            BDescriptor[] idleDesc = devExt.getDescriptors(BDescriptorState.idle);
            ArrayList newList = new ArrayList();
            Collections.addAll(newList, idleDesc);
            devQ.add(newList);
            if (!BRoundRobinCollector.log.isLoggable(Level.FINE)) continue;
            BRoundRobinCollector.log.fine(" [" + i + "] " + devices[i].getName() + " has " + idleDesc.length + " idle descriptors");
        }
        return devQ;
    }
}

