/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.file.types.bog.BBogSpace;
import com.tridium.fox.sys.BFoxService;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.ui.StationModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType
public class BStationMgrTable
extends BMgrTable {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationMgrTable.class);
    Set<BComponent> subscription = new HashSet<BComponent>();
    boolean serverConnectionsSubscribed = false;
    StationModel model;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationMgrTable() {
    }

    public BStationMgrTable(StationModel model) {
        super((MgrModel)model);
        this.model = model;
    }

    public void reload() {
        super.reload();
        BFoxService rows = this.getComponentModel().getRows();
        if (rows == null || ((BComponent[])rows).length < 1) {
            return;
        }
        ArrayList<BComponent> list = new ArrayList<BComponent>();
        boolean stationOffline = this.model.getTarget().getSpace().getType().is(BBogSpace.TYPE);
        if (!this.serverConnectionsSubscribed && !stationOffline) {
            BFoxService foxService = (BFoxService)BOrd.make((String)"service:fox:FoxService").get((BObject)this.model.getTarget());
            list.add((BComponent)foxService.getServerConnections());
            this.subscription.add((BComponent)foxService.getServerConnections());
            this.serverConnectionsSubscribed = true;
        }
        for (BFoxService row : rows) {
            this.addChildren((BComponent)row, list);
        }
        if (list.size() == 0) {
            return;
        }
        BComponent[] toSub = list.toArray(new BComponent[0]);
        this.getManager().registerForComponentEvents(toSub, 0);
    }

    void addChildren(BComponent parent, List<BComponent> list) {
        if (!this.model.hasChildNeedingSubscribe(parent)) {
            return;
        }
        parent.lease();
        SlotCursor c = parent.getProperties();
        while (c.nextComponent()) {
            this.addChild(parent, (BComponent)c.get(), list);
        }
        if (parent instanceof BNiagaraStation) {
            this.addChild(parent, (BComponent)((BNiagaraStation)parent).getServerConnection(), list);
        }
    }

    void addChild(BComponent parent, BComponent child, List<BComponent> list) {
        if (this.model.subscribeToChild(parent, child)) {
            if (!this.subscription.contains(child)) {
                list.add(child);
                this.subscription.add(child);
            }
            this.model.getDescendantsToSubscribe(parent, child).forEach(descendant -> {
                if (!this.subscription.contains(descendant)) {
                    list.add((BComponent)descendant);
                    this.subscription.add((BComponent)descendant);
                }
            });
        }
        this.addChildren(child, list);
    }
}

