/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.discover.NiagaraLearnUtil;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.ui.FoxSessionSupport;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import java.util.ArrayList;
import java.util.Optional;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDeviceExt;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrLearn;

public abstract class NiagaraLearn
extends MgrLearn {
    public static final int UNESCAPE = 1;
    BComponent target;
    FoxSessionSupport sessionSupport;
    protected BOrd bqlQuery;
    BITable<?> lastLearn;
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];

    protected NiagaraLearn(BAbstractManager manager) {
        super(manager);
    }

    public BComponent getTarget() {
        return this.target;
    }

    protected BWidget makeJobBar() {
        return null;
    }

    public void load(BComponent target) {
        super.load(target);
        this.target = target;
        BISession session = target.getSession();
        this.sessionSupport = session instanceof BFoxSession ? new FoxSessionSupport(this.getManager(), (BFoxSession)session) : new FoxSessionSupport(this.getManager(), null);
    }

    public BFoxSession connect(BNiagaraStation s) {
        s.lease(1);
        return this.sessionSupport.connect(s.getStationName(), s.getAddress(), s.getClientConnection().getPort(), s.getClientConnection().getUseFoxs());
    }

    public BFoxSession connect(BLearnStation s, boolean useHostName) {
        String host = useHostName ? s.getHostName() : s.getHostAddress();
        boolean useFoxs = false;
        if (s.getScheme().equalsIgnoreCase("foxs")) {
            useFoxs = true;
        }
        return this.sessionSupport.connect(s.getStationName(), BOrd.make((String)("ip:" + host)), s.getFoxPort(), useFoxs);
    }

    public BFoxSession connect(String stationName, BOrd host, int foxPort, boolean useFoxs) {
        return this.sessionSupport.connect(stationName, host, foxPort, useFoxs);
    }

    public void bqlDiscover(BNiagaraStation station, BTypeSpec filterType, Context cx) throws Exception {
        Optional<BOrd> discoveryQuery;
        if (this.bqlQuery == null) {
            this.bqlQuery = this.getDefaultDiscoveryQuery(filterType);
        }
        if (!(discoveryQuery = this.getDiscoveryQuery(station, filterType, cx)).isPresent()) {
            return;
        }
        this.bqlQuery = discoveryQuery.get().relativizeToSession();
        BNiagaraPointDeviceExt points = station.getPoints();
        BITable table = (BITable)NiagaraLearnUtil.bqlDiscoverViaProxyExt((BDeviceExt)points, (BOrd)this.bqlQuery);
        this.updateTable(table);
    }

    protected BOrd getDefaultDiscoveryQuery(BTypeSpec filterType) {
        return BOrd.make((String)("station:|slot:/|bql:select " + this.getBqlProjection() + " from " + filterType));
    }

    protected Optional<BOrd> getDiscoveryQuery(BNiagaraStation station, BTypeSpec filterType, Context cx) throws Exception {
        BNiagaraPointDeviceExt points = station.getPoints();
        BINavNode root = NiagaraLearnUtil.discoverPointRootsViaProxyExt((BDeviceExt)points, (Context)cx);
        BBqlQueryBuilder builder = new BBqlQueryBuilder((BObject)root, this.bqlQuery, false);
        BOrd bqlFromUser = builder.open((BWidget)this.getManager());
        return Optional.ofNullable(bqlFromUser);
    }

    public String getBqlProjection() {
        StringBuilder s = new StringBuilder();
        MgrColumn[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            Column col = (Column)cols[i];
            s.append(col.projection);
        }
        s.append(",icon.encodeToString");
        return s.toString();
    }

    public BImage getIcon(Object node) {
        return ((Node)node).getIcon();
    }

    public boolean hasChildren(Object node) {
        return ((Node)node).hasChildren();
    }

    public Object[] getChildren(Object node) {
        return ((Node)node).getChildren();
    }

    public void updateTable(BITable<?> table) {
        this.lastLearn = table;
        ArrayList<Node> roots = new ArrayList<Node>(32);
        try (TableCursor c = table.cursor();){
            while (c.next()) {
                Node n = this.makeNode();
                n.update(c.row());
                roots.add(n);
            }
        }
        this.updateRoots(roots.toArray(EMPTY_NODE_ARRAY));
    }

    protected Node makeNode() {
        return new Node();
    }

    public static class Node {
        public BImage icon;
        public BObject[] cells;

        public BImage getIcon() {
            return this.icon;
        }

        public Object get(MgrColumn col) {
            return col.get((Object)this);
        }

        public boolean hasChildren() {
            return false;
        }

        public Node[] getChildren() {
            return EMPTY_NODE_ARRAY;
        }

        public void update(Row<?> row) {
            ColumnList cols = row.getTable().getColumns();
            this.cells = new BObject[cols.size() - 1];
            for (int c = 0; c < this.cells.length; ++c) {
                this.cells[c] = (BObject)row.cell(cols.get(c)).as(BObject.class);
            }
            this.icon = BImage.make((String)row.cell(cols.get(cols.size() - 1)).toString());
        }
    }

    public static class Column
    extends MgrColumn {
        public final String projection;
        int colIndex = -1;
        int special;

        public Column(String displayName, String projection) {
            this(displayName, projection, 0, 0);
        }

        public Column(String displayName, String projection, int flags) {
            this(displayName, projection, flags, 0);
        }

        public Column(String displayName, String projection, int flags, int special) {
            super(displayName, flags);
            this.projection = projection;
            this.special = special;
        }

        public int getColumnIndex() {
            if (this.colIndex == -1) {
                MgrColumn[] cols = this.getManager().getLearn().getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i] != this) continue;
                    this.colIndex = i;
                    break;
                }
                if (this.colIndex == -1) {
                    throw new IllegalStateException("Column not in manager.getDiscoveryColumns()");
                }
            }
            return this.colIndex;
        }

        public Object get(Object discovery) {
            BObject x = ((Node)discovery).cells[this.getColumnIndex()];
            if ((this.special & 1) != 0) {
                return SlotPath.unescape((String)x.toString());
            }
            return x;
        }
    }
}

