/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.px;

import com.tridium.nd.BNSpaceScheme;
import com.tridium.nd.util.BSimpleMap;
import com.tridium.sys.station.BStationScheme;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BDynamicPxView;
import javax.baja.converters.BEnumToSimpleMap;
import javax.baja.converters.BNumericToSimpleMap;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxEncoder;
import javax.baja.ui.px.PxProperty;

@NiagaraType
@NiagaraProperty(name="pxFile", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"file:PxFile\")")})
public abstract class BAbstractSubstitutePxView
extends BDynamicPxView {
    @Generated
    public static final Property pxFile = BAbstractSubstitutePxView.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:PxFile")));
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractSubstitutePxView.class);
    private static final int unknown = 0;
    private static final int virt = 1;
    private static final int file = 2;
    private static final int module = 3;
    private static final int history = 4;
    static final Logger LOG = Logger.getLogger("niagaraVirtual.px");
    static final String NEQL_SCHEME = "neql";
    static final String SYS_SCHEME = "sys";

    @Generated
    public BOrd getPxFile() {
        return (BOrd)this.get(pxFile);
    }

    @Generated
    public void setPxFile(BOrd v) {
        this.set(pxFile, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="r")
    public String generateXml(Object arg, Context context) {
        try {
            if (this.getPxFile().isNull()) {
                return "";
            }
            Object base = arg instanceof BComponent && ((BComponent)arg).isMounted() ? (BComponent)arg : this.getParent();
            BIFile pxFile = this.loadFile(this.getPxFile(), (BObject)base, false, context).orElseThrow(() -> new LocalizableRuntimeException("niagaraDriver", "virtual.px.loadFail", (Object[])new BObject[]{this.getPxFile()}));
            PxDecoder decoder = new PxDecoder(pxFile);
            BWidget root = decoder.decodeDocument();
            decoder.close();
            this.process(this.getSubstituteOrds(), (BComplex)root, (BObject)base, context);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                new PxEncoder((OutputStream)out).encodeDocument(root);
            }
            catch (IOException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            return new String(out.toByteArray());
        }
        catch (LocalizableRuntimeException le) {
            throw le;
        }
        catch (PermissionException pe) {
            throw new LocalizableRuntimeException("bajaui", "errorPanel.noPermission", (Throwable)pe);
        }
        catch (Throwable e) {
            this.getLogger().log(Level.SEVERE, "Error constructing Substitute Px View", e);
            return "";
        }
    }

    public BSimpleMap getSubstituteOrds() {
        return BSimpleMap.DEFAULT;
    }

    protected Optional<BIFile> loadFile(BOrd remoteFileOrd, BObject base, boolean isMedia, Context cx) {
        return Optional.ofNullable((BIFile)remoteFileOrd.get(base));
    }

    protected Logger getLogger() {
        return LOG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(BSimpleMap ordRefMap, BComplex comp, BObject base, Context cx) throws Exception {
        Property[] props = comp.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BOrd ord;
            BOrdList newOrdList;
            BNumericToSimpleMap map;
            BOrdList newOrdList2;
            BValue val = comp.get(props[i]);
            if (val instanceof BPxInclude) {
                PxProperty[] pxProps;
                BWidget root;
                BIFile pxFile;
                BPxInclude pxInclude;
                block27: {
                    pxInclude = (BPxInclude)val;
                    BOrd pxFileOrd = pxInclude.getOrd();
                    if (pxFileOrd.isNull()) continue;
                    BOrd ord2 = (BOrd)ordRefMap.get((BSimple)pxFileOrd);
                    boolean loadFileLocally = false;
                    if (ord2 != null) {
                        pxInclude.setOrd(ord2);
                        loadFileLocally = true;
                    }
                    if (pxInclude.getOrd().isNull()) continue;
                    pxFile = null;
                    try {
                        pxFile = loadFileLocally ? (BIFile)pxInclude.getOrd().get(base) : this.loadFile(pxInclude.getOrd(), base, false, cx).orElseThrow(() -> new UnresolvedException(pxInclude.getOrd().toString(cx)));
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isLoggable(Level.FINE)) break block27;
                        StringBuilder sb = new StringBuilder("Failed to load a PxInclude. ");
                        if (loadFileLocally) {
                            sb.append("Cannot resolve the local (imported) PxInclude file ");
                            sb.append(pxInclude.getOrd());
                            sb.append(". This local PxInclude file is expected to be imported from a corresponding remote station file called ");
                            sb.append(pxFileOrd);
                        } else {
                            sb.append("Cannot load (import) a remote station PxInclude file ");
                            sb.append(pxInclude.getOrd());
                            sb.append(". Check to see if the PxInclude file exists on the remote station ");
                            sb.append("and that the configured NiagaraStation user can access the remote ");
                            sb.append("PxInclude file. If the remote PxInclude file no longer exists, modify ");
                            sb.append("the remote Px view containing the PxInclude to remove/update its reference.");
                        }
                        this.getLogger().log(Level.FINE, sb.toString(), e);
                    }
                }
                if (pxFile == null) continue;
                try (PxDecoder decoder = null;){
                    decoder = base instanceof BINavNode ? new PxDecoder(((BINavNode)base).getNavOrd(), (InputStream)new BufferedInputStream(pxFile.getInputStream())) : new PxDecoder(pxFile);
                    root = decoder.decodeDocument();
                    pxProps = decoder.getPxProperties();
                }
                if (pxProps != null) {
                    pxInclude.fw(307, (Object)root, (Object)pxProps, null, (Object)pxFile);
                    Property rootPropInParent = root.getPropertyInParent();
                    if (rootPropInParent != null) {
                        pxInclude.remove(rootPropInParent);
                    }
                }
                if (!pxInclude.getVariables().isNull()) {
                    BAbstractSubstitutePxView.loadPxVariables((BComponent)root, pxInclude.getVariables());
                }
                Property[] includeProps = pxInclude.getPropertiesArray();
                for (int j = 0; j < includeProps.length; ++j) {
                    BValue incVal;
                    String incName = includeProps[j].getName();
                    if (includeProps[j].isFrozen() && root.getProperty(incName) != null) {
                        incVal = pxInclude.get(includeProps[j]).newCopy(true);
                        root.set(incName, incVal);
                        continue;
                    }
                    if (!includeProps[j].isDynamic() || !(pxInclude.get(includeProps[j]) instanceof BBinding)) continue;
                    incVal = pxInclude.get(includeProps[j]).newCopy(true);
                    root.add(incName + "?", incVal);
                }
                comp.set(props[i], (BValue)root);
                this.process(ordRefMap, (BComplex)root, base, cx);
                continue;
            }
            if (val instanceof BComplex) {
                this.process(ordRefMap, val.asComplex(), base, cx);
                continue;
            }
            if (val instanceof BImage) {
                BOrdList ordList = ((BImage)val).getOrdList();
                BOrdList newOrdList3 = this.processOrdList(ordList, ordRefMap);
                if (newOrdList3.isNull()) continue;
                comp.set(props[i], (BValue)BImage.make((BOrdList)newOrdList3));
                continue;
            }
            if (val instanceof BOrdList) {
                BOrdList newOrdList4 = this.processOrdList((BOrdList)val, ordRefMap);
                if (newOrdList4.isNull()) continue;
                comp.set(props[i], (BValue)newOrdList4);
                continue;
            }
            if (val instanceof BBrush) {
                BBrush.Image brushImage;
                BImage img;
                BOrdList list = BOrdList.DEFAULT;
                int brushImageTile = -1;
                int brushImageValign = -1;
                int brushImageHalign = -1;
                BBrush.Paint paint = ((BBrush)val).getPaint();
                if (paint != null && paint instanceof BBrush.Image && (img = (brushImage = (BBrush.Image)paint).getImage()) != null) {
                    brushImageTile = brushImage.getTile();
                    brushImageValign = brushImage.getValign();
                    brushImageHalign = brushImage.getHalign();
                    list = img.getOrdList();
                }
                if (list.isNull() || (newOrdList2 = this.processOrdList(list, ordRefMap)).isNull()) continue;
                comp.set(props[i], (BValue)BBrush.makeImage((BImage)BImage.make((BOrdList)newOrdList2), (int)brushImageTile, (int)brushImageHalign, (int)brushImageValign));
                continue;
            }
            if (val instanceof BNumericToSimpleMap) {
                BOrdList ordList;
                BOrdList newOrdList5;
                map = (BNumericToSimpleMap)val;
                if (map.isNull() && map.getDefault() == null || !map.getValueType().is(BImage.TYPE)) continue;
                BSimple[] vals = map.getValues();
                for (int j = 0; j < vals.length; ++j) {
                    BOrdList ordList2 = ((BImage)vals[j]).getOrdList();
                    newOrdList = this.processOrdList(ordList2, ordRefMap);
                    if (newOrdList.isNull()) continue;
                    vals[j] = BImage.make((BOrdList)newOrdList);
                }
                double[] maxs = map.getMaximums();
                double[] mins = map.getMinimums();
                BSimple def = map.getDefault();
                if (def != null && !(newOrdList5 = this.processOrdList(ordList = ((BImage)def).getOrdList(), ordRefMap)).isNull()) {
                    def = BImage.make((BOrdList)newOrdList5);
                }
                comp.set(props[i], (BValue)BNumericToSimpleMap.make((double[])mins, (double[])maxs, (BSimple[])vals, (BSimple)def));
                continue;
            }
            if (val instanceof BEnumToSimpleMap) {
                BOrdList ordList;
                map = (BEnumToSimpleMap)val;
                if (map.isNull() && map.getDefault() == null || !map.getValueType().is(BImage.TYPE)) continue;
                BSimple[] vals = map.getValues();
                for (int j = 0; j < vals.length; ++j) {
                    BOrdList ordList3 = ((BImage)vals[j]).getOrdList();
                    newOrdList = this.processOrdList(ordList3, ordRefMap);
                    if (newOrdList.isNull()) continue;
                    vals[j] = BImage.make((BOrdList)newOrdList);
                }
                int[][] ordinals = map.getOrdinals();
                BSimple def = map.getDefault();
                if (def != null && !(newOrdList2 = this.processOrdList(ordList = ((BImage)def).getOrdList(), ordRefMap)).isNull()) {
                    def = BImage.make((BOrdList)newOrdList2);
                }
                comp.set(props[i], (BValue)BEnumToSimpleMap.make((int[][])ordinals, (BSimple[])vals, (BSimple)def));
                continue;
            }
            if (!(val instanceof BOrd) || val.isNull() || (ord = (BOrd)ordRefMap.get((BSimple)((BOrd)val))) == null) continue;
            comp.set(props[i], (BValue)ord);
        }
    }

    private BOrdList processOrdList(BOrdList ordList, BSimpleMap ordRefMap) {
        if (ordList.isNull()) {
            return BOrdList.NULL;
        }
        BOrd[] ords = ordList.toArray();
        for (int i = 0; i < ords.length; ++i) {
            BOrd o;
            if (ords[i].isNull() || (o = (BOrd)ordRefMap.get((BSimple)ords[i])) == null) continue;
            ords[i] = o;
        }
        return BOrdList.make((BOrd[])ords);
    }

    public static void loadPxVariables(BComponent c, BFacets vars) throws Exception {
        if (c == null) {
            return;
        }
        Property[] props = c.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BValue val = c.get(props[i]);
            if (!(val instanceof BOrd)) continue;
            BOrd ord = (BOrd)val;
            c.set(props[i], (BValue)ord.substitute(vars));
        }
        BComponent[] kids = c.getChildComponents();
        for (int i = 0; i < kids.length; ++i) {
            BAbstractSubstitutePxView.loadPxVariables(kids[i], vars);
        }
    }

    public static void processPx(BComplex widget, BObject base, String stationName, IPxOrdVisitor visitor, BSimpleMap overrideMap, Context cx) throws Exception {
        Property[] props = widget.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            BValue val = widget.get(props[i]);
            if (val instanceof BPxInclude) {
                BPxInclude pxInclude = (BPxInclude)val;
                BOrd pxFileOrd = pxInclude.getOrd();
                if (!pxFileOrd.isNull()) {
                    BWidget root;
                    block21: {
                        BAbstractSubstitutePxView.processOrdInPx((BComplex)pxInclude, props[i], pxFileOrd, visitor, overrideMap);
                        root = null;
                        try {
                            root = visitor.decodePxFileFromOrd(pxFileOrd, base, stationName, cx);
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(Level.FINE)) break block21;
                            StringBuilder sb = new StringBuilder("Failed to process requested PxInclude file: ");
                            sb.append(pxFileOrd);
                            sb.append(". Check to see if the PxInclude file exists on the remote station '");
                            sb.append(stationName);
                            sb.append("' and that the configured NiagaraStation user can access the remote ");
                            sb.append("PxInclude file. If the remote PxInclude file no longer exists, modify ");
                            sb.append("the remote Px view containing the PxInclude to remove/update its reference.");
                            LOG.log(Level.FINE, sb.toString(), e);
                        }
                    }
                    if (root != null) {
                        if (!pxInclude.getVariables().isNull()) {
                            BAbstractSubstitutePxView.loadPxVariables((BComponent)root, pxInclude.getVariables());
                        }
                        BAbstractSubstitutePxView.processPx((BComplex)root, base, stationName, visitor, overrideMap, cx);
                    }
                }
                BBinding[] bindings = pxInclude.getBindings();
                for (int j = 0; j < bindings.length; ++j) {
                    BAbstractSubstitutePxView.processPx((BComplex)bindings[j], base, stationName, visitor, overrideMap, cx);
                }
                continue;
            }
            if (val instanceof BComplex) {
                BAbstractSubstitutePxView.processPx(val.asComplex(), base, stationName, visitor, overrideMap, cx);
                continue;
            }
            if (val instanceof BImage || val instanceof BBrush) {
                BImage img = null;
                if (val instanceof BBrush) {
                    BBrush.Paint paint = ((BBrush)val).getPaint();
                    if (paint != null && paint instanceof BBrush.Image) {
                        img = ((BBrush.Image)paint).getImage();
                    }
                } else {
                    img = (BImage)val;
                }
                if (img == null) continue;
                BAbstractSubstitutePxView.processImageInPx(widget, props[i], img, visitor, overrideMap);
                continue;
            }
            if (val instanceof BNumericToSimpleMap || val instanceof BEnumToSimpleMap) {
                BSimple def = null;
                Array simpleArray = new Array(BSimple.class);
                if (val instanceof BNumericToSimpleMap) {
                    BNumericToSimpleMap map = (BNumericToSimpleMap)val;
                    def = map.getDefault();
                    simpleArray.addAll((Object[])map.getValues());
                } else if (val instanceof BEnumToSimpleMap) {
                    BEnumToSimpleMap map = (BEnumToSimpleMap)val;
                    def = map.getDefault();
                    simpleArray.addAll((Object[])map.getValues());
                }
                simpleArray = simpleArray.filter(new IFilter(){

                    public boolean accept(Object obj) {
                        return obj instanceof BImage;
                    }
                });
                if (def != null && def instanceof BImage) {
                    BAbstractSubstitutePxView.processImageInPx(widget, props[i], (BImage)def, visitor, overrideMap);
                }
                for (int j = 0; j < simpleArray.size(); ++j) {
                    BAbstractSubstitutePxView.processImageInPx(widget, props[i], (BImage)simpleArray.get(j), visitor, overrideMap);
                }
                continue;
            }
            if (val instanceof BOrdList) {
                BOrdList list = (BOrdList)val;
                if (list == BOrdList.NULL) continue;
                BOrd[] ords = list.toArray();
                for (int j = 0; j < ords.length; ++j) {
                    BAbstractSubstitutePxView.processOrdInPx(widget, props[i], ords[j], visitor, overrideMap);
                }
                continue;
            }
            if (!(val instanceof BOrd)) continue;
            BAbstractSubstitutePxView.processOrdInPx(widget, props[i], (BOrd)val, visitor, overrideMap);
        }
    }

    private static void processImageInPx(BComplex comp, Property prop, BImage image, IPxOrdVisitor visitor, BSimpleMap overrideMap) throws Exception {
        BOrdList list = image.getOrdList();
        if (list == BOrdList.NULL) {
            return;
        }
        BOrd[] ords = list.toArray();
        for (int i = 0; i < ords.length; ++i) {
            BAbstractSubstitutePxView.processOrdInPx(comp, prop, ords[i], visitor, overrideMap);
        }
    }

    private static void processOrdInPx(BComplex comp, Property prop, BOrd ord, IPxOrdVisitor visitor, BSimpleMap overrideMap) throws Exception {
        OrdQuery[] queries;
        if (ord.isNull()) {
            return;
        }
        if (ord.hasVariables()) {
            return;
        }
        if (!visitor.handlePreprocessOrd(comp, prop, ord)) {
            return;
        }
        BOrd overrideOrd = (BOrd)overrideMap.get((BSimple)ord);
        if (overrideOrd != null) {
            visitor.handleOverrideOrd(comp, prop, ord, overrideOrd);
            return;
        }
        try {
            queries = ord.normalize().parse();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Could not parse invalid ORD found in Px view: " + ord, e);
            }
            return;
        }
        String firstRelevantScheme = null;
        for (OrdQuery query : queries) {
            String scheme = query.getScheme();
            if (BStationScheme.INSTANCE.getId().equals(scheme)) continue;
            firstRelevantScheme = scheme;
            break;
        }
        if (BNSpaceScheme.INSTANCE.getId().equals(firstRelevantScheme)) {
            return;
        }
        if (prop.getName().equals("hyperlink")) {
            String firstScheme;
            String string = firstScheme = queries.length > 0 ? queries[0].getScheme() : null;
            if (!(firstScheme != null && ("station".equals(firstScheme) || "slot".equals(firstScheme) || "h".equals(firstScheme) || "virtual".equals(firstScheme) || "file".equals(firstScheme) || "module".equals(firstScheme) || "history".equals(firstScheme) || NEQL_SCHEME.equals(firstScheme) || SYS_SCHEME.equals(firstScheme)))) {
                visitor.handleHyperlinkOrd(comp, prop, ord);
                return;
            }
        }
        int state = 0;
        if (NEQL_SCHEME.equals(firstRelevantScheme) || SYS_SCHEME.equals(firstRelevantScheme)) {
            state = 1;
        }
        int queryIndex = -1;
        for (int i = 0; i < queries.length; ++i) {
            if (queries[i].isSession() || queries[i].isHost() || queries[i].getScheme().equals("station")) continue;
            if (queries[i].getScheme().equals("slot") || queries[i].getScheme().equals("h") || queries[i].getScheme().equals("virtual")) {
                state = 1;
                continue;
            }
            if (queries[i].getScheme().equals("file")) {
                state = 2;
                queryIndex = i;
                break;
            }
            if (queries[i].getScheme().equals("module")) {
                state = 3;
                queryIndex = i;
                break;
            }
            if (!queries[i].getScheme().equals("history")) continue;
            state = 4;
            queryIndex = i;
            break;
        }
        if (state == 1) {
            visitor.handleVirtualOrd(comp, prop, ord);
        } else if (state == 2) {
            visitor.handleFileOrd(comp, prop, ord, queries, queryIndex);
        } else if (state == 3) {
            visitor.handleModuleOrd(comp, prop, ord, queries, queryIndex);
        } else if (state == 4) {
            visitor.handleHistoryOrd(comp, prop, ord, queries, queryIndex);
        } else {
            visitor.handleUnknownOrd(comp, prop, ord);
        }
    }

    public static interface IPxOrdVisitor {
        public boolean handlePreprocessOrd(BComplex var1, Property var2, BOrd var3) throws Exception;

        public void handleVirtualOrd(BComplex var1, Property var2, BOrd var3) throws Exception;

        public void handleHyperlinkOrd(BComplex var1, Property var2, BOrd var3) throws Exception;

        public void handleFileOrd(BComplex var1, Property var2, BOrd var3, OrdQuery[] var4, int var5) throws Exception;

        public void handleModuleOrd(BComplex var1, Property var2, BOrd var3, OrdQuery[] var4, int var5) throws Exception;

        public void handleHistoryOrd(BComplex var1, Property var2, BOrd var3, OrdQuery[] var4, int var5) throws Exception;

        public void handleUnknownOrd(BComplex var1, Property var2, BOrd var3) throws Exception;

        public void handleOverrideOrd(BComplex var1, Property var2, BOrd var3, BOrd var4) throws Exception;

        default public BWidget decodePxFileFromOrd(BOrd pxFileOrd, BObject base, String stationName, Context cx) throws Exception {
            BIFile sourcePxFile = (BIFile)pxFileOrd.get(base);
            PxDecoder decoder = new PxDecoder(sourcePxFile);
            BWidget root = decoder.decodeDocument();
            decoder.close();
            return root;
        }
    }
}

