/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.px;

import com.tridium.agent.BILoadablePxView;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.file.BNiagaraFileImport;
import com.tridium.nd.ui.px.BAbstractSubstitutePxView;
import com.tridium.nd.ui.px.BReloadVirtualPxAction;
import com.tridium.nd.util.BSimpleMap;
import com.tridium.nd.virtual.BNiagaraVirtualNetworkExt;
import com.tridium.nv.BINiagaraVirtualPropertySubstitute;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualGateway;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.comps.BNiagaraVirtualGatewayComponent;
import com.tridium.nv.comps.BNiagaraVirtualStation;
import com.tridium.query.BSingleScheme;
import com.tridium.sys.station.BStationScheme;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryId;
import javax.baja.history.HistoryQuery;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.VirtualPath;

@NiagaraType(agent={@AgentOn(types={"baja:PxView"})})
@NiagaraProperties(value={@NiagaraProperty(name="icon", type="BIcon", defaultValue="BIcon.std(\"views/view.png\")", flags=1, override=true), @NiagaraProperty(name="requiredPermissions", type="BPermissions", defaultValue="BPermissions.operatorRead", flags=1, override=true), @NiagaraProperty(name="media", type="BTypeSpec", defaultValue="BTypeSpec.make(\"workbench:WbPxMedia\")", flags=1, facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"bajaui:PxMedia\")")}, override=true), @NiagaraProperty(name="pxFile", type="BOrd", defaultValue="BOrd.NULL", flags=1, facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"file:PxFile\")")}, override=true)})
public final class BNiagaraVirtualPxView
extends BAbstractSubstitutePxView
implements BINiagaraVirtualPropertySubstitute,
BILoadablePxView {
    @Generated
    public static final Property icon = BNiagaraVirtualPxView.newProperty((int)1, (BValue)BIcon.std((String)"views/view.png"), null);
    @Generated
    public static final Property requiredPermissions = BNiagaraVirtualPxView.newProperty((int)1, (BValue)BPermissions.operatorRead, null);
    @Generated
    public static final Property media = BNiagaraVirtualPxView.newProperty((int)1, (BValue)BTypeSpec.make((String)"workbench:WbPxMedia"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"bajaui:PxMedia")));
    @Generated
    public static final Property pxFile = BNiagaraVirtualPxView.newProperty((int)1, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:PxFile")));
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualPxView.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final BOrd EMPTY_SLOT_ORD = BOrd.make((OrdQuery)SlotPath.EMPTY_SLOT_PATH);
    private BAbsTime lastReload = BAbsTime.DEFAULT;
    private AtomicBoolean asyncLoadInProgress = new AtomicBoolean(false);
    private Boolean sysDbAvailable;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFacets nvFilterFacets(BFacets facets) {
        return facets;
    }

    public void nvRead(BNiagaraVirtualComponent vParent, BValue val, Context cx) {
        if (val instanceof BPxView) {
            BPxView view = (BPxView)val;
            this.setPxFile(view.getPxFile());
            this.setRequiredPermissions(view.getRequiredPermissions());
            this.setMedia(view.getMedia());
            this.setIcon(view.getIcon());
        }
    }

    public BValue nvWrite(BNiagaraVirtualComponent vParent) {
        return null;
    }

    public boolean isPxViewModified(BAbsTime lastModifiedTime) {
        boolean needsReload;
        BComponent base = this.getParentComponent();
        if (!(base instanceof BNiagaraVirtualComponent)) {
            return false;
        }
        BNiagaraVirtualComponent component = (BNiagaraVirtualComponent)base;
        if (!component.isRunning()) {
            return true;
        }
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        if (!network.getVirtualPolicies().getImportVirtualPxFilesOnDemand()) {
            return false;
        }
        if (this.asyncLoadInProgress.get()) {
            return true;
        }
        VirtualRoutingInfo virtualRoutingInfo = BNiagaraVirtualPxView.getVirtualRoutingInfo(network, component);
        String stationName = virtualRoutingInfo.targetStationName;
        BOrd localFileOrd = BNiagaraVirtualPxView.convertRemoteToLocalFileOrd(stationName, this.getPxFile(), false, null);
        try {
            BIFile file = (BIFile)localFileOrd.get((BObject)base);
            needsReload = file == null;
        }
        catch (Exception e) {
            needsReload = true;
        }
        return needsReload || lastModifiedTime.isBefore(this.lastReload);
    }

    public void reloadPxView() {
        BComponent base = this.getParentComponent();
        if (!(base instanceof BNiagaraVirtualComponent)) {
            return;
        }
        BNiagaraVirtualComponent component = (BNiagaraVirtualComponent)base;
        if (!component.isRunning()) {
            return;
        }
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        if (!network.getVirtualPolicies().getImportVirtualPxFilesOnDemand()) {
            return;
        }
        if (!this.asyncLoadInProgress.getAndSet(true)) {
            try {
                network.getWorkers().process((Object)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BNiagaraVirtualPxView.this.reload();
                        }
                        finally {
                            BNiagaraVirtualPxView.this.asyncLoadInProgress.set(false);
                        }
                    }
                });
            }
            catch (Throwable t) {
                this.lastReload = BAbsTime.now();
                this.asyncLoadInProgress.set(false);
            }
        }
    }

    public boolean isPxViewLoading() {
        return this.asyncLoadInProgress.get();
    }

    @Override
    protected void process(BSimpleMap ordRefMap, BComplex comp, BObject base, Context cx) throws Exception {
        if (base instanceof BNiagaraVirtualComponent) {
            BNiagaraVirtualComponent component = (BNiagaraVirtualComponent)base;
            VirtualRoutingInfo virtualRoutingInfo = BNiagaraVirtualPxView.getVirtualRoutingInfo((BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE), component);
            String stationName = virtualRoutingInfo.targetStationName;
            PxOrdVisitor visitor = new PxOrdVisitor(this, virtualRoutingInfo.virtualSpaceBaseOrd, stationName, (BComponent)component, virtualRoutingInfo.routeToStation != null);
            BNiagaraVirtualPxView.processPx(comp, (BObject)BFileSystem.INSTANCE, stationName, visitor, BSimpleMap.DEFAULT, cx);
            super.process(BSimpleMap.make((Map)visitor.getOrdMap()), comp, base, cx);
        }
    }

    @Override
    protected Optional<BIFile> loadFile(BOrd remoteFileOrd, BObject base, boolean isMedia, Context cx) {
        if (this.getPxFile().equals((Object)remoteFileOrd)) {
            this.sysDbAvailable = null;
        }
        BNiagaraVirtualPxView.updateReloadAction(this.getParentComponent());
        if (base instanceof BNiagaraVirtualComponent) {
            BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            if (!network.getVirtualPolicies().getImportVirtualPxFilesOnDemand()) {
                throw new UnresolvedException("Virtual PxView support is disabled");
            }
            BNiagaraVirtualComponent component = (BNiagaraVirtualComponent)base;
            VirtualRoutingInfo virtualRoutingInfo = BNiagaraVirtualPxView.getVirtualRoutingInfo(network, component);
            BOrd localFileOrd = BNiagaraVirtualPxView.convertRemoteToLocalFileOrd(virtualRoutingInfo.targetStationName, remoteFileOrd, isMedia, cx);
            try {
                return Optional.of((BIFile)localFileOrd.get(base));
            }
            catch (Exception exception) {
                return this.loadRemoteFile(remoteFileOrd, component, isMedia, false);
            }
        }
        return Optional.empty();
    }

    public void reload() {
        try {
            this.loadRemoteFile(this.getPxFile(), (BNiagaraVirtualComponent)this.getParentComponent(), false, true);
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Could not reload remote px file", e);
        }
        finally {
            this.lastReload = BAbsTime.now();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<BIFile> loadRemoteFile(BOrd remoteFileOrd, BNiagaraVirtualComponent component, boolean isMedia, boolean forceReimport) {
        if (remoteFileOrd == null || remoteFileOrd.isNull()) {
            return Optional.empty();
        }
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        if (!network.getVirtualPolicies().getImportVirtualPxFilesOnDemand()) {
            throw new UnresolvedException("Virtual PxView support is disabled");
        }
        VirtualRoutingInfo virtualRoutingInfo = BNiagaraVirtualPxView.getVirtualRoutingInfo(network, component);
        String stationName = virtualRoutingInfo.targetStationName;
        BNiagaraStation station = virtualRoutingInfo.firstNiagaraStationAlongRoute;
        BOrd localFileOrd = BNiagaraVirtualPxView.convertRemoteToLocalFileOrd(stationName, remoteFileOrd, isMedia, null);
        String interest = component.getNavOrd().toString() + remoteFileOrd.toString();
        try {
            OrdQuery[] queries = remoteFileOrd.parse();
            if (queries.length > 0 && BModuleScheme.INSTANCE.getId().equals(queries[0].getScheme())) {
                Optional<BIFile> optional = Optional.of((BIFile)remoteFileOrd.get((BObject)component));
                return optional;
            }
            station.engageNoRetry(interest);
            BFileChannel channel = station.getClientConnection().getChannels().getFileChannel();
            if (channel != null) {
                FilePath filePath;
                boolean isReachableStation = virtualRoutingInfo.routeToStation != null;
                String[] targetStationRoute = isReachableStation ? virtualRoutingInfo.routeToStation.toArray(EMPTY_STRING_ARRAY) : null;
                BFoxFileSpace fileSpace = new BFoxFileSpace(channel, targetStationRoute);
                BIFileStore fileStore = fileSpace.findStore(filePath = (FilePath)queries[queries.length - 1]);
                if (fileStore == null) {
                    throw new BajaRuntimeException("Could not find remote file: " + filePath);
                }
                PxDecoder decoder = new PxDecoder(remoteFileOrd, (InputStream)new BufferedInputStream(fileStore.getInputStream()));
                BWidget root = decoder.decodeDocument();
                decoder.close();
                PxOrdVisitor visitor = new PxOrdVisitor(this, virtualRoutingInfo.virtualSpaceBaseOrd, stationName, (BComponent)component, isReachableStation);
                BNiagaraVirtualPxView.processPx((BComplex)root, (BObject)fileSpace, stationName, visitor, BSimpleMap.DEFAULT, null);
                visitor.getOrdFileMap().put(localFileOrd, remoteFileOrd);
                BSimpleMap fileImpMap = BSimpleMap.make((Map)visitor.getOrdFileMap());
                String fileImpName = "niagaraVirtualPx_";
                fileImpName = isReachableStation ? fileImpName + stationName + '_' + BNiagaraVirtualPxView.fileOrdToPathString(null, remoteFileOrd) : fileImpName + BNiagaraVirtualPxView.fileOrdToPathString(null, remoteFileOrd);
                if (!SlotPath.isValidName((String)fileImpName)) {
                    fileImpName = SlotPath.escape((String)fileImpName);
                }
                BNiagaraFileImport imp = (BNiagaraFileImport)NiagaraVirtualUtil.findInstance((BComponent)station.getFiles(), (String)fileImpName, (Type)BNiagaraFileImport.TYPE);
                BNiagaraVirtualNetworkExt virtualPolicies = network.getVirtualPolicies();
                imp.set(BNiagaraFileImport.fileOverwritePolicy, (BValue)virtualPolicies.getPxFileImportOverwritePolicy());
                imp.getExecutionTime().set(BTimeTrigger.triggerMode, (BValue)virtualPolicies.getPxFileImportExecutionTime());
                imp.set(BNiagaraFileImport.files, (BValue)fileImpMap);
                if (isReachableStation) {
                    imp.setRouteToStation(String.join((CharSequence)";", virtualRoutingInfo.routeToStation));
                }
                if (station.getFiles().get(fileImpName) == null) {
                    station.getFiles().add(fileImpName, (BValue)imp);
                }
                if (forceReimport) {
                    imp.forceFullExecute();
                } else {
                    imp.doExecute();
                }
                Optional<BIFile> optional = Optional.of((BIFile)localFileOrd.get((BObject)component));
                return optional;
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.FINE, "Could not load remote px file for " + component.getNavOrd(), t);
        }
        finally {
            if (station != null) {
                station.disengage(interest);
            }
        }
        return Optional.empty();
    }

    private static void updateReloadAction(BComponent parent) {
        try {
            BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            boolean add = network.getVirtualPolicies().getImportVirtualPxFilesOnDemand();
            BValue val = parent.get("reloadNiagaraVirtualPxViews");
            if (!add && val instanceof BReloadVirtualPxAction) {
                parent.remove("reloadNiagaraVirtualPxViews");
            } else if (add && val == null) {
                Property prop = parent.add("reloadNiagaraVirtualPxViews", (BValue)new BReloadVirtualPxAction(), 128);
                parent.setDisplayName(prop, BFormat.make((String)BFormat.getLexiconPattern((String)"niagaraDriver", (String)"virtual.reloadPx.action.displayName", null)), null);
            }
        }
        catch (Exception e) {
            BAbstractSubstitutePxView.LOG.log(Level.FINE, "Error during updateReloadAction", e);
        }
    }

    private static String fileOrdToPathString(String stationName, BOrd fileOrd) {
        OrdQuery[] queries = fileOrd.parse();
        FilePath path = (FilePath)queries[queries.length - 1];
        String pathStr = path.getBody();
        if (pathStr.startsWith("^")) {
            pathStr = pathStr.substring(1, pathStr.length());
        }
        if (pathStr.startsWith("!")) {
            pathStr = pathStr.substring(1, pathStr.length());
        }
        while (pathStr.startsWith("/")) {
            pathStr = pathStr.substring(1, pathStr.length());
        }
        if (stationName != null) {
            pathStr = pathStr.length() > 0 ? "/" + stationName + "/" + pathStr : "/" + stationName;
        }
        return pathStr;
    }

    private static BOrd convertRemoteToLocalFileOrd(String stationName, BOrd remoteFileOrd, boolean isMedia, Context cx) {
        OrdQuery[] queries = remoteFileOrd.relativizeToSession().parse();
        if (queries.length > 0 && BModuleScheme.INSTANCE.getId().equals(queries[0].getScheme())) {
            return remoteFileOrd;
        }
        BNiagaraVirtualNetworkExt virtualPolicies = ((BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE)).getVirtualPolicies();
        BOrd directoryOrd = isMedia ? virtualPolicies.getVirtualPxFileMediaDirectory() : virtualPolicies.getVirtualPxFileDirectory();
        queries = directoryOrd.parse();
        FilePath path = (FilePath)queries[queries.length - 1];
        String pathStr = path.getBody() + BNiagaraVirtualPxView.fileOrdToPathString(stationName, remoteFileOrd);
        path = new FilePath(pathStr);
        if (cx != null) {
            BFileSystem.INSTANCE.checkReadPermission(path, cx);
        }
        return BOrd.make((OrdQuery)path);
    }

    private static VirtualRoutingInfo getVirtualRoutingInfo(BNiagaraNetwork network, BNiagaraVirtualComponent virtualComp) {
        BNiagaraVirtualGateway gateway = virtualComp.getNiagaraVirtualGateway();
        String firstNiagaraStationName = gateway.getStationAdapter().getStationName();
        BNiagaraStation firstNiagaraStationAlongRoute = (BNiagaraStation)network.getNiagaraStation(firstNiagaraStationName);
        String targetStationName = null;
        BOrd virtualSpaceBaseOrd = null;
        ArrayList<String> routeToStation = null;
        BComplex comp = virtualComp.getParent();
        while (comp != null) {
            if (comp instanceof BNiagaraVirtualGatewayComponent && (comp = comp.getParent()) instanceof BNiagaraVirtualStation) {
                BNiagaraVirtualStation virtualStation = (BNiagaraVirtualStation)comp;
                String sName = virtualStation.getStationName();
                if (routeToStation == null) {
                    routeToStation = new ArrayList<String>();
                    targetStationName = sName;
                    virtualSpaceBaseOrd = BOrd.make((String)(virtualStation.getNavOrd().relativizeToSession().encodeToString() + "/virtual/virtual"));
                }
                routeToStation.add(0, sName);
            }
            if (comp == null) continue;
            comp = comp.getParent();
        }
        if (routeToStation != null) {
            routeToStation.add(0, firstNiagaraStationName);
        } else {
            targetStationName = firstNiagaraStationName;
            virtualSpaceBaseOrd = gateway.getAbsoluteOrd().relativizeToSession();
        }
        return new VirtualRoutingInfo(targetStationName, firstNiagaraStationAlongRoute, virtualSpaceBaseOrd, (List<String>)routeToStation);
    }

    private static class VirtualRoutingInfo {
        final String targetStationName;
        final BNiagaraStation firstNiagaraStationAlongRoute;
        final BOrd virtualSpaceBaseOrd;
        final List<String> routeToStation;

        public VirtualRoutingInfo(String targetStationName, BNiagaraStation firstNiagaraStationAlongRoute, BOrd virtualSpaceBaseOrd, List<String> routeToStation) {
            this.targetStationName = targetStationName;
            this.firstNiagaraStationAlongRoute = firstNiagaraStationAlongRoute;
            this.virtualSpaceBaseOrd = virtualSpaceBaseOrd;
            this.routeToStation = routeToStation;
        }
    }

    private static final class PxOrdVisitor
    implements BAbstractSubstitutePxView.IPxOrdVisitor {
        private static final BOrd SYS_ORD = BOrd.make((String)"sys:");
        private static final OrdQuery SYS_ORD_QUERY = SYS_ORD.parse()[0];
        private static final OrdQuery[] EMPTY_ORD_QUERIES = new OrdQuery[0];
        private static final String ABS_VIRTUAL_ROOT = "virtual:/";
        private static final String REL_VIRTUAL_ROOT = "virtual:";
        private final Map<BOrd, BOrd> ordMap = new LinkedHashMap<BOrd, BOrd>();
        private final Map<BOrd, BOrd> ordFileMap = new LinkedHashMap<BOrd, BOrd>();
        private final BNiagaraVirtualPxView view;
        private final BOrd virtualSpaceBaseOrd;
        private final String stationName;
        private final BComponent base;
        private final boolean isReachableStation;

        PxOrdVisitor(BNiagaraVirtualPxView view, BOrd virtualSpaceBaseOrd, String stationName, BComponent base, boolean isReachableStation) {
            this.view = view;
            this.virtualSpaceBaseOrd = virtualSpaceBaseOrd;
            this.stationName = stationName;
            this.base = base;
            this.isReachableStation = isReachableStation;
        }

        @Override
        public boolean handlePreprocessOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            return this.ordMap.get(ord) == null;
        }

        @Override
        public void handleVirtualOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            try {
                BOrd newOrd = null;
                OrdQuery[] queries = ord.normalize().parse();
                boolean isAbsolute = false;
                ArrayList<Object> slotQueries = new ArrayList<Object>();
                int queryIdxFollowingPath = -1;
                int firstSlotPathIdx = -1;
                int firstNonSlotPathIdx = -1;
                OrdQuery previousQuery = null;
                for (int i = 0; i < queries.length; ++i) {
                    OrdQuery query = queries[i];
                    if (query instanceof SlotPath && (queryIdxFollowingPath < 0 || slotQueries.isEmpty())) {
                        SlotPath slotPath = (SlotPath)query;
                        if (firstSlotPathIdx < 0) {
                            firstSlotPathIdx = i;
                        }
                        queryIdxFollowingPath = -1;
                        if (slotQueries.size() <= 1) {
                            isAbsolute |= slotPath.isAbsolute() && (slotQueries.isEmpty() || previousQuery == null || !previousQuery.getClass().equals(SlotPath.class) || !slotPath.getClass().equals(VirtualPath.class));
                        }
                        if (!slotQueries.isEmpty() && previousQuery != null) {
                            if (previousQuery.getClass().equals(slotPath.getClass()) && previousQuery.getScheme().equals(slotPath.getScheme())) {
                                previousQuery = ((SlotPath)previousQuery).merge(slotPath);
                                slotQueries.set(slotQueries.size() - 1, previousQuery);
                                continue;
                            }
                            if (previousQuery.getClass().equals(VirtualPath.class) && slotPath.getClass().equals(SlotPath.class)) {
                                previousQuery = ((SlotPath)previousQuery).merge((SlotPath)VirtualPath.convertFromSlotPath((SlotPath)slotPath));
                                slotQueries.set(slotQueries.size() - 1, previousQuery);
                                continue;
                            }
                            if (slotPath.isAbsolute() && !(previousQuery instanceof SlotPath)) {
                                slotQueries.clear();
                            }
                        }
                        slotQueries.add(slotPath);
                    } else {
                        if (!BStationScheme.INSTANCE.getId().equals(query.getScheme())) {
                            if (queryIdxFollowingPath < 0) {
                                queryIdxFollowingPath = i;
                            }
                            if (firstNonSlotPathIdx < 0) {
                                firstNonSlotPathIdx = i;
                            }
                        }
                        if (previousQuery != null && (previousQuery instanceof SlotPath || BSingleScheme.INSTANCE.getId().equals(previousQuery.getScheme()))) {
                            queries[i] = PxOrdVisitor.adjustOrdQuery(ord, query);
                        }
                    }
                    previousQuery = query;
                }
                if (firstNonSlotPathIdx >= 0 && (firstSlotPathIdx < 0 || firstNonSlotPathIdx < firstSlotPathIdx) && ("neql".equals(queries[firstNonSlotPathIdx].getScheme()) || "sys".equals(queries[firstNonSlotPathIdx].getScheme()))) {
                    if (firstNonSlotPathIdx == 0) {
                        newOrd = this.base.getNavOrd().relativizeToSession();
                        queryIdxFollowingPath = 0;
                    } else {
                        boolean isStationAbsolute = false;
                        for (int i = 0; i < firstNonSlotPathIdx; ++i) {
                            if (!BStationScheme.INSTANCE.getId().equals(queries[i].getScheme())) {
                                newOrd = BOrd.NULL;
                                if (!BAbstractSubstitutePxView.LOG.isLoggable(Level.FINE)) break;
                                BAbstractSubstitutePxView.LOG.log(Level.FINE, "Niagara Virtual Px View: Could not translate non slot path ORD to virtual form: " + ord);
                                break;
                            }
                            isStationAbsolute = true;
                        }
                        if (newOrd == null) {
                            newOrd = isStationAbsolute ? BOrd.make((BOrd)this.virtualSpaceBaseOrd, (String)(this.isReachableStation ? REL_VIRTUAL_ROOT : ABS_VIRTUAL_ROOT)).normalize() : this.base.getNavOrd().relativizeToSession();
                            queryIdxFollowingPath = firstNonSlotPathIdx;
                        }
                    }
                }
                if (newOrd == null) {
                    if (slotQueries.isEmpty()) {
                        newOrd = BOrd.NULL;
                        if (BAbstractSubstitutePxView.LOG.isLoggable(Level.FINE)) {
                            BAbstractSubstitutePxView.LOG.log(Level.FINE, "Niagara Virtual Px View: Could not translate non slot path ORD to virtual form: " + ord);
                        }
                    } else if (slotQueries.size() == 1 && ((OrdQuery)slotQueries.get(0)).getBody().isEmpty()) {
                        newOrd = BOrd.make((OrdQuery)((OrdQuery)slotQueries.get(0)));
                    } else {
                        BOrd slotOrd = BOrd.make((OrdQuery[])slotQueries.toArray(EMPTY_ORD_QUERIES));
                        VirtualPath vPath = NiagaraVirtualUtil.fromServerOrdToClientVirtual((BOrd)BOrd.make((String)"slot:/"), (BOrd)slotOrd);
                        if (isAbsolute) {
                            String body;
                            if (this.isReachableStation && (body = vPath.getBody()).startsWith("/")) {
                                vPath = body.length() == 1 ? VirtualPath.EMPTY_VIRTUAL_PATH : new VirtualPath(body.substring(1));
                            }
                            newOrd = BOrd.make((BOrd)this.virtualSpaceBaseOrd, (OrdQuery)vPath).normalize();
                        } else {
                            String virtualPathBody;
                            newOrd = vPath.getBackupDepth() <= 0 ? ((virtualPathBody = vPath.getBody().substring(1)).isEmpty() ? EMPTY_SLOT_ORD : BOrd.make((OrdQuery)new VirtualPath(virtualPathBody))) : BOrd.make((OrdQuery)vPath);
                        }
                    }
                }
                if (queryIdxFollowingPath >= 0 && !newOrd.isNull()) {
                    if ("neql".equals(queries[queryIdxFollowingPath].getScheme())) {
                        this.logSystemDbAvailability();
                        if (!SYS_ORD.equals((Object)newOrd)) {
                            newOrd = BOrd.make((BOrd)newOrd, (BOrd)SYS_ORD);
                        }
                    } else if ("sys".equals(queries[queryIdxFollowingPath].getScheme())) {
                        this.logSystemDbAvailability();
                    }
                    newOrd = BOrd.make((BOrd)newOrd, (BOrd)PxOrdVisitor.redirectAdditionalNeqlQueriesToSystemDb(BOrd.make((OrdQuery[])queries, (int)queryIdxFollowingPath, (int)queries.length)));
                }
                this.ordMap.put(ord, newOrd);
            }
            catch (Exception e) {
                BAbstractSubstitutePxView.LOG.log(Level.FINE, "Niagara Virtual Px View: Could not resolve ORD: " + ord, e);
            }
        }

        private static OrdQuery adjustOrdQuery(BOrd ord, OrdQuery query) {
            block8: {
                if (query instanceof ViewQuery) {
                    String viewId = ((ViewQuery)query).getViewId();
                    try {
                        TypeInfo[] agentOnTypes;
                        Type viewType = Sys.getType((String)viewId);
                        if (viewType.is(BAbstractPxView.TYPE)) {
                            return query;
                        }
                        AgentInfo viewAgentInfo = viewType.getTypeInfo().getAgentInfo();
                        for (TypeInfo agentOnType : agentOnTypes = viewAgentInfo.getAgentOn()) {
                            if (!agentOnType.is(BNiagaraVirtualComponent.TYPE)) continue;
                            return query;
                        }
                        if (TypeHolder.VIRTUAL_AGENTS.indexOf(viewAgentInfo) >= 0) {
                            return query;
                        }
                        if (BAbstractSubstitutePxView.LOG.isLoggable(Level.FINE)) {
                            BAbstractSubstitutePxView.LOG.fine("Niagara Virtual Px View: " + viewId + " is not a valid view query that can be resolved against a Niagara virtual. Substituting the default view (\"view:?\") for the following ORD when it is translated to virtual form: " + ord);
                        }
                        return new ViewQuery("?");
                    }
                    catch (IllegalArgumentException | NullPointerException | RegistryException | ModuleException | TypeException viewType) {
                    }
                    catch (Exception e) {
                        if (!BAbstractSubstitutePxView.LOG.isLoggable(Level.WARNING)) break block8;
                        BAbstractSubstitutePxView.LOG.log(Level.WARNING, "Niagara Virtual Px View: " + viewId + " view query caused an unexpected exception when processing the following ORD for virtual translation: " + ord, e);
                    }
                }
            }
            return query;
        }

        private void logSystemDbAvailability() {
            if (this.view.sysDbAvailable == null) {
                if (TypeHolder.SYS_DB_SERVICE_TYPE != null) {
                    BAbstractService sysDbService = Sys.findService((Type)TypeHolder.SYS_DB_SERVICE_TYPE).orElse(null);
                    this.view.sysDbAvailable = sysDbService != null && sysDbService.isOperational() && !sysDbService.getStatus().isDown();
                } else {
                    this.view.sysDbAvailable = false;
                }
                if (!this.view.sysDbAvailable.booleanValue() && BAbstractSubstitutePxView.LOG.isLoggable(Level.WARNING)) {
                    if (TypeHolder.SYS_DB_SERVICE_TYPE == null) {
                        BAbstractSubstitutePxView.LOG.warning("The virtual px view '" + this.view.getDisplayName(null) + "' on " + this.base.getNavOrd() + " has at least one ORD binding that contains a query (e.g. tag-based binding) that needs to be routed to the SystemDb in order to resolve, but the modules for the SystemDb are not installed or not supported on this platform.");
                    } else {
                        BAbstractSubstitutePxView.LOG.warning("The virtual px view '" + this.view.getDisplayName(null) + "' on " + this.base.getNavOrd() + " has at least one ORD binding that contains a query (e.g. tag-based binding) that needs to be routed to the SystemDb in order to resolve, but the SystemDb is not available.");
                    }
                }
            }
        }

        private static BOrd redirectAdditionalNeqlQueriesToSystemDb(BOrd ord) {
            ArrayList newOrdQueries = null;
            OrdQuery[] ordQueries = ord.parse();
            for (int i = 0; i < ordQueries.length; ++i) {
                if (i > 0 && "neql".equals(ordQueries[i].getScheme()) && !"sys".equals(ordQueries[i - 1].getScheme())) {
                    if (newOrdQueries == null) {
                        newOrdQueries = Arrays.stream(ordQueries).limit(i).collect(Collectors.toCollection(ArrayList::new));
                    }
                    newOrdQueries.add(SYS_ORD_QUERY);
                }
                if (newOrdQueries == null) continue;
                newOrdQueries.add(ordQueries[i]);
            }
            if (newOrdQueries != null) {
                return BOrd.make((OrdQuery[])newOrdQueries.toArray(EMPTY_ORD_QUERIES));
            }
            return ord;
        }

        @Override
        public void handleHyperlinkOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
        }

        @Override
        public void handleFileOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                BOrd remoteFileOrd = BOrd.make((OrdQuery)queries[queryIndex]);
                BOrd newFileOrd = BNiagaraVirtualPxView.convertRemoteToLocalFileOrd(this.stationName, remoteFileOrd, true, null);
                queries[queryIndex] = newFileOrd.parse()[0];
                newFileOrd = BOrd.make((OrdQuery[])queries);
                this.ordFileMap.put(newFileOrd, remoteFileOrd);
                if (!ord.equals((Object)newFileOrd)) {
                    this.ordMap.put(ord, newFileOrd);
                }
            }
            catch (Exception e) {
                BAbstractSubstitutePxView.LOG.log(Level.FINE, "Niagara Virtual Px View: Could not resolve File ORD: " + ord, e);
            }
        }

        @Override
        public void handleModuleOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                ord.resolve();
            }
            catch (Exception e) {
                BAbstractSubstitutePxView.LOG.log(Level.FINE, "Niagara Virtual Px View: Could not resolve module ORD: " + ord, e);
            }
        }

        @Override
        public void handleHistoryOrd(BComplex clx, Property prop, BOrd ord, OrdQuery[] queries, int queryIndex) throws Exception {
            try {
                BOrd historyOrd = ord;
                HistoryQuery historyQuery = (HistoryQuery)queries[queryIndex];
                BHistoryId historyId = historyQuery.getHistoryId();
                if (historyId != null && (historyId.isShorthand() || "@".equals(historyId.getDeviceName()))) {
                    boolean isDeviceShorthand = historyId.isShorthand();
                    String devName = isDeviceShorthand ? this.stationName : "@";
                    for (BComponent comp = this.base; comp != null; comp = comp.getParent()) {
                        if (!isDeviceShorthand && comp instanceof BNiagaraVirtualStation) {
                            devName = ((BNiagaraVirtualStation)comp).getStationName();
                            break;
                        }
                        if (!(comp instanceof BNiagaraVirtualGatewayComponent) || comp == this.base) continue;
                        if (!isDeviceShorthand || !((comp = comp.getParent()) instanceof BNiagaraVirtualStation)) break;
                        devName = ((BNiagaraVirtualStation)comp).getStationName();
                        break;
                    }
                    String substituteHistoryQuery = historyQuery.getBody().replace(historyId.encodeToString(), BHistoryId.make((String)devName, (String)historyId.getHistoryName()).encodeToString());
                    queries[queryIndex] = new HistoryQuery(historyQuery.getScheme(), substituteHistoryQuery);
                    historyOrd = BOrd.make((OrdQuery[])queries);
                    if (!ord.equals((Object)historyOrd)) {
                        this.ordMap.put(ord, historyOrd);
                    }
                }
                historyOrd.resolve((BObject)this.base);
            }
            catch (Exception e) {
                BAbstractSubstitutePxView.LOG.log(Level.FINE, "Niagara Virtual Px View: Could not resolve history ORD: " + ord, e);
            }
        }

        @Override
        public void handleUnknownOrd(BComplex clx, Property prop, BOrd ord) throws Exception {
            if (BAbstractSubstitutePxView.LOG.isLoggable(Level.FINE)) {
                BAbstractSubstitutePxView.LOG.fine("Niagara Virtual Px View: ORD not supported: " + ord);
            }
        }

        @Override
        public void handleOverrideOrd(BComplex clx, Property prop, BOrd ord, BOrd overrideOrd) throws Exception {
            if (this.ordMap.get(ord) == null) {
                this.ordMap.put(ord, overrideOrd);
            }
        }

        @Override
        public BWidget decodePxFileFromOrd(BOrd pxFileOrd, BObject base, String stationName, Context cx) throws Exception {
            PxDecoder decoder;
            if (base.getType().is(BFileSpace.TYPE)) {
                if (!base.getType().is(BIFoxProxySpace.TYPE)) {
                    pxFileOrd = BNiagaraVirtualPxView.convertRemoteToLocalFileOrd(stationName, pxFileOrd, false, cx);
                }
                BFileSpace fileSpace = (BFileSpace)base;
                OrdQuery[] queries = pxFileOrd.parse();
                FilePath filePath = (FilePath)queries[queries.length - 1];
                BIFileStore fileStore = fileSpace.findStore(filePath);
                decoder = new PxDecoder(pxFileOrd, (InputStream)new BufferedInputStream(fileStore.getInputStream()));
            } else {
                BIFile sourcePxFile = (BIFile)pxFileOrd.get(base);
                decoder = new PxDecoder(sourcePxFile);
            }
            BWidget root = decoder.decodeDocument();
            decoder.close();
            return root;
        }

        private Map<BOrd, BOrd> getOrdMap() {
            return this.ordMap;
        }

        private Map<BOrd, BOrd> getOrdFileMap() {
            return this.ordFileMap;
        }

        private static final class TypeHolder {
            static final AgentList VIRTUAL_AGENTS;
            static final Type SYS_DB_SERVICE_TYPE;

            private TypeHolder() {
            }

            static {
                Type type;
                VIRTUAL_AGENTS = new BNiagaraVirtualComponent().getAgents();
                try {
                    type = Sys.getType((String)"systemDb:SystemDbService");
                }
                catch (Exception e) {
                    type = null;
                }
                SYS_DB_SERVICE_TYPE = type;
            }
        }
    }
}

