/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.ux;

import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagGroupInfo;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BTaggingRpcUtil
extends BSingleton {
    @Generated
    public static final BTaggingRpcUtil INSTANCE = new BTaggingRpcUtil();
    @Generated
    public static final Type TYPE = Sys.loadType(BTaggingRpcUtil.class);
    public static final String TAG_NAME_KEY = "n";
    public static final String DICTIONARY_KEY = "d";
    public static final String TAG_TYPE_KEY = "t";
    public static final String TAG_B_TYPE_KEY = "b";
    public static final String DEFAULT_VALUE_KEY = "v";
    public static final String IS_IDEAL_KEY = "ii";
    public static final String IS_VALID_KEY = "iv";
    public static final String DICTIONARY_NAME_KEY = "dn";
    public static final String ALL_DICTIONARIES = "all.dictionaries";
    private static final Lexicon lex = Lexicon.make(BTaggingRpcUtil.class);
    private static final Logger LOG = Logger.getLogger("tagdictionary.ux");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BTaggingRpcUtil() {
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<Object> getTagInfos(String selectedDictionary, String targetOrd, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getTagInfos, for: dictionary: " + selectedDictionary + ", targetOrd: " + targetOrd);
        }
        BComplex target = null;
        if (!targetOrd.isEmpty()) {
            try {
                target = (BComplex)BOrd.make((String)targetOrd).get(null, cx);
            }
            catch (Exception ex) {
                throw new BajaRuntimeException((Throwable)ex);
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<TagDictionary> dictionaries = new ArrayList<TagDictionary>();
        try {
            if (selectedDictionary.equals(ALL_DICTIONARIES)) {
                dictionaries.addAll(BTaggingRpcUtil.getTagDictionaryService(cx).getTagDictionaries());
            } else {
                dictionaries.add(BTaggingRpcUtil.getTagDictionary(selectedDictionary, cx));
            }
            for (TagDictionary dictionary : dictionaries) {
                Iterator itr = dictionary.getTags();
                while (itr.hasNext()) {
                    TagInfo ti = (TagInfo)itr.next();
                    if (!BTaggingRpcUtil.hasReadPermission(ti, cx)) continue;
                    result.add(BTaggingRpcUtil.createTagInfoJson(ti, target));
                }
            }
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<Object> getTagGroupInfos(String selectedDictionary, String targetOrd, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getTagGroupInfos, for: " + selectedDictionary + ", targetOrd: " + targetOrd);
        }
        BComplex target = null;
        if (!targetOrd.isEmpty()) {
            try {
                target = (BComplex)BOrd.make((String)targetOrd).get(null, cx);
            }
            catch (Exception ex) {
                throw new BajaRuntimeException((Throwable)ex);
            }
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<TagDictionary> dictionaries = new ArrayList<TagDictionary>();
        try {
            if (selectedDictionary.equals(ALL_DICTIONARIES)) {
                dictionaries.addAll(BTaggingRpcUtil.getTagDictionaryService(cx).getTagDictionaries());
            } else {
                dictionaries.add(BTaggingRpcUtil.getTagDictionary(selectedDictionary, cx));
            }
            for (TagDictionary dictionary : dictionaries) {
                Iterator itr = dictionary.getTagGroups();
                while (itr.hasNext()) {
                    TagGroupInfo tgi = (TagGroupInfo)itr.next();
                    if (!BTaggingRpcUtil.hasReadPermission(tgi, cx)) continue;
                    result.add(BTaggingRpcUtil.createTagGroupInfoJson(tgi, target));
                }
            }
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<Object> getTagInfosForTagGroup(String tagGroupOrd, String targetOrd, Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getTagInfosForTagGroup, for: " + tagGroupOrd + ", targetOrd: " + targetOrd);
        }
        BComplex target = null;
        BComplex tagGroup = null;
        if (!targetOrd.isEmpty()) {
            try {
                target = (BComplex)BOrd.make((String)targetOrd).get(null, cx);
            }
            catch (Exception ex) {
                throw new BajaRuntimeException((Throwable)ex);
            }
        }
        try {
            tagGroup = (BComplex)BOrd.make((String)tagGroupOrd).get(null, cx);
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        if (!(tagGroup instanceof TagGroupInfo)) {
            throw new BajaRuntimeException("Not a tag group: " + tagGroupOrd);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            Iterator itr = ((TagGroupInfo)tagGroup).getTags();
            while (itr.hasNext()) {
                TagInfo ti = (TagInfo)itr.next();
                if (!BTaggingRpcUtil.hasReadPermission(ti, cx)) continue;
                result.add(BTaggingRpcUtil.createTagInfoJson(ti, target));
            }
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getTagDictionaryServiceOrd(Context cx) {
        TagDictionaryService tagDictionaryService = BTaggingRpcUtil.getTagDictionaryService(cx);
        if (null != tagDictionaryService) {
            return ((BComponent)tagDictionaryService).getNavOrd().toString();
        }
        return "";
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<Object> getTagDictionariesInfo(Context cx) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("getTagDictionariesInfo");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Collection<TagDictionary> tagDictionaries = BTaggingRpcUtil.getTagDictionaries(cx);
        if (tagDictionaries == null) {
            return result;
        }
        try {
            for (TagDictionary dictionary : tagDictionaries) {
                result.add(BTaggingRpcUtil.createDictionaryInfoJson(dictionary, cx));
            }
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        return result;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> getRelationIds(Context cx) {
        ArrayList<String> results = new ArrayList<String>();
        Collection<TagDictionary> tagDictionaries = BTaggingRpcUtil.getTagDictionaries(cx);
        if (tagDictionaries == null) {
            return results;
        }
        for (TagDictionary dictionary : tagDictionaries) {
            dictionary.getRelations().forEachRemaining(relation -> {
                if (BTaggingRpcUtil.hasReadPermission(relation, cx)) {
                    results.add(relation.getRelationId().toString());
                }
            });
        }
        return results;
    }

    private static JSONObject createTagInfoJson(TagInfo tagInfo, BComplex target) throws IOException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(TAG_NAME_KEY, (Object)tagInfo.getTagId().getName());
        jsonObj.put(DICTIONARY_KEY, (Object)tagInfo.getTagId().getDictionary());
        jsonObj.put(TAG_TYPE_KEY, (Object)tagInfo.getTagType().getTypeSpec().toString());
        jsonObj.put(DEFAULT_VALUE_KEY, (Object)BsonEncoderPlugin.marshal((BValue)((BValue)tagInfo.getDefaultValue())));
        jsonObj.put(TAG_B_TYPE_KEY, (Object)((BObject)tagInfo).getType().getTypeSpec().toString());
        jsonObj.put(IS_IDEAL_KEY, tagInfo.isIdealFor(target.getType()));
        boolean isValid = true;
        if (target instanceof Entity) {
            isValid = tagInfo.isValidFor((Entity)target);
        }
        jsonObj.put(IS_VALID_KEY, isValid);
        return jsonObj;
    }

    private static JSONObject createTagGroupInfoJson(TagGroupInfo tagGroupInfo, BComplex target) throws IOException {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(TAG_NAME_KEY, (Object)tagGroupInfo.getGroupId().getName());
        jsonObj.put(DICTIONARY_KEY, (Object)tagGroupInfo.getGroupId().getDictionary());
        BOrd slotPathOrd = BOrd.DEFAULT;
        if (tagGroupInfo instanceof BTagGroupInfo) {
            slotPathOrd = ((BTagGroupInfo)tagGroupInfo).getSlotPathOrd();
        } else if (tagGroupInfo instanceof BComponent) {
            slotPathOrd = ((Entity)tagGroupInfo).getOrdToEntity().orElse(BOrd.DEFAULT);
        }
        jsonObj.put(DEFAULT_VALUE_KEY, (Object)BsonEncoderPlugin.marshal((BValue)slotPathOrd));
        jsonObj.put(TAG_B_TYPE_KEY, (Object)((BObject)tagGroupInfo).getType().getTypeSpec().toString());
        jsonObj.put(IS_IDEAL_KEY, tagGroupInfo.isIdealFor(target.getType()));
        boolean isValid = true;
        if (target instanceof Entity) {
            isValid = tagGroupInfo.isValidFor((Entity)target);
        }
        jsonObj.put(IS_VALID_KEY, isValid);
        return jsonObj;
    }

    private static JSONObject createDictionaryInfoJson(TagDictionary dictionary, Context cx) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(DICTIONARY_KEY, (Object)dictionary.getNamespace());
        jsonObj.put(DICTIONARY_NAME_KEY, (Object)dictionary.getDisplayName(cx));
        return jsonObj;
    }

    private static TagDictionary getTagDictionary(String namespace, Context cx) {
        TagDictionary tagDictionary;
        TagDictionaryService tagDictionaryService = BTaggingRpcUtil.getTagDictionaryService(cx);
        if (null != tagDictionaryService && BTaggingRpcUtil.hasReadPermission(tagDictionary = (TagDictionary)tagDictionaryService.getTagDictionary(namespace).orElse(null), cx)) {
            return tagDictionary;
        }
        return null;
    }

    private static TagDictionaryService getTagDictionaryService(Context cx) {
        TagDictionaryService tagDictionaryService;
        BStation station = Sys.getStation();
        if (null != station && BTaggingRpcUtil.hasReadPermission(tagDictionaryService = station.getTagDictionaryService(), cx)) {
            return tagDictionaryService;
        }
        return null;
    }

    private static Collection<TagDictionary> getTagDictionaries(Context cx) {
        TagDictionaryService service = BTaggingRpcUtil.getTagDictionaryService(cx);
        if (service == null) {
            return null;
        }
        Collection tagDictionaries = service.getTagDictionaries();
        tagDictionaries.removeIf(dictionary -> !BTaggingRpcUtil.hasReadPermission(dictionary, cx));
        tagDictionaries.removeIf(dictionary -> !BTaggingRpcUtil.dictionaryIsValid(dictionary));
        return tagDictionaries;
    }

    private static boolean hasReadPermission(Object obj, Context cx) {
        if (obj instanceof BIProtected) {
            return ((BIProtected)obj).getPermissions(cx).hasOperatorRead();
        }
        return true;
    }

    private static boolean dictionaryIsValid(TagDictionary dictionary) {
        return dictionary.getEnabled() && null != dictionary.getNamespace() && !"".equals(dictionary.getNamespace());
    }
}

