/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.defaultComm;

import com.tridium.ddf.clock.BDdfScheduler;
import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfReceiver;
import com.tridium.ddf.comm.BIDdfTransactionMgr;
import com.tridium.ddf.comm.BIDdfTransmitter;
import com.tridium.ddf.comm.BIDdfUnsolicitedMgr;
import com.tridium.ddf.comm.defaultComm.BDdfNullReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfNullTransactionMgr;
import com.tridium.ddf.comm.defaultComm.BDdfNullTransmitter;
import com.tridium.ddf.comm.defaultComm.BDdfNullUnsolicitedMgr;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.defaultComm.BDdfUnsolicitedMgr;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BDdfRawTransmitRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.poll.BDdfPollScheduler;
import com.tridium.ddf.poll.BIDdfPollScheduler;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BWorker;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="transmitter", type="BDdfTransmitter", defaultValue="new BDdfNullTransmitter()"), @NiagaraProperty(name="receiver", type="BDdfReceiver", defaultValue="new BDdfNullReceiver()"), @NiagaraProperty(name="transactionManager", type="BDdfTransactionMgr", defaultValue="new BDdfNullTransactionMgr()"), @NiagaraProperty(name="pollScheduler", type="BDdfPollScheduler", defaultValue="new BDdfPollScheduler()"), @NiagaraProperty(name="unsolicitedMgr", type="BDdfUnsolicitedMgr", defaultValue="new BDdfNullUnsolicitedMgr()")})
@NiagaraActions(value={@NiagaraAction(name="resetStatistics", flags=128), @NiagaraAction(name="requeue", flags=4)})
public class BDdfCommunicator
extends BWorker
implements BIDdfCommunicator {
    @Generated
    public static final Property transmitter = BDdfCommunicator.newProperty((int)0, (BValue)new BDdfNullTransmitter(), null);
    @Generated
    public static final Property receiver = BDdfCommunicator.newProperty((int)0, (BValue)new BDdfNullReceiver(), null);
    @Generated
    public static final Property transactionManager = BDdfCommunicator.newProperty((int)0, (BValue)new BDdfNullTransactionMgr(), null);
    @Generated
    public static final Property pollScheduler = BDdfCommunicator.newProperty((int)0, (BValue)new BDdfPollScheduler(), null);
    @Generated
    public static final Property unsolicitedMgr = BDdfCommunicator.newProperty((int)0, (BValue)new BDdfNullUnsolicitedMgr(), null);
    @Generated
    public static final Action resetStatistics = BDdfCommunicator.newAction((int)128, null);
    @Generated
    public static final Action requeue = BDdfCommunicator.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfCommunicator.class);
    protected Vector<BIDdfRequest> requeueList = new Vector();
    protected Clock.Ticket requeueTicket = null;
    protected Queue infiniteQueue = new Queue();
    protected Worker communicationWorker = new Worker((Worker.ITodo)this.infiniteQueue);
    private BIDdfCommunicating communicatingParent;
    private BIDdfReceiver ddfReceiver;
    private BIDdfTransactionMgr ddfTransactionMgr;
    private BIDdfTransmitter ddfTransmitter;
    private Object commSynchronizer = new CommSynchronizer();

    @Generated
    public BDdfTransmitter getTransmitter() {
        return (BDdfTransmitter)this.get(transmitter);
    }

    @Generated
    public void setTransmitter(BDdfTransmitter v) {
        this.set(transmitter, (BValue)v, null);
    }

    @Generated
    public BDdfReceiver getReceiver() {
        return (BDdfReceiver)this.get(receiver);
    }

    @Generated
    public void setReceiver(BDdfReceiver v) {
        this.set(receiver, (BValue)v, null);
    }

    @Generated
    public BDdfTransactionMgr getTransactionManager() {
        return (BDdfTransactionMgr)this.get(transactionManager);
    }

    @Generated
    public void setTransactionManager(BDdfTransactionMgr v) {
        this.set(transactionManager, (BValue)v, null);
    }

    @Generated
    public BDdfPollScheduler getPollScheduler() {
        return (BDdfPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BDdfPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Generated
    public BDdfUnsolicitedMgr getUnsolicitedMgr() {
        return (BDdfUnsolicitedMgr)this.get(unsolicitedMgr);
    }

    @Generated
    public void setUnsolicitedMgr(BDdfUnsolicitedMgr v) {
        this.set(unsolicitedMgr, (BValue)v, null);
    }

    @Generated
    public void resetStatistics() {
        this.invoke(resetStatistics, null, null);
    }

    @Generated
    public void requeue() {
        this.invoke(requeue, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIDdfCommunicating;
    }

    private void loadClientSideSupport() {
        this.loadForClientComm(this, "UnableToSyncProxySpace - communicator");
        this.getDdfTransactionMgr().getDdfCommunicator();
        this.getDdfTransmitter().getDdfCommunicator();
        this.getDdfReceiver().getDdfCommunicator();
        this.getUnsolicitedMgr().getDdfCommunicator();
        this.findCommunicatingParent();
    }

    public final void started() throws Exception {
        this.loadClientSideSupport();
        this.findCommunicatingParent();
        super.started();
        this.communicatorStarted();
    }

    public void descendantsStarted() throws Exception {
        this.startCommunicating();
        super.descendantsStarted();
    }

    public final void stopped() throws Exception {
        this.stopCommunicating();
        this.communicatorStopped();
        super.stopped();
    }

    public boolean isNavChild() {
        return false;
    }

    protected void startWorker() {
        if (this.isCommEnabled()) {
            super.startWorker();
        }
    }

    protected String getWorkerThreadName() {
        Object h;
        String tn;
        BTypeSpec ts;
        String threadName = "Communicator";
        Type t = this.getType();
        if (t != null && (ts = t.getTypeSpec()) != null && (tn = ts.getTypeName()) != null) {
            threadName = tn;
        }
        if ((h = this.getHandle()) != null) {
            threadName = threadName + ":h" + h;
        }
        return threadName;
    }

    protected final void stopWorker() {
        super.stopWorker();
    }

    public Worker getWorker() {
        return this.communicationWorker;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Ddf Communicator");
        out.endProps();
        this.getReceiver().spy(out);
        super.spy(out);
    }

    @Override
    public BIDdfTransmitter getDdfTransmitter() {
        if (this.ddfTransmitter == null) {
            this.ddfTransmitter = this.getTransmitter();
            this.loadForClientComm(this.ddfTransmitter, "Unable to Sync Transmitter");
        }
        return this.ddfTransmitter;
    }

    @Override
    public BIDdfReceiver getDdfReceiver() {
        if (this.ddfReceiver == null) {
            this.ddfReceiver = this.getReceiver();
            this.loadForClientComm(this.ddfReceiver, "Unable to Sync Receiver");
        }
        return this.ddfReceiver;
    }

    @Override
    public BIDdfTransactionMgr getDdfTransactionMgr() {
        if (this.ddfTransactionMgr == null) {
            this.ddfTransactionMgr = this.getTransactionManager();
            this.loadForClientComm(this.ddfTransactionMgr, "Unable to Sync Transaction Manager");
        }
        return this.ddfTransactionMgr;
    }

    @Override
    public Log getLog() {
        String logName = this.getType().getTypeSpec().getTypeName() + ".h" + this.getHandle();
        return Log.getLog((String)logName);
    }

    @Override
    public BIDdfPollScheduler getDdfPollScheduler() {
        return this.getPollScheduler();
    }

    @Override
    public BIDdfUnsolicitedMgr getDdfUnsolicitedMgr() {
        return this.getUnsolicitedMgr();
    }

    @Override
    public void communicate(BIDdfRequest ddfRequest) {
        if (this.isCommEnabled()) {
            this.loadClientSideSupport();
            boolean coalesce = false;
            if (ddfRequest instanceof BIDdfWriteRequest && this.coalesceWrites((BIDdfWriteRequest)ddfRequest)) {
                coalesce = this.coalesceWrite((BIDdfWriteRequest)ddfRequest);
            }
            if (!coalesce) {
                this.infiniteQueue.enqueue((Object)new Communication(ddfRequest));
            }
        } else {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(DdfDefaultCommLexicon.noCommunicationsAvailableWhileInvaldStatus);
            }
            throw new BajaRuntimeException(DdfDefaultCommLexicon.noCommunicationsAvailableWhileInvaldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCommunicating() {
        Object object = this.commSynchronizer;
        synchronized (object) {
            this.stopWorker();
            this.clearQueue();
            this.getUnsolicitedMgr().stopUnsolicitedMgr();
            this.getTransactionManager().stopTransactionMgr();
            this.getTransmitter().stopTransmitter();
            this.getReceiver().stopReceiver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCommunicating() {
        if (this.isCommEnabled()) {
            Object object = this.commSynchronizer;
            synchronized (object) {
                this.loadClientSideSupport();
                this.getReceiver().startReceiver();
                this.getTransmitter().startTransmitter();
                this.getTransactionManager().startTransactionMgr();
                this.getUnsolicitedMgr().startUnsolicitedMgr();
                this.startWorker();
            }
        }
    }

    public void communicatorStarted() throws Exception {
    }

    public void communicatorStopped() throws Exception {
    }

    public BIDdfCommunicating getDdfCommunicatingParent() {
        this.findCommunicatingParent();
        return this.communicatingParent;
    }

    void loadForClientComm(Object o, String errorLogSummary) {
        BComponentSpace componentSpace = this.getComponentSpace();
        if (componentSpace != null && componentSpace.isProxyComponentSpace() && o instanceof BComponent && (((BComponent)o).getParent() == null || !((BComponent)o).isSubscribed())) {
            BComponent c = (BComponent)o;
            c.lease(Integer.MAX_VALUE, Integer.MAX_VALUE);
            try {
                c.getComponentSpace().sync();
            }
            catch (Exception e) {
                this.getLog().error(errorLogSummary, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doCommunicate(BIDdfRequest ddfRequest) {
        if (this.grantAccess(ddfRequest)) {
            ddfRequest.setRemainingRetryCount(this.getTransmitter().getMaxRetryCount(ddfRequest));
            ddfRequest.setResponseTimeout(this.getReceiver().getResponseTimeout(ddfRequest));
            if (ddfRequest.getType().is(BDdfRawTransmitRequest.TYPE)) {
                try {
                    this.getDdfTransmitter().forceTransmit(ddfRequest);
                    return;
                }
                catch (Exception e) {
                    this.getLog().error("RawTransmitError", (Throwable)e);
                }
                return;
            }
            try {
                this.loadForClientComm(this, "UnableToSyncProxySpace - communicator");
                BIDdfTransmitter transmitter = this.getDdfTransmitter();
                this.loadForClientComm(transmitter, "UnableToSyncProxySpace - transmitter");
                transmitter.getDdfCommunicator();
                BIDdfTransactionMgr transactionMgr = this.getDdfTransactionMgr();
                this.loadForClientComm(transactionMgr, "UnableToSyncProxySpace - transaction manager");
                transactionMgr.getDdfCommunicator();
                BIDdfReceiver receiver = this.getDdfReceiver();
                this.loadForClientComm(receiver, "UnableToSyncProxySpace - receiver");
                transactionMgr.processTransaction(ddfRequest);
                transmitter.transmitRequest(ddfRequest);
                return;
            }
            finally {
                if (ddfRequest.getResponseTimeout().getMillis() <= 0L) {
                    BIDdfRequest bIDdfRequest = ddfRequest;
                    synchronized (bIDdfRequest) {
                        ddfRequest.notifyAll();
                    }
                }
            }
        }
        this.requeue(ddfRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRequeue() {
        Vector<BIDdfRequest> vector = this.requeueList;
        synchronized (vector) {
            Iterator<BIDdfRequest> i = this.requeueList.iterator();
            while (i.hasNext()) {
                BIDdfRequest ddfRequest = i.next();
                i.remove();
                this.communicate(ddfRequest);
            }
        }
    }

    public void doResetStatistics() {
        this.getTransmitter().resetStatistics();
        this.getReceiver().resetStatistics();
        this.getPollScheduler().resetStatistics();
        this.getTransactionManager().resetStatistics();
        this.getUnsolicitedMgr().resetStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requeue(BIDdfRequest ddfRequest) {
        Vector<BIDdfRequest> vector = this.requeueList;
        synchronized (vector) {
            this.requeueList.addElement(ddfRequest);
            if (this.requeueTicket == null || this.requeueTicket.isExpired()) {
                this.requeueTicket = BDdfScheduler.INSTANCE.schedule((BComponent)this, 10000L, requeue, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean coalesceWrite(BIDdfWriteRequest ddfWriteRequest) {
        Queue queue = this.infiniteQueue;
        synchronized (queue) {
            Object[] communicatorObjects = this.infiniteQueue.toArray();
            boolean coalesce = false;
            for (int i = 0; i < communicatorObjects.length && !coalesce; ++i) {
                if (!(communicatorObjects[i] instanceof Communication)) continue;
                Communication commObject = (Communication)communicatorObjects[i];
                if (!(commObject.ddfRequest instanceof BIDdfWriteRequest) || commObject.ddfRequest.getType() != ddfWriteRequest.getType() || !commObject.ddfRequest.getDeviceId().equivalent(ddfWriteRequest.getDeviceId()) || !((BIDdfWriteRequest)commObject.ddfRequest).getWriteParameters().equivalent(ddfWriteRequest.getWriteParameters())) continue;
                boolean groupable = ((BIDdfWriteRequest)commObject.ddfRequest).isGroupable();
                boolean sameWritableSource = this.sameWritableSource((BIDdfWriteRequest)commObject.ddfRequest, ddfWriteRequest);
                if (!groupable && !sameWritableSource) continue;
                coalesce = true;
                if (sameWritableSource) continue;
                this.ensureInWritableSource((BIDdfWriteRequest)commObject.ddfRequest, ddfWriteRequest.getWritableSource());
            }
            return coalesce;
        }
    }

    protected void ensureInWritableSource(BIDdfWriteRequest writeReqInQueue, IDdfWritable[] writableSourceToCoalesce) {
        Array writableSourceInQueue = new Array((Object[])writeReqInQueue.getWritableSource());
        for (int i = 0; i < writableSourceToCoalesce.length; ++i) {
            if (writableSourceInQueue.contains((Object)writableSourceToCoalesce[i])) continue;
            writableSourceInQueue.add((Object)writableSourceToCoalesce[i]);
        }
        writeReqInQueue.setWritableSource((IDdfWritable[])writableSourceInQueue.trim());
    }

    protected boolean coalesceWrites(BIDdfWriteRequest ddfRequest) {
        return true;
    }

    protected boolean grantAccess(BIDdfRequest ddfRequest) {
        return true;
    }

    boolean isCommEnabled() {
        this.findCommunicatingParent();
        return this.communicatingParent != null && !this.communicatingParent.isDisabled() && !this.communicatingParent.isFault();
    }

    private boolean sameWritableSource(BIDdfWriteRequest reqA, BIDdfWriteRequest reqB) {
        IDdfWritable[] reqAWritables = reqA.getWritableSource();
        IDdfWritable[] reqBWritables = reqB.getWritableSource();
        if (reqAWritables == null || reqBWritables == null || reqAWritables.length != reqBWritables.length || reqAWritables.length == 0) {
            return false;
        }
        Hashtable<IDdfWritable, IDdfWritable> reqBHash = new Hashtable<IDdfWritable, IDdfWritable>(reqBWritables.length * 2);
        for (int b = 0; b < reqBWritables.length; ++b) {
            reqBHash.put(reqBWritables[b], reqBWritables[b]);
        }
        for (int a = 0; a < reqAWritables.length; ++a) {
            if (reqBHash.get(reqAWritables[a]) != null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue() {
        Object queueItem = this.infiniteQueue.dequeue();
        while (queueItem != null) {
            if (queueItem instanceof Communication) {
                Communication queueCommItem = (Communication)queueItem;
                BIDdfRequest bIDdfRequest = queueCommItem.ddfRequest;
                synchronized (bIDdfRequest) {
                    queueCommItem.ddfRequest.notifyAll();
                }
            }
            queueItem = this.infiniteQueue.dequeue();
        }
    }

    private void findCommunicatingParent() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BIDdfCommunicating)) continue;
            this.communicatingParent = (BIDdfCommunicating)parent;
            return;
        }
    }

    class CommSynchronizer {
        CommSynchronizer() {
        }
    }

    public class Communication
    implements Runnable {
        BIDdfRequest ddfRequest;

        Communication(BIDdfRequest ddfRequest) {
            this.ddfRequest = ddfRequest;
        }

        @Override
        public void run() {
            BDdfCommunicator.this.doCommunicate(this.ddfRequest);
        }
    }
}

