/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.defaultComm;

import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.BIDdfUnsolicitedMgr;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfNullUnsolicitedMgr;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperty(name="unsolicitedMessageCount", type="long", defaultValue="0", flags=1, facets={@Facet(value="BFacets.make(BFacets.MIN,BInteger.make(0))")})
public abstract class BDdfUnsolicitedMgr
extends BComponent
implements BIDdfUnsolicitedMgr,
Runnable {
    @Generated
    public static final Property unsolicitedMessageCount = BDdfUnsolicitedMgr.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfUnsolicitedMgr.class);
    private BIDdfCommunicator ddfCommunicator;
    private Queue unsolicitedFrameManager = null;
    private boolean stopUnsolicitedMgr = true;
    private Thread myThread = null;

    @Generated
    public long getUnsolicitedMessageCount() {
        return this.getLong(unsolicitedMessageCount);
    }

    @Generated
    public void setUnsolicitedMessageCount(long v) {
        this.setLong(unsolicitedMessageCount, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BIDdfCommunicator.TYPE);
    }

    public final void started() throws Exception {
        this.unsolicitedMgrStarted();
        super.started();
    }

    public final void stopped() throws Exception {
        this.unsolicitedMgrStopped();
        super.stopped();
    }

    @Override
    public void startUnsolicitedMgr() {
        if (!(this instanceof BDdfNullUnsolicitedMgr) && this.stopUnsolicitedMgr) {
            this.stopUnsolicitedMgr = false;
            this.unsolicitedFrameManager = new Queue();
            String threadName = "UnsolicitedMgr";
            BIDdfCommunicator comm = this.getDdfCommunicator();
            if (comm != null && comm instanceof BDdfCommunicator) {
                threadName = threadName + ':' + ((BDdfCommunicator)comm).getWorkerThreadName();
            }
            this.myThread = new Thread((Runnable)this, threadName);
            this.myThread.start();
        }
    }

    @Override
    public void stopUnsolicitedMgr() {
        if (!(this instanceof BDdfNullUnsolicitedMgr) && !this.stopUnsolicitedMgr) {
            this.stopUnsolicitedMgr = true;
            this.myThread.interrupt();
            this.ddfCommunicator = null;
        }
    }

    @Override
    public BIDdfCommunicator getDdfCommunicator() {
        if (this.ddfCommunicator == null) {
            this.ddfCommunicator = (BIDdfCommunicator)this.getParent();
        }
        return this.ddfCommunicator;
    }

    @Override
    public void enqueueUnsolicitedFrame(IDdfDataFrame unsolicitedFrame) {
        if (!(this instanceof BDdfNullUnsolicitedMgr)) {
            this.unsolicitedFrameManager.enqueue((Object)unsolicitedFrame);
        }
    }

    @Override
    public void run() {
        while (!this.stopUnsolicitedMgr) {
            IDdfDataFrame unsolicitedFrame;
            block7: {
                try {
                    unsolicitedFrame = (IDdfDataFrame)this.unsolicitedFrameManager.dequeue(-1);
                }
                catch (InterruptedException ie) {
                    unsolicitedFrame = null;
                    if (this.stopUnsolicitedMgr) break block7;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (unsolicitedFrame == null) continue;
            this.setUnsolicitedMessageCount(this.getUnsolicitedMessageCount() + 1L);
            try {
                this.processUnsolicitedFrame(unsolicitedFrame);
            }
            catch (Exception e) {
                this.getDdfCommunicator().getLog().error(this.myThread.getName(), (Throwable)e);
            }
        }
    }

    public abstract void processUnsolicitedFrame(IDdfDataFrame var1) throws Exception;

    public void resetStatistics() {
        this.setUnsolicitedMessageCount(0L);
    }

    protected void unsolicitedMgrStarted() {
    }

    protected void unsolicitedMgrStopped() {
    }
}

