/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.point;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.BIDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.req.util.DdfWriteRequestUtil;
import com.tridium.ddf.discover.BDdfDiscoveryGroup;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfAutoParams;
import com.tridium.ddf.identify.BIDdfReadParams;
import com.tridium.ddf.identify.BIDdfWriteParams;
import com.tridium.ddf.point.BIDdfWritable;
import com.tridium.ddf.point.DdfPointLexicon;
import com.tridium.ddf.poll.BDdfPollGroup;
import com.tridium.ddf.poll.BIDdfPollable;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="readParameters", type="BDdfIdParams", defaultValue="new BDdfIdParams()", facets={@Facet(value="DdfFacets.MGR_INCLUDE")}), @NiagaraProperty(name="writeParameters", type="BDdfIdParams", defaultValue="new BDdfIdParams()", facets={@Facet(value="DdfFacets.MGR_INCLUDE")}), @NiagaraProperty(name="pointId", type="BDdfIdParams", defaultValue="new BDdfIdParams()", facets={@Facet(value="DdfFacets.MGR_INCLUDE")})})
public abstract class BDdfProxyExt
extends BProxyExt
implements BIDdfPollable,
BIDdfWritable,
IDdfFacetConst {
    @Generated
    public static final Property readParameters = BDdfProxyExt.newProperty((int)0, (BValue)new BDdfIdParams(), (BFacets)DdfFacets.MGR_INCLUDE);
    @Generated
    public static final Property writeParameters = BDdfProxyExt.newProperty((int)0, (BValue)new BDdfIdParams(), (BFacets)DdfFacets.MGR_INCLUDE);
    @Generated
    public static final Property pointId = BDdfProxyExt.newProperty((int)0, (BValue)new BDdfIdParams(), (BFacets)DdfFacets.MGR_INCLUDE);
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfProxyExt.class);
    private static Hashtable<BDdfDevice, ArrayList> readParametersForDevices = new Hashtable();
    private boolean isReadSubscribed = false;
    private Object registeredPollGroupCode = null;

    @Generated
    public BDdfIdParams getReadParameters() {
        return (BDdfIdParams)this.get(readParameters);
    }

    @Generated
    public void setReadParameters(BDdfIdParams v) {
        this.set(readParameters, (BValue)v, null);
    }

    @Override
    @Generated
    public BDdfIdParams getWriteParameters() {
        return (BDdfIdParams)this.get(writeParameters);
    }

    @Generated
    public void setWriteParameters(BDdfIdParams v) {
        this.set(writeParameters, (BValue)v, null);
    }

    @Override
    @Generated
    public BDdfIdParams getPointId() {
        return (BDdfIdParams)this.get(pointId);
    }

    @Generated
    public void setPointId(BDdfIdParams v) {
        this.set(pointId, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BControlPoint || parent instanceof BDdfDiscoveryGroup;
    }

    public final void started() throws Exception {
        super.started();
        if (this.getReadParameters() instanceof BIDdfReadParams) {
            this.registerToPollGroup();
        }
        this.proxyExtStarted();
    }

    public final void stopped() throws Exception {
        this.readUnsubscribed(null);
        if (this instanceof BIDdfPollable) {
            this.unregisterFromPollGroup();
            BDdfPollGroup.unregister(this);
        }
        super.stopped();
        this.proxyExtStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changed(Property property, Context context) {
        if (property.equals(readParameters) && this.isRunning()) {
            BDdfProxyExt bDdfProxyExt = this;
            synchronized (bDdfProxyExt) {
                BIDdfReadParams previousPollGroupCode = (BIDdfReadParams)this.registeredPollGroupCode;
                BIDdfReadParams newReadParams = (BIDdfReadParams)((Object)this.getReadParameters());
                if (!previousPollGroupCode.groupWith(newReadParams)) {
                    boolean wasReadSubscribed = this.isReadSubscribed;
                    if (wasReadSubscribed) {
                        try {
                            this.readUnsubscribed(context);
                        }
                        catch (Exception e) {
                            this.getDdfCommunicator().getLog().error(DdfPointLexicon.errorChangingReadRequestId(this), (Throwable)e);
                        }
                    }
                    try {
                        this.unregisterFromPollGroup();
                    }
                    catch (Exception e) {
                        this.getDdfCommunicator().getLog().error(DdfPointLexicon.errorChangingReadRequestId(this), (Throwable)e);
                    }
                    try {
                        this.registerToPollGroup();
                    }
                    catch (Exception e) {
                        this.getDdfCommunicator().getLog().error(DdfPointLexicon.errorChangingReadRequestId(this), (Throwable)e);
                    }
                    if (wasReadSubscribed) {
                        try {
                            this.readSubscribed(context);
                        }
                        catch (Exception e) {
                            this.getDdfCommunicator().getLog().error(DdfPointLexicon.errorChangingReadRequestId(this), (Throwable)e);
                        }
                    }
                }
            }
        }
        super.changed(property, context);
        this.proxyExtChanged(property, context);
    }

    @Override
    public void writeFail(String cause) {
        if (this.logWriteFail()) {
            this.getDdfCommunicator().getLog().error(this.getSlotPath().toDisplayString() + ' ' + this.getParentPoint().getOutStatusValue() + " to " + this.getWriteValue() + ' ' + cause);
        }
        super.writeFail(cause);
    }

    public boolean write(Context cx) throws Exception {
        if (this.getMode() != BReadWriteMode.readonly) {
            BDdfNetwork network = (BDdfNetwork)this.getNetwork();
            final BStatusValue out = this.getWriteValue();
            if (out.getStatus().isNull()) {
                if (this.getDdfDevice().getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfDevice().getDdfCommunicator().getLog().trace(DdfPointLexicon.auto + '<' + this + ">:" + out);
                }
                try {
                    network.getBackgroundProcessor().processInBackground(new Runnable(){

                        @Override
                        public void run() {
                            BDdfProxyExt.this.doAuto();
                        }
                    });
                }
                catch (Exception e) {
                    this.writeFail(DdfPointLexicon.postAutoFail + ":" + e);
                    this.getDdfDevice().getDdfCommunicator().getLog().error(this.getSlotPath().toString() + ':' + DdfPointLexicon.postAutoFail, (Throwable)e);
                }
            } else {
                if (this.getDdfDevice().getDdfCommunicator().getLog().isTraceOn()) {
                    this.getDdfDevice().getDdfCommunicator().getLog().trace(DdfPointLexicon.write + '<' + this + ">:" + out);
                }
                try {
                    network.getBackgroundProcessor().processInBackground(new Runnable(){

                        @Override
                        public void run() {
                            BDdfProxyExt.this.doWrite(out);
                        }
                    });
                }
                catch (Exception e) {
                    this.writeFail(DdfPointLexicon.postWriteFail + ":" + e);
                    this.getDdfDevice().getDdfCommunicator().getLog().error(this.getSlotPath().toString() + ':' + DdfPointLexicon.postWriteFail, (Throwable)e);
                }
            }
        }
        return false;
    }

    public synchronized void readSubscribed(Context cx) throws Exception {
        if (this.getReadParameters().getType() != BDdfIdParams.TYPE) {
            BDdfPollGroup.readSubscribed(this, cx);
            this.isReadSubscribed = true;
        }
    }

    public synchronized void readUnsubscribed(Context cx) throws Exception {
        if (this.getReadParameters().getType() != BDdfIdParams.TYPE) {
            BDdfPollGroup.readUnsubscribed(this, cx);
            this.isReadSubscribed = false;
        }
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    protected boolean logWriteFail() {
        return true;
    }

    @Override
    public BFacets getFacets() {
        return this.getPointFacets();
    }

    @Override
    public Type getReadRequestType() {
        return ((BIDdfReadParams)((Object)this.getReadParameters())).getReadRequestType();
    }

    @Override
    public synchronized Object getPollGroupCode() {
        return this.registeredPollGroupCode;
    }

    @Override
    public BIDdfCommunicator getDdfCommunicator() {
        return this.getDdfDevice().getDdfCommunicator();
    }

    @Override
    public BIDdfReadRequest makePollRequest() {
        Type ddfReadRequestType = this.getReadRequestType();
        BIDdfReadRequest ddfReadRequest = (BIDdfReadRequest)ddfReadRequestType.getInstance();
        ddfReadRequest.setResponseTimeout(this.getDdfCommunicator().getDdfReceiver().getResponseTimeout());
        ddfReadRequest.setRemainingRetryCount(this.getDdfCommunicator().getDdfTransmitter().getMaxRetryCount());
        ddfReadRequest.setDeviceId((BDdfIdParams)this.getDdfDevice().getDeviceId().newCopy());
        ddfReadRequest.setReadParameters((BDdfIdParams)this.getReadParameters().newCopy());
        if (ddfReadRequest instanceof BIDdfPingRequest) {
            ((BIDdfPingRequest)((Object)ddfReadRequest)).setPingableSource(new IDdfPingable[]{this.getDdfDevice()});
        }
        return ddfReadRequest;
    }

    @Override
    public Type getWriteRequestType() {
        if (this.getWriteParameters() instanceof BIDdfWriteParams) {
            return ((BIDdfWriteParams)((Object)this.getWriteParameters())).getWriteRequestType();
        }
        return null;
    }

    @Override
    public BIDdfWriteRequest makeAutoRequest() {
        return this.makeWriteRequest(true);
    }

    @Override
    public BIDdfWriteRequest makeWriteRequest() {
        return this.makeWriteRequest(false);
    }

    public BDdfDevice getDdfDevice() {
        return (BDdfDevice)this.getDevice();
    }

    protected void proxyExtStarted() {
    }

    protected void proxyExtStopped() {
    }

    protected void proxyExtChanged(Property property, Context context) {
    }

    private BIDdfWriteRequest makeWriteRequest(boolean isAuto) {
        Type ddfRequestType;
        Type type = ddfRequestType = isAuto ? this.getAutoRequestType() : this.getWriteRequestType();
        if (ddfRequestType == null) {
            return null;
        }
        BIDdfWriteRequest ddfRequest = (BIDdfWriteRequest)ddfRequestType.getInstance();
        ddfRequest.setResponseTimeout(this.getDdfCommunicator().getDdfReceiver().getResponseTimeout());
        ddfRequest.setRemainingRetryCount(this.getDdfCommunicator().getDdfTransmitter().getMaxRetryCount());
        ddfRequest.setDeviceId((BDdfIdParams)this.getDdfDevice().getDeviceId().newCopy());
        ddfRequest.setWriteParameters((BDdfIdParams)this.getWriteParameters().newCopy());
        if (ddfRequest instanceof BIDdfReadRequest) {
            ((BIDdfReadRequest)((Object)ddfRequest)).setReadParameters((BDdfIdParams)this.getReadParameters().newCopy());
        }
        this.setWritableSource(ddfRequest);
        return ddfRequest;
    }

    private void setWritableSource(BIDdfWriteRequest ddfWriteRequest) {
        ddfWriteRequest.setWritableSource(new IDdfWritable[]{this});
    }

    public Type getAutoRequestType() {
        if (this.getWriteParameters() instanceof BIDdfAutoParams) {
            return ((BIDdfAutoParams)((Object)this.getWriteParameters())).getAutoRequestType();
        }
        return null;
    }

    public void doAuto() {
        DdfWriteRequestUtil.doAuto(this);
    }

    public void doWrite(BStatusValue out) {
        DdfWriteRequestUtil.doWrite(this, out);
    }

    private synchronized void registerToPollGroup() throws Exception {
        this.registeredPollGroupCode = this.lookupPollGroupCode();
        BDdfPollGroup.register(this);
    }

    private synchronized void unregisterFromPollGroup() throws Exception {
        BDdfPollGroup.unregister(this);
        this.cleanReadParametersTable();
        this.registeredPollGroupCode = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getAllKnownDifferentReadParametersForDevice() {
        BDdfDevice d = this.getDdfDevice();
        ArrayList uniqueReadParamsForDevice = null;
        Hashtable<BDdfDevice, ArrayList> hashtable = readParametersForDevices;
        synchronized (hashtable) {
            uniqueReadParamsForDevice = readParametersForDevices.get(d);
            if (uniqueReadParamsForDevice == null) {
                uniqueReadParamsForDevice = new ArrayList();
                readParametersForDevices.put(d, uniqueReadParamsForDevice);
            }
        }
        return uniqueReadParamsForDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookupPollGroupCode() {
        ArrayList uniqueReadParamsForDevice;
        BDdfIdParams readParameters = this.getReadParameters();
        ArrayList arrayList = uniqueReadParamsForDevice = this.getAllKnownDifferentReadParametersForDevice();
        synchronized (arrayList) {
            BIDdfReadParams uniqueReadParamsForProxy = null;
            int numUniqueReadParams = uniqueReadParamsForDevice.size();
            Object[] allUniqueReadParams = uniqueReadParamsForDevice.toArray();
            for (int i = 0; i < numUniqueReadParams && uniqueReadParamsForProxy == null; ++i) {
                BIDdfReadParams uniqueReadParams = (BIDdfReadParams)allUniqueReadParams[i];
                if (!uniqueReadParams.groupWith((BIDdfReadParams)((Object)readParameters))) continue;
                uniqueReadParamsForProxy = uniqueReadParams;
            }
            if (uniqueReadParamsForProxy == null) {
                uniqueReadParamsForProxy = (BIDdfReadParams)readParameters.newCopy();
                uniqueReadParamsForDevice.add(uniqueReadParamsForProxy);
            }
            return uniqueReadParamsForProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanReadParametersTable() {
        BDdfIdParams pollGroupCode = (BDdfIdParams)this.getPollGroupCode();
        BControlPoint[] devicePoints = this.getDeviceExt().getPoints();
        boolean anotherPointHasSameReadParameters = false;
        for (int i = 0; i < devicePoints.length && !anotherPointHasSameReadParameters; ++i) {
            if (!(devicePoints[i].getProxyExt() instanceof BDdfProxyExt) || !((BDdfProxyExt)devicePoints[i].getProxyExt()).getReadParameters().equivalent(pollGroupCode)) continue;
            anotherPointHasSameReadParameters = true;
        }
        if (!anotherPointHasSameReadParameters) {
            ArrayList uniqueReadParametersForDevice;
            ArrayList arrayList = uniqueReadParametersForDevice = this.getAllKnownDifferentReadParametersForDevice();
            synchronized (arrayList) {
                uniqueReadParametersForDevice.remove(pollGroupCode);
                if (uniqueReadParametersForDevice.size() < 1) {
                    readParametersForDevices.remove(this.getDdfDevice());
                }
            }
        }
    }
}

