/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.tcp.comm;

import com.tridium.ddf.comm.singleTransaction.BIDdfSingleTransactionMgr;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class TcpSocketManager
implements Runnable {
    protected Object idleMonitor = new Object();
    protected Object connectMonitor = new Object();
    protected Socket commSocket;
    protected InputStream inStream = null;
    protected OutputStream outStream = null;
    protected int numOutstandingRequests = 0;
    protected int numConnectionFailures = 0;
    protected int state = 0;
    protected BDdfTcpCommunicator ddfTcpCommunicator;
    protected boolean running = true;
    protected PipedOutputStream bos;
    protected PipedInputStream bin;
    protected Object readMonitor = new Object();
    protected Object ioMonitor = new Object();
    protected boolean messageSent = false;
    protected long timeTxEnd;
    protected long timeRxEnd;
    protected BFacets SHOW_SECONDS_AND_MILLIS = BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    public static final int STATE_IDLE = 0;
    public static final int STATE_NO_SOCKET = 1;
    public static final int STATE_GOT_SOCKET = 2;

    public TcpSocketManager(BDdfTcpCommunicator tcpComm) {
        this.ddfTcpCommunicator = tcpComm;
        if (this.isTraceOn()) {
            this.trace("entered constructor TcpSocketManager");
        }
        this.switchState(0);
        this.bos = new PipedOutputStream();
        try {
            this.bin = new PipedInputStream(this.bos);
        }
        catch (Exception e) {
            this.ddfTcpCommunicator.getLog().error(e.toString(), (Throwable)e);
        }
    }

    protected boolean isTraceOn() {
        return this.getLog().isTraceOn();
    }

    public void startSocketManager() {
        this.running = true;
        if (this.isTraceOn()) {
            this.trace("entered method startSocketManager");
        }
        this.switchState(1);
    }

    protected boolean isConnected() {
        return this.state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchState(int newState) {
        if (this.isTraceOn()) {
            this.trace("entered method switchState");
            this.trace("old state = " + this.state);
            this.trace("new state = " + newState);
        }
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        if (newState == 1) {
            this.numConnectionFailures = 0;
        }
        Object object = this.idleMonitor;
        synchronized (object) {
            this.idleMonitor.notifyAll();
        }
    }

    public void stopSocketManager() {
        if (this.isTraceOn()) {
            this.trace("entered method stopSocketManager");
        }
        this.switchState(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIdle() {
        this.closeSocket();
        this.nullStreams();
        Object object = this.idleMonitor;
        synchronized (object) {
            try {
                this.idleMonitor.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void finiteStateMachine() {
        if (this.isTraceOn()) {
            this.trace("entered method finiteStateMachine()");
        }
        switch (this.state) {
            case 0: {
                this.doIdle();
                break;
            }
            case 1: {
                if (this.ddfTcpCommunicator.getDdfTransactionMgr() instanceof BIDdfSingleTransactionMgr) {
                    this.waitForeverForSend();
                }
                this.initSocketConnection();
                break;
            }
            case 2: {
                if (this.ddfTcpCommunicator.getDdfTransactionMgr() instanceof BIDdfSingleTransactionMgr) {
                    this.waitLittleWhileForSend();
                }
                this.readMessage();
            }
        }
    }

    protected String getPrefix() {
        return "";
    }

    protected void trace(String details) {
        this.getLog().trace(this.getPrefix() + details + "[timestamp=" + Clock.ticks() + "]");
    }

    protected Log getLog() {
        return Log.getLog((String)(this.ddfTcpCommunicator.getLog().getLogName() + "_TcpSocketManager"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readMessageFromStream() {
        Object object = this.ioMonitor;
        synchronized (object) {
            if (this.isTraceOn()) {
                this.trace("entered method readMessageFromStream");
            }
            byte[] ibuf = new byte[261];
            try {
                if (this.isTraceOn()) {
                    this.trace("Reading from input stream, inStream=" + this.inStream);
                }
                int rxSize = this.inStream.read(ibuf, 0, 261);
                if (this.isTraceOn()) {
                    this.trace("finished read from instream, rxSize=" + rxSize);
                }
                if (rxSize == -1) {
                    if (this.isTraceOn()) {
                        this.trace("bad read! switching state to force reinitialize socket");
                    }
                    this.switchState(1);
                } else {
                    this.timeRxEnd = System.currentTimeMillis();
                    if (this.isTraceOn()) {
                        StringWriter s = new StringWriter();
                        PrintWriter p = new PrintWriter(s);
                        ByteArrayUtil.hexDump((PrintWriter)p, (byte[])ibuf, (int)0, (int)rxSize);
                        p.flush();
                        p.close();
                        String traceByteArrayPrintOut = s.toString();
                        this.trace(":" + this.ddfTcpCommunicator.getSlotPath() + ":" + this.getDebugCurTimeSecAndMs() + ":RX:\n" + traceByteArrayPrintOut + "\nTcp/Ip response time(milliSec) = " + (this.timeRxEnd - this.timeTxEnd));
                    }
                    this.numOutstandingRequests = 0;
                    this.bos.write(ibuf, 0, rxSize);
                }
            }
            catch (Exception e) {
                this.processReadStreamException(e);
            }
            this.considerReinitialize();
        }
    }

    public int readByte() throws Exception {
        return this.bin.read();
    }

    protected void processReadStreamException(Exception e) {
        if (this.isTraceOn()) {
            this.trace("entered method processReadStreamException");
        }
        if (e instanceof SocketException) {
            this.trace("Tcp/Ip SOCKET connection lost to " + this.getPrefix() + "!!!");
            this.switchState(1);
        } else if (!(e instanceof NullPointerException) && !(e instanceof InterruptedIOException)) {
            this.ddfTcpCommunicator.getLog().error(e.toString(), (Throwable)e);
        }
    }

    protected void considerReinitialize() {
        if (this.isTraceOn()) {
            this.trace("entered method considerReinitialize");
        }
        if (this.numOutstandingRequests > 1) {
            this.switchState(1);
        }
    }

    protected void setNextReadTimeout() {
        block3: {
            if (this.isTraceOn()) {
                this.trace("entered method setNextReadTimeout()");
            }
            try {
                this.commSocket.setSoTimeout((int)this.getResponseTimeout());
            }
            catch (Exception e) {
                if (!this.isTraceOn()) break block3;
                this.trace("exception caught setting so timeout, e=" + e);
            }
        }
    }

    protected void readMessage() {
        this.setNextReadTimeout();
        this.readMessageFromStream();
    }

    @Override
    public void run() {
        if (this.isTraceOn()) {
            this.trace("entered method run");
        }
        while (this.running) {
            this.finiteStateMachine();
        }
    }

    protected void closeSocket() {
        block4: {
            if (this.isTraceOn()) {
                this.trace("entered method closeSocket");
            }
            if (this.commSocket != null) {
                try {
                    this.commSocket.close();
                }
                catch (Exception e) {
                    if (!this.isTraceOn()) break block4;
                    this.trace("exception caught from closeSocket() while closing commSocket" + e);
                }
            }
        }
    }

    protected void failureSocketConnectionInit(Exception e) {
        if (this.isTraceOn()) {
            this.trace("entered method failureSocketConnectionInit");
            this.trace("" + this.getDebugCurTimeSecAndMs() + " Tcp/Ip - Cannot open socket connection to " + this.getPrefix() + ".");
        }
        ++this.numConnectionFailures;
        this.nullStreams();
        this.closeSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyConnectMonitor() {
        Object object = this.connectMonitor;
        synchronized (object) {
            this.connectMonitor.notifyAll();
        }
    }

    protected void successSocketConnectionInit() {
        if (this.isTraceOn()) {
            this.trace("entered method successSocketConnectionInit");
            this.trace("" + this.getDebugCurTimeSecAndMs() + " Tcp/Ip - socket connection established to " + this.getPrefix() + ".");
        }
        this.switchState(2);
        this.numOutstandingRequests = 0;
        this.notifyConnectMonitor();
    }

    protected String getDestAddress() {
        return this.ddfTcpCommunicator.getTcpIpComm().getDestinationAddress().getIpAddress();
    }

    protected int getConnectionTimeout() {
        return (int)this.ddfTcpCommunicator.getTcpIpComm().getSocketConnectionTimeout().getMillis();
    }

    protected long getResponseTimeout() {
        long respTimeout = this.ddfTcpCommunicator.getReceiver().getResponseTimeout().getMillis();
        if (respTimeout < 100L) {
            respTimeout = 100L;
        }
        return respTimeout;
    }

    protected boolean icmpPing(String userIpText) {
        return true;
    }

    protected void connectSocket() throws Exception {
        if (this.isTraceOn()) {
            this.trace("entered method connectSocket");
        }
        String userIpText = this.getDestAddress();
        if (this.isTraceOn()) {
            this.trace("userIpText=" + userIpText);
        }
        if (userIpText == null || userIpText.length() <= 0 || userIpText.equals("[***DEFAULT***]") || userIpText.equals(BDdfIpAddressPort.ipAddress.getDefaultValue().toString())) {
            if (this.isTraceOn()) {
                this.trace("Could not conclude that the IP address [" + userIpText + "] is valid.");
            }
            throw new SocketException("Could not conclude that the IP address [" + userIpText + "] is valid.");
        }
        if (this.isTraceOn()) {
            this.trace("Pinging  device (same ping as DOS cmd prompt would use) using 500 ms. ping timeout...");
        }
        BTcpIpPlatformService platTcpIp = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        platTcpIp.lease();
        if (!this.icmpPing(userIpText)) {
            if (this.isTraceOn()) {
                this.trace("--- NO RESPONSE to ping (same procedure as DOS cmd prompt would use)!!! ---");
            }
            throw new IOException("Device did not respond to ping (same ping as DOS cmd prompt would use)!");
        }
        if (this.isTraceOn()) {
            this.trace("Device responded to ping (same ping as DOS cmd prompt would use)!");
        }
        if (this.isTraceOn()) {
            this.trace("getting new socket");
        }
        this.commSocket = this.ddfTcpCommunicator.getTcpIpComm().createSocket();
    }

    protected void nullStreams() {
        if (this.isTraceOn()) {
            this.trace("entered method nullStreams");
        }
        this.inStream = null;
        this.outStream = null;
    }

    protected void createStreams() throws IOException {
        if (this.isTraceOn()) {
            this.trace("entered method createStreams");
        }
        if (this.isTraceOn()) {
            this.trace("getting new input stream");
        }
        this.inStream = this.commSocket.getInputStream();
        if (this.isTraceOn()) {
            this.trace("getting new output stream");
        }
        this.outStream = this.commSocket.getOutputStream();
    }

    protected synchronized void initSocketConnection() {
        if (this.isTraceOn()) {
            this.trace("entered method initSocketConnection");
        }
        try {
            this.nullStreams();
            this.closeSocket();
            this.connectSocket();
            this.createStreams();
            this.successSocketConnectionInit();
        }
        catch (Exception e) {
            this.failureSocketConnectionInit(e);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceiveMonitor() {
        Object object = this.readMonitor;
        synchronized (object) {
            this.readMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForeverForSend() {
        if (this.isTraceOn()) {
            this.trace("entered method waitForeverForSend");
        }
        if (!this.messageSent) {
            Object object = this.readMonitor;
            synchronized (object) {
                try {
                    this.readMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("exiting method waitForeverForSend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitLittleWhileForSend() {
        if (this.isTraceOn()) {
            this.trace("entered method waitLittleWhileForSend");
        }
        if (!this.messageSent) {
            Object object = this.readMonitor;
            synchronized (object) {
                try {
                    this.readMonitor.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("exiting method waitLittleWhileForSend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForConnect(long waitInterval) {
        Object object = this.connectMonitor;
        synchronized (object) {
            block7: {
                try {
                    if (this.isTraceOn()) {
                        this.trace("waitForConnect - waiting for up to " + waitInterval + " milliseconds.");
                    }
                    this.connectMonitor.wait(waitInterval);
                    if (this.isTraceOn()) {
                        this.trace("waitForConnect - woke up from wait");
                    }
                }
                catch (InterruptedException e) {
                    if (!this.isTraceOn()) break block7;
                    this.trace("waitForConnect interrupted while waiting");
                }
            }
        }
    }

    protected void waitAWhileForConnect() {
        long waitInterval = this.getConnectionTimeout();
        long l = waitInterval = waitInterval < 13000L ? 13000L : waitInterval;
        if (this.isTraceOn()) {
            this.trace("entered method waitLittleWhileForConnect");
        }
        this.waitForConnect(waitInterval);
        if (this.isTraceOn()) {
            this.trace("exiting method waitLittleWhileForConnect");
        }
    }

    protected boolean isConnecting() {
        return this.state == 1;
    }

    protected boolean isConnectingFirstTime() {
        return this.isConnecting() && this.numConnectionFailures == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutputStream(byte[] data, int startIndex, int endIndex) throws Exception {
        Object object;
        if (this.isTraceOn()) {
            this.trace("entered method writeOutputStream");
        }
        if (this.isConnecting()) {
            object = this.connectMonitor;
            synchronized (object) {
                this.notifyReceiveMonitor();
                if (this.isConnectingFirstTime()) {
                    this.waitAWhileForConnect();
                } else {
                    this.waitForConnect(this.getResponseTimeout());
                }
            }
        }
        if (this.isConnected()) {
            object = this.ioMonitor;
            synchronized (object) {
                ++this.numOutstandingRequests;
                this.outStream.write(data, startIndex, endIndex);
                this.outStream.flush();
            }
        } else {
            throw new SocketException();
        }
        this.notifyReceiveMonitor();
    }

    protected String getDebugCurTimeSecAndMs() {
        return BAbsTime.now().toString((Context)this.SHOW_SECONDS_AND_MILLIS);
    }
}

