/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.udp.comm;

import com.tridium.ddfIp.comm.BDdfIpAdapter;
import com.tridium.ddfIp.comm.BDdfIpCommunicator;
import com.tridium.ddfIp.udp.comm.BDdfUdpReceiver;
import com.tridium.ddfIp.udp.comm.BDdfUdpTransmitter;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="transmitter", type="BDdfTransmitter", defaultValue="new BDdfUdpTransmitter()", facets={@Facet(value="MGR_INCLUDE")}, override=true), @NiagaraProperty(name="receiver", type="BDdfReceiver", defaultValue="new BDdfUdpReceiver()", facets={@Facet(value="MGR_INCLUDE")}, override=true)})
public class BDdfUdpCommunicator
extends BDdfIpCommunicator {
    @Generated
    public static final Property transmitter = BDdfUdpCommunicator.newProperty((int)0, (BValue)new BDdfUdpTransmitter(), (BFacets)MGR_INCLUDE);
    @Generated
    public static final Property receiver = BDdfUdpCommunicator.newProperty((int)0, (BValue)new BDdfUdpReceiver(), (BFacets)MGR_INCLUDE);
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfUdpCommunicator.class);
    protected DatagramSocket udpTransmitSocket = null;
    protected DatagramSocket udpReceiveSocket = null;
    protected BDdfIpAdapter udpNetworkAdapter = null;
    protected int udpTransmitPort = Integer.MIN_VALUE;
    protected int udpReceivePort = Integer.MIN_VALUE;
    protected final Object udpTransmitSocketLock = new Object();
    protected final Object udpReceiveSocketLock = new Object();
    public static final String lexkeyJaceSocketConnectionError = "JaceSocketConnectionError";
    public static final String lexkeyJaceUnknownHostException = "JaceUnknownHostException";
    public static final Lexicon LEX = Lexicon.make(BDdfUdpCommunicator.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected boolean doesSocketNeedReInitialized(BDdfIpAdapter socketAdapter, DatagramSocket socket, int socketPort, BDdfIpAdapter currentAdapter, int currentPort) {
        if (socketAdapter == null) {
            return true;
        }
        if (socketAdapter.equivalent((Object)currentAdapter)) {
            if (socket == null) {
                return true;
            }
            return socketPort != currentPort;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket getUdpTransmitSocket() throws Exception {
        Object object = this.udpTransmitSocketLock;
        synchronized (object) {
            if (this.doesSocketNeedReInitialized(this.udpNetworkAdapter, this.udpTransmitSocket, this.udpTransmitPort, this.getNetworkAdapter(), this.getUdpTransmitPort())) {
                this.cleanupUdpTransmitSocket();
            }
            if (this.udpTransmitSocket == null) {
                this.makeUdpTransmitSocket();
            }
            return this.udpTransmitSocket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket getUdpReceiveSocket() throws Exception {
        Object object = this.udpReceiveSocketLock;
        synchronized (object) {
            if (this.doesSocketNeedReInitialized(this.udpNetworkAdapter, this.udpReceiveSocket, this.udpReceivePort, this.getNetworkAdapter(), this.getUdpReceivePort())) {
                this.cleanupUdpReceiveSocket();
            }
            if (this.udpReceiveSocket == null) {
                this.makeUdpReceiveSocket();
            }
            return this.udpReceiveSocket;
        }
    }

    public int getUdpTransmitPort() {
        return this.getUdpTransmitter().getTransmitFromPort();
    }

    public int getUdpReceivePort() {
        return this.getUdpReceiver().getReceivePort();
    }

    public BDdfUdpTransmitter getUdpTransmitter() {
        return (BDdfUdpTransmitter)this.getDdfTransmitter();
    }

    public BDdfUdpReceiver getUdpReceiver() {
        return (BDdfUdpReceiver)this.getDdfReceiver();
    }

    public void udpCommunicatorStarted() throws Exception {
    }

    public void udpCommunicatorStopped() throws Exception {
    }

    @Override
    public final void ipCommunicatorStarted() throws Exception {
        this.udpCommunicatorStarted();
    }

    @Override
    public final void ipCommunicatorStopped() throws Exception {
        this.udpCommunicatorStopped();
        this.cleanupUdpTransmitSocket();
        this.cleanupUdpReceiveSocket();
    }

    protected DatagramSocket makeLocalHostSocket(int bindPort) throws SocketException {
        if (bindPort < 0) {
            return new DatagramSocket();
        }
        return new DatagramSocket(bindPort);
    }

    protected DatagramSocket makeFullySpecifiedSocket(BDdfIpAdapter networkInterface, int bindPort) throws UnknownHostException, SocketException {
        if (bindPort < 0) {
            DatagramSocket tempSocket = null;
            for (int port = 49152; port <= 65535 && tempSocket == null; ++port) {
                try {
                    tempSocket = new DatagramSocket(port, InetAddress.getByName(networkInterface.getIpAddress()));
                    continue;
                }
                catch (SocketException socketException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (tempSocket == null) {
                throw new SocketException("No Available Dynamic Port in Range [49152-65535]");
            }
            return tempSocket;
        }
        return new DatagramSocket(bindPort, InetAddress.getByName(networkInterface.getIpAddress()));
    }

    protected DatagramSocket makeSocket(BDdfIpAdapter networkInterface, int bindPort) throws SocketException, UnknownHostException {
        if (networkInterface.isDefaultLocalHost()) {
            return this.makeLocalHostSocket(bindPort);
        }
        return this.makeFullySpecifiedSocket(networkInterface, bindPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeUdpTransmitSocket() throws Exception {
        Object object = this.udpTransmitSocketLock;
        synchronized (object) {
            this.udpNetworkAdapter = (BDdfIpAdapter)this.getNetworkAdapter().newCopy();
            this.udpTransmitPort = this.getUdpTransmitPort();
            this.udpTransmitSocket = this.makeSocket(this.udpNetworkAdapter, this.udpTransmitPort);
        }
        this.initUdpTransmitSocket();
    }

    protected void initUdpTransmitSocket() throws Exception {
    }

    protected void initUdpReceiveSocket() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeUdpReceiveSocket() throws Exception {
        Object object = this.udpReceiveSocketLock;
        synchronized (object) {
            this.udpNetworkAdapter = (BDdfIpAdapter)this.getNetworkAdapter().newCopy();
            this.udpReceivePort = this.getUdpReceivePort();
            Object object2 = this.udpTransmitSocketLock;
            synchronized (object2) {
                DatagramSocket transmitSocket = this.getUdpTransmitSocket();
                if (this.udpReceivePort == this.udpTransmitPort) {
                    this.udpReceiveSocket = transmitSocket;
                    return;
                }
            }
            this.udpReceiveSocket = this.makeSocket(this.udpNetworkAdapter, this.udpReceivePort);
        }
    }

    protected void cleanupUdpTransmitSocket() {
        this.udpTransmitSocket = BDdfUdpCommunicator.cleanupSocket(this.udpTransmitSocket, this.udpTransmitSocketLock);
    }

    protected void cleanupUdpReceiveSocket() {
        this.udpReceiveSocket = BDdfUdpCommunicator.cleanupSocket(this.udpReceiveSocket, this.udpReceiveSocketLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DatagramSocket cleanupSocket(DatagramSocket cleanupSocket, Object socketLock) {
        Object object = socketLock;
        synchronized (object) {
            if (cleanupSocket != null) {
                cleanupSocket.close();
            }
            return null;
        }
    }
}

