/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.messages;

import com.tridium.edgeIo.datatypes.BEdgeIoDriverParams;
import com.tridium.edgeIo.messages.BEdgeIoMessageTypeEnum;
import com.tridium.edgeIo.messages.EdgeIoMessage;
import com.tridium.ndriver.io.TypedInputStream;
import com.tridium.ndriver.io.TypedOutputStream;

public class SetDriverParam
extends EdgeIoMessage {
    public int pollDelay;
    public int debugLevel;
    public int commLossTimeout;
    public static final int DISABLE_COMM_LOSS_TIMEOUT = 0;

    public SetDriverParam(BEdgeIoDriverParams parm) {
        super(BEdgeIoMessageTypeEnum.setDriverParam);
        this.pollDelay = parm.getPollDelay();
        this.debugLevel = parm.getDebugLevel();
        this.commLossTimeout = parm.getEnableCommLossDefaults() ? parm.getCommLossTimeout() : 0;
    }

    public SetDriverParam(int pollDelay, int debugLevel, int commLossTimeout) {
        super(BEdgeIoMessageTypeEnum.setDriverParam);
        this.pollDelay = pollDelay;
        this.debugLevel = debugLevel;
        this.commLossTimeout = commLossTimeout;
    }

    @Override
    public void toOutStream(TypedOutputStream out) {
        out.writeUnsigned16(this.pollDelay);
        out.writeUnsigned8(this.debugLevel);
        out.writeUnsigned16(this.commLossTimeout);
    }

    @Override
    public void fromInputStream(TypedInputStream in) {
        this.pollDelay = in.readUnsigned16();
        this.debugLevel = in.readUnsigned8();
        this.commLossTimeout = in.readUnsigned16();
    }

    @Override
    protected void toTraceString(StringBuffer sb) {
        sb.append("  pollDelay:").append(this.pollDelay).append("\n");
        sb.append("  debugLevel:").append(this.debugLevel).append("\n");
        sb.append("  commLossTimeout:").append(this.commLossTimeout).append("\n");
    }
}

