/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.edgeIo.point;

import com.tridium.edgeIo.enums.BEdgeIoModeEnum;
import com.tridium.edgeIo.messages.BEdgeIoMessageTypeEnum;
import com.tridium.edgeIo.messages.EdgeIoMessage;
import com.tridium.edgeIo.messages.InitDigital;
import com.tridium.edgeIo.messages.PointMessage;
import com.tridium.edgeIo.messages.UpdateDigital;
import com.tridium.edgeIo.point.BEdgeIoProxyExt;
import com.tridium.json.JSONObject;
import javax.baja.control.BBooleanWritable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BEdgeIoDigitalProxyExt
extends BEdgeIoProxyExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BEdgeIoDigitalProxyExt.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void sendInit() {
        int mode = BEdgeIoModeEnum.make(this.getPointMode().getTag()).getOrdinal();
        InitDigital init = new InitDigital(this.getPointId(), mode);
        this.getEdgeIoNetwork().sendMessage(init);
    }

    @Override
    protected void sendStop() {
        PointMessage stop = new PointMessage(BEdgeIoMessageTypeEnum.stopDigital, this.getPointId());
        this.getEdgeIoNetwork().sendMessage(stop);
    }

    @Override
    public boolean write(Context cx) throws Exception {
        if (!this.isWriteable() || !this.getEnabled()) {
            return false;
        }
        BStatusValue sv = this.getWriteValue();
        this.writeDigital(this.getValue((BStatusBoolean)sv));
        this.writeOk(sv);
        return true;
    }

    @Override
    public void receiveUpdate(EdgeIoMessage msg) {
        boolean bv;
        if (!(msg instanceof UpdateDigital)) {
            log.severe("The message received is not UpdateDigital message");
            return;
        }
        BStatusBoolean sval = (BStatusBoolean)this.getReadValue();
        UpdateDigital update = (UpdateDigital)msg;
        sval.setValue(update.value);
        this.readOk((BStatusValue)sval);
        if (this.isWriteable() && this.getWriteValue().getStatus().isValid() && update.value != (bv = this.getValue((BStatusBoolean)this.getWriteValue()))) {
            log.info("Reported value " + update.value + " did not match written value " + bv + ". Rewrite value ");
            try {
                this.writeDigital(bv);
            }
            catch (Exception e) {
                log.severe("catch exception " + e.getMessage());
            }
        }
    }

    @Override
    protected boolean updateDefault(JSONObject jsonObj) {
        boolean currDef;
        boolean defVal = this.getValue(((BBooleanWritable)this.getParent()).getFallback());
        if (defVal == (currDef = jsonObj.getBoolean("DefaultValue"))) {
            return false;
        }
        jsonObj.put("DefaultValue", defVal);
        return true;
    }

    @Override
    protected Slot getFallbackSlot() {
        return BBooleanWritable.fallback;
    }

    @Override
    protected Slot getSetSlot() {
        return BBooleanWritable.set;
    }

    protected boolean getValue(BStatusBoolean sb) {
        return sb.getStatus().isNull() ? false : sb.getValue();
    }
}

