/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver;

import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.util.SfUtil;
import com.tridiumx.ldapDriver.BLdapConnection;
import com.tridiumx.ldapDriver.BLdapNetwork;
import com.tridiumx.ldapDriver.BLdapSearchControlScope;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import com.tridiumx.ldapDriver.callbacks.LdapChangeRegistrationCallback;
import com.tridiumx.ldapDriver.callbacks.LdapConnectionCallback;
import com.tridiumx.ldapDriver.callbacks.LdapUpdateVendorDetailsCallback;
import com.tridiumx.ldapDriver.groups.BLdapGroupsDeviceExt;
import com.tridiumx.ldapDriver.users.BCleanupUserDataJob;
import com.tridiumx.ldapDriver.users.BLdapUser;
import com.tridiumx.ldapDriver.users.BLdapUsersDeviceExt;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ldapConnection", type="BLdapConnection", defaultValue="new BLdapConnection()", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="vendorName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="vendorVersion", type="String", defaultValue="", flags=1), @NiagaraProperty(name="supportedLDAPVersion", type="int", defaultValue="3", flags=1), @NiagaraProperty(name="isGlobalCatalogReady", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="users", type="BLdapUsersDeviceExt", defaultValue="new BLdapUsersDeviceExt()"), @NiagaraProperty(name="groups", type="BLdapGroupsDeviceExt", defaultValue="new BLdapGroupsDeviceExt()"), @NiagaraProperty(name="attributes", type="BLdapAttributesDeviceExt", defaultValue="new BLdapAttributesDeviceExt()"), @NiagaraProperty(name="userSearchBase", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"ldapDriver:LdapSearchBaseFE\"")}), @NiagaraProperty(name="userSearchFilter", type="String", defaultValue="(objectclass=*)", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"ldapDriver:LdapSearchFilterFE\"")}), @NiagaraProperty(name="searchScope", type="BLdapSearchControlScope", defaultValue="BLdapSearchControlScope.objectScope", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="pollingInterval", type="BRelTime", defaultValue="BRelTime.make(5 * BRelTime.MILLIS_IN_MINUTE)", facets={@Facet(value="BFacets.make(BFacets.make(new String[] {BFacets.MIN, LdapDriverConstants.SHOW_DAY, BFacets.SHOW_MILLISECONDS}, new BIDataValue[] { BRelTime.make(5 * BRelTime.MILLIS_IN_MINUTE), BBoolean.TRUE, BBoolean.FALSE }), SfUtil.incl(SfUtil.MGR_EDIT))")}), @NiagaraProperty(name="cleanupLdapDeletedEntries", type="BTimeTrigger", defaultValue="new BTimeTrigger(BDailyTriggerMode.make())"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true)})
@NiagaraActions(value={@NiagaraAction(name="register"), @NiagaraAction(name="cleanupUserData")})
@NiagaraTopic(name="ldapEntryChanged")
public class BLdapServer
extends BNDevice {
    @Generated
    public static final Property ldapConnection = BLdapServer.newProperty((int)0, (BValue)new BLdapConnection(), (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property vendorName = BLdapServer.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property vendorVersion = BLdapServer.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property supportedLDAPVersion = BLdapServer.newProperty((int)1, (int)3, null);
    @Generated
    public static final Property isGlobalCatalogReady = BLdapServer.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property users = BLdapServer.newProperty((int)0, (BValue)new BLdapUsersDeviceExt(), null);
    @Generated
    public static final Property groups = BLdapServer.newProperty((int)0, (BValue)new BLdapGroupsDeviceExt(), null);
    @Generated
    public static final Property attributes = BLdapServer.newProperty((int)0, (BValue)new BLdapAttributesDeviceExt(), null);
    @Generated
    public static final Property userSearchBase = BLdapServer.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"ldapDriver:LdapSearchBaseFE"));
    @Generated
    public static final Property userSearchFilter = BLdapServer.newProperty((int)0, (String)"(objectclass=*)", (BFacets)BFacets.make((String)"fieldEditor", (String)"ldapDriver:LdapSearchFilterFE"));
    @Generated
    public static final Property searchScope = BLdapServer.newProperty((int)0, (BValue)BLdapSearchControlScope.objectScope, (BFacets)SfUtil.incl((String)"ed"));
    @Generated
    public static final Property pollingInterval = BLdapServer.newProperty((int)0, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((BFacets)BFacets.make((String[])new String[]{"min", "showDay", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BRelTime.make((long)300000L), BBoolean.TRUE, BBoolean.FALSE}), (BFacets)SfUtil.incl((String)"ed")));
    @Generated
    public static final Property cleanupLdapDeletedEntries = BLdapServer.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make()), null);
    @Generated
    public static final Property status = BLdapServer.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    @Generated
    public static final Action register = BLdapServer.newAction((int)0, null);
    @Generated
    public static final Action cleanupUserData = BLdapServer.newAction((int)0, null);
    @Generated
    public static final Topic ldapEntryChanged = BLdapServer.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLdapServer.class);
    private final Logger log = this.getLogger();
    private LdapUpdateVendorDetailsCallback vendorDetailsCallback;
    private LdapChangeRegistrationCallback registrationCallback;

    @Generated
    public BLdapConnection getLdapConnection() {
        return (BLdapConnection)this.get(ldapConnection);
    }

    @Generated
    public void setLdapConnection(BLdapConnection v) {
        this.set(ldapConnection, (BValue)v, null);
    }

    @Generated
    public String getVendorName() {
        return this.getString(vendorName);
    }

    @Generated
    public void setVendorName(String v) {
        this.setString(vendorName, v, null);
    }

    @Generated
    public String getVendorVersion() {
        return this.getString(vendorVersion);
    }

    @Generated
    public void setVendorVersion(String v) {
        this.setString(vendorVersion, v, null);
    }

    @Generated
    public int getSupportedLDAPVersion() {
        return this.getInt(supportedLDAPVersion);
    }

    @Generated
    public void setSupportedLDAPVersion(int v) {
        this.setInt(supportedLDAPVersion, v, null);
    }

    @Generated
    public boolean getIsGlobalCatalogReady() {
        return this.getBoolean(isGlobalCatalogReady);
    }

    @Generated
    public void setIsGlobalCatalogReady(boolean v) {
        this.setBoolean(isGlobalCatalogReady, v, null);
    }

    @Generated
    public BLdapUsersDeviceExt getUsers() {
        return (BLdapUsersDeviceExt)this.get(users);
    }

    @Generated
    public void setUsers(BLdapUsersDeviceExt v) {
        this.set(users, (BValue)v, null);
    }

    @Generated
    public BLdapGroupsDeviceExt getGroups() {
        return (BLdapGroupsDeviceExt)this.get(groups);
    }

    @Generated
    public void setGroups(BLdapGroupsDeviceExt v) {
        this.set(groups, (BValue)v, null);
    }

    @Generated
    public BLdapAttributesDeviceExt getAttributes() {
        return (BLdapAttributesDeviceExt)this.get(attributes);
    }

    @Generated
    public void setAttributes(BLdapAttributesDeviceExt v) {
        this.set(attributes, (BValue)v, null);
    }

    @Generated
    public String getUserSearchBase() {
        return this.getString(userSearchBase);
    }

    @Generated
    public void setUserSearchBase(String v) {
        this.setString(userSearchBase, v, null);
    }

    @Generated
    public String getUserSearchFilter() {
        return this.getString(userSearchFilter);
    }

    @Generated
    public void setUserSearchFilter(String v) {
        this.setString(userSearchFilter, v, null);
    }

    @Generated
    public BLdapSearchControlScope getSearchScope() {
        return (BLdapSearchControlScope)this.get(searchScope);
    }

    @Generated
    public void setSearchScope(BLdapSearchControlScope v) {
        this.set(searchScope, (BValue)v, null);
    }

    @Generated
    public BRelTime getPollingInterval() {
        return (BRelTime)this.get(pollingInterval);
    }

    @Generated
    public void setPollingInterval(BRelTime v) {
        this.set(pollingInterval, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getCleanupLdapDeletedEntries() {
        return (BTimeTrigger)this.get(cleanupLdapDeletedEntries);
    }

    @Generated
    public void setCleanupLdapDeletedEntries(BTimeTrigger v) {
        this.set(cleanupLdapDeletedEntries, (BValue)v, null);
    }

    @Generated
    public void register() {
        this.invoke(register, null, null);
    }

    @Generated
    public void cleanupUserData() {
        this.invoke(cleanupUserData, null, null);
    }

    @Generated
    public void fireLdapEntryChanged(BValue event) {
        this.fire(ldapEntryChanged, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BLdapNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.doRegister();
        this.linkTo((BComponent)this.getCleanupLdapDeletedEntries(), (Slot)BTimeTrigger.fireTrigger, (Slot)cleanupUserData);
    }

    public void stopped() throws Exception {
        if (this.vendorDetailsCallback != null) {
            this.vendorDetailsCallback.cleanUp();
        }
        if (this.registrationCallback != null) {
            this.registrationCallback.cleanUp();
        }
        super.stopped();
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == cleanupLdapDeletedEntries) {
            return this.getLexicon().getText("ldapServer.cleanupLdapDeletedEntries.displayName");
        }
        return super.getDisplayName(slot, cx);
    }

    public void doPing() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Invoking the Ping action on LDAP Server");
        }
        this.setFaultCause("");
        try {
            DirContext ctx = this.connect();
            if (ctx != null) {
                this.pingOk();
                this.log.fine("Ping Invocation successful");
                ctx.close();
            } else {
                this.pingFail("Ping Invocation failed : null");
            }
        }
        catch (NamingException e) {
            this.pingFail(e.getLocalizedMessage());
            this.log.fine("Ping Invocation failed with reason : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRegister() throws NamingException {
        if (this.isFault()) {
            throw new BajaRuntimeException(this.getFaultCause());
        }
        ArrayList<LdapConnectionCallback> callbacks = new ArrayList<LdapConnectionCallback>();
        this.vendorDetailsCallback = new LdapUpdateVendorDetailsCallback(this);
        callbacks.add(this.vendorDetailsCallback);
        if (this.isSubscriptionEligible()) {
            this.registrationCallback = new LdapChangeRegistrationCallback(this);
            callbacks.add(this.registrationCallback);
        }
        try (javax.naming.Context dirContext = null;){
            dirContext = this.connect(callbacks.toArray(new LdapConnectionCallback[0]));
        }
    }

    private boolean isSubscriptionEligible() {
        BLdapUsersDeviceExt userExt = this.getUsers();
        return !BAbsTime.NULL.equals((Object)userExt.getLastUpdateTime());
    }

    public Type getLdapUsersType() {
        return BLdapUser.TYPE;
    }

    public final BLdapNetwork getLdapNetwork() {
        return (BLdapNetwork)this.getNetwork();
    }

    public BLdapUsersDeviceExt getLdapUsersExt() {
        return this.getUsers();
    }

    public String getConnectionUrl() {
        return this.getLdapConnection().getConnectionUrl();
    }

    public BLdapGroupsDeviceExt getLdapGroupsExt() {
        return this.getGroups();
    }

    public DirContext connect() throws NamingException {
        return this.getLdapConnection().connect();
    }

    public void setRegistrationCallback(LdapChangeRegistrationCallback registrationCallback) {
        this.registrationCallback = registrationCallback;
    }

    public LdapChangeRegistrationCallback getRegistrationCallback() {
        return this.registrationCallback;
    }

    public DirContext connect(LdapConnectionCallback[] callbacks) throws NamingException {
        return this.getLdapConnection().connect(callbacks);
    }

    public void doCleanupUserData() {
        AgentList agents = this.getAgents().filter(AgentFilter.is((Type)BCleanupUserDataJob.TYPE));
        BCleanupUserDataJob cleanupUserDataJob = (BCleanupUserDataJob)agents.get(0).getInstance();
        cleanupUserDataJob.setServer(this);
        cleanupUserDataJob.submit(null);
    }
}

